/*
 * slip.drv	A program for TNET, which reads SLIP encapsulated IP
 *		datagrams from a serial port, and sends them to TNET
 *		for further processing.
 *
 *		Definitions for the TNET SLIP driver.
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */

/* SLIP protocol configuration. */
#define DEF_MTU		600
#define DEF_BUFS	1


#ifndef GLOBAL
#   define GLOBAL	extern
#endif
GLOBAL int opt_d;			/* flag: dump incoming IP packs */
GLOBAL int opt_v;			/* flag: be verbose!		*/
GLOBAL jmp_buf env;
	
GLOBAL int sl_mtu;			/* SLIP MaxTransferUnit number	*/
GLOBAL int sl_bufs;			/* SLIP # of serial I/O buffers	*/

/* Function prototyping according to ANSI. */
#ifndef _PROTOTYPE
#    if _MINIX
#	include <ansi.h>
#    else
#	define _ANSI		0
#	ifdef __STDC__		
#	    if (__STDC__ == 1)	
#	    	undef _ANSI
#	    	define _ANSI	1
#	    endif
#	endif
#	if _ANSI
#	    define	_PROTOTYPE(function, params)	function params
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST		const
#	    define	_VOLATILE	volatile
#	    define	_SIZET		size_t
#	else
#	    define	_PROTOTYPE(function, params)	function()
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST
#	    define	_VOLATILE
#	    define	_SIZET		int
#	endif /* _ANSI */
#    endif /* _MINIX */
#endif	/* _PROTOTYPE */

/* Functions in ipdump.c: */
_PROTOTYPE( void ip_dump, (char *ptr, int len)				);

/* Functions in serial.c: */
_PROTOTYPE( int tty_init, (char *tty_name, char *baud)			);
_PROTOTYPE( void tty_stop, (void)					);
_PROTOTYPE( int tty_getc, (void)					);
_PROTOTYPE( int tty_putc, (int c)					);

/* Functions in dial.c: */
_PROTOTYPE( int do_dial, (char *telscript)				);

/* Functions in slip.c: */
_PROTOTYPE( void slip_in, (int fd)					);
_PROTOTYPE( void slip_out, (int fd)					);


