/*
 * slip.drv	A program for TNET, which reads SLIP encapsulated IP
 *		datagrams from a serial port, and sends them to TNET
 *		for further processing.
 *
 *		IP Datagram dumping routines.
 *
 * Authors:	Original taken from KA9Q NET, Copyright Phil Karn KA9Q.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <setjmp.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <arpa/ip.h>
#include "slip.h"


/*
 * Dump the contents of an IP datagram.
 */
void ip_dump(ptr, len)
char *ptr;
int len;
{
  int hdr_ver;
  int hdr_len;
  int dta_len;
  int dta_off;
  u_long src, dst;
  IP *ip;

  ip = (IP *) ptr;
  hdr_ver = (ip->v_ihl & 0xF0) >> 4;
  hdr_len = (ip->v_ihl & 0x0F) * sizeof(long);
  dta_len = ntohs(ip->length);
  dta_off = (ntohs(ip->fl_offs) & IPF_F_OFFSET) << 3 ;

  src = ip->source;
  dst = ip->dest;

  fprintf(stderr, "\r*****\n");
  fprintf(stderr, "IP: %s->", inet_ntoa(src));
  fprintf(stderr, "%s\n", inet_ntoa(dst));
  fprintf(stderr, " len %u ihl %u ttl %u prot %u",
	dta_len, ip->v_ihl & 0xFF, ip->ttl & 0xFF, ip->protocol & 0xFF);

  if (ip->tos != 0) fprintf(stderr, " tos %u", ip->tos);
  if (dta_off != 0 || (ntohs(ip->fl_offs) & IPF_MF))
	fprintf(stderr, " id %u offs %u", ntohs(ip->id), dta_off);

  if (ntohs(ip->fl_offs) & IPF_DF) fprintf(stderr, " DF");
  if (ntohs(ip->fl_offs) & IPF_MF) fprintf(stderr, " MF");
  fprintf(stderr, "\n*****\n");
  (void) fflush(stderr);
}
