/*
 * ether.drv	A program for TNET, which reads IEEE Ethernet encapsu-
 *		lated IP datagrams from an Ethernet driver, and sends
 *		them to TNET for further processing.
 *
 *		Definitions for the TNET ETHER driver.
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */

/* SLIP protocol configuration. */
#define DEF_MTU		1500
#define DEF_BUFS	1


#ifndef GLOBAL
#   define GLOBAL	extern
#endif
GLOBAL int opt_d;			/* flag: dump incoming IP packs */
GLOBAL int opt_v;			/* flag: be verbose!		*/
GLOBAL jmp_buf env;
	
GLOBAL int ec_mtu;			/* ETHER MaxTransferUnit number	*/
GLOBAL int ec_mode;			/* ETHER current operation mode	*/
GLOBAL int ec_bufs;			/* SLIP # of serial I/O buffers	*/

/* Function prototyping according to ANSI. */
#ifndef _PROTOTYPE
#    if _MINIX
#	include <ansi.h>
#    else
#	define _ANSI		0
#	ifdef __STDC__		
#	    if (__STDC__ == 1)	
#	    	undef _ANSI
#	    	define _ANSI	1
#	    endif
#	endif
#	if _ANSI
#	    define	_PROTOTYPE(function, params)	function params
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST		const
#	    define	_VOLATILE	volatile
#	    define	_SIZET		size_t
#	else
#	    define	_PROTOTYPE(function, params)	function()
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST
#	    define	_VOLATILE
#	    define	_SIZET		int
#	endif /* _ANSI */
#    endif /* _MINIX */
#endif	/* _PROTOTYPE */

/* Functions in ether.c: */
_PROTOTYPE( int eth_init, (char *dev_name)				);

/* Functions in ipdump.c: */
_PROTOTYPE( void ip_dump, (char *ptr, int len)				);

_PROTOTYPE( void in_eth, (int fd)					);
_PROTOTYPE( void out_eth, (int fd)					);
