.\"#
.\"#			TNET: an implementation of TCP/IP
.\"#
.\"#			    Version 2.00 of 07/07/92
.\"#
.\"#				    I N T R O
.\"#
.\"#		    Michael Temari <temari@temari.ae.ge.com>
.\"#		Fred N. van Kempen <waltje@uwalt.nl.mugnet.org>
.\"#

.CD "I N T R O D U C T I O N"
.br
Many small UNIX-based systems for microcomputers, most notably the ones
lying in the "hobby" corner of this area, lack an implementation of the
TCP/IP networking protocols.  This basically means that users of such
systems have to muther around with UUCP and various homebrew types of
network protocols, even though they often have the hardware needed to use a
standard protocol like TCP/IP.
.sp 1
.B TNET
tries to fill in this (void *)NULL.  It is a port of the
.B KA9Q/NET
program, written by Phil Karn, and implements the full set of standard
TCP/IP protocols, including
.B UDP
,
.B TCP
,
.B IP
,
.B ICMP
and
.B ARP.
The TNET main program (called the TNET kernel, or kernel for short)
runs in user space as a normal "server" type program.  It receives requests
from other processes to attach or detach devices for packet transport, it
can be asked to actively or passively open a network connection, and so
forth.  This is the
.B "top level"
interface offered by TNET, and it has been structured into a "system call"
type of layer to make it portable to systems other than MINIX and PowerMOS
(Coherent, for example).
.sp 1
The
.B "bottom level"
interface of TNET is that to its attached device drivers.  Since we did not
want TNET to know anything about its underlying hardware, we opted for
having TNET spawn external programs that do the actual input and output of
IP datagrams.  At the time of this writing, the
.B SLIP
protocol device driver can be used to send and receive datagrams over serial
("tty") lines (which is a common type of hardware to have on UNIX-like
systems), and, if a kernel resident Ethernet hardware driver is present, it
is possible to attach the
.B ETHER
protocol driver to the TNET kernel.  More types of protocol drivers (
.B CSLIP
,
.B PPP
,
.B AX.25
) will probably added as we continue to develop this package, so watch this
space for more...

.CD "UPPER LEVEL INTERFACE"
.br
As said before, the upper level of TNET (the COMMAND level) is simply a
system call dispatcher.  So, one can call various functions of the TNET
kernel by issuing a well-defined "system call" to it, much like how it is
done in the underlying operating system.
.sp 1
Since TNET is supposed to run on many types of systems, we opted for a
somewhat unusual approach when it comes to sending system calls to the TNET
kernel.  In MINIX, for example, it would be well possible to link TNET to the
operating system, and implement some native system calls in MINIX (which
preferrably look like the BSD ones :-) that cause the OS to talk to TNET.
This is a possibility that will be researched in the future.
.sp 1
On other systems, however, it is impossible to add modules to the operating
system itself.  The only mechanism of Interprocess Communications widely
available on UNIX-like system is the pipe, and, to be more precise, the
named pipe.  This is a "file" that can be opened by two processes (of course
it has to be created first...), and then one process can write bytes into
it, which the other process can read from its end of the pipe.  For full
duplex communication between two processes, two pipes are needed, one for
each direction.
.sp 1
The upper level command interface consists of a
.B "named pipe"
(with awell-known name, defined in the TNET header files) which can be
written to by any other process.  We call this the
.B "COMMAND CHANNEL"
of TNET.  TNET simply waits for something to arrive in that pipe by setting
it to non-blocking READ mode (alas, _this_ has to be patched into the MINIX
operating system to get TNET to run...) and then continuously tries to read
from it.  This eats lots of CPU time of course, but for now, it is the only
way without having to change the underlying OS (MINIX) to accomodate TNET.
.sp 1
So, processes have a way of talking to TNET.  They create a system call
structure in their data space, open the TNET control channel, and write the
structure to it, after which they close the channel for others to use.  This
is of course nice, but they do not have a channel from which they can read
an answer from TNET, since the pipe (which was WRITE-only, anyway) to TNET
has been closed. Creating a similar TNET STATUS channel is dangerous, because
it would be possible for several processes to start reading that pipe,
leading to certain disaster.  The solution was to have an extra field in the
command message structure, containing the name (14 charachters max) of the
pipe that TNET should write the result to.  After writing the command to
the TNET kernel, the client opens that pipe and waits for the result to
arrive.  Both TNET and its clients know where to find pipes, since the
general TNET header file
.B <tnet/tnet.h>
defines the name of the main TNET directory (/etc, or /etc/tnet), the name
of the TNET COMMAND channel pipe (relative to the TNET directory), and the
name of the directory in which user pipes can be found (also, relative to
the TNET main directory). Needless to say, that the latter directory has to
be writable by all, since the client/server code will otherwise fail to read
the result...
.sp 1
In order to execute a TNET system call, a client process must create a name
for its return pipe (it must be unique, and that is the reason why the TNET
header file has a definition for the names of these return pipes), and fill
in a
.B command
data structure. Then it opens the TNET COMMAND channel, writes the structure
to it, possibly followed by writing any extra system-call dependent data.
Finally, it closes the COMMAND channel.  After the client has opened its
return channel pipe, it _could_ issue a READ call on it, but that is
dangerous, since the TNET kernel may crash, leaving the clients hanging on
their READ calls.  Instead, the client now starts an alarm timer, and issues
the READ call.  When the timer expires before an answer is read, it closes
the pipe and returns an error code telling that the TNET server is not
responding.  Otherwise, it extracts the result structure from the pipe,
followed by any system-call dependent data and closes the channel.
Of course, the pipe is removed when it is no longer needed (i.e. an error,
or successful return of the call).
.sp 1
The command structure looks like this:
.sp 1
.nf
typedef struct {
  u_short	c_opcode;		/* what system call is desired	*/
  u_short	c_pid;			/* process ID of caller		*/
  u_short	c_uid;			/* (effective) UID of caller	*/
  char		c_return[14];		/* name of return pipe		*/
  u_short	c_i1, c_i2, c_i3;	/* three integer parameters	*/
  u_long	c_l1, c_l2, c_l3;	/* three long int parameters	*/
  u_short  	c_length;		/* length of data portion	*/
} RMTHDR;
#define RMTHDR_LEN		(sizeof(RMTHDR))
.fi
.sp 1
This is a fixed-size header, which is always read and writtin in an
atomic fashion.  The "
.B opcpode
" field tells TNET what operation is desired (see defs below). The "
.B pid
" field is a means to identify the calling process (note that we cannot
tell otherwise!).  The "
.B uid
" field tells TNET what the (effective) ID the calling process has, to
decide whether it may or may not execute certain dangerous calls.. The "
.B return
" array of characters contains the name of the pipe from which the calling
client expects to read the system call result status. This result is also a
structure of this type, to allow for easy decoding. The six "
.B parameter
" fields are in the header to allow simple system calls to stash their
parameters in the header, without the need for writing a second (possibly
non-atomic) structure.  This of course creates a bit of "message size"
overhead, but experience has proven this is usually a good way to do it.
Finally, the "
.B length
" field identifies how much system-call dependent data follows this message
header.  If it is 0, no data follows the header.
.sp 1
When TNET finished a request (it called an internal procedure to perform
the actual work), it fills in a reply message (which is a command structure
with the "
.B opcode
" field set to the system call status code, opens the return pipe for
writing, and writes the reply structure to it, followed by any system-call
dependent data.  Finally, it closes the return pipe and returns to its main
loop.
.sp 1
The following opcodes (TNET system calls) are currently defined:
.sp 1
.CO EXIT "Terminate the TNET kernel"
.CO STOP "Temporarily suspend the TNET kernel"
.CO START "Restart the TNET kernel"
.CO ATTACH "Attach a device to TNET"
.CO DETACH "Detach (remove) a device from TNET"
.CO IFCONFIG "Configure an attached interface"
.CO SETHOSTID "Set the TNET IP address"
.CO GETHOSTID "Fetch the TNET IP address"
.CO SETHOSTNAME "Set the name of the system"
.CO GETHOSTNAME "Fetch the name of this system"
.CO SETDOMAINNAME "Set the domain name of this system"
.CO GETDOMAINNAME "Fetch the domain name of this system"
.CO ROUTE "Manage the internal routing table"
.CO ARP "Manage the internal ARP cache"
.CO IP "Configure the IP protocol layer"
.CO TCP "Configure the TCP protocol layer"
.sp 1
All of these will be explained in detail in the next chapter.
