.\"#
.\"#			TNET: an implementation of TCP/IP
.\"#
.\"#			    Version 2.00 of 07/07/92
.\"#
.\"#				  D R I V E R S
.\"#
.\"#		    Michael Temari <temari@temari.ae.ge.com>
.\"#		Fred N. van Kempen <waltje@uwalt.nl.mugnet.org>
.\"#

.CD "THE BOTTOM LAYER"
Device drivers are an ugly fact of life, especially when you are writing
application-level software that does have to work with several types of
underlying hardware.  The TNET software system is such an application,
because it must know how to do I/O with its underlying hardware (link
level) connections.
.sp 1
To free the TNET kernel (or any application program, for that matter)
from having to know about any details, systems programmers created
special programs for their operating systems, which can be called in
a (sort-of) hardware independent way.  These programs (or object
modules inside the OS) are called
.B "device drivers"
or even
.B "I/O tasks"
and can usually be used much like an ordinary file.  This means, that
one can
.B open
a device driver for usage by opening its associated device driver
file, which results in a file descriptor with which we can call the
system read(2) and write(2) entry points.
.sp 1
However, this solution does not free a program like the TNET kernel
from knowledge about what protocol is being used on a certain piece
of hardware, and such kind of details.  For example, on a standard
serial line (the UNIX operating system calls them "terminal lines"),
one can simply send and receive data in a byte-oriented fashion (which
is what a terminal or a modem does), and one can arrange for the bytes
to be sent in packets of data, which allows for connection multiplexing.
In turn, it is possible to choose from many of such "packet" protocols,
which is what a program like TNET needs.
.sp 1
When looking (again) at serial lines, we can see that some of the
more popular protocols used are:
.sp 1
.IN
1. PK, the  packet protocol first implemented on the Seventh Edition
   of the UNIX operation system. It is not being used much, although
   it is easy to implement.

2. SLIP, the Serial Line Internet Protocol.  This  protocol takes IP
   datagrams, and converts ("encapsulates") them into  a format that
   can be sent over a serial line to  another system that also has a
   SLIP driver running.

3. CSLIP, or "Compressed SLIP".  This is basically the same protocol
   as SLIP, except for the fact that it also does compression of the
   data sent, and decompression of any received data.  This may save
   a lot of line bandwidth.

4. PPP, or Point to Point Protocol. This is the latest protocol that
   can be used to connect two computers over a serial line. PPP also
   does data compression/decompression, and is more general than the
   (IP-based) SLIP/CSLIP protocol.

In addition to the above protocols, there are also several protocols
that deal with network hardware like Ethernet, ARCnet and TokenRing.

.NI
TNET has separate programs ("drivers") for each of these protocols, and
these will be updated and expanded whenever there is need for it.  To
make attaching these drivers simple, a common way of setting up these
drivers is needed.  The rest of this chapter handles the strategy used
to set up a protocol driver interface.

.HD "General Protocol Driver Interface"
When booted up, the kernel does not know anything, since all setup
is done by sending it system calls with the needed info. The only
"protocol driver" is the internal driver called
.B loopback
, which is actually the lower half of the TNET IP protocol.  Thus,
the loopback device is the driver for all 
.B local
packets of data.  This driver (the usual term for drivers is
.B interfaces
when dealing with TCP/IP software) is entered into the IP routing
table whenever the kernel's IP address is being set (so, when the
kernel gets its address, local IP traffic can pass through).
.br
The connections to other systems are enabled via two setup commands
called
.B attach
and
.B route
, the first of which tells the TNET kernel to start a protocol driver
for a certain type of communications hardware, and to attach that
driver to an
.B interface
to which the protocol layers can talk.  The latter command instructs
the TNET kernel to add a
.B "routing table entry"
, so the IP layer knows which interface to use to get to a certain
IP address.  The following is a sample attachment:
.sp 1
.IN
  # Tell TNET its host.domain name and IP address.
  /etc/tnet/bin/hostname -S
  /etc/tnet/bin/ip addr 137.24.101.1

  # Attach the "InterNET" SLIP line and setup a default route.
  /etc/tnet/bin/attach slip sl0 tty5 600 1 b2400
  /etc/tnet/bin/route add default sl0

  # Attach the "bonjovi" SLIP line and set a route to it.
  /etc/tnet/bin/attach slip sl1 tty6 600 1 b38400
  /etc/tnet/bin/route add bonjovi sl1
.NI
.sp 1
The first two commands tell TNET its host/domain name (which is needed
by some programs), and it is told its main IP address.  As dicsussed
above, the latter causes the kernel to add a route to this address to
be added to the routing table, using the "loopback" interface.
.br
The second series of instructions will have the effect that TNET starts
up a SLIP protocol driver, attached to serial port /dev/tty5, with baud
rate (line speed) equal to 2400bps.  This driver will be connected to
interface "sl0", and it serves as the "default" route (i.e. the path
to which all packets for non-local addresses go).
.br
The final bunch of commands tells the kernel to start up a SLIP driver
(connected to serial line /dev/tty6 operating at 38400bps), and to connect
it to interface "sl1".  This interface is the path to the machine called
"bonjovi", which' address is first looked up in the system's "hosts" file.
.sp 1





I would prefer that ALL the SLIP code went into SLIPRECV, which
would then become SLIPDRV.  Something like:
.sp 1
.IN
  slipdrv [-b baud] [flags] [-i in_pipe] [-o out_pipe] \
		[-m mtu] iface tty_name
.NI
.sp 1
One could then send IP dgrams to a SLIP device by writing into the
/tmp/slip_p_out named pipe (or, by writing to the stdin of the
driver- whatever you like), and incoming IP dgrams can be read  
from the driver by reading the /tmp/slip_p_out pipe, or by
reading the driver's stdout.
.sp 1
I must admit that I have an alterior motive for this. If we
get all SLIP code into one program, I can then add my IP
frame buffer management code added in, to allow for datagram
buffering inside _the_driver_ (pipes have a write limit of
4-10 K in most *X'es).
.sp 1
Also, creating similar drivers for PPP and CSLIP would become
much easier- TNET does not, and will not ever, know about it.
TNET just knows about IP dgrams....
.sp 1
Now I come to think of it, it might even be possible to have
the driver fork itself, to allow for "multi-threaded" READ
RECV) and WRITE (SEND) operations...
Perhaps we could also have the driver tell TNET how many more
dgrams are waiting to be read:
.sp 1
.IN
  struct pipe_header {
    int16 dg_channel;	/* channel (interface) number of this driver */
    int16 dg_length;	/* length of IP datagram */
    int16 dg_nmore;	/* how many more dgrams are available in driver */
  };
.NI
.sp 1
I think this would work for all kinds of "drivers". If TNET wants to
know the Ether address of an ethernet card, it sends a "ReqAddr"
control message to the ETHDRV program via its control pipe, and
then reads the result from the status pipe...
.sp 1
So, TNET allocated two named pipes for comms with the driver, and
passes the names thereof to the driver.  Optionally, the device's
baud rate (SLIP, CSLIP, PPP) and other flags (ETHER, X.25, AX.25)
are passed as well. The "-m mtu" flag specifies a maximum xfer
unit count, which overrides any defaults. Finally, the two real
arguments are the names of the UNIX device file that has to be
opened (eg /dev/tty6, or /dev/ether0), and the name of the interface
that the driver is servicing.  The latter has to be known by programs
like SLIPLOGIN.
.br
The attachment is done via NETCOM:
.sp 1
.IN
  attach <class> <label> <device> <mtu> [optional flags]

  eg    attach slip sl0 /dev/tty6 600 -b115200
        ==> exec /etc/tnet/slipdrv -b115200 -m600 \
                -i/etc/tnet/tmp/tndi_XXXXX
                -o/etc/tnet/tmp/tndo_XXXX /dev/tty6 sl0

  or    attach eth ec0 /dev/wd8003 1500
        ==> exec /etc/tnet/ethdrv -m1500 \
                -i/etc/tnet/tmp/tndi_XXXXX \
                -o/etc/tnet/tmp/tndo_XXXXX /dev/ether ec0
.NI
.sp 1
When the driver gets started, it forks once to get separate 'servers' for
data input (from device to TNET, blocking) and output (from TNET to the
device).  Each of the two then opens the device (O_RDONLY and O_WRONLY)
and the corresponding pipe to TNET.  It sets any flags needed (baud rate,
multicast mode, promisc mode, the lot) and starts running.
.sp 1
when a packet has arrived and the driver decodes it into an ip datagram
the packet driver writes to the driver control pipe a datagram update
message which says what channel and how many datagrams are waiting.
.br
The driver then sends a signal to tnet so that it can read the driver
control pipe
