.\"#
.\"#			TNET: an implementation of TCP/IP
.\"#
.\"#			    Version 2.00 of 07/07/92
.\"#
.\"#			    S Y S T E M    C A L L S
.\"#
.\"#		    Michael Temari <temari@temari.ae.ge.com>
.\"#		Fred N. van Kempen <waltje@uwalt.nl.mugnet.org>
.\"#

.CD "S Y S T E M    C A L L S"
.br
This chapter describes which system calls TNET knows about, and how the
respective messages should be constructed.  For all of the system calls,
the
.B libtnet.a
library has a C procedure that client processes can call.  These library
procedures in turn call a low-level function called
.B "tn_rlink()"
to call the TNET kernel via the mechanism described in the previous
chapter. The calling syntax of this function is:
.sp 1
.ti +5
int tn_rmtlnk(RMTHDR *ptr, char *buf, int len, int tm, int *netfd);
.sp 1
The first parameter is a pointer to the message it must fill in and
send to the TNET kernel.  The structure must have been built by the
calling function, and this function fills in the low-level fields.
The second parameter is a pointer to the user data to be sent to the
TNET kernel (the length of which is determined by the
.B c_length
fields of the message itself).  It is also the pointer to a buffer in
the caller's space in which any return data can be placed.  The length
of this buffer, if any, is determined by the third parameter.  The
fourth parameter is the number of seconds that it must wait at most to
receive an answer.  If it is zero (0), then it should wait forever and
not time out at all.  Finally, the fifth parameter is a pointer to an
integer variable in which the file descriptor of the caller's return
channel can be put.  It is currently only used by the
.B CONNECT
system call, which will be changed in the future to use a different
mechanism for setting up connections with the kernel.
.sp 1
This function fills in the remaining fields of the message
header (the
.B pid
and
.B uid
fields, most notably) and starts opening pipe files for communication
with TNET.  First, it opens the COMMAND CHANNEL for writing.  If this
fails, an error is returned. Otherwise, it writes the message structure
and (if present) any user data to the channel, and closes it again.
Since writing to pipes must be done atomically, this function builds a
large structure containing of the message header,
.B plus
a data field of a certain maximum length (say, of at most 4 Kbyte), and
writes that structure as a whole.  This ensures that it is also received
as a whole by the TNET kernel.
.br
If the
.B timeout
parameter is not equal to zero (0), it starts an alarm timer to send it a
signal within the amount of seconds specified (this should be enough for
TNET to do its work, a reasonable value would be 30). After setting the
timer, it opens the return channel pipe, and issues a read(2) operating
system call on its status pipe, waiting for either the timer to expire,
or a reply to come in.  In either case, the pipe is closed, and the
remaining file is removed, since it is no longer needed.
.sp 1
If the timer expired
.B before
an answer was received, an error code "
.B "TimeOut"
is returned, to indicate the situation.  Otherwise, it returns the "
.B OK
" code, to indicate that all went well, and that the real result is
in the reply message from the TNET kernel (the TNET calling convention
states that it is in the
.B c_opcode
message field).
.sp 1
.HD EXIT
Executing this call causes the TNET kernel to terminate itself gracefully
after replying to this message (to prevent the caller from hanging). It
can be used if the TNET services are no longer required by the operator
of the system.  Needless to say, that this call is a dangerous one, and
it should be possible only for the super-user to execute this call.
.sp 1
.IN USAGE

#include <tnet/tnet.h>
#include <tnet/client.h>

int tn_exit(void);

.NI

.HD STOP
The STOP call can be used if the TNET kernel has to be shut down for a
certain amount of time (remember, that it consumes a lot of CPU time,
which sometimes is needed for other processes!).  When received, TNET
sets an internal "I am suspended" flag, and replies to the caller. It
then returns to its main loop, where it sees the flag.  This causes
TNET to again enter the main loop, but without using the NON_BLOCK
option (the cause of the need for CPU time).  It remains in this loop
until it receives a valid START command, at which it clears the flag
and resumes normal (time-consuming) operation. Of course, this call
may only be executed by the super-user.
.sp 1
.IN USAGE

#include <tnet/tnet.h>
#include <tnet/client.h>

int tn_stop(void);

.NI

.HD START
When TNET has been suspended by the STOP system call, a process must
execute the START call to place TNET into its normal mode of operation,
polling devices and the command channel.  This call may only be executed
by the super-user.
.sp 1
.IN USAGE

#include <tnet/tnet.h>
#include <tnet/client.h>

int tn_start(void);

.NI

.HD ATTACH
The TNET kernel needs to be told what devices to attach, what these
devices can do, and so on.  The
.B NETCOM
program (see the TNET Reference Manual for details on NETCOM) is used
to tell TNET about this kind of things.  The "attach" procedure tells
the kernel to start a device driver, accepting incoming IP datagrams
from it, and it allows TNET to send IP datagrams to it.  This call
may only be executed by the super-user.
.sp 1
.IN USAGE

#include <tnet/tnet.h>
#include <tnet/client.h>

int tn_attach(struct attach *ptr);

.NI
.sp 1
When this function returns with an "
.B OK
" status, the specified device has been attached to the TNET kernel
successfully.  The next logical step would then be to tell TNET to
add a route to that interface.  This call may only be executed by
the super-user.

.HD DETACH
This call tells TNET to remove (detach) an interface from the
interface list, and to terminate the device driver that services the
interface.  Prior to doing this, any routes pointing to this interface
should have been removed, otherwise TNET could get into trouble when
trying to deliver IP datagrams.
.sp 1
.IN USAGE

#include <tnet/tnet.h>
#include <tnet/client.h>

int tn_detach(char *label);

.NI
.sp 1
Of course, this call may only be executed by the super-user.

.HD SETHOSTID
This BSD UNIX compatible call tells the TNET kernel to use the specified
IP address as its own.  This is one piece of information that is of vital
importance to the proper operation of the kernel, so it must be executed
very soon after the kernel starts up.
.sp 1
.IN USAGE

#include <tnet/tnet.h>
#include <tnet/client.h>

int sethostid(u_long id);

.NI
.sp 1
The IP address is presented as a single value of type
.B u_long
, which is defined to be
.B "unsigned long"
(a 32-bit wide unsiged integer). Of course, this call may only be executed
by the super-user.

.HD GETHOSTID
This BSD UNIX compatible call fetches the current IP address of this
system from the TNET kernel.
.sp 1
.IN USAGE

#include <tnet/tnet.h>
#include <tnet/client.h>

u_long gethostid(void);

.NI
.sp 1
If the function returns with the INADDR_ANY value (unsigned long 0), then
there was either an error, or the address had not been set before by the
SETHOSTID call.  This call may only be executed by the super-user.

.HD SETHOSTNAME
This BSD UNIX compatible call can be used to tell the TNET kernel what its
host name is. Since the kernel does not read any configuration files at
startup (this may not be possible if the TNET kernel is linked to an
operating system in the future!), it does not know anything about matters
like these.  So, library functions exist to read certain configuration
files and then issue a TNET system call to let it know about it.
.sp 1
The host and domain names of a system are kept in a TNET system file, which
name is defined in the TNET header file.  The 
.B hostname(1)
program reads this file, extracts the system's host and domain name, and
executes the SETHOSTNAME and/or SETDOMAINNAME calls to pass on these values
to the TNET kernel, for subsequent retrieval by the other related calls.
.sp 1
.IN USAGE

#include <tnet/tnet.h>
#include <tnet/client.h>

int sethostname(char *name, int length);

.NI
.sp 1
Note, that this call can only be executed by the super-user, for obvious
reasons.

.HD GETHOSTNAME
User processes can retrieve the system's current host name by executing
this BSD UNIX compatible call.
.sp 1
.IN USAGE

#include <tnet/tnet.h>
#include <tnet/client.h>

int gethostname(char *mybuff, int length);

.NI
.sp 1
Note, that an error will be returned when the host name has not been
previously set by the SETHOSTNAME call.

.HD SETDOMAINNAME
This BSD UNIX compatible call can be used to tell the TNET kernel what its
domain name is (see also the comments near the SETHOSTNAME call).
.sp 1
.IN USAGE

#include <tnet/tnet.h>
#include <tnet/client.h>

int setdomainname(char *name, int length);

.NI
.sp 1
Note, that this call can only be executed by the super-user, for obvious
reasons.

.HD GETDOMAINNAME
User processes can retrieve the system's current domain name by executing
this BSD UNIX compatible call.
.sp 1
.IN USAGE

#include <tnet/tnet.h>
#include <tnet/client.h>

int getdomainname(char *mybuff, int length);

.NI
.sp 1
Note, that an error will be returned when the host name has not been
previously set by the SETDOMAINNAME call.

.HD ROUTE
After having attached some devices to the TNET kernel, it must be told
to which systems these devices are connected.  This is called setting
up the
.B "routing table"
and this is done at system startup.  The
.B NETCOM
program is the user interface to the ROUTE call, and it converts the
data presented by the user into a format usable by the ROUTE call.
.sp 1
Since this call is actually multiplexed into several sub-calls, we
describe its workings in chapter XXX in full detail.  The only thing
worth telling here is that this call can (you guessed it) only be
used by the super-user.

.HD ARP
The TNET kernel maintains an internal table of mappings between
IP addresses of hosts, and the physical Ethernet addresses to
which any Ethernet traffic has to be sent.  Setting up and
maintaining this table is a dynamic process, mostly by using the
.B ARP
(Address Resolution Protocol) when communicating with hosts over
an Ethernet.  However, it is sometimes useful to check the contents
of the mapping table, or to change (or even set permanently) an
ARP table entry.  Also, it is possible to tell the kernel to drop
one or more of its mappings at once (for example, because you want
to test another route to that machine).
.sp1
The ARP call is just for this kind of work.  It can be used to clear or
view the entire ARP table, or to change, drop or set individual entries of
it.  Since this call is multiplexed into several sub-calls, we describe its
workings in chapter YYY in full detail.  The only thing worth telling here
is that this call can (you guessed it) only be used by the super-user.

.HD "IP and TCP"
Various variables in the IP and TCP protocol layer software can be altered
by issuing system calls to the TNET kernel.  This of course results in a
highly configurable system, without the need for recompilation. The key
function to do this are these calls:
.sp 1
.IN USAGE

#include <tnet/tnet.h>
#include <tnet/client.h>

int tn_ipval(int code, u_short val);
int tn_tcpval(int code, u_short val);

.NI
.sp 1
Currently, the following variables can be changed:
.sp 1
.CO ip_ttl "change or set the IP TTL field value"
.CO tcp_mss "change or set the TCP MSS field value"
.CO tcp_window "change or set the TCP WINDOW field value"
.sp 1
When setting the value of a variable, put the code for this
variable in the first parameter (codes can be found in the
<tnet/client> header file), and put the value for that variable
in the second parameter.  The current value of the variable
can be obtained by calling this function with a value equal to
zero (0).
.sp 1
Needless to say, that these calls can only be executed by the
superuser...

.CD "THE ROUTE SYSTEM CALL"
As described in chapter 1, the
.B ROUTE
system call is multiplexed for several sub-calls.  This chapter will
discuss all possible sub-functions in detail.

.CD "THE ARP SYSTEM CALL"
As described in chapter 1, the
.B ARP
system call is multiplexed for several sub-calls.  This chapter will
discuss all possible sub-functions in detail.
