/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Handle the allocation of a PTY.
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <errno.h>
#include <fcntl.h>
#include <sgtty.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "telnetd.h"


#define DEV_DIR		"/dev"


/*
 * Allocate a PTY, by trying to open one repeatedly,
 * until all PTY channels are done.  If at that point
 * no PTY is found, go into panic mode :-(
 */
int get_pty(pty_inp, pty_outp, tty_inp, tty_outp)
int *pty_inp, *pty_outp, *tty_inp, *tty_outp;
{
  char buff[128], temp[128];
  struct sgttyb tty;
  register int i, j;
  int fd1, fd2;

  for(i = 'p'; i < 't'; i++) {
	j = 0;
	do {
		sprintf(buff, "%s/pty%c%c",
			DEV_DIR, i, (j < 10) ? j + '0' : j + 'a' - 10);

		if (opt_d == 1) {
			(void) write(2, "Testing: ", 9);
			(void) write(2, buff, strlen(buff));
			(void) write(2, "...: ", 5);
		}

		fd1 = open(buff, O_RDWR);
		if (opt_d == 1) {
			if (fd1 < 0) sprintf(temp, "error %d\r\n", errno);
			  else sprintf(temp, "OK\r\n");
			(void) write(2, temp, strlen(temp));
		}

		if (fd1 >= 0) break;

		j++;
		if (j == 16) break;
	} while(1);

	/* Did we find one? */
	if (j < 16) break;
  }
  if (fd1 < 0) return(-1);
  fd2 = dup(fd1);

  if (opt_d == 1) {
	sprintf(temp, "File %s, descs %d %d\n", buff, fd1, fd2);
	(void) write(1, temp, strlen(temp));
  }
  if (fd2 < 0) {
	(void) close(fd1);
	return(-1);
  }

  *pty_inp = fd1;
  *pty_outp = fd2;

  sprintf(buff, "%s/tty%c%c", DEV_DIR, i, (j < 10) ? j + '0' : j + 'a' - 10);
  fd1 = open(buff, O_RDWR);
  fd2 = dup(fd1);

  if (opt_d == 1) {
	sprintf(temp, "File %s, descs %d %d\n", buff, fd1, fd2);
	(void) write(1, temp, strlen(temp));
  }
  if (fd2 < 0) {
	(void) close(fd1);
	return(-1);
  }

  /* Initialize the SLAVE channel. */
  (void) ioctl(fd1, TIOCGETP, &tty);
  tty.sg_ispeed = tty.sg_ospeed = B9600;
  tty.sg_flags = (XTABS | CRMOD | ECHO);
#ifdef CS8
  tty.sg_flags |= BITS8;
#endif
#ifdef BITS8
  tty.sg_flags |= BITS8;
#endif
  tty.sg_erase = '\b';		/* CTRL-H (backspace) */
  tty.sg_kill = '\030';		/* CTRL-X */
  (void) ioctl(fd1, TIOCSETP, &tty);

  *tty_inp = fd1;
  *tty_outp = fd2;
  return(0);
}
