/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Fetch some OS-dependent information.
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <tnet/client.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "telnetd.h"

#if _HAVE_UTS
#   include <sys/utsname.h>
#endif


/* Fetch some system info. */
void os_info(os, name)
char *os;
char *name;
{
  char hostname[32], domainname[128];
  register int c;
#if _HAVE_UTS
  struct utsname un;

  (void) uname(&un);
#ifdef _MINIX
  sprintf(os, "Advanced %s %s%s-%s",
	un.sysname, un.release, un.version, un.machine);
#else
  sprintf(os, "%s UNIX %s", un.sysname, un.release);
#endif /* _MINIX */
  strcpy(name, un.nodename);
#else
  strcpy(os, "Prentice-Hall MINIX 1.5");

  /* Fetch the host name and display it. */
  if ((c = gethostname(hostname, 32)) < 0)
	strcpy(hostname, "unknown");
  if ((c = getdomainname(domainname, 128)) < 0)
	sprintf(name, hostname);
  else
	sprintf(name, "%s.%s", hostname, domainname);
#endif
}
