/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file contains an implementation of the "server"
 *		for the TELNET protocol.  This protocol can be used to
 *		remote-login on other systems, just like a normal TTY
 *		session.
 *
 * Usage:	telnetd [-dv]
 *
 * Version:	@(#)telnetd.c	1.00	07/26/92
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <errno.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "telnetd.h"


#define LOGIN_PRG	"/bin/login"


static char *Version = "@(#) telnetd 1.00 (07/26/92)";


int opt_d = 0;				/* debugging output flag	*/


extern int getopt(), optind, opterr;
extern char *optarg;


void usage()
{
  fprintf(stderr, "Usage: telnetdd [-dv]\n");
  exit(-1);
}


int main(argc, argv)
int argc;
char *argv[];
{
  char os_name[64], sys_name[32];
  char buff[128];
  register int c;
  int pty_in, pty_out;
  int tty_in, tty_out, pid;

  opterr = 0;
  while ((c = getopt(argc, argv, "dv")) != EOF) switch(c) {
	case 'd':
	case 'v':
		opt_d = 1;
		break;
	default:
		usage();
  }

  /* No more arguments allowed. */
  if (optind != argc) usage();

  /* Fetch some OS info. */
  os_info(os_name, sys_name);

  /* Try allocating a PTY. */
  if (get_pty(&pty_in, &pty_out, &tty_in, &tty_out) < 0) {
	sprintf(buff, "I am sorry, but there is no free PTY left!\r\n");
	(void) write(1, buff, strlen(buff));
	return(-1);
  }

  /* Tell the caller who we are. */
  sprintf(buff, "\r\n\r\n%s (%s)\r\n\r\n", os_name, sys_name);
  (void) write(tty_out, buff, strlen(buff));

  /* Fork off a child process and have it execute login(1). */
  if ((pid = fork()) == 0) {
	(void) close(0); (void) close(1); (void) close(2);
	(void) dup(tty_in); (void) dup(tty_out); (void) dup(tty_out);
	for (c = 3; c < 50; c++) (void) close(c);
	cooked(0);

	(void) execl(LOGIN_PRG, LOGIN_PRG, (char *)NULL);
	(void) write(1, "EXEC failed!\r\n", 14);
  } else if (pid < 0) {
	sprintf(buff, "I am sorry, but the fork(2) call failed!\r\n");
	(void) write(1, buff, strlen(buff));
	(void) close(tty_in); (void) close(tty_out);
	(void) close(pty_in); (void) close(pty_out);
	return(-1);
  }

  (void) close(tty_in); (void) close(tty_out);

  terminal(pty_in, pty_out);

  (void) close(tty_in); (void) close(tty_out);
  (void) close(pty_in); (void) close(pty_out);

  /* Shoot any left-over shell or login process. */
  (void) kill(pid, SIGKILL);

  /* We should do some UTMP/WATP accounting here, I think. */
  /* wtmp();  */

  return(0);
}
