#include <sys/types.h>
#include <fcntl.h>
#include <sgtty.h>

#include "telnet.h"

static int TelROpts[LASTTELOPT+1];
static int TelLOpts[LASTTELOPT+1];

static int TelOpts;

static int ThisOpt;

static int telfdout;

static void dowill(), dowont(), dodo(), dodont(), respond();

static struct sgttyb oldtty, newtty;

static void doraw()
{
   newtty.sg_flags &= ~ECHO;
   newtty.sg_flags |= CBREAK;
   newtty.sg_flags |= RAW;
   ioctl(1, TIOCSETP, &newtty);
}

static void docooked()
{
   newtty.sg_flags |= ECHO;
   newtty.sg_flags |= CBREAK;
   newtty.sg_flags &= ~RAW;
   ioctl(1, TIOCSETP, &newtty);
}

void tel_init()
{
int i;

   ioctl(1, TIOCGETP, &oldtty);
   newtty = oldtty;
   for(i = 0; i <= LASTTELOPT; i++) {
	TelROpts[i] = 0;
	TelLOpts[i] = 0;
   }
   TelOpts = 0;
   doraw();
}

void tel_stop()
{
   ioctl(1, TIOCSETP, &oldtty);
}

int tel_in(fdout, telout, buffer, len)
int fdout;
int telout;
unsigned char *buffer;
int len;
{
unsigned char *p, *p2;
int size;

   telfdout = telout;
   p = buffer;
   while(len > 0) {
	while(len > 0 && TelOpts) {
		DoTelOpt((int)*p);
		p++;
		len--;
	}
	if(len == 0) break;
	size = 0; p2 = p;
	while(len--) {
		if(*p == IAC) break;
		p++;
		size++;
	}
	if(size > 0)
		write(fdout, p2, size);
	if(len == 0) break;
	if(*p == IAC) {
		TelOpts = 1;
		p++;
	}
   }
}

int tel_out(fdout, buffer, len)
int fdout;
unsigned char *buffer;
int len;
{
unsigned char *p;

   p = buffer;
   while(len--) {
	if(*p == IAC)
		write(fdout, p, 1);
	write(fdout, p, 1);
	p++;
   }
}

int DoTelOpt(c)
int c;
{
   if(TelOpts == 1) {
	switch(c) {
		case WILL:
		case WONT:
		case DO:
		case DONT:
			ThisOpt = c;
			TelOpts++;
			break;
		case IAC:
			write(telfdout, &c, 1);
		default:
			TelOpts = 0;
	}
	return(TelOpts);
   }
   switch(ThisOpt) {
	case WILL:
		dowill(c);
		break;
	case WONT:
		dowont(c);
		break;
	case DO:
		dodo(c);
		break;
	case DONT:
		dodont(c);
		break;
	default:
		TelOpts = 0;
		return(0);
   }
   
   TelOpts = 0;
   return(1);
}

static void dowill(c)
int c;
{
int ack;

   switch(c) {
	case TELBINARY:
	case TELECHO:
	case TELSUPPRESSGA:
		if(TelROpts[c] == 1)
			return;
		if(c == TELECHO)
			doraw();
		TelROpts[c] = 1;
		ack = DO;
		break;
	default:
		ack = DONT;
   }
   respond(ack, c);
}

static void dowont(c)
int c;
{
   if(c <= LASTTELOPT) {
	if(TelROpts[c] == 0)
		return;
	TelROpts[c] = 0;
	if(c == TELECHO)
		docooked();
   }
   respond(DONT, c);
}

static void dodo(c)
int c;
{
int ack;

   switch(c) {
	default:
		ack = WONT;
   }
   respond(ack, c);
}

static void dodont(c)
int c;
{
   if(c <= LASTTELOPT) {
	if(TelLOpts[c] == 0)
		return;
	TelLOpts[c] = 0;
   }
   respond(WONT, c);
}

static void respond(ack, option)
int ack, option;
{
unsigned char c[3];

   c[0] = IAC;
   c[1] = ack;
   c[2] = option;
   write(telfdout, c, 3);
}
