/* telnet by Michael Temari 06/21/92 */

#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/in.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <netdb.h>
#include <fcntl.h>
#include <sgtty.h>
#include <ctype.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <time.h>
#include <stdio.h>
#include <signal.h>
#include <errno.h>

int keyfd, keypid = -1;

void getkeys()
{
char keys[10];
int s, ppid;

   ppid = getppid();

   while(1) {
	s = read(0, keys, sizeof(keys));
	if(s > 0) {
		write(1, keys, s);
		kill(ppid, SIGUSR1);
	}
   }
}

int start_keyboard()
{
int pfd[2];

   if(pipe(pfd) < 0)
	return(-1);

   switch(keypid = fork()) {
	case -1:perror("Error forking keyboard reader!");
		return(-1);
	case 0:	close(1);
		dup(pfd[1]);
		close(pfd[0]);
		getkeys();
		exit(0);
   }
   close(pfd[1]);
   keyfd = pfd[0];
   fcntl(keyfd, F_SETFL, O_NONBLOCK);
}

void gotkey()
{
   signal(SIGUSR1, gotkey);
}

static char buffer[2048];

main(argc, argv)
int argc;
char *argv[];
{
int netin, netout;
u_short port;
u_long hostip;
struct hostent *hp;
int s, i, ok;

   for(i = 1; i <= _NSIG; i++)
	signal(i, SIG_IGN);

   if(argc < 2) {
	printf("Usage: tterm host [port]\n");
	exit(1);
   }

   if(argc < 3)
	port = 23;
   else
	port = (u_short) atoi(argv[2]);

  hp = gethostbyname(argv[1]);
  if (hp == (struct hostent *)NULL) {
	hostip = (u_long)0;
	printf("Unresolved host %s\n", argv[1]);
	return(0);
  } else
	memcpy((char *) &hostip, (char *) hp->h_addr, hp->h_length);

   s = client(TCP_PTCL, (u_short)0, port, hostip, &netin, &netout);
   if(s != 0) {
	printf("Error %d connecting to host.\n", s);
	return(0);
   }

   ok = 1;

   tel_init();

   if(start_keyboard())
	ok = 0;

   signal(SIGUSR1, gotkey);

   while(ok) {
	s = read(netin, buffer, sizeof(buffer));
	if(s == 0) break;
	if(s == -1 && errno != EINTR) break;
	if(s > 0)
		tel_in(1, netout, buffer, s);
	while(1) {
		s = read(keyfd, buffer, sizeof(buffer));
		if(s == 0)
			ok = 0;
		if(s <= 0) break;
		tel_out(netout, buffer, s);
	}
   }
   if(keypid != -1)
	kill(keypid, SIGKILL);
   tel_stop();
   close(netin); close(netout);
}
