/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		TNET Device Attachment/Detachment/Config commands.
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <errno.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "netcom.h"


_PROTOTYPE( void atusage, (int what)					);
_PROTOTYPE( int tn_attach, (struct attach *ptr)				);
_PROTOTYPE( int slip_atch, (int argc, char **argv)			);
_PROTOTYPE( int cslip_atch, (int argc, char **argv)			);
_PROTOTYPE( int ppp_atch, (int argc, char **argv)			);
_PROTOTYPE( int eth_atch, (int argc, char **argv)			);


static void atusage(what)
int what;
{
  printf("Usage: attach ");
  if (what < 0 || what == 0) printf(
    "slip label device mtu buffers [speed] [telno|script]\n");
  if (what < 0 || what == 1) printf(
    "       cslip label device mtu buffers [speed] [telno|script]\n");
  if (what < 0 || what == 2) printf(
    "       ppp label device mtu buffers [speed] [telno|script]\n");
  if (what < 0 || what == 3) printf(
    "       ether label device mtu buffers\n");
  printf("\n");
}


static int tn_attach(ptr)
register struct attach *ptr;
{
  RMTHDR hdr;
  int st, netin;

  hdr.c_opcode = RMT_ATTACH;
  hdr.c_length = sizeof(struct attach);

  st = tn_rlink(&hdr, (char *) ptr, 0, 10, &netin);
  if (st < 0) return(st);

  (void) close(netin);
  return(hdr.c_opcode);
}


static int slip_atch(argc, argv)
int argc;
char **argv;
{
  struct attach at;
  register char *sp;
  int st;

  if (argc < 4) {
	atusage(0);
	return(-1);
  }

  at.class = ATTCH_SLIP;		/* this is device class SLIP	*/

  strncpy(at.label, argv[0], 16);
  if ((sp = strrchr(argv[1], '/')) != (char *)NULL) sp++;
    else sp = argv[1];
  strncpy(at.device, sp, 16);
  at.mtu = atoi(argv[2]);
  at.buffers = atoi(argv[3]);
  strncpy(at.speed, "", 16);
  strncpy(at.telno, "", 128);

  argc -= 4;
  if (argc > 0) {
	if (*argv[4] == 'B' || *argv[4] == 'b')
			strncpy(at.speed, &argv[4][1], 16);
	  else strncpy(at.telno, argv[4], 128);
	argc--;
  }
  if (argc > 0) {
	if (*argv[5] == 'B' || *argv[5] == 'b')
			strncpy(at.speed, &argv[5][1], 16);
	  else strncpy(at.telno, argv[5], 128);
  }

  st = tn_attach(&at);
  if (st != 0) printf("Attach failed; error code is %d\n", st);
  return(st);
}


static int cslip_atch(argc, argv)
int argc;
char **argv;
{
  struct attach at;
  register char *sp;
  int st;

  if (argc < 4) {
	atusage(1);
	return(-1);
  }

  at.class = ATTCH_CSLIP;		/* this is device class CSLIP	*/

  strncpy(at.label, argv[0], 16);
  if ((sp = strrchr(argv[1], '/')) != (char *)NULL) sp++;
    else sp = argv[1];
  strncpy(at.device, sp, 16);
  at.mtu = atoi(argv[2]);
  at.buffers = atoi(argv[3]);
  strncpy(at.speed, "", 16);
  strncpy(at.telno, "", 128);

  argc -= 4;
  if (argc > 0) {
	if (*argv[4] == 'B' || *argv[4] == 'b')
			strncpy(at.speed, &argv[4][1], 16);
	  else strncpy(at.telno, argv[4], 128);
	argc--;
  }
  if (argc > 0) {
	if (*argv[5] == 'B' || *argv[5] == 'b')
			strncpy(at.speed, &argv[5][1], 16);
	  else strncpy(at.telno, argv[5], 128);
  }

  st = tn_attach(&at);
  if (st != 0) printf("Attach failed; error code is %d\n", st);
  return(st);
}


static int ppp_atch(argc, argv)
int argc;
char **argv;
{
  struct attach at;
  register char *sp;
  int st;

  if (argc < 4) {
	atusage(2);
	return(-1);
  }

  at.class = ATTCH_PPP;			/* this is device class PPP	*/

  strncpy(at.label, argv[0], 16);
  if ((sp = strrchr(argv[1], '/')) != (char *)NULL) sp++;
    else sp = argv[1];
  strncpy(at.device, sp, 16);
  at.mtu = atoi(argv[2]);
  at.buffers = atoi(argv[3]);
  strncpy(at.speed, "", 16);
  strncpy(at.telno, "", 128);

  argc -= 4;
  if (argc > 0) {
	if (*argv[4] == 'B' || *argv[4] == 'b')
			strncpy(at.speed, &argv[4][1], 16);
	  else strncpy(at.telno, argv[4], 128);
	argc--;
  }
  if (argc > 0) {
	if (*argv[5] == 'B' || *argv[5] == 'b')
			strncpy(at.speed, &argv[5][1], 16);
	  else strncpy(at.telno, argv[5], 128);
  }

  st = tn_attach(&at);
  if (st != 0) printf("Attach failed; error code is %d\n", st);
  return(st);
}


static int eth_atch(argc, argv)
int argc;
char **argv;
{
  struct attach at;
  register char *sp;
  int st;

  if (argc != 4) {
	atusage(3);
	return(-1);
  }

  at.class = ATTCH_ETHER;		/* this is device class ETHER	*/

  strncpy(at.label, argv[0], 16);
  if ((sp = strrchr(argv[1], '/')) != (char *)NULL) sp++;
    else sp = argv[1];
  strncpy(at.device, sp, 16);
  at.mtu = atoi(argv[2]);
  at.buffers = atoi(argv[3]);
  strncpy(at.speed, "", 16);
  strncpy(at.telno, "", 128);

  st = tn_attach(&at);
  if (st != 0) printf("Attach failed; error code is %d\n", st);
  return(st);
}


int do_attach(argc, argv)
int argc;
char **argv;
{
  int ret;

  if (argc == 0) {
	atusage(-1);
	return(-1);
  }

  if (!strcmp(argv[0], "slip") || !strcmp(argv[0], "SLIP"))
					ret = slip_atch(--argc, ++argv);
  else if (!strcmp(argv[0], "cslip") || !strcmp(argv[0], "CSLIP"))
					ret = cslip_atch(--argc, ++argv);
  else if (!strcmp(argv[0], "ppp") || !strcmp(argv[0], "PPP"))
					ret = ppp_atch(--argc, ++argv);
  else if (!strcmp(argv[0], "ether") || !strcmp(argv[0], "ETHER"))
					ret = eth_atch(--argc, ++argv);
  else {
	fprintf(stderr, "Attach: unknown device class %s\n\n", argv[0]);
	ret = -1;
  }
  return(ret);
}


int do_detach(argc, argv)
int argc;
char **argv;
{
  RMTHDR hdr;
  int st, netin;

  hdr.c_opcode = RMT_DETACH;
  hdr.c_length = strlen(argv[0]);
  hdr.c_i1 = hdr.c_length;

  st = tn_rlink(&hdr, argv[0], 0, 10, &netin);
  if (st < 0) return(st);

  (void) close(netin);
  st = hdr.c_opcode;
  if (st != 0) printf("Detach failed; error code is %d\n", st);
  return(st);
}


int do_ifconfig(argc, argv)
int argc;
char **argv;
{
  char buff[128];
  RMTHDR hdr;
  int st, netin;

  /* Tell TNET to dump the list of interfaces. */
  hdr.c_opcode = RMT_IFCONFIG;
  hdr.c_length = 0;
  hdr.c_i1 = 0;

  st = tn_rlink(&hdr, (char *)NULL, 0, 10, &netin);
  if (st < 0) {
	printf("ifconfig: error code %d\n\n", st);
	return;
  }
  if (hdr.c_opcode == 0) {
	while(1) {
		st = read(netin, buff, 128);
		if (st > 0) (void) write(1, buff, st);
		  else break;
	}
  } else printf("Error code: %d\n\n", hdr.c_opcode);
  (void) close(netin);
  return(0);
}
