#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <errno.h>
#include <netdb.h>
#include <pwd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define TNET_INETD	"inetd.conf"


typedef struct _ind_ {
  u_short	port;			/* TCP/UDP port number		*/
  u_short	stype;			/* socket type (DGRAM,STREAM)	*/
  u_short	proto;			/* protocol type (TCP,UDP,RPC)	*/
  u_short	flags;			/* WAIT/NOWAIT			*/
  uid_t		uid;			/* service owner's UID		*/
  gid_t		gid;			/* service owner's GID		*/
  char		*path;			/* path name of server program	*/
  char		*args;			/* arguments to server program	*/
  struct _ind_	*next;
} INETD;
#define INF_WAIT	0x0001


static INETD *srv_list = (INETD *)NULL;	/* list of usable services	*/
static INETD *srv_last = (INETD *)NULL;	/* final entry in linked list	*/
static int opt_d = 0;			/* flag: debugging output	*/


static void srv_add(ptr)
INETD *ptr;
{
  ptr->next = (INETD *)NULL;

  if (srv_last == (INETD *)NULL) {
	srv_list = (INETD *) malloc(sizeof(INETD));
	if (srv_list == (INETD *)NULL) {
		fprintf(stderr, "srv_add: out of memory!\n");
		return;
	}
	srv_last = srv_list;
  } else {
	srv_last->next = (INETD *) malloc(sizeof(INETD));
	if (srv_last->next == (INETD *)NULL) {
		fprintf(stderr, "srv_add: out of memory!\n");
		return;
	}
	srv_last = srv_last->next;
  }
  memcpy((char *) srv_last, (char *) ptr, sizeof(INETD));
}


static void srv_show()
{
  register INETD *ptr;

  ptr = srv_list;
  printf("PORT  TYPE   PROTO  FLAGS  UID   GID   Program\n");
  while(ptr != (INETD *)NULL) {
	printf("%-4d  %-4d   %-4d   %05.5x  %-4d  %-4d  %s\n",
		ptr->port, ptr->stype, ptr->proto, ptr->flags,
		(int) ptr->uid, (int) ptr->gid,
		(ptr->path == (char *)NULL) ? "(internal)" : ptr->path);
	ptr = ptr->next;
  }
  printf("\n");
}


static int srv_make(text)
char *text;
{
  char buff[512];
  char temp[32];
  INETD in;
  register char *bp, *p;
  struct servent *sp;
  struct protoent *pp;
  struct passwd *pw;
  char x;

  /* Make a copy of the line. */
  strcpy(buff, text);
  p = buff;

  /* Fetch the service name. */
  while (*p == ' ' || *p == '\t') p++;
  bp = p;
  while (*p && *p != ' ' && *p != '\t') p++;
  *p++ = '\0';
  strcpy(temp, bp);

  /* Fetch the socket type. */
  while (*p == ' ' || *p == '\t') p++;
  bp = p;
  while (*p && *p != ' ' && *p != '\t') p++;
  *p++ = '\0';

  if (!strcmp(bp, "stream") || !strcmp(bp, "STREAM")) in.stype = 0;
    else if (!strcmp(bp, "dgram") || !strcmp(bp, "DGRAM")) in.stype = 1;
    else {
	fprintf(stderr, "Unknown socket type \"%s\"", bp);
	return(-1);
  }

  /* Fetch the protocol name. */
  while (*p == ' ' || *p == '\t') p++;
  bp = p;
  while (*p && *p != ' ' && *p != '\t') p++;
  *p++ = '\0';
  if ((pp = getprotobyname(bp)) == (struct protoent *)NULL) {
	fprintf(stderr, "Unknown protocol \"%s\"", bp);
	return(-1);
  }
  in.proto = pp->p_proto;

  /* See if this host understands the indicated port. */
  if ((sp = getservbyname(temp, bp)) == (struct servent *)NULL) {
	fprintf(stderr, "Unknown port/proto \"%s\"/\"%s\"", temp, bp);
	return(-1);
  }
  in.port = sp->s_port;

  /* Fetch the FLAGS field. */
  in.flags = 0;
  while (*p != '\0') {
	while (*p == ' ' || *p == '\t') p++;
	bp = p;
	while (*p && *p != ' ' && *p != '\t' && *p != ',') p++;
	x = *p;
	if (*p != '\0') *p++ = '\0';
	if (!strcmp(bp, "nowait")) in.flags &= ~INF_WAIT;
	  else if (!strcmp(bp, "wait")) in.flags |= INF_WAIT;
	  else {
		fprintf(stderr, "Unknown flag \"%s\"", bp);
		return(-1);
	}
	if (x == ' ' || x == '\t') break;
  }

  /* Fetch the USER field. */
  while (*p == ' ' || *p == '\t') p++;
  bp = p;
  while (*p && *p != ' ' && *p != '\t') p++;
  *p++ = '\0';
  if ((pw = getpwnam(bp)) == (struct passwd *)NULL) {
	fprintf(stderr, "Unknown user \"%s\"", bp);
	return(-1);
  }
  in.uid = pw->pw_uid;
  in.gid = pw->pw_gid;

  /* Fetch the PATHNAME field. */
  while (*p == ' ' || *p == '\t') p++;
  bp = p;
  while (*p && *p != ' ' && *p != '\t') p++;
  *p++ = '\0';
  if (strcmp(bp, "internal") && strcmp(bp, "INTERNAL")) {
	in.path = (char *) malloc(strlen(bp) + 1);
	if (in.path == (char *)NULL) {
		fprintf(stderr, "Out of memory for \"%s\"", bp);
		return(-1);
	}
	strcpy(in.path, bp);
  } else in.path = (char *)NULL;

  /* Fetch the program arguments, if any. */
  while (*p == ' ' || *p == '\t') p++;
  bp = p;
  while (*p && *p != ' ' && *p != '\t') p++;
  *p++ = '\0';
  if (*bp != '\0') {
	in.args = (char *) malloc(strlen(bp) + 1);
	if (in.args == (char *)NULL) {
		fprintf(stderr, "Out of memory for \"%s\"", bp);
		return(-1);
	}
	strcpy(in.args, bp);
  } else in.args = (char *)NULL;

  /* Add this entry to the server list. */
  srv_add(&in);

  return(0);
}


int main(argc, argv)
int argc;
char *argv[];
{
  char buff[512];
  register FILE *fp;
  register char *sp;
  int lineno, c;
  extern int getopt(), optind, opterr;
  extern char *optarg;

  sprintf(buff, "%s/%s", TNET_DIR, TNET_INETD);
  opt_d = 0;
  opterr = 0;
  while ((c = getopt(argc, argv, "di:")) != EOF) switch(c) {
	case 'd':
		opt_d = 1;
		break;
	case 'i':
		strcpy(buff, optarg);
		break;
	default:
		fprintf(stderr, "BARF on option %c\n", c);
		exit(-1);
  }

  if ((fp = fopen(buff, "r")) == (FILE *)NULL) {
	fprintf(stderr, "inetd: cannot open %s (%d)\n", buff, errno);
	return(errno);
  }

  /* Read all ps of the file. */
  lineno = 0;
  while(fgets(buff, 512, fp) != (char *)NULL) {
	if ((sp = strchr(buff, '\n')) != (char *)NULL) *sp = '\0';
	lineno++;
	if (opt_d) fprintf(stderr, "%04.4d: %s\n", lineno, buff);
	if (buff[0] == '#' || buff[0] == '\0') continue;

	if (srv_make(buff) != 0) {
		fprintf(stderr, " in line %d:\n", lineno);
		fprintf(stderr, "%s\n", buff);
	}

  }

  srv_show();

  (void) fclose(fp);
  return(0);
}
