/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file contains an implementation of the command
 *		that eitehr displays or sets a system's host (and/or
 *		domain) name.
 *
 * Usage:	hostname [-adv] [-S]
 *
 * Version:	@(#)hostname.c	1.00	07/02/92
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <inet/socket.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


static char *Version = "@(#) hostname 1.00 (07/02/92)";


int opt_a = 0;				/* ARPANET domain address	*/
int opt_d = 0;				/* debugging output flag	*/
int opt_s = 0;				/* "set name" flag		*/


_PROTOTYPE( int fetchit, (char *host, char *domain)			);


extern int getopt(), optind, opterr;
extern char *optarg;


int fetchit(host, domain)
char *host;
char *domain;
{
  char buff[128];
  register FILE *fp;
  register char *sp;

  sprintf(buff, "%s/%s", TNET_DIR, TNET_HST);
  if ((fp = fopen(buff, "r")) == (FILE *)NULL) return(-1);
  if (fgets(buff, 128, fp) == (char *)NULL) {
	(void) fclose(fp);
	return(-1);
  }
  if ((sp = strchr(buff, '\n')) != (char *)NULL) *sp = '\0';
  strcpy(host, buff);

  if (fgets(buff, 128, fp) == (char *)NULL) {
	(void) fclose(fp);
	return(-1);
  }
  (void) fclose(fp);
  if ((sp = strchr(buff, '\n')) != (char *)NULL) *sp = '\0';
  strcpy(domain, buff);
  return(0);
}


void usage()
{
  fprintf(stderr, "Usage: hostname [-adv] [-S]\n");
  exit(-1);
}


int main(argc, argv)
int argc;
char *argv[];
{
  char hostname[32], domainname[128];
  register int c;

  opterr = 0;
  while ((c = getopt(argc, argv, "advS")) != EOF) switch(c) {
	case 'a':
		opt_a = 1;
		break;
	case 'd':
	case 'v':
		opt_d = 1;
		break;
	case 'S':
		opt_s = 1;
		break;
	default:
		usage();
  }

  /* No more arguments allowed. */
  if (optind != argc) usage();

  if (opt_s == 1) {
	c = fetchit(hostname, domainname);
	if (c != 0) return(-1);

	if (opt_d ==1) {
		fprintf(stderr, "HOSTNAME=\"%s\"\n", hostname);
		fprintf(stderr, "DOMAIN=\"%s\"\n", domainname);
	}

	/* Set the "host name" part of this new name. */
	if ((c = sethostname(hostname, strlen(hostname))) < 0) {
		if (opt_d == 1) fprintf(stderr,
			"%s: cannot set host name, status %d\n",
						argv[0], errno);
		return(c);
	}

	/* Set the "domain name" part. */
	if ((c = setdomainname(domainname, strlen(domainname))) < 0) {
		if (opt_d == 1) fprintf(stderr,
			"%s: cannot set domain name, status %d\n",
						argv[0], errno);
		return(c);
	}

	return(0);
  }

  /* Fetch the host name and display it. */
  if ((c = gethostname(hostname, 32)) < 0) {
	if (opt_d == 1) fprintf(stderr,
		"%s: cannot get host name, status %d\n", argv[0], errno);
	return(c);
  }
  printf("%s", hostname);
  if (opt_a == 1) {
	if ((c = getdomainname(domainname, 128)) < 0) {
		if (opt_d == 1) fprintf(stderr,
			"%s: cannot get domain name, status %d\n",
							argv[0], errno);
		return(c);
	}
	printf(".%s", domainname);
  }
  printf("\n");
  return(0);
}
