/* quick and dirty address resolver by Michael Temari 06/28/92 */
#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/in.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <netdb.h>
#include <ctype.h>
#include <string.h>
#include <signal.h>
#include <errno.h>
#include <stdio.h>

struct socket {
  u_long address;
  u_short port;
};

struct udp_hdr {
  int size;
  struct socket lsocket;
  struct socket fsocket;
  char data[512];
};

#define	UDPHDR_SIZE	14

struct ns_request {
  u_short	id;
  u_short	flags;
  u_short	qdcount;
  u_short	ancount;
  u_short	nscount;
  u_short	arcount;
};

void wake_up()
{
  signal(SIGALRM, wake_up);
}


int main(argc, argv)
int argc;
char *argv[];
{
struct udp_hdr udp_hdr;
struct ns_request ns_request;
u_short lport, rport;
u_long raddr;
int s, netin, netout;
char *p, *p2, *q, *name;
int i;
struct hostent *hp;

   if(argc < 3) {
	printf("usage: host server name\n");
	exit(-1);
   }
   lport = (u_short)0;
   rport = (u_long)0;
   raddr = (u_long)0;
   s = tconnect(UDP_PTCL, &lport, &rport, &raddr, 0L, &netin, &netout);
   if(s != 0) {
	printf("Connect error %d\n", s);
	exit(-1);
   }
   hp = gethostbyname(argv[1]);
   if(hp == (struct hostent *)NULL) {
	printf("Unresolved host %s\n", argv[1]);
	exit(-1);
   } else
	memcpy((char *) &raddr, (char *) hp->h_addr, hp->h_length);
   while(1) {
	udp_hdr.size = sizeof(ns_request);
	udp_hdr.lsocket.address = ntohl(gethostid());
	udp_hdr.lsocket.port = lport;
	udp_hdr.fsocket.address = ntohl(raddr);
	udp_hdr.fsocket.port = (u_short)53;
	ns_request.id = (u_short)9654;
	ns_request.flags = (u_short)0;
	ns_request.qdcount = htons(1);
	ns_request.ancount = (u_short)0;
	ns_request.nscount = (u_short)0;
	ns_request.nscount = (u_short)0;
	memcpy((char *)&udp_hdr + UDPHDR_SIZE, (char *)&ns_request,
		sizeof(ns_request));
	p = p2 = (char *)&udp_hdr + UDPHDR_SIZE + udp_hdr.size;
	q = p;
	*p++ = 0;
	name = argv[2];
	i = 0;
	do {
		while(*name && *name != '.') {
			*p++ = *name++;
			i++;
		}
		*q = (char )i;
		q = p; i = 0;
		if(*name == '.') {
			name++;
			p++;
		}
	} while(*name);
	*p++ = 0;
	/* QTYPE */
	*p++ = 0;
	*p++ = 1;
	/* QCLASS */
	*p++ = 0;
	*p++ = 1;
	udp_hdr.size += (p - p2);
	s = write(netout, &udp_hdr, UDPHDR_SIZE + udp_hdr.size);
	signal(SIGALRM, wake_up);
	alarm(30);
	s = read(netin, &udp_hdr, UDPHDR_SIZE);
	alarm(0);
printf("S=%d\n", s);
	if(s <= 0) break;
	if(s == UDPHDR_SIZE) {
		s = read(netin, (char *)&udp_hdr + UDPHDR_SIZE,
					udp_hdr.size);
		if(s == 0) break;
		memcpy((char *)&ns_request, (char *)&udp_hdr + UDPHDR_SIZE,
			sizeof(ns_request));
		printf("resolver:\n");
		fflush(stdout);
		p = (char *)&udp_hdr + UDPHDR_SIZE +
				sizeof(struct ns_request);
		p2 = (char *)&udp_hdr + UDPHDR_SIZE + udp_hdr.size;
		while(1) {
			i = (unsigned int)*p++;
			if(i == 0) break;
			p = p + i;
		}
		p = p + 2 + 2 + 4 + 2 + 6;
		printf("%s = %s\n",
			argv[2], inet_ntoa(*(u_long *)p));
	}
	break;
   }
   close(netin); close(netout);

  return(0);
}
