/* ftpd.c by Michael Temari 06/14/92
/*
 * ftpd		An FTP server program for use with TNET.
 *
 * Usage:	tnet usage: start server tcp ftp ftpd
 *
 * Version:	0.10	06/14/92 (pre-release not yet completed)
 * 		0.20	07/01/92
 *
 * Author:	Michael Temari, <temari@temari.ae.ge.com>
 */
#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <arpa/ftp.h>
#include <inet/in.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>
#include <pwd.h>
#include <time.h>
#include <unistd.h>
#include <stdio.h>
#undef	ERROR
#include <errno.h>

extern char *sys_errlist[];

extern char *tzname[2];
char *days[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
char *months[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

static char *msg501 = "501 Syntax error in parameters or arguments.\r\n";
static char *msg530 = "530 Not logged in.\r\n";
static char *msg550 = "550 %s: %s.\r\n";

static char line[512];
static char username[80];

static int loggedin, gotuser;
static int type, format, mode, structure;
static u_long data_addr;
static u_short data_port;

int init()
{
   loggedin = 0;
   gotuser = 0;
   type = TYPE_A;
   format = FORM_N;
   mode = MODE_S;
   structure = STRU_F;
}

char *dir(path, full)
char *path;
int full;
{
char cmd[128];
static char name[32];
extern char *tmpnam();

   tmpnam(name);
   if(full)
	sprintf(cmd, "ls -lg %s > %s", path, name);
   else
	sprintf(cmd, "ls %s > %s", path, name);
   system(cmd);
   return(name);
}

static char buffer[4096];

static int asciisend(fd, fdout)
int fd;
int fdout;
{
int s, len;
char *p, *pp;

   while((s = read(fd, buffer, sizeof(buffer))) > 0) {
	buffer[s] = '\0';
	p = buffer;
	while(s > 0) {
		if((pp = strchr(p, '\n')) == (char *)NULL) {
			write(fdout, p, s);
			break;
		}
		len = pp - p;
		write(fdout, p, len);
		write(fdout, "\r\n", 2);
		p = pp + 1;
		s = s - len - 1;
	}
   }
   return(s);
}

static int binarysend(fd, fdout)
int fd;
int fdout;
{
int s;

   while((s = read(fd, buffer, sizeof(buffer))) > 0) {
	write(fdout, buffer, s);
   }
   return(s);
}

static int sendfile(fd, fdout)
int fd;
int fdout;
{
int s;

   switch(type) {
	case TYPE_A:
		s = asciisend(fd, fdout);
		break;
	default:
		s = binarysend(fd, fdout);
   }

   if(fd > 2)
	close(fd);
   if(s < 0)
	return(-1);
   else
	return(0);
}

static int asciirecv(fd, fdin)
int fd;
int fdin;
{
int s, len;
char *p, *pp;

   while((s = read(fdin, buffer, sizeof(buffer))) > 0) {
	p = buffer;
	buffer[s] = '\0';
	while(s > 0) {
		if((pp = strchr(p, '\r')) == (char *)NULL) {
			write(fd, p, s);
			break;
		}
		len = pp - p;
		write(fd, p, len);
		p = pp + 1;
		s = s - len - 1;
	}
   }
   return(s);
}

static binaryrecv(fd, fdin)
int fd;
int fdin;
{
int s;

   while((s = read(fdin, buffer, sizeof(buffer))) > 0) {
	write(fd, buffer, s);
   }
   return(s);
}

int recvfile(fd, fdin)
int fd;
int fdin;
{
int s;

   switch(type) {
	case TYPE_A:
		s = asciirecv(fd, fdin);
		break;
	default:
		s = binaryrecv(fd, fdin);
   }

   if(fd > 2)
	close(fd);
   if(s < 0)
	return(-1);
   else
	return(0);
}

static int doUNIMP(buff)
char *buff;
{
   printf("502 Command \"%s\" not implemented.\r\n", line);
   return(0);
}

static int doUSER(buff)
char *buff;
{
   loggedin = 0;
   gotuser = 0;
   strncpy(username, buff, sizeof(username));
   if(*username != '\0') {
	printf("331 Password required for %s.\r\n", username);
	gotuser = 1;
   } else
	printf(msg501);

   return(0);
}

static int doPASS(buff)
char *buff;
{
char *name;
struct passwd *pwd;
int bad=0;

   name = username;
   if(!strcmp(name, "anonymous"))
	name = "ftp";
   if(!gotuser || ((pwd = getpwnam(name)) == (struct passwd *)0))
	bad = 1;
   else
	if(strcmp(name, "ftp") && (strlen(pwd->pw_passwd) != 0))
		if(strcmp(pwd->pw_passwd, crypt(buff, pwd->pw_passwd)))
			bad = 1;
   if(bad) {
	printf(msg530);
	return(0);
   }

   if(setgid(pwd->pw_gid) || setuid(pwd->pw_uid) || chdir(pwd->pw_dir))
	printf(msg530);
   else {
	printf("230 User %s logged in, directory %s.\r\n",
		username, pwd->pw_dir);
	loggedin = 1;
   }

   return(0);
}

static int doCWD(buff)
char *buff;
{
   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   if(chdir(buff))
	printf(msg550, buff, sys_errlist[errno]);
   else
	printf("250 %s command okay.\r\n", line);

   return(0);
}

static int doCDUP(buff)
char *buff;
{
   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   return(doCWD(".."));
}

static int doQUIT(buff)
char *buff;
{
   printf("221 Service closing, don't be a stranger.\r\n");
   return(1);
}

static int doREIN(buff)
char *buff;
{
   init();
   printf("220 FTP service ready for the next user\r\n");
   return(0);
}

static int doPORT(buff)
char *buff;
{
u_long ipaddr;
u_short port;
int i;

   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   ipaddr = (u_long)0;
   for(i = 0; i < 4; i++) {
	ipaddr = (ipaddr << 8) + (u_long)atoi(buff);
	if((buff = strchr(buff, ',')) == (char *)0) {
		printf(msg501);
		return(0);
	}
	buff++;
   }
   port = (u_short)atoi(buff);
   if((buff = strchr(buff, ',')) == (char *)0) {
	printf(msg501);
	return(0);
   }
   buff++;
   port = (port << 8) + (u_short)atoi(buff);
   data_addr = ntohl(ipaddr);
   data_port = port;
   printf("200 Port command okay.\r\n");
   return(0);
}

static int doPASV(buff)
char *buff;
{
u_long ipaddr;
u_short port;

   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   ipaddr = gethostid();
   port = 1234;

#define	hiword(x)	((u_short)((x) >> 16))
#define	loword(x)	((u_short)(x & 0xffff))	
#define	hibyte(x)	(((x) >> 8) & 0xff)
#define	lobyte(x)	((x) & 0xff)

   printf("227 Entering Passive Mode (%u,%u,%u,%u,%u,%u).\r\n",
		hibyte(hiword(ipaddr)), lobyte(hiword(ipaddr)),
		hibyte(loword(ipaddr)), lobyte(loword(ipaddr)),
		hibyte(port), lobyte(port));
   return(0);
}

static int doTYPE(buff)
char *buff;
{
   if(*(buff+1) != '\0') {
	printf(msg501);
	return(0);
   }

   switch(*buff) {
	case 'A':
	case 'a':
		type = TYPE_A;
		printf("200 Type set to A.\r\n");
		break;
	case 'I':
	case 'i':
		type = TYPE_I;
		printf("200 Type set to I.\r\n");
		break;
	default:
		printf("501 Invalid type %c.\r\n", *buff);
   }
   return(0);
}

static int doRETR(buff)
char *buff;
{
int fd, s, datain, dataout;

   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   fd = open(buff, O_RDONLY);
   if(fd < 0) {
	printf(msg550, buff, sys_errlist[errno]);
	return(0);
   }
   printf("150 File %s okay.  Opening data connection.\r\n", buff);
   fflush(stdout);
   s = client(TCP_PTCL, (u_short)20, data_port, data_addr, &datain, &dataout);
   if(s < 0) {
	printf("425 Can't open data connection.\r\n");
	return(0);
   }
   s = sendfile(fd, dataout);
   close(fd); close(dataout); close(datain);
   if(s < 0)
	printf("451 Transfer aborted.\r\n");
   else
	printf("226 Transfer finished successfully.\r\n");
   return(0);
}

static int doSTOR(buff)
char *buff;
{
int fd, s, datain, dataout;

   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   fd = open(buff, O_WRONLY | O_CREAT | O_TRUNC, 0600);
   if(fd < 0) {
	printf(msg550, buff, sys_errlist[errno]);
	return(0);
   }
   printf("150 File %s okay.  Opening data connection.\r\n", buff);
   s = client(TCP_PTCL, (u_short)20, data_port, data_addr, &datain, &dataout);
   if(s < 0) {
	printf("425 Can't open data connection.\r\n");
	return(0);
   }
   s = recvfile(fd, datain);
   close(fd); close(dataout); close(datain);
   if(s < 0)
	printf("451 Transfer aborted.\r\n");
   else
	printf("226 Transfer finished successfully.\r\n");
   return(0);
}

static int doALLO(buff)
char *buff;
{
   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   printf("202 ALLO command not needed at this site.\r\n");
   return(0);
}
static int doDELE(buff)
char *buff;
{
   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   if(unlink(buff))
	printf(msg550, buff, sys_errlist[errno]);
   else
	printf("250 File \"%s\" deleted.\r\n", buff);

   return(0);
}

static int doRMD(buff)
char *buff;
{
   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   if(rmdir(buff))
	printf(msg550, buff, sys_errlist[errno]);
   else
	printf("250 Directory \"%s\" deleted.\r\n", buff);

   return(0);
}

static int doMKD(buff)
char *buff;
{
   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   if(mkdir(buff, 0777))
	printf(msg550, buff, sys_errlist[errno]);
   else
	printf("257 \"%s\" directory created.\r\n", buff);

   return(0);
}

static int doPWD(buff)
char *buff;
{
char dir[128];

   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   if(getcwd(dir, sizeof(dir)) == (char *)0)
	printf(msg550, buff, sys_errlist[errno]);
   else
	printf("251 \"%s\" is current directory.\r\n", dir);

   return(0);
}

static int doLIST(buff)
char *buff;
{
char *p;
int s;

   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   p = dir(buff, 1);
   s = doRETR(p);
   unlink(p);
   return(s);
}

static int doNLST(buff)
char *buff;
{
char *p;
int s;

   if(!loggedin) {
	printf(msg530);
	return(0);
   }

   p = dir(buff, 0);
   s = doRETR(p);
   unlink(p);
   return(s);
}

static int doHELP();

static int doNOOP(buff)
char *buff;
{
   printf("200 NOOP okay.\r\n");
   return(0);
}

struct commands {
	char *name;
	int (*func)();
};

static struct commands commands[] = {
	"USER",	doUSER,
	"PASS",	doPASS,
	"ACCT",	doUNIMP,
	"CWD",	doCWD,
	"XCWD",	doCWD,
	"CDUP",	doCDUP,
	"XCUP",	doCDUP,
	"SMNT",	doUNIMP,
	"QUIT",	doQUIT,
	"REIN",	doREIN,
	"PORT",	doPORT,
	"PASV",	doPASV,
	"TYPE",	doTYPE,
	"STRU",	doUNIMP,
	"MODE",	doUNIMP,
	"RETR",	doRETR,
	"STOR",	doSTOR,
	"STOU",	doUNIMP,
	"APPE",	doUNIMP,
	"ALLO",	doALLO,
	"REST",	doUNIMP,
	"RNFR",	doUNIMP,
	"RNTO",	doUNIMP,
	"ABOR",	doUNIMP,
	"DELE",	doDELE,
	"RMD",	doRMD,
	"XRMD",	doRMD,
	"XRMD",	doRMD,
	"MKD",	doMKD,
	"XMKD",	doMKD,
	"PWD",	doPWD,
	"XPWD",	doPWD,
	"LIST",	doLIST,
	"NLST",	doNLST,
	"SITE",	doUNIMP,
	"SYST",	doUNIMP,
	"STAT",	doUNIMP,
	"HELP",	doHELP,
	"NOOP",	doNOOP,
	"",	(int (*)())0
};

static int doHELP(buff)
char *buff;
{
struct commands *cmd;
char star;
int i;
char *space = "    ";

   printf("211-Here is a list of available ftp commands\r\n");
   printf("    Those with '*' are not yet implemented.\r\n");
   i = 0;
   for(cmd = commands; *cmd->name != '\0'; cmd++) {
	if(cmd->func == doUNIMP)
		star = '*';
	else
		star = ' ';
	printf("     %c%s%s", star, cmd->name, space + strlen(cmd->name));
	if(++i == 6) {
		printf("\r\n");
		i = 0;
	}
   }
   if(i)
	printf("\r\n");
   printf("211 Thats all the help you get.\r\n");
   return(0);
}

static int readline(args)
char **args;
{
char *p;

   if(gets(line) == (char *)NULL)
	return(1);
   p = line + strlen(line) - 1;
   while(p != line)
	if(*p == '\r' || *p == '\n' || isspace(*p))
		*p-- = '\0';
	else
		break;
  p = line;
  while(*p && !isspace(*p)) {
	*p = toupper(*p);
	p++;
  }
  if(*p) {
	*p = '\0';
	p++;
	while(*p && isspace(*p))
		p++;
   }
   *args = p;
   return(0);
}

int main(argc, argv)
int argc;
char *argv[];
{
struct commands *cmd;
char *args;
int status;
time_t now;
struct tm *tm;
char buf1[64], buf2[64];
char hostname[128];

   /* Ask the system what our hostname is. */
   if((gethostname(buf1, sizeof(buf1)) < 0) ||
	(getdomainname(buf2, sizeof(buf2)) <0))
		strcpy(hostname, "this.computer");
   else
	sprintf(hostname, "%s.%s", buf1, buf2);
   time(&now);
   tm = localtime(&now);
   printf("220 FTP service ready on %s at ", hostname);
   printf("%s, %d %s %d %02d:%02d:%02d %s\r\n", days[tm->tm_wday],
	tm->tm_mday, months[tm->tm_mon], tm->tm_year,
	tm->tm_hour, tm->tm_min, tm->tm_sec,
	tzname[tm->tm_isdst]);
   fflush(stdout);
   init();
   while(1) {
	if(readline(&args)) {
		printf("221 Connection closing.\r\n");
		break;
	}
	for(cmd = commands; *cmd->name != '\0'; cmd++)
		if(!strcmp(line, cmd->name))
			break;
	if(*cmd->name != '\0') {
		status = (*cmd->func)(args);
	} else {
		printf("500 Command \"%s\" not recongnized.\r\n", line);
		status = 0;
	}
	fflush(stdout);
	if(status)
		break;
   }
}
