/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file contains an implementation of the FINGER
 *		protocol for accessing user information databases.
 *
 * Usage:	finger [-dv] user | [user]@host
 *
 * Version:	@(#)finger.c	1.00	07/02/92
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <errno.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


static char *Version = "@(#) finger 1.00 (07/02/92)";


int opt_d = 0;				/* debugging output flag	*/


extern int getopt(), optind, opterr;
extern char *optarg;


/*
 * Send a FINGER request to a host, requesting information
 * from its user database.  This request is simply a line
 * of text which only contains a user name, a blank line
 * (for _all_ users), or "SYSTEM" for system information.
 */
int finger(who)
char *who;
{
  char user[128], host[128];
  u_long rmt_addr;
  u_short rmt_port;
  struct hostent *hp;
  struct servent *sp;
  register char *p;
  int fd_in, fd_out;
  int s;

  if ((p = strchr(who, '@')) != (char *)NULL) {
	*p++ = '\0';
	strcpy(user, who);
	strcpy(host, p);
  } else {
	strcpy(user, who);
	(void) gethostname(host, 128);
  }

  if (opt_d == 1) fprintf(stderr, "Resolving %s...", host);

  if ((hp = gethostbyname(host)) == (struct hostent *)NULL) {
	fprintf(stderr, "Unknown host %s!\n", host);  
	return(-1);
  } else {
	memcpy((char *) &rmt_addr, (char *) hp->h_addr, hp->h_length);
	strcpy(host, hp->h_name);
  }
  printf("[%s]\n", host);

  /* Now, to which port must we connect? */
  if ((sp = getservbyname("finger", "tcp")) == (struct servent *)NULL) {
	fprintf(stderr, "FINGER port is unknown????\n");
	return(-1);
  } else rmt_port = sp->s_port;

  if (opt_d == 1) fprintf(stderr, " trying %s:%d...\n",
				inet_ntoa(rmt_addr), rmt_port);

  s = client(TCP_PTCL, 0, rmt_port, rmt_addr, &fd_in, &fd_out);
  if (s != 0) {
	fprintf(stderr, "Connection failed: status = %d\n", s);
	return(s);
  }

  /* Send the request. */
  sprintf(host, "%s\r\n", user);
  if (write(fd_out, host, strlen(host)) < 0) {
	fprintf(stderr, "Request failed: status = %d\n", errno);
	return(-1);
  }

  /* Wait for the reply to arrive. */
  do {
	s = read(fd_in, host, 128);
	if (s <= 0) break;
	write(1, host, s);
  } while(1);

  (void) close(fd_in);
  (void) close(fd_out);

  return(0);
}


void usage()
{
  fprintf(stderr, "Usage: finger [-dv] user | [user]@host\n");
  exit(-1);
}


int main(argc, argv)
int argc;
char *argv[];
{
  char who[128];
  register int c;

  opterr = 0;
  while ((c = getopt(argc, argv, "dv")) != EOF) switch(c) {
	case 'd':
	case 'v':
		opt_d = 1;
		break;
	default:
		usage();
  }

  /* Exactly one more argument needed. */
  if (optind != (argc -1)) usage();

  /* We require a host name or IP address. */
  strcpy(who, argv[optind++]);

  /* Do the connection. */
  c = finger(who);

  return(c);
}
