#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/in.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <errno.h>
#include <netdb.h>
#include <string.h>
#include <signal.h>
#include <stdio.h>

struct socket {
	u_long address;
	u_short port;
};

struct udp_hdr {
	int size;
	struct socket lsocket;
	struct socket fsocket;
};

static char buffer[1024];
void wake_up()
{
   signal(SIGALRM, wake_up);
}

main(argc, argv)
int argc;
char *argv[];
{
struct udp_hdr udp_hdr;
u_short lport, rport;
u_long raddr;
int s, netin, netout;
int interval;
struct hostent *hp;

   if(argc < 2) {
	printf("usage: alive host [interval]\n");
	exit(-1);
   }
   lport = (u_short)0;
   rport = (u_long)0;
   raddr = (u_long)0;
   s = tconnect(UDP_PTCL, &lport, &rport, &raddr, 0L, &netin, &netout);
   if(s != 0) {
	printf("Connect error %d\n", s);
	exit(-1);
   }
   hp = gethostbyname(argv[1]);
   if(hp == (struct hostent *)NULL) {
	printf("Unresolved host %s error %d\n", argv[1], errno);
	exit(-1);
   } else
	memcpy((char *) &raddr, (char *) hp->h_addr, hp->h_length);
   if(argv > 2)
	interval = atoi(argv[2]);
   if(interval == 0)
	interval = 30;
   while(1) {
	udp_hdr.size = 0;
	udp_hdr.lsocket.address = ntohl(gethostid());
	udp_hdr.lsocket.port = lport;
	udp_hdr.fsocket.address = ntohl(raddr);
	udp_hdr.fsocket.port = (u_short)9;
	s = write(netout, &udp_hdr, sizeof(struct udp_hdr) + udp_hdr.size);
	signal(SIGALRM, wake_up);
	alarm(interval);
	s = read(netin, &udp_hdr, sizeof(struct udp_hdr));
	alarm(0);
	if(s == 0) break;
	if(s == sizeof(struct udp_hdr)) {
		s = read(netin, buffer, udp_hdr.size);
		if(s == 0) break;
		printf("alive:\n");
		fflush(stdout);
	}
   }
   close(netin); close(netout);
}
