/* Stuff specific to the Western Digital WD8003E Ethernet controller board */

#if (ETHERNET == ETH_WD8003)

/* The EN registers - First, the board registers */

#define EN_CMD		0x00	/* Board's command register */
#define EN_REG1		0x01	/* 8013 bus size register */
#define EN_REG5		0x05	/* New command register (REGISTER 5) */
#define EN_SAPROM	0x08	/* Window on station addr prom */
#define EN_REGE		0x0e	/* Board Id (code) byte */

#define EN_OFF		0x10	/* 8390 offset */

#define ENDCFG_BM8	0x48

/* Board commands in EN_CMD */
#define EN_RESET	0x80	/* Reset the board */
#define EN_MEMEN	0x40	/* Enable the shared memory */
#define EN_MEM_MASK	0x3f	/* B18-B13 of address of the shared memory */

/* Bits in REG1 */
#define ENR1_BUS16BIT	0x01	/* Bus is 16 bits */

/* Commands for REG5 register */
#define ENR5_MEM16EN	0x80	/* Enable 16 bit memory access from bus (8013) */
#define ENR5_LAN16EN	0x40	/* Enable 16 bit memory access from chip (8013) */
#define ENR5_MEM_MASK	0x1f	/* B23-B19 of address of the memory (8013) */
#define ENR5_LA19	0x01	/* B19 of address of the memory (8013) */
#define ENR5_EIL	0x04	/* Enable 8390 interrupts to bus (microchannel) */

/* Bits in the REGE register */
#define ENRE_MICROCHANEL	0x80	/* Microchannel bus (vs. PC/AT) */
#define ENRE_LARGERAM		0x40	/* Large RAM */
#define ENRE_SOFTCONFIG		0x20	/* Soft config */
#define ENRE_REVMASK		0x1e	/* Revision mask */
#define ENRE_ETHERNET		0x01	/* Ethernet (vs. Starlan) */

/* Shared memory management parameters */

#define SM_TSTART_PG		0	/* First page of TX buffer */
#define SM_RSTART_PG		6	/* Starting page of ring */
#define SM_RSTOP_PG		32	/* Last page +1 of ring */

/* End of WD8003E parameter definitions */

/* board_features	db	0	--- Board features */
#define BF_MEM16EN		1	/* 16-bit board, enable 16-bit memory */
#define BF_16K			2	/* Board has 16 KB or shared memory */

#endif	/* WD8003 stuff */
