#include "kernel.h"
#include "ether.h"

#if (ETHERNET == ETH_WD8003)

/* LOCAL FUNCTIONS */
FORWARD void rcopy_subr();

/*===========================================================================*
 *				ram_enable				     * 
 *===========================================================================*/
PUBLIC void ram_enable()
{}

/*===========================================================================*
 *				reset_8390				     * 
 *===========================================================================*/
PUBLIC void reset_8390()
{
  output(EN_CMD, EN_RESET);	/* turn on board reset bit */
  output(EN_CMD, 0);		/* turn it off */
}

/*===========================================================================*
 *				block_output				     * 
 *===========================================================================*/
PUBLIC int block_output(src_addr, sm_offset, count)
phys_bytes src_addr;		/* source buffer location */
vir_bytes sm_offset;		/* board shared memory offset */
vir_bytes count;		/* byte count */
{
  phys_bytes dst_addr;

  dst_addr=ETHER_BASE+(phys_bytes)sm_offset;	/* compute dst physical addr */
/* should word align to the destination writing to WD8003ET/A
 * if odd bytes round up:
 *
 * if (count & 1)
 *   count++;
 */
  rcopy_subr(src_addr, dst_addr, count);
  return OK;
}

/*===========================================================================*
 *				block_input				     * 
 *===========================================================================*/
PUBLIC void block_input(sm_offset, dst_addr, count)
vir_bytes sm_offset;		/* board shared memory offset */
phys_bytes dst_addr;		/* dest buffer location */
vir_bytes count;		/* byte count */
{
  vir_bytes count1;
  phys_bytes src_addr;

  if ((sm_offset+count) > (sm_rstop_ptr<<8))	/* over the top of the ring? */
  {			/* yes, copy in two pieces due to buffer wraparound. */
    count1=sm_rstop_ptr<<8;	/* compute length of first part... */
    count1-=sm_offset;		/* ...as all the bytes up to wrap point */
    src_addr=ETHER_BASE+(phys_bytes)sm_offset;	/* compute src physical addr */
    rcopy_subr(src_addr, dst_addr, count1);
    sm_offset=SM_RSTART_PG<<8;	/* offset to start of first receive page */
    dst_addr+=(phys_bytes)count1;  /* new buffer location */
    count-=count1;		/* bytes left to move */
  }
  src_addr=ETHER_BASE+(phys_bytes)sm_offset;	/* compute src physical addr */
  rcopy_subr(src_addr, dst_addr, count);
}

/*===========================================================================*
 *				rcopy_subr				     * 
 *===========================================================================*/
PRIVATE void rcopy_subr(src_addr, dst_addr, count)
phys_bytes src_addr;		/* source address */
phys_bytes dst_addr;		/* destination address */
vir_bytes count;		/* byte count */
{
/* 16-bit access stuff (if any) would go here */
  phys_copy(src_addr, dst_addr, (phys_bytes) count);	/* do copy */
}

/*===========================================================================*
 *				init_card				     * 
 *===========================================================================*/
PUBLIC void init_card()
{
  int sum, i;

/* Step 1: determine board type */
	/* for now, WD8003 */

/* Step 2: get hardwarre address and verify checkdum */
  for (sum=0, i=0 ; i < sizeof(Eth_addr) ; i++)		/* get 6 bytes */
  {
    sum += input(EN_SAPROM+i);	
    curr_hw_addr.ea[i]=input(EN_SAPROM+i);
  }
  sum += input(EN_REGE);				/* 7th byte */
  sum += input(EN_REGE+1);				/* 8th byte */
  if (sum & BYTE != 0xff)				/* checksum OK? */
    panic("WD Ethernet board not found", NO_NUM);

/* Step 3: determine shared memory size */
  sm_rstop_ptr=SM_RSTOP_PG;

/* Step 4: enable shared memory */
  output(EN_CMD, EN_MEMEN|(EN_MEM_MASK&(ETHER_BASE>>13)));

/* Step 5: determine real shared memory size */
	/* for now, no test */

}

#endif /* ETHERNET - no code after this line ! */
