#include <conio.h>
#include <dir.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char defdir[80], *sourDir, command[128], *comd ;
char dos[80], unix[256] ;

long *direct ;
size_t totalDir ;

FILE *mapFile ;

const ScrLeng = 20 ;

int isDir( char *s ) {

	char x = s[strlen(s) - 1] ;

	return x == '/' || x == '\\' ;
}

void filname( size_t p ) {

	if ( p < totalDir ) {
		fseek( mapFile, *( direct + p ), SEEK_SET ) ;
		fscanf( mapFile, "%256s %80s\n", unix, dos ) ;
	}
}

void procesFile( void ) {

	size_t i = 0 ;
	long pos ;

	rewind( mapFile ) ;
	while ( !feof( mapFile ) ) {
		fscanf( mapFile, "%s %s\n", unix, dos ) ;
		if ( !isDir( unix ) )
			i++ ;
	}
	totalDir = i ;
	direct = ( long * )malloc( i * sizeof ( long ) ) ;
	if ( direct == NULL ) {
		fputs( "Too many file entries.\n", stderr ) ;
		exit( 3 ) ;
	}
	rewind( mapFile ) ;
	i = 0 ;
	while ( !feof( mapFile ) ) {
		pos = ftell( mapFile ) ;
		fscanf( mapFile, "%s %s\n", unix, dos ) ;
		if ( !isDir( unix ) ) {
			*( direct + i ) = pos ;
			i++ ;
		}
	}
}

char *cmd = "TAPV: [Enter]Apply, [NumPad]Scroll [Ins]ReComd [Esc]Bye" ;

void printScrn( void ) {

	gotoxy( 1, 25 ) ;
	cputs( cmd ) ;
	clreol() ;
	gotoxy( 70, 25 ) ;
	cprintf( "[%-8s]", comd ) ;
	clreol() ;
}

char *question( char *ques ) {

	static char ans[83], *r ;

	ans[0] = 81 ;
	gotoxy( 1, 25 ) ;
	clreol() ;
	gotoxy( 1, 25 ) ;
	cprintf( ques ) ;
	r = cgets( ans ) ;
	return r ;
}

void displayFile( size_t pos ) {

	int i ;

	for ( i = 0 ; i < ScrLeng ; i++ ) {
		gotoxy( 1, i + 1 ) ;
		if ( pos + i + 1 > totalDir )
			clreol() ;
		else {
			filname( pos + i ) ;
			cprintf( "%5d %-70s", pos + i + 1, unix ) ;
		}
	}
}

void applyCommand( void ) {

	static char command[160], *ptr, name[80] ;

	clrscr() ;
	if ( comd ) {
		sprintf( name, "%s\\%s", sourDir, dos ) ;
		if ( ( ptr = strstr( comd, "$s" ) ) != NULL ) {
			*ptr = '%' ;
			sprintf( command, comd, name ) ;
			*ptr = '$' ;
		} else
			sprintf( command, "%s %s", comd, name ) ;
		system( command ) ;
	}
	gotoxy( 1, 25 ) ;
	cputs( "Press any key to continue..." ) ;
	clreol() ;
	getch() ;
	clrscr() ;
}

void drawBar( size_t pos, size_t h ) {

	filname( pos ) ;
	gotoxy( 1, 21 ) ;
	cprintf( "%s\\%s", sourDir, dos ) ;
	clreol() ;
	gotoxy( 1, 22 ) ;
	cputs( unix ) ;
	clreol() ;
	gotoxy( 1, pos - h + 1 ) ;
}

void shell( void ) {

	size_t curPos = 0, headPos = 0 ;
	int done = 0, disp = 1 ;

	clrscr() ;
	printScrn() ;
	procesFile() ;
	while ( !done ) {
		if ( disp ) {
			displayFile( headPos ) ;
			disp = 0 ;
		}
		drawBar( curPos, headPos ) ;
		switch ( getch() ) {
			case 0x1b :
				done = 1 ;
				break ;
			case '\r' :
				applyCommand() ;
				disp = 1 ;
				printScrn() ;
				break ;
			case 0 :
			switch( getch() ) {
/* up */		case 0x48 :
				if ( curPos == 0 ) {
					curPos = totalDir - 1 ;
					if ( totalDir > ScrLeng )
						headPos = totalDir - ScrLeng ;
					disp = 1 ;
				} else {
					curPos-- ;
					if ( curPos < headPos ) {
						headPos-- ;
						disp = 1 ;
					}
				}
				break ;
/* down */		case 0x50 :
				if ( curPos == totalDir - 1 ) {
					curPos = 0 ;
					headPos = 0 ;
					disp = 1 ;
				} else {
					curPos++ ;
					if ( curPos >= headPos + ScrLeng ) {
						headPos++ ;
						disp = 1 ;
					}
				}
				break ;
/* PgUp */		case 0x49 :
				if ( curPos >= ScrLeng ) {
					disp = 1 ;
					headPos = headPos < ScrLeng ?
						0 : headPos - ScrLeng ;
					curPos -= ScrLeng ;
				}
				break ;
/* PgDn */		case 0x51 :
				if ( totalDir < ScrLeng )
					break ;
				if ( curPos + ScrLeng < totalDir ) {
					disp = 1 ;
					headPos += ScrLeng ;
					if ( headPos + ScrLeng > totalDir )
						headPos = totalDir - ScrLeng ;
					curPos += ScrLeng ;
				} else if ( headPos != totalDir - ScrLeng ) {
					disp = 1 ;
					headPos = totalDir - ScrLeng ;
				}
				break ;
/* Home */		case 0x47 :
				if ( headPos != 0 ) {
					headPos = 0 ;
					disp = 1 ;
				}
				curPos = 0 ;
				break ;
/* End */		case 0x4f :
				if ( totalDir > ScrLeng )
					if ( totalDir - ScrLeng != headPos ) {
						headPos = totalDir - ScrLeng ;
						disp = 1 ;
					}
				curPos = totalDir - 1 ;
				break ;
/* Ins */		case 0x52 :
				comd = question(
					"Enter DOS Commands while applying :"
				) ;
				printScrn() ;
				break ;

			}

		}
	}
}

char *banner =
	"Tape Archive viewer 1.0\n" ;
char *usage =
	"[Usage]: TARV tar-mapfile source-dir comd\n"
	"tar-mapfile\tmapfile created by LTAR\n"
	"source-dir\tsubdir of archive files\n"
	"comd\t\tcomd you use while applying\n"
	"For example: TARV c:\\mytar.map c:\\mytar type\n" ;

void main( int argc, char *argv[] ) {

	fputs( banner, stderr ) ;

	if ( argc != 4 ) {
		fputs( usage, stderr ) ;
		exit( 1 ) ;
	}

	mapFile = fopen( argv[1], "rt" ) ;
	sourDir = argv[2] ;
	comd = argv[3] ;
	if ( mapFile == NULL ) {
		fprintf( stderr, "Error open %s.\n", argv[1] ) ;
		exit( 2 ) ;
	}

	getcwd( defdir, 80 ) ;
	shell() ;
	fclose( mapFile ) ;
	setdisk( defdir[0] - 'A' ) ;
	chdir( defdir ) ;
	clrscr() ;
}