/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  tools.c						   */
/*        FUNKTIONEN  whoami(), tty(), stripped(), upcased(), length(),    */
/*		      strcopy(), strcomp(), ansi(), mydate(), mytime(),    */
/*	              crypted(), dateconv(), datereconv(), timeconv(),     */
/*		      timereconv(), maybe_locked(), num_stripped(),        */
/*		      rename(), headline(), ttyna(), bigcopy(), lockf(),   */
/*		      unlockf(), shortname(), clearline()		   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  22.12.1991					   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <pwd.h>

#ifdef _SYS7
#include <termcap.h>
#endif


#ifdef _MBOX
#include "mbox.h"
#else
#define VERSION "TOOLS.C"
#define CR 13
#include "mbox.msg"
#endif

#ifdef STRING
#undef STRING
#endif

#ifdef LONGSTRING
#undef LONGSTRING
#endif

#define STRING 81
#define LONGSTRING 256


void unlockf();
void clearline();

char headinfo[STRING];


/***************************************************************************/
/*      FUNKTION  whoami()						   */
/*  BESCHREIBUNG  Name des eigenen SH-Accounts.		 		   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  siehe BESCHREIBUNG                                       */
/***************************************************************************/

char *whoami()
{
  struct passwd *pw_entry;

  pw_entry = getpwuid(getuid());

  if (pw_entry->pw_uid < 0) return (char *) "OOPS";

  return (char *) (pw_entry->pw_name);
}




/***************************************************************************/
/*      FUNKTION  stripped()						   */
/*  BESCHREIBUNG  STRING von fuehrenden und folgenden Leerzeichen be-      */
/*		  freien.                                                  */
/*     PARAMETER  st  =  STRING inclusive Leerzeichen                      */
/*     RUECKGABE  STRING exclusive Leerzeichen                             */
/***************************************************************************/

char *stripped(st)
char st[];
{
  static char s[STRING];

  int i = 0, a = 0, b = 0, c = 0;

  if (st[0] == '\0') return (char *) '\0';
  if ((st[0] == 10) || (st[0] == 13)) return (char *) " ";

  strcpy(s, st);

  while ((s[i] < 33) && (s[i] != '\0')) i++;
  a = i;
  while (s[a] != '\0') a++;
  a--;
  while (s[a] < 33) a--;

  for (c = i; c <= a; c++) {
	s[b] = s[c];
	b++;
  }
  s[b] = '\0';

  return (char *) s;
}





/***************************************************************************/
/*      FUNKTION  upcased()						   */
/*  BESCHREIBUNG  Zeichen eines STRING auf Grossbuchstaben umstellen.	   */
/*     PARAMETER  st  =  STRING mit Gross-/Kleinbuchstaben		   */
/*     RUECKGABE  STRING in Grossbuchstaben                                */
/***************************************************************************/

char *upcased(st)
char st[];
{
  static char s[STRING];

  int i = 0;


  strcpy(s, st);

  while (s[i] != '\0') {
	if (s[i] > 96) s[i] -= 32;
	i++;
  }

  return (char *) s;
}





/***************************************************************************/
/*      FUNKTION  length()						   */
/*  BESCHREIBUNG  Laenge eines STRING ermitteln (ja, ja, "strlen" ...)	   */
/*     PARAMETER  st  =  STRING                                            */
/*     RUECKGABE  Laenge des STRING                                        */
/***************************************************************************/

int length(st)
char st[];
{
  int i = 0;

  while (st[i] != '\0') i++;

  return i;
}




/***************************************************************************/
/*      FUNKTION  strcopy()						   */
/*  BESCHREIBUNG  Einen TeilSTRING aus einem STRING herausschneiden.       */
/*     PARAMETER  st  =  STRING                                            */
/*		  v   =  von Zeichen (1. Zeichen = 0 !!!)		   */
/*		  b   =  bis Zeichen				           */
/*     RUECKGABE  TeilSTRING                                               */
/***************************************************************************/

char *strcopy(st, v, b)
char st[];
int v, b;
{
  static char s[STRING];

  int i = 0, j;


  strcpy(s, st);

  if (length(s) < b) b = length(s);

  for (j = v; j <= b; j++) {
	s[i] = s[j];
	i++;
  }
  s[i] = '\0';

  return (char *) s;
}


/***************************************************************************/
/*      FUNKTION  bigcopy()						   */
/*  BESCHREIBUNG  Einen TeilLONGSTRING aus LONGSTRING herausschneiden.     */
/*     PARAMETER  st  =  LONGSTRING                                        */
/*		  v   =  von Zeichen (1. Zeichen = 0 !!!)		   */
/*		  b   =  bis Zeichen				           */
/*     RUECKGABE  TeilLONGSTRING                                           */
/***************************************************************************/

char *bigcopy(st, v, b)
char st[];
int v, b;
{
  static char s[LONGSTRING];

  int i = 0, j;


  strcpy(s, st);

  if (length(s) < b) b = length(s);

  for (j = v; j <= b; j++) {
	s[i] = s[j];
	i++;
  }
  s[i] = '\0';

  return (char *) s;
}




/***************************************************************************/
/*      FUNKTION  strcomp()						   */
/*  BESCHREIBUNG  Zwei STRINGs vergleichen. Und zwar genau solange, bis    */
/*		  bei STRING1 das Ende ('\0') erreicht ist !!!             */
/*                Gross-/Kleinschreibung wird dabei IGNORIERT !!!          */
/*     PARAMETER  st  =  STRING1                                           */
/*	          tt  =  STRING2                                           */
/*     RUECKGABE  Anzahl der UNGLEICHEN Zeichen                            */
/***************************************************************************/

int strcomp(s, t)
char s[], t[];
{
  int i = 0, a = 0;
  int s1, t1;

  while (s[i] != '\0') {
	s1 = s[i];
	t1 = t[i];
	if ((t1 > 96) && (t1 < 123)) t1 -= 32;
	if ((s1 > 96) && (s1 < 123)) s1 -= 32;
	if (t1 != s1) a++;
	i++;
  }
  return a;
}


/***************************************************************************/
/*      FUNKTION  ansi()						   */
/*  BESCHREIBUNG  TERMCAP-Eintrag fuer ein Terminal in "buf" einlesen,     */
/*		  und angeforderte Sequenzen finden & ausgeben.            */
/*     PARAMETER  code  =  'INIT'  =  Eintrag holen und speichern	   */
/*		  	           =  Sequenz finden & ausgeben            */
/*     RUECKGABE  -1  =  Terminal nicht gefunden                           */
/*		   1  =  Sequenz nicht gefunden				   */
/***************************************************************************/

static char buf[1024];

int ansi(code)
char code[];
{
  char *getenv();
  static char s[STRING];
  char *p = s;
  char *term;

#ifdef _MBOX
  term = &TERMINAL;
#else
  term = getenv("TERM");
#endif

  if (strcomp("INIT", code) == 0) {
	if (tgetent(buf, term) != 1) return -1;
  }
  if (tgetstr(code, &p) == 0) return 1;

  printf("%s", s);

  return 0;
}



/***************************************************************************/
/*      FUNKTION  mydate()						   */
/*  BESCHREIBUNG  Tagesdatum liefern.  					   */
/*     PARAMETER  mode  =  0  =  tt.mm.yyyy				   */
/*			   1  =  tt.mm.yy				   */
/*			   2  =  ttt					   */	
/*     RUECKGABE  Datum                                                    */
/***************************************************************************/

#define TZS      1

char *mydate(mode)
int mode;
{
  struct tm *tp;
  time_t tt;
  char wt[8][11];

  static char s[STRING];

#ifndef _MBOX
  strcpy(wt[0], "Sonntag");
  strcpy(wt[1], "Montag");
  strcpy(wt[2], "Dienstag");
  strcpy(wt[3], "Mittwoch");
  strcpy(wt[4], "Donnerstag");
  strcpy(wt[5], "Freitag");
  strcpy(wt[6], "Samstag");
#else
  strcpy(wt[0], TOL01_MSG);
  strcpy(wt[1], TOL02_MSG);
  strcpy(wt[2], TOL03_MSG);
  strcpy(wt[3], TOL04_MSG);
  strcpy(wt[4], TOL05_MSG);
  strcpy(wt[5], TOL06_MSG);
  strcpy(wt[6], TOL07_MSG);
#endif

  time(&tt);
  tp = localtime(&tt);
  if (mode == 0) {
	sprintf(s, "%02.2d.%02.2d.%04.4d", tp->tm_mday, tp->tm_mon + TZS, 1900 + tp->tm_year);
  }
  if (mode == 1) {
	sprintf(s, "%02.2d.%02.2d.%02.2d", tp->tm_mday, tp->tm_mon + TZS, tp->tm_year);
  }
  if (mode == 2) {
	sprintf(s, "%s", wt[tp->tm_wday]);
  }
  return (char *) s;
}




/***************************************************************************/
/*      FUNKTION  mytime()						   */
/*  BESCHREIBUNG  Tageszeit liefern.  					   */
/*     PARAMETER  mode  =  0  =  hh:mm:ss				   */
/*			   1  =  hh:mm	 				   */
/*     RUECKGABE  Zeit                                                     */
/***************************************************************************/

char *mytime(mode)
int mode;
{
  struct tm *tp;
  time_t tt;

  static char s[STRING];

  time(&tt);
  tp = localtime(&tt);
  sprintf(s, "%02.2d:%02.2d:%02.2d", tp->tm_hour, tp->tm_min, tp->tm_sec);

  if (mode == 1) s[5] = '\0';

  return (char *) s;
}




/***************************************************************************/
/*      FUNKTION  crypted()						   */
/*  BESCHREIBUNG  STRING verschluesseln und zurueckgeben.		   */
/*     PARAMETER  s  =  STRING                                             */
/*     RUECKGABE  Verschluesselter STRING                                  */
/***************************************************************************/

char *crypted(s)
char s[];
{
  static char t[STRING];
  int i, a;


  strcpy(t, s);
  i = 0;
  a = 2;
  while (t[i] != '\0') {
	t[i] = (t[i] / a) + 32;
	i++;
	a++;
	if (a > 5) a = 2;
  }

  return (char *) t;
}




/***************************************************************************/
/*      FUNKTION  dateconv() 						   */
/*  BESCHREIBUNG  Datum (STRING) in Datum (LONG) wandeln.		   */
/*     PARAMETER  d  =  Datum (STRING)                                     */
/*     RUECKGABE  Datum (LONG)                                             */
/***************************************************************************/

long dateconv(d)
char d[];
{
  char s[STRING];
  int a, b, i;


  strcpy(s, (char *) strcopy(d, 0, 1));
  a = atoi(s);
  strcpy(s, (char *) strcopy(d, 3, 4));
  b = atoi(s);
  strcpy(s, (char *) strcopy(d, 6, 9));
  i = atoi(s);
  if (i < 1900) i += 1900;

  sprintf(s, "%4.4d%02.2d%02.2d", i, b, a);

  return atol(s);
}



/***************************************************************************/
/*      FUNKTION  datereconv() 						   */
/*  BESCHREIBUNG  Datum (LONG) in Datum (STRING) wandeln.		   */
/*     PARAMETER  l  =  Datum (LONG)                                       */
/*     RUECKGABE  Datum (STRING)                                           */
/***************************************************************************/

char *datereconv(l)
long l;
{
  static char s[STRING];
  static char t[STRING];


  if (l < 19000000)
	sprintf(s, "%ld", 1900000L + l);
  else
	sprintf(s, "%ld", l);

  strcpy(t, (char *) strcopy(s, 6, 7));
  strcat(t, ".");
  strcat(t, (char *) strcopy(s, 4, 5));
  strcat(t, ".");
  strcat(t, (char *) strcopy(s, 0, 3));

  return (char *) t;
}



/***************************************************************************/
/*      FUNKTION  timeconv() 						   */
/*  BESCHREIBUNG  Zeit (STRING) in Zeit (LONG) wandeln.			   */
/*     PARAMETER  t  =  Zeit (STRING)                                      */
/*     RUECKGABE  Zeit (LONG)                                              */
/***************************************************************************/

int timeconv(t)
char t[];
{
  char s[STRING];
  int i = 0;


  strcpy(s, (char *) strcopy(t, 0, 1));
  i = 100 * atoi(s);
  strcpy(s, (char *) strcopy(t, 3, 4));
  i += atoi(s);

  return i;
}




/***************************************************************************/
/*      FUNKTION  timereconv() 						   */
/*  BESCHREIBUNG  Zeit (LONG) in Zeit (STRING) wandeln.			   */
/*     PARAMETER  i  =  Zeit (LONG)                                        */
/*     RUECKGABE  Zeit (STRING)                                            */
/***************************************************************************/

char *timereconv(i)
int i;
{
  static char s[STRING];
  static char t[STRING];


  if (i < 10000)
	sprintf(s, "%04.4d00", i);
  else
	sprintf(s, "%06.6d", i);

  strcpy(t, (char *) strcopy(s, 0, 1));
  strcat(t, ":");
  strcat(t, (char *) strcopy(s, 2, 3));
  strcat(t, ":");
  strcat(t, (char *) strcopy(s, 4, 5));

  return (char *) t;
}



/***************************************************************************/
/*      FUNKTION  shortname() 						   */
/*  BESCHREIBUNG  Wandelt lange Namen (NGs) ins 14-Zeichenformat, um Ver-  */
/*                Wechslungen zu vermeiden:				   */
/*									   */
/*		      comp.protocols.tcp-ip.sources.wanted		   */
/*                =>  com0ces.wanted					   */
/*							                   */
/*     PARAMETER  longname : langer Name                                   */
/*									   */
/*   									   */
/*     RUECKGABE  s : kurzer Name                                          */
/***************************************************************************/

char *shortname( longname )
char longname[];
{
  char s[STRING];
  char t[STRING];

  int i = 0, j = 0;

  strcpy(s, longname);
  strcpy(t, longname);

  while(s[i] != '\0'){
	if(s[i] == '/') j = i + 1;
	i++;
  }

  i = strlen(t);

  if((i - j) < 15) return (char *) s;

  s[j + 3] = '0'; s[j + 4] = '\0';
  strcat(s, (char *) strcopy(t, (i-10), i));

  return (char *) s;
}





/***************************************************************************/
/*      FUNKTION  maybe_locked()					   */
/*  BESCHREIBUNG  Um sicherzustellen das eine Datei, die eigentlich vor-   */
/*		  handen sein MUSS, wirklich nicht da ist (und nicht nur   */
/*		  gerade von einem anderen Task benutzt wird), verzoegert  */
/*		  diese Funktion die Fehlermeldung um eine festgelegte     */
/*		  Zeitspanne.                                              */
/*     PARAMETER  name  =  Dateiname				           */
/*		  mode  =  Zugriffsmodus (sollte NICHT verwendet werden !) */
/*     RUECKGABE   0    =  Datei erreichbar				   */
/*		  -1    =  Datei nicht verfuegbar			   */
/***************************************************************************/

int maybe_locked(name, mode)
char name[], mode[];
{
  FILE *fp;
  int i = 0, LCK = 0;
  char s[STRING];
  char t[STRING];

  sprintf(s, "%s.LCK", name); t[0] = '\0'; strcat(t, (char *) shortname(s));

  TRY_TWICE:

  fp = NULL;

  do {
	if(fp != NULL) fclose(fp);
	fp = fopen(t, "r");
	i++;
	if (fp != NULL) {
		if(i == 1) printf("%c%s ", CR, TOL08_MSG);
		printf(".");
		sleep(3);
	}
  } while ((i < 8) && (fp != 0));

  if(fp != 0){
	fclose(fp);
#ifdef _MBOX
	unlockf(name);   /* <--- DAS IST NATUERLICH NICHT KORREKT !!! */
	goto TRY_TWICE;  /* <--- DAS AUCH NICHT !!! */
	nerror("tools.c", 566, "maybe_locked", "Datei gesperrt", name);	
#else
	printf("\n\nDatei >>%s<< gesperrt !!!\n\n", name);
#endif
	exit( -1 );
  }

  i = 0;

  do {
	fp = fopen(name, "r");	/* "r" => "mode", aber VORSICHT ! */
	i++;
	if (fp == NULL) {
		if(i == 1) printf("%c%s ", CR, TOL08_MSG);	
		printf(".");
		sync();
		sleep(3);
	}
  } while ((i < 5) && (fp == NULL));

  if (fp == NULL) return -1;

  fclose(fp);
  return 0;
}





/***************************************************************************/
/*      FUNKTION  num_stripped()					   */
/*  BESCHREIBUNG  Entfernt alle Ziffern aus STRING.			   */
/*     PARAMETER  s  =  STRING (incl. Ziffern)				   */
/*     RUECKGABE  STRING (excl. Ziffern)				   */
/***************************************************************************/

char *numstripped(s)
char s[];
{
  static char t[STRING];
  int i = 0, a = 0;

  while (s[i] != '\0') {
	if (((s[i] > 64) && (s[i] < 127)) || (s[i] == ' ') || (s[i] == '-')) {
		t[a] = s[i];
		a++;
	}
	i++;
  }
  t[a] = '\0';

  return (char *) t;
}




/***************************************************************************/
/*      FUNKTION  rename()						   */
/*  BESCHREIBUNG  Benennt Datei1 in Datei2 um (ok, gelogen ... Datei1 wird */
/*		  in Datei2 kopiert).                                      */
/*     PARAMETER  alt  =  Datei1                                           */
/*		  neu  =  Datei2                                           */
/*     RUECKGABE   0   =  ok                                               */
/*		  -1   =  Datei1 nicht gefunden				   */
/***************************************************************************/

#ifndef _ANSI

int rename(alt, neu)
char *alt[], *neu[];
{
  FILE *fp;
  FILE *ff;

  char s[250];

  fp = fopen(neu, "w");
  if (fp == NULL) {
	return -1;
  }
  ff = fopen(alt, "r");
  if (ff == NULL) {
	return -2;
  }
  while (fgets(s, 250, ff) != NULL) {
	fputs(s, fp);
  }

  fclose(fp);
  fclose(ff);

  unlink(alt);

  return 0;
}

#endif




/***************************************************************************/
/*      FUNKTION  headline()						   */
/*  BESCHREIBUNG  Ueberschrift mit Ansage-Text ausgeben. Vorher wird der   */
/*		  der Bildschirm geloescht (falls moegliche) und auf	   */
/*		  negative Darstellung umgeschaltet.                       */
/*     PARAMETER  line  =  Ansage-Text					   */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void headline(line)
char line[];
{
  char ex[255];
  int i;


  strcpy(ex, line);
  i = 0;
  while(line[i] != '\0'){
	if(line[i] == '\''){
		line[i] = ' ';
		ex[0] = '\0';
		strcat(ex, strcopy(line, 0, (i-1)));
	}
	i++;
  }
   
  sprintf(headinfo, "%s", ex);

  sprintf(ex, "%s                                                                          ", line);
  ex[79] = '\0';
  if (ansi("cl") != -1) {
	if (ansi("mr") == 1) {
		if (ansi("so") == 1) { 
			printf("\n\n------  %s  ------\n\n", line);
			return;
		}
	}
	printf("%s\n", ex);
	if (ansi("me") == 1) {
		ansi("se");
	}
  }
  else {
	printf("\n\n\n\n\n------  %s  ------\n\n", line);
  }
}


/***************************************************************************/
/*      FUNKTION  lockf()						   */
/*  BESCHREIBUNG  Schuetzt eine Datei vor ALLEN Zugriffen		   */
/*     PARAMETER  path  =  Datei					   */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void lockf( path )
char path[];
{
  FILE *fp;
  char s[STRING];
  char t[STRING];  

  sprintf(s, "%s.LCK", path); t[0] = '\0'; strcat(t, (char *) shortname(s));

  fp = fopen( t, "w" );
  fputs(VERSION, fp);
  fclose(fp);
}


/***************************************************************************/
/*      FUNKTION  unlockf()						   */
/*  BESCHREIBUNG  Erlaubt Zugriffe auf eine Datei			   */
/*     PARAMETER  path  =  Datei					   */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void unlockf( path )
char path[];
{
  char s[STRING];
  char t[STRING];
  
  sprintf(s, "%s.LCK", path); t[0] = '\0'; strcat(t, (char *) shortname(s));

  unlink(t);
}


/***************************************************************************/
/*      FUNKTION  tty()							   */
/*  BESCHREIBUNG  Name des eigenen Terminal-Anschlusses. 		   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  siehe BESCHREIBUNG                                       */
/***************************************************************************/

int tty()
{
  char s[STRING];
  char t[STRING];
  int i, l, a, b;


  strcpy(s, (char *) ttyname(0));
  l = length(s);
  i = l;

  while ((s[l] != 'y') && (l > 0)) l--;

  l++;
  a = 0;

  for (b = l; b < i; b++) {
	t[a] = s[b];
	a++;
  }
  t[a] = '\0';

  return atoi(t);
}


/***************************************************************************/
/*      FUNKTION  ttyna()						   */
/*  BESCHREIBUNG  Name des eigenen Terminal-Anschlusses. 		   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  siehe BESCHREIBUNG                                       */
/***************************************************************************/

char *ttyna()
{
  static char s[STRING];
  static char t[STRING];
  int i, j, l;


  strcpy(s, (char *) ttyname(0));

  l = length(s) + 1;

  i = 0; 
  while(s[i] != '\0'){
	if(s[i] == '/') j = i + 1;
	i++;
  }
  (void) strcpy(t, (char *) strcopy(s, j, l));
  
  return (char *) t;
}



/***************************************************************************/
/*      FUNKTION  clearline()						   */
/*  BESCHREIBUNG  Bildschirmzeile loeschen.		 		   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine			                                   */
/***************************************************************************/

void clearline()
{
  printf("%c", CR);
  if (ansi("ce") == 1) {
	printf("                                                               ");
  }
  printf("%c", CR);
}
