/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  show.c						   */
/*        FUNKTIONEN  show(), more()					   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  18.11.1991					   */
/***************************************************************************/

#include <stdio.h>
#include <string.h>

#include "mbox.h"


static int show_more;
static FILE *page;
static char show_tmp[STRING];
static int seite;


extern char headinfo[STRING];


/***************************************************************************/
/*      FUNKTION  show()				        	   */
/*  BESCHREIBUNG  Zeigt den Inhalt einer Datei an.		 	   */
/*     PARAMETER  fname    = Dateiname                                   */
/*		  maxlines = mehr Zeilen auf keinen Fall ausgeben        */
/*		  mode     = '> 99'  Ueberschrift einrechnen	           */
/*			       '= 99'  Reset (alle Parameter von "show")   */
/*			       '=  0'  Kontinuierlich ausgeben             */
/*     RUECKGABE  -1  =  Datei nicht gefunden                              */
/***************************************************************************/

#define LLL 80

int show(fname, maxlines, mode)
char fname[];
int maxlines;
int mode;
{
  FILE *fp;

  char s[LONGSTRING];
  char o[LONGSTRING];
  char t[STRING];
  int c;
  int ml;
  int morechen;
  int ret_status = 0;
  int maxi = MAX_SCR_LINES;
  int swing = 0;
  int sl, ok;
 
  int HEADER_lines = 0;
  int HEADER_path = 0;


  if (mode > 99) {		/* HEADLINE */
	mode -= 100;
	maxi -= 2;
	swing = 2;
	morechen = 1;
	seite = 1;
  }
  if (mode == 99) {		/* RESET */
	show_more = 0;
	seite = 1;
	return 0;
  }
  fp = fopen(fname, "r");
  if (fp == NULL) {
	return -1;
  }
  ml = 0;
  morechen = 0;


  sprintf(show_tmp, "%s/show%d", TMP, getpid());
  page = fopen(show_tmp, "w");

  if (mode != 2)
	show_more = 0;
  else
	morechen = show_more;

  if (show_more > maxi) show_more = 0;


  while ((ml < maxlines) && (fgets(s, 250, fp) != NULL)) {

	if(SHORT_HEADER){
		if(strcomp("Path: ", s) == 0){
			HEADER_path++;
			continue;
		}

		if((HEADER_path != 0) && (HEADER_lines == 0)){

			if(strcomp("From: ", s) == 0){
				printf("%s %s", GBL01_MSG, strcopy(s, 6, strlen(s)));
				fprintf(fp, "%s %s", GBL01_MSG, strcopy(s, 6, strlen(s)));
				morechen++;
			}
			if(strcomp("Subject: ", s) == 0){
				printf("%s %s", GBL03_MSG, strcopy(s, 9, strlen(s)));
				fprintf(fp, "%s %s", GBL03_MSG, strcopy(s, 9, strlen(s)));
				morechen++;
			}		
			if(strcomp("Date: ", s) == 0){
				printf("%s %s\n", GBL02_MSG, strcopy(s, 6, strlen(s)));
				fprintf(fp, "%s %s\n", GBL02_MSG, strcopy(s, 6, strlen(s)));
				morechen++;
			}
			if(strlen(s) < 3){
				HEADER_lines++;
				morechen++;
			}
			continue;
 		}	
	}
	else{
		if(HEADER_lines == 0){
			if((strcomp("Path:", s) == 0) || (strcomp(GBL01_MSG, s) == 0)){
				ansi("md");
			}	
			if(strlen(s) < 3){
				HEADER_lines++;
				ansi("me");
			}			
		}
	}

	sl = length(s);
	while(sl > LLL){
		o[0] = '\0'; strcat(o, s);
		sl = LLL; ok = 0;
		while((sl > 0) && (ok == 0)){
			if(s[sl] < 48){
				ok = sl;
			}
			sl--;
		}
		s[ok] = '\0';
		morechen++;
		printf("%s\n", s);
		fprintf(page, "%s\n", s);
		s[0] = '\0'; strcat(s, (char *)bigcopy(o, ok, length(o)));
		sl = length(s);
		if(ok == 0){
			sl = LLL;
			printf("[SysBug \"show.c\"]");
		}
		if(s[0] == '\n') s[0] = '\0';
	}
	if(s[strlen(s)] == '\n') s[strlen(s)] == '\0'; 
	printf("%s", s);
	fputs(s, page);
	ml++;
	morechen++;
	if ((morechen >= maxi) && (mode > 0)) {
		morechen = 0;
		maxi += swing;
		swing = 0;
		fclose(page);
		ret_status = more();
		if (ret_status != 0) {
			ml = maxlines + 9999;
		}
		else {
			page = fopen(show_tmp, "w");
		}
	}
  }
  fclose(fp);

  show_more = morechen;

  if (page != NULL) fclose(page);
  unlink(show_tmp);

  return (int) ret_status;
}



/***************************************************************************/
/*      FUNKTION  more()						   */
/*  BESCHREIBUNG  Erfragen ob weitergelesen werden soll, oder nicht.       */
/*     PARAMETER  keine  	                                           */
/*     RUECKGABE  0  =  weiterlesen                                        */
/*		 -1  =  abbrechen				           */
/***************************************************************************/

int more()
{
  char s[255];
  char c;
  int ok = 0;

FIRST_TRY:

  ansi("mr");
  printf("                                                                               ");
  printf("%c[%s] (?) > ", CR, SHO04_MSG);
  ansi("me");

SECOND_TRY:

  c = getint();

  if (c == '?') {
	ansi("mr");
	clearline();
	printf("%c%s > ", CR, SHO05_MSG);
	ansi("me");
	goto SECOND_TRY;
  }
  if (c > 96) c -= 32;

  if ((c == DEL) ||
      (c == CTRL_D) ||
      (c == CTRL_X) ||
      (c == SHO06_MSG) ||
      (c == SHO07_MSG))
	ok = -1;

  if ((c == SHO08_MSG) || (c == SHO09_MSG)) ok = 1;

  if (c == SHO10_MSG) {
	ansi("cl");
	ansi("mr");
	printf("                                                                               ");
	printf("%c%s\n", CR, SHO11_MSG);
	ansi("me");	
	page = fopen(show_tmp, "r");
	if (page != NULL) {
		while (fgets(s, 250, page) != NULL) {
			printf("%s", s);
		}
		fclose(page);
	}
	goto FIRST_TRY;
  }
 
  if(ok != 1){	
	  if (USER.more == 3) {
		clearline();
	  }
	  else {
		if(USER.more != 0){
			ansi("cl");
			seite++;
			sprintf(s, "%s'-  [%s %d]", headinfo, SHO12_MSG, seite);
			headline(s);
		}
		else printf("\n\n");
	  }
  }
  else{	
	clearline();
  }

  return (int) ok;
}

