/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  postfach.c					   */
/*        FUNKTIONEN  postfach()					   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  09.12.1991					   */
/***************************************************************************/
  
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>

#include "mbox.h"



/***************************************************************************/
/*      FUNKTION  postfach()						   */
/*  BESCHREIBUNG  Postfach und versch. Dateien fuer einen neuen Teil-      */
/*		  nehmer einrichten.                                       */
/*     PARAMETER  arg  =  '*'  =  normaler Aufruf, wird geprueft	   */
/*			       =  Aufruf von ADMIN                         */
/*		       =  '#'  =  Neuinstallation der UDBASE		   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void postfach(arg)
char arg[];
{
  int fd;
  FILE *fp;
  char s[STRING*2];
  char t[STRING*2];
  struct userdaten LOOSER;
  struct userdaten POSTER;
  int ok, i, j, c;
  long ll;


  if (arg[0] == '*') {
	if ((strcomp(GUEST, USER.name) != 0) &&
	    (strcomp(POSTMASTER, USER.sh_name) != 0)) {
		ansi("md");
		printf(" %s\n", POS01_MSG);
		ansi("me");
		return;
	}
  }
  
  if (arg[0] == '#') {

	if (arg[1] == '1') { /* ADMINISTRATION */

		strcpy(USER.name, "Administration");
		strcpy(USER.sh_name, POSTMASTER);
		strcpy(USER.nick, "Sysop");

		USER.id = 1;
		USER.level = 10;

		printf("%s - %s (%s)\n", POS04_MSG, USER.name, USER.sh_name);

		fp = fopen(UDSEQ, "w");
		if (fp == NULL) {
			nerror("postfach.c", 63, "postfach", "Datei-Schreibfehler", UDSEQ);
		}
		fputs("1", fp);
		fclose(fp);
		
		fp = fopen(UDBASE, "w");
		fclose(fp);
	}	 
	if (arg[1] == '2') { /* GUEST */
	
		strcpy(USER.name, GUEST);
		strcpy(USER.sh_name, GBL10_MSG);
		strcpy(USER.nick, POS03_MSG);

		USER.id = 2;
		USER.level = 0;
	
		printf("%s - %s (%s)\n", POS05_MSG, USER.name, USER.sh_name);
	}

	strcpy(USER.passwort, "*****");
	strcpy(USER.wohnort, "");
	strcpy(USER.strasse, "???");
	strcpy(USER.telefon1, "???");
	strcpy(USER.telefon2, "???");
	strcpy(USER.geburtsdatum, "00.00.0000");

	goto INIT_UDBASE;
  }

  maybe_locked(UDBASE, "r"); 
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("postfach.c", 51, "postfach", "Datei-Lesefehler", UDBASE);
  }
  headline( POS06_MSG );
  ansi("md");
  printf("\n%s\n%s\n%s\n\n", POS07_MSG, POS08_MSG, POS09_MSG);
  ansi("me");

  RETRY_1:

  printf("\n%s ", POS10_MSG);
  strcpy(s, POSTER.name);
  strcpy(POSTER.name, (char *) getline(30, 11, '.', ""));
  if ((strcomp("<BREAK>", POSTER.name) == 0) || (POSTER.name[0] < 64) || (POSTER.name[1] < 64)) {
	strcpy(POSTER.name, s);
	printf("\n\n");
	ansi("md");
	printf("%s", POS11_MSG);
	ansi("me");
	printf("\n");
	return;
  }
  ansi("md");
  printf("\n%s", POS12_MSG);
  ok = 0;
  lseek(fd, 0L, SEEK_SET);
  while ((read(fd, &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) && (ok == 0)) {
	if (strcomp(POSTER.name, LOOSER.name) == 0) ok = 1;
  }

  if (ok == 1) {
	printf(" %s\n", POS13_MSG);
	ansi("me");
	sprintf(POSTER.name, "%s", s);
	goto RETRY_1;
  }
  ansi("me");

  do {
	printf("%c%s ", CR, POS14_MSG);
	strcpy(s, (char *) getline(10, 11, '.', ""));
	if (strcomp("<BREAK>", s) == 0) s[0] = '\0';
	strcpy(POSTER.passwort, (char *) crypted(s));
	if (length(POSTER.passwort) < 5) {
		ansi("md");
		printf("\n%s", POS15_MSG);		
		ansi("me");
	}
  } while (length(POSTER.passwort) < 5);

RETRY_2:

  printf("\n%s ", POS16_MSG);
  strcpy(s, getline(30, 11, '.', ""));
  if (strcomp("<BREAK>", s) == 0) {
	strcpy(s, "John Doe");
  }
  strcpy(POSTER.nick, s);

  ansi("md");
  printf("\n%s", POS12_MSG);
  ok = 0;
  lseek(fd, 0L, SEEK_SET);
  while ((read(fd, &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) && (ok == 0)) {
	if (strcomp(POSTER.nick, LOOSER.nick) == 0) ok = 1;
  }
  if (ok == 1) {
	printf(" %s\n", POS13_MSG);
	ansi("me");
	goto RETRY_2;
  }
  ansi("me");


  printf("%c%s ", CR, POS17_MSG);
  strcpy(POSTER.wohnort, (char *) getline(30, 11, '.', ""));

  printf("\n%s ", POS18_MSG);
  strcpy(POSTER.strasse, (char *) getline(30, 11, '.', ""));

  printf("\n%s ", POS19_MSG);
  strcpy(POSTER.telefon1, (char *) getline(20, 11, '.', ""));

  printf("\n%s ", POS20_MSG);
  strcpy(POSTER.telefon2, (char *) getline(20, 11, '.', ""));

  printf("\n%s ", POS21_MSG);
  strcpy(POSTER.geburtsdatum, (char *) getline(10, 114, '?', ""));

  close(fd);

  ansi("md");
  printf("\n\n%s\n%s\n\n", POS22_MSG, POS23_MSG);
  ansi("me");

  USER.level = 0;
  if(USER.id == 1) USER.level = 10; /* POSTMASTER-Account */

  if (arg[0] != '*') {
	sprintf(s, "%s", arg);
	s[14] = '\0';
	strcpy(USER.sh_name, s);
	USER.level = WRITE_EX_LEV;
  }
  else USER.sh_name[0] = '\0';

  sprintf(USER.name, "%s", POSTER.name);
  sprintf(USER.passwort, "%s", POSTER.passwort);
  sprintf(USER.nick, "%s", POSTER.nick);
  sprintf(USER.wohnort, "%s", POSTER.wohnort);
  sprintf(USER.strasse, "%s", POSTER.strasse);
  sprintf(USER.telefon1, "%s", POSTER.telefon1);
  sprintf(USER.telefon2, "%s", POSTER.telefon2);
  sprintf(USER.geburtsdatum, "%s", POSTER.geburtsdatum);   


  INIT_UDBASE:

  
  USER.terminal = 1;
  USER.editor = 1;
  USER.prompt = 2;
  USER.bell = 0;
  USER.more = 1;
  USER.seq = 0;
  USER.intro = 3;
  strcpy(USER.lastlog, (char *) "01.01.1970");
  USER.lasttime = 0;
  USER.lastmode = 2;
  USER.leserichtung = 1;
  USER.upratio = 0L;
  USER.downratio = 0L;
  USER.elapsed = 0L;
  sprintf(USER.newsgrps, "%s", NEWS_MINIMUM);

  maybe_locked(UDSEQ, "r"); lockf(UDSEQ);
  fp = fopen(UDSEQ, "r");
  if (fp == NULL) {
	nerror("postfach.c", 188, "postfach", "Datei-Lesefehler", UDSEQ);
  }
  fscanf(fp, "%d", &USER.id);
  fclose(fp);
  unlockf(UDSEQ);

  if(USER.id < 1) USER.id = 1;

  maybe_locked(UDSEQ, "r"); lockf(UDSEQ);
  fp = fopen(UDSEQ, "w");
  if (fp == NULL) {
	nerror("postfach.c", 196 , "postfach", "Datei-Schreibfehler", UDSEQ);
  }
  fprintf(fp, "%d\n", (USER.id + 1));
  fclose(fp);
  unlockf(UDSEQ);

  maybe_locked(UDBASE, "r"); lockf(UDBASE);
  fd = open(UDBASE, O_RDWR);
  if (fd == -1) {
	nerror("poastfach.c", 204, "postfach", "Datei-Lesefehler", UDBASE);
  }
  ll = lseek(fd, 0L, SEEK_END);
  write(fd, &USER, sizeof(USER));
  close(fd);
  unlockf(UDBASE);

  sprintf(s, "%s/usr/%d", HOME, USER.id);
  mkdir(s, 0777);

  sprintf(s, "%s/usr/%d/seq", HOME, USER.id);
  fp = fopen(s, "w");
  fputs("1\n", fp);
  fclose(fp);

  sprintf(s, "%s/usr/%d/.hello", HOME, USER.id);
  fp = fopen(s, "w");
  fputs("\n", fp);
  fclose(fp);

  sprintf(s, "%s/usr/%d/.signature", HOME, USER.id);
  fp = fopen(s, "w");
  fputs("\n", fp);
  fclose(fp);

  if (arg[0] != '*') {
	sprintf(s, "cp /usr/%s/%s %s/usr/%d/.signature &", USER.sh_name, SIGNATURE,
		HOME, USER.id);
	system(s);
  }
  sprintf(s, "%s/usr/%d/INDEX", HOME, USER.id);
  fp = fopen(s, "w");
  fprintf(fp, "%s\n", GBL05_MSG);
  fputs("===============================================================================\n", fp);
  fclose(fp);

  if (arg[0] == '#') {
	return; /* UDBASE installiert */
  }

  i = 0;
  strcpy(t, USER.name);
  while(t[i] != '\0'){
	if(t[i] == ' ') t[i] = '.';
	i++;
  }

  sprintf(s, "/bin/sh ./etc/alias.sh \"%s\"", t);
  system( s );


  sprintf(s, "%s \"%s\" (%d)", POS24_MSG, USER.name, USER.id);
  control(s, 3);

  printf("\n");
  init_user( POS25_MSG );
  
}

