/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  portinfo.c					   */
/*        FUNKTIONEN  port(), show_level(), userliste()			   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  23.11.1991					   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <utmp.h>
#include <time.h>

#include <string.h>

#include "mbox.h"




/***************************************************************************/
/*      FUNKTION  port()						   */
/*  BESCHREIBUNG  Anzeigen was die Mbox- und die SH-User z. Zt. anstellen. */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

#define MAX_TERMINALS 20

void port(arg)
char arg[];
{
  FILE *fp;
  FILE *ff;
  FILE *pp;
  int fd;
  char s[STRING];
  char t[STRING];
  char ks[STRING];
  char ls[STRING];
  char tmp[STRING];
  char ex[255];
  char terms[MAX_TERMINALS][STRING];
  int termc = 0;
  int a, b, k, l;
  struct utmp US;
  struct tm *tmt;
  long ltime;
  

  if(arg[0] != '-'){
	headline( POR01_MSG );
  }
  else printf("\n\n");

  printf("%s\n", POR02_MSG);
  printf("===============================================================================\n");

  printf("%s ", POR03_MSG);

  maybe_locked(WHO, "r");
  fp = fopen(WHO, "r");
  if (fp == NULL) {
	nerror("portinfo.c", 56, "port", "Datei-Lesefehler", WHO);
  }
  while (fgets(s, 80, fp) != NULL) {
	printf(".");
	if(s[0] > 32){
		strcpy(t, (char *) strcopy(s, 6, 80));
		sprintf(terms[termc], "%s", t);
		strcat(terms[termc], "          ");
		terms[termc][56] = '\0';
		sprintf(t, "%s", (char *) strcopy(s, 40, 49));
		sprintf(s, "%s/etc/%s.", HOME, (char *) stripped(t));
		ff = fopen(s, "r");
		if (ff == NULL) {
			continue;
		}
		fgets(s, 80, ff);
		s[23] = '\0';
		fclose(ff);
		strcat(terms[termc], s);
		strcat(terms[termc], "\n");
		termc++;
	}
  }
  fclose(fp);

  sprintf(tmp, "%s/%dps", TMP, getpid());
  sprintf(s, "ps -a > %s", tmp);
  system( s );

#ifdef _SYS7
  maybe_locked(UTMP, "r");
  fd = open(UTMP, O_RDONLY);
#else
  maybe_locked(UTMP_FILE, "r");
  fd = open(UTMP_FILE, O_RDONLY);
#endif

  if (fd == -1) {

#ifdef _SYS7
	nerror("portinfo.c", 83, "port", "Datei-Lesefehler", UTMP);
#else
	nerror("portinfo.c", 83, "port", "Datei-Lesefehler", UTMP_FILE);
#endif

  }
  while (read(fd, &US, sizeof(US)) == sizeof(US)) {

	printf(".");
	t[0] = '\0';
	strcat(t, "[$] -\n");

	if (US.ut_type == USER_PROCESS) {
		terms[termc][0] = '\0';
		sprintf(ex, "%.8s [SH-Account]                                                  ",
			US.ut_user);
		ex[33] = '\0';
		strcat(terms[termc], ex);

		sprintf(ex, " %s                ",
			US.ut_line);
		ex[11] = '\0';
		strcat(terms[termc], ex);

		ltime = US.ut_time;
		tmt = localtime(&ltime);
		sprintf(ex, "%02.2d:%02.2d   ",
			tmt->tm_hour, tmt->tm_min);
		strcat(terms[termc], ex);

		l = atoi(strcopy(US.ut_line, 3, 6));

		pp = fopen(tmp, "r");
		if (pp == NULL) {
			nerror("portinfo.c", 113, "port", tmp, "???");
		}
		while (fgets(s, 80, pp) != NULL) {
			k = atoi((char *) strcopy(s, 8, 10));
			if ((k == l) && (s[17] != '-')) {
				t[0] = '\0';
				strcat(t, "[$] ");
				strcat(t, (char *) strcopy(s, 17, 40));
				s[0] = '\0';
				strcat(s, t);
				t[0] = '\0';
				strcat(t, (char *) stripped(s));
				t[27] = '\0';
				strcat(t, "\n");
			}
		}
		fclose(pp);

		strcat(terms[termc], t);
		termc++;
	}
  }
  close(fd);

  unlink(tmp);

  printf("%c", CR);

  for (a = 0; a < termc; a++) {
	for (b = 0; b < termc; b++) {
		sprintf(ks, "%s", (char *) strcopy(terms[a], 34, 40));
		sprintf(ls, "%s", (char *) strcopy(terms[b], 34, 40));
		if((strcomp(ks, ls) == 0) && (a != b)){
			if (terms[a][53] == '$') terms[a][0] = '*';
			if (terms[b][53] == '$') terms[b][0] = '*';
		}
		sprintf(s, "%d", ks); k = atoi(s);
		sprintf(s, "%d", ls); l = atoi(s);
		if (k < l) {
			s[0] = '\0';
			strcat(s, terms[a]);
			terms[a][0] = '\0';
			strcat(terms[a], terms[b]);
			terms[b][0] = '\0';
			strcat(terms[b], s);
		}
	}
  }


  for (a = 0; a < termc; a++) {
	if (terms[a][0] != '*'){
		if(terms[a][53] != '$') ansi( "md" );
		printf("%s", terms[a]);
		if(terms[a][53] != '$') ansi( "me" );
	}
  }

  printf("\n");
}





/***************************************************************************/
/*      FUNKTION  show_level()						   */
/*  BESCHREIBUNG  Zuweisung der Userlevel anzeigen.			   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void show_level()
{
  headline( POR04_MSG );
  printf("\n");

  printf("%s\n", POR05_MSG);
  printf("-----------------------------------------\n");
  printf("%s (%d)\n", POR06_MSG, GUEST_LEV);
  printf("%s (%d)\n", POR07_MSG, WRITE_IN_LEV);
  printf("%s (%d)\n", POR08_MSG, MAILOUT_LEV);
  printf("%s (%d)\n", POR09_MSG, WRITE_EX_LEV);
  printf("%s (%d)\n", POR10_MSG, WRITE_INTERNAT);
  printf("%s (%d)\n", POR11_MSG, PD_D_LEV);
  printf("%s (%d)\n", POR12_MSG, PD_U_LEV);
  printf("%s (%d)\n", POR13_MSG, EXE_LEV);
  printf("%s (%d)\n", POR14_MSG, ADMIN_LEV);

  printf("\n%s (%d), %s !\n\n", POR15_MSG, USER.level, USER.name);

}



/***************************************************************************/
/*      FUNKTION  userliste()						   */
/*  BESCHREIBUNG  Verschieden Formen der Userliste ausgeben.		   */
/*     PARAMETER  arg  =  ''   =  nur Username und ID                      */
/*			  '*'  =  Name, letzter Anruf etc.                 */
/*			  '#'  =  Name, Up- / Downloads			   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void userliste(arg)
char arg[];
{
  FILE *fp;
  int fd;
  struct userdaten LOOSER;
  char s[STRING];
  char u[(STRING*2)];
  char tmp[STRING];
  int i = 0, l;
  int mode = 0;
  int totalusr = 0;
  int totalact = 0;
  int totalgas = 0;
 
  if (arg[0] == '*') mode = 1;
  if ((arg[0] == '#') && (USER.level >= ADMIN_LEV)) mode = 2;

  headline( POR15aMSG );

  show(UDBASE, 99, 99); /* RESET */

  if (mode == 1) {
	printf("%s\n", POR16_MSG);	
	printf("===============================================================================\n");
	printf("%s", POR17_MSG);
  }
  if (mode == 2) {
	printf("%s\n", POR18_MSG);	
	printf("===============================================================================\n");
	printf("%s", POR17_MSG);
  }
  sprintf(tmp, "%s/%d", TMP, getpid());
  fp = fopen(tmp, "w");
  if (fp == NULL) {
	nerror("portinfo.c", 231, "userliste", "Datei-Schreibfehler", tmp);
  }
  maybe_locked(UDBASE, "r");
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 254, "userliste", "Datei-Lesefehler", UDBASE);
  }
  while (read(fd, &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) {
	if (mode == 0) {
		sprintf(u, "%s", LOOSER.name);
		sprintf(s, " (%d) ", LOOSER.id);		
		u[26 - strlen(s)] = '\0';
		strcat(u, s); strcat(u, "                                ");	
 		u[26] = '\0';
		fprintf(fp, "%s", u);
		i++;
		if (i == 3) {
			i = 0;
			fprintf(fp, "\n");
		}
	}
	if (mode == 1) {
		sprintf(s, "%s", "   ");
		if ((LOOSER.elapsed / 60) > 2) {
			if (LOOSER.wohnort[0] < 48) {
				if (strcomp(GUEST, LOOSER.name) != 0)
					sprintf(s, "%s", "<?>");
			}
		}
		else {
			sprintf(s, "%s", "{-}");
		}
		fprintf(fp, "%-30.30s  %10s %s%6.6d   %6.6ld\"  %5.5d%10.10s\n",
			LOOSER.name, LOOSER.lastlog, s, LOOSER.seq, (LOOSER.elapsed / 60), LOOSER.level, LOOSER.sh_name);

	}
	if (mode == 2) {
		fprintf(fp, "%-30.30s  %8.8d kB  %10.10d kB %8.8d\"\n",
			LOOSER.name, LOOSER.upratio, LOOSER.downratio, (LOOSER.elapsed / 60));
	}
	totalusr++;
	sprintf(s, "%s", (char *) mydate( 0 )); 
	if((strcomp(s, LOOSER.lastlog) < 3) && (LOOSER.seq > 10)) totalact++;
	if(strcomp(GUEST, LOOSER.name) == 0) totalgas = LOOSER.seq;
  }
  close(fd);

  fclose(fp);

  if ((mode == 1) || (mode == 2)) {
	printf("%c", CR);
	sprintf(s, "sort -d -o %s %s", tmp, tmp);
	system(s);
	show(tmp, 9999, USER.more + 100);
	if (mode == 1) {
		printf("\n%s\n%s", POR19_MSG, POR20_MSG);
	}
  }
  else{
	show(tmp, 9999, USER.more);
  }
  if(mode == 0){
	printf("\n\n%s %d %s %d %s", POR21_MSG, totalusr, POR22_MSG, totalact, POR23_MSG); 
	printf("\n%s %d %s", POR24_MSG, totalgas, POR25_MSG);
  }
  printf("\n");
  unlink(tmp);
}
