/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  misc.c						   */
/*        FUNKTIONEN  scanner(), schreiben(), prf(), pruefe(), lesen(),    */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  11.12.1991					   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <utmp.h>
#include <time.h>


#include "mbox.h"


extern char headinfo[STRING];

/***************************************************************************/
/*      FUNKTION  scanner()   						   */
/*  BESCHREIBUNG  Wechselt BRETTER. Bei "B +" bzw. "B -" wird die Aktual-  */
/*		  litaet nicht beruecksichtigt. In den anderen Modi 	   */
/*		  werden nur aktuelle Bretter angesprungen.                */
/*     PARAMETER  mode  =  '> 255'  =  nicht nur aktuelle Bretter	   */
/*			   '+'      =  aufwaerts springen		   */
/*			   '-'      =  abwaerts springen		   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void scanner(mode)
int mode;
{
  FILE *fp;
  char s[STRING];
  char t[STRING];
  char f[STRING];
  int ok = 0, a, b;
  int line = 0, l = 0;
  int locmod = 0;
  int max = 0;

  if (mode >= 255) {
	locmod = 255;
	mode -= 255;
  }
  KEIN_ZUGRIFF:

  if (locmod == 255) {
	maybe_locked(NGROUPS, "r");
	fp = fopen(NGROUPS, "r");
	if (fp == NULL) {
		nerror("misc.c", 26, "scanner", "Datei-Lesefehler", NGROUPS);
	}
 }
  else {
	maybe_locked(UGROUPS, "r");
	fp = fopen(UGROUPS, "r");
	if (fp == NULL) {
		nerror("misc.c", 34, "scanner", "Datei-Lesefehler", UGROUPS);
	}
  }

  f[0] = '\0';
  ok = 0;

  while ((ok == 0) && (fscanf(fp, "%s %d %d %s", &s, &a, &a, &t) > 0)) {
	l++;
	if (strcomp(NG, s) == 0) {
		ok = 1;
	}
	else {
		strcpy(f, (char *) s);
	}
  }


  if (mode == '+') {
	if (fscanf(fp, "%s %d %d %s", &f, &a, &a, &t) < 1) {
		if (ok == 0) {
			rewind(fp);
			fscanf(fp, "%s %d %d %s", &f, &a, &a, &t);
		}
	  	else {
			line = -1;
		}
	}
  }
  if (mode == '-') {
	if (f[0] == '\0') {
		rewind(fp);
		while (fscanf(fp, "%s %d %d %s", &f, &a, &a, &t) > 0);

	}
  }
  fclose(fp);

  if (max > 20) line = -1;

  if (line == -1) {
	strcpy(BRETT, (char *) "PM");
	printf("\n");
	sprintf(NG, "%s.PM", USER.name);
	sprintf(INHALT, "%s/usr/%d/INDEX", HOME, USER.id);
	return;
  }
  if (l == 0) {
	ansi("md");
	printf(" %s\n", MIS01_MSG);
	ansi("me");
	return;
  }
  if (chk_newsgrp(f) != 0) {
	sprintf(NG, "%s", f);
	max++;
	goto KEIN_ZUGRIFF;
  }
  brett(f);
}





/***************************************************************************/
/*      FUNKTION  schreiben()						   */
/*  BESCHREIBUNG  Artikel fuer NEWS einlesen und verteilen. Die Distri-    */
/*		  bution ist abhaengig von der NG und vom Userlevel.	   */
/*     PARAMETER  arg = DUMMY (!)                                          */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void schreiben(arg)
char arg[];
{
  FILE *fp;
  FILE *ff;
  FILE *fl;
  char s[STRING];
  char t[STRING];
  char f[STRING];
  char g[LSTRING];
  char ex[255];
  char cmdl[STRING];
  char rep[STRING];
  char subj[STRING];
  char keyw[STRING];
  char summ[STRING];
  char from[STRING];
  char msid[STRING];
  char refs[STRING];
  char tmp[STRING];
  char ng[STRING];
  int i, a, b, ok;
  char protokoll = 0;
  char c;
  char lf;
  int BINFILE;
  struct stat fst;
  char pubdir[STRING];
  long tdummy;
  long tn, ts;

  if (strcomp(BRETT, "PM") == 0) {
	ansi("md");
	printf(" <- \"%s.PM\" %s\n\n", USER.name, MIS02_MSG);
	ansi("me");
	return;
  }
  BINFILE = 0;


  umask(0000);

  if (arg[0] == '\0') {

	subj[0] = '\0';
	keyw[0] = '\0';
	from[0] = '\0';
	msid[0] = '\0';
	summ[0] = '\0';
	refs[0] = '\0';

	sprintf(rep, "%s/%dRep", TMP, getpid());

	fp = fopen(rep, "r");
	if (fp != NULL) {		/* REPLY */
		while ((fgets(s, 80, fp) != NULL) && (s[0] > 32)) {
			if (strcomp("Subject:", s)   == 0) {
				strcat(subj, strcopy(s, 8, 79));
			}
			if (strcomp("From:", s)      == 0) {
				from[0] = '\0';
				strcat(from, strcopy(s, 6, 79));
			}
			if (strcomp("Reply-To:", s)  == 0) {
				from[0] = '\0';
				strcat(from, strcopy(s, 10, 79));
			}
			if (strcomp("Keywords:", s)  == 0) {
				strcat(keyw, strcopy(s, 10, 79));
			}
			if (strcomp("Summary:", s)   == 0) {
				strcat(summ, strcopy(s, 9, 79));
			}
			if (strcomp("Message-ID:", s) == 0) {
				strcat(msid, strcopy(s, 11, 79));
			}
			if (strcomp("Article-I.D.:", s) == 0) {
				strcat(msid, strcopy(s, 13, 79));
			}
			if (strcomp("References:", s) == 0) {
				strcat(refs, strcopy(s, 12, 79));
			} 
		}
		
		strcpy(subj, (char *) stripped(subj));				
		strcpy(from, (char *) stripped(from));
		strcpy(msid, (char *) stripped(msid));
		strcpy(keyw, (char *) stripped(keyw));
		strcpy(summ, (char *) stripped(summ));
		strcpy(refs, (char *) stripped(refs));

		sprintf(t, "%s/A%d", TMP, getpid());
		ff = fopen(t, "w");

		a = 0;
		b = 0;
		i = 0;
		while (from[i] != '\0') {
			if (from[i] == '(') a = i + 1;
			if (from[i] == ')') b = i - 1;
			i++;
		}
		if (a < b) {
			strcpy(s, (char *) strcopy(from, a, b));
			strcpy(from, (char *) s);
		}
		sprintf(ex, "In article %s,\n            %s writes:\n\n", msid, from);
		fputs(ex, ff);
		while (fgets(s, 80, fp) != NULL) {
			fputs("> ", ff);
			fputs(s, ff);
		}
		fclose(fp);
		fclose(ff);

		sprintf(cmdl, "%s %s", EDDY, t);
		printf("\n\n");
		system(cmdl);
		if (strcomp("Re:", subj) != 0) {
			sprintf(f, "Re: %s", stripped(subj));
			strcpy(subj, (char *) f);
		}
		unlink(rep);
	}
	else {		/* Interactive MAIL */

		printf("\n\n%c", CR);
		ansi("mr");
		printf("%s", MIS03_MSG);
		ansi("me");
		printf(" %s (%s)\n%c", USER.name, USER.nick, CR);
		ansi("mr");
		printf("%s", MIS04_MSG);
		ansi("me");
		printf(" %s\n%c", NG, CR);
		ansi("mr");
		printf("%s", MIS05_MSG);
		ansi("me");
		printf(" ");
		strcpy(subj, (char *) getline(57, 11, '.', ""));
		printf("\n");
		ansi("mr");
		printf("%s", MIS06_MSG);
		ansi("me");
		printf(" ");
		strcpy(keyw, (char *) getline(57, 11, '.', ""));
		printf("\n");
		ansi("mr");
		printf("%s", MIS07_MSG);
		ansi("me");
		printf(" ");
		strcpy(summ, (char *) getline(57, 11, '.', ""));

		printf("\n\n");
		ansi("mr");
		printf("[%s] %s ? > ", NG, MIS08_MSG);
		ansi("me");
		printf("%c%c", MIS09_MSG, BS);

		do {
			c = getint();
			if (c >= 97) c -= 32;
			if (c == '?') {
				clearline();
				ansi("mr");
				printf("%c%s > ", CR, MIS12_MSG);
				ansi("me");
			}
			if (c == ENTER) c = MIS09_MSG;
			if ((c != MIS09_MSG) && (c != MIS10_MSG) && (c != MIS11_MSG)) c = 0;
		} while (c == 0);

		printf("%c", c);

		if (c == MIS11_MSG) {
			printf("\n");
			unlink(t);
			return;
		}
		if (c == MIS10_MSG) {
			printf("%c                                                                       ", CR);
			ansi("mr");
			printf("%c%s, ? > ", CR, MIS13_MSG);
			ansi("me");

			do {
				protokoll = getint();
				if (protokoll >= 97) protokoll -= 32;
				if (protokoll == '?') {
					clearline();
					ansi("mr");
					printf("%c%s > ", CR, MIS14_MSG);
					ansi("me"); 
				}
				if ((protokoll != MIS15_MSG) && (protokoll != MIS15_MSG) &&
				    (protokoll != MIS18_MSG) && (protokoll != MIS17_MSG ))
					protokoll = 0;
			} while (protokoll == 0);

			printf("%c", protokoll);

		}
		sprintf(tmp, "%s/A%d", TMP, getpid());
		sprintf(cmdl, "%s %s", EDDY, tmp);
		sprintf(pubdir, "%s/dir%d", TMP, getpid());

		if (c == MIS09_MSG) {
			noctrlx();
			system(cmdl);
			ctrlx();
			protokoll = '*';
		}
		else {	/* UPLOAD */

			printf("\n\n");
			ansi("md");
			printf("%s", MIS19_MSG);
			ansi("me");

			switch (protokoll) {
			    case MIS15_MSG:
					fp = fopen(tmp, "w");
					if (fp == NULL) {
						nerror("misc.c", 310, "schreiben", "DSF", tmp);
					}
					c = 0;
					lf = CR;
					fputc(LF, fp);

					while ((c != CTRL_X) && (c != CTRL_D)) {
						c = getint();
						if ((c == CR) && (lf == CR))
							fputc(LF, fp);
						if (c == CR) lf = CR;
						if (c == LF) lf = LF;
						if ((c != CTRL_X) && (c != CTRL_D) && (c != CR)) {
							fputc(c, fp);
						}
					}
					fclose(fp);
					break;
			    case MIS16_MSG:
					printf("\n");
					sprintf(s, "%s -bc TimeTravelAgency 2> /dev/null", RX);
					break;
			    case MIS17_MSG:
					printf("\n");
					sprintf(s, "%s -b 2> /dev/null", RB);
					break;
			    case MIS18_MSG:
					printf("\n");
					sprintf(s, "%s -b 2> /dev/null", RZ);
					break;
			}
			if (protokoll != MIS15_MSG){
				mkdir( pubdir, 0777 );
				chdir( pubdir );

				time(&ts);
				system( s );
				time(&tn); tn = tn - ts;
				tn -= 10;  /* 10 = "Toleranz" */
	
				chdir( HOME );
				sprintf(s, "mv %s/* %s", pubdir, tmp);
				system( s );
				sprintf(s, "rm -r %s", pubdir);
				system( s );
			}
			sync();
			stat(tmp, &fst);
			if (fst.st_size < 3L) {
				printf("\n\n%s\n", MIS20_MSG);
				control(MIS21_MSG, 3);
				unlink(tmp);
				return;
			}
			if (prf(tmp) == 1) {
				if (strcomp(PDNG, NG) == 0) {
					USER.upratio += ((long) fst.st_size / 1024);
				}
				BINFILE++;
				sprintf(s, MIS22_MSG);
			}
			else{
				mkix(tmp);
				sprintf(s, MIS23_MSG);
			}
			ansi( "md" );
			printf("\n\n%ld %s %s %s.\n", fst.st_size, MIS24_MSG, s, MIS25_MSG);
			ansi( "me" );
			if(tn < 1) tn = 1L;
			printf("%s %d cps (ca. %d bps).", MIS26_MSG,
				(fst.st_size / tn), ((fst.st_size / tn) * 11));				
		}
	}

	ONCE_MORE:

	printf("\n\n");
	ansi("mr");
	if(BINFILE == 0){
		printf("[%s] %s, ? > ", NG, MIS27_MSG);
	}
	else{
		printf("[%s] %s, ? > ", NG, MIS28_MSG);
	}
	ansi("me");
	printf("%c%c", MIS29_MSG, BS);

	do {
		c = getint();
		if (c >= 97) c -= 32;
		if (c == '?') {
			clearline();
			ansi("mr");
			if(BINFILE == 0){
				printf("%c%s > ", CR, MIS32_MSG);
			}
			else{
				printf("%c%s > ", CR, MIS33_MSG);
			}
			ansi("me");
		}
		if (c == ENTER) c = MIS29_MSG;
		if ((c != MIS29_MSG) && (c != MIS30_MSG) && (c != MIS31_MSG)) c = 0;
	} while (c == 0);

	printf("%c", c);
	if (c == MIS30_MSG) {
		unlink(f);
		unlink(s);
		unlink(t);
		unlink(tmp); /* ??? */
		unlink(rep);
		return;
	}
	if ((c == MIS31_MSG) && (BINFILE == 0)) {
		noctrlx();
		system(cmdl);
		ctrlx();
		goto ONCE_MORE;
	}

	ansi( "md" );
	printf("\n\n%s\n", MIS34_MSG);
	ansi( "me" );

	sprintf(f, "%s/A%d", TMP, getpid());
	sprintf(t, "%s/B%d", TMP, getpid());

	fp = fopen(f, "r");
	if (fp == NULL) {
		printf("\n");
		ansi("md");
		printf("%s ...\n", MIS35_MSG);
		ansi("me");
		control(MIS36_MSG, 3);
		unlink(rep);
		return;
	}

	i = 0;				/* Vorname.Name */
	strcpy(ng, USER.name);
	while (ng[i] != '\0') {
		if (ng[i] == ' ') ng[i] = '.';
		i++;
	}


	ff = fopen(t, "w");

	time(&tdummy);

	fprintf(ff, "From: %s <%s@%s>\n", USER.name, ng, UUCPID);
	fprintf(ff, "Reply-To: %s@%s (%s)\n", ng, UUCPID, USER.name);
	fprintf(ff, "Newsgroups: %s\n", NG);
	if (USER.level < WRITE_EX_LEV) {
		fputs("Distribution: local\n", ff);
	}
	else {
		strcpy(ng, NG);
		i = 0;
		while ((ng[i] != '.') && (ng[i] != '\0')) i++;
		ng[i] = '\0';
		fprintf(ff, "Distribution: %s\n", ng);
	}
	if(subj[0] != '\0')
		fprintf(ff, "Subject: %s\n", subj);
	if(keyw[0] != '\0')
		fprintf(ff, "Keywords: %s\n", keyw);
	if(summ[0] != '\0')
		fprintf(ff, "Summary: %s\n", summ);
	fprintf(ff, "X-News-Reader: %s %s %s\n", VERSION, PATCHLEVEL, AUTOR);
	fprintf(ff, "Message-ID: <%x.%d@%s>\n", tdummy, USER.id, UUCPID);
	if(refs[0] != '\0') strcat(refs, " ");
	strcat(refs, msid);	
	if(refs[0] != '\0')
		fprintf(ff, "References: %s\n", refs);
	fputs("\n", ff);	

	if (BINFILE == 0) {
		while (fgets(s, 80, fp) != 0) {
			fputs(s, ff);
		}
	}
	else {
		time(&tdummy);
		fputs("BINFILE\n", ff);
		sprintf(s, "%s/PD.%d", BRETT, tdummy);
		fputs(s, ff);
		sprintf(f, "cp %s %s &", tmp, s);
		system(f);
		sprintf(s, "\n/public/pd/%s\n", subj);
		fputs(s, ff);
		fl = fopen( PDSCRIPT, "a" );
		fprintf(fl, "mv %s/PD.%d /public/pd/%s\n", BRETT, tdummy, subj);
		fclose(fl);
	}
	fclose(fp);
	unlink(f);

	unlink(rep);

	if ((USER.level > WRITE_IN_LEV) && (BINFILE == 0)) {
		sprintf(s, "%s/usr/%d/.signature", HOME, USER.id);
		fp = fopen(s, "r");
		if (fp != NULL) {
			while (fgets(s, 80, fp) != 0) {
				fputs(s, ff);
			}
			fclose(fp);
		}
	}
	fclose(ff);

	sprintf(ex, "/bin/sh ./etc/inews.sh %s %s", NG, t);
	system(ex);

	unlink(t);

	sprintf(s, "%s \"%s\" %s", MIS37_MSG, NG, MIS38_MSG);
	control(s, 3);

	
	if(BINFILE != 0){
		maybe_locked(NGROUPS, "r");
		fp = fopen(NGROUPS, "r");
		if (fp == NULL) {
			nerror("misc.c", 895, "schreiben", "Datei-Lesefehler", NGROUPS);
		}

		ok = 0;

	        while ((ok == 0) && (fscanf(fp, "%s %d %d %s", &s, &a, &b, &f) > 0)) {
			if(strcomp(NG, s) == 0){
				i = a;
				ok = 1;
			}
	 	}
		fclose(fp);

		fl = fopen( PDSCRIPT, "a" );
		fprintf(fl, "mined %s/%d\n", BRETT, i); 
		fprintf(fl, "#%s   %s\n\n", NG, USER.name);
		fclose(fl);
	}

	printf("%s", MIS39_MSG);

#ifndef _SYS7
	sleep(30);	/* Scheinbar laeuft INEWS bei SYSV im Hintergrund */
#endif

	sprintf(s, "%s %s", MB_DAEMON, NG);
	system(s);
	unlink(tmp);
	printf("\n");
  }
  else {
	ansi("md");
	printf(" %s\n\n", MIS40_MSG);
	ansi("me");
  }
  umask(0007);
}





/***************************************************************************/
/*      FUNKTION  prf()							   */
/*  BESCHREIBUNG  Stellt fest, ob eine Datei (die per UPLOAD empfangen     */
/*		  wurde) einen Text oder ein ausfuehrbares Programm ent-   */
/*		  haelt.                                                   */
/*     PARAMETER  arg  =  Dateiname                                        */
/*     RUECKGABE  0    =  Text-Datei                                       */
/*		  1    =  Ausfuehrbares Programm			   */
/***************************************************************************/

int prf(arg)
char arg[];
{
  FILE *fp;
  char ex[255];
  int i, a;

  fp = fopen(arg, "r");
  if (fp == NULL) return -1;
  while ((fgets(ex, 250, fp) != NULL) && (strlen(ex) < 30));
  fclose(fp);

  i = 0;
  a = 0;
  while (ex[i] != '\0') {
	if ((ex[i] < 32) || (ex[i] > 127)) a++;
	i++;
  }
  if (a > 3) return 1;		/* BINFILE */

  return 0;			/* TEXTFILE */
}




/***************************************************************************/
/*      FUNKTION  pruefe()	 					   */
/*  BESCHREIBUNG  Stellt fest, ob eine Datei aus den News-Artikeln die     */
/*		  Kennung "BINFILE" enthaelt. Faellt die Antwort positiv   */
/*		  aus, wird die Routine "pd()" aufgerufen.		   */
/*     PARAMETER  arg  =  Nummer des Artikels                              */
/*     RUECKGABE  0    =  Text-Datei                                       */
/*                1    =  BINFILE					   */
/***************************************************************************/

int pruefe(arg)
char arg[];
{
  FILE *fp;
  char ex[255];
  char s[STRING];
  char entry[STRING];
  char keywds[STRING];

  if ((arg[0] == '\0') || (arg[0] == '*')) return -1;

  if (strcomp(BRETT, "PM") != 0) {
	sprintf(entry, "%s/%s", BRETT, arg);
  }
  else {
	sprintf(entry, "%s/usr/%d/%s", HOME, USER.id, arg);
  }

  keywds[0] = '\0';

  fp = fopen(entry, "r");
  if (fp == NULL) return -1;

  while ((fgets(ex, 250, fp) != NULL) && (ex[0] > 32)){
	if(strcomp("Keywords: ", ex) == 0){
		ex[80] = '\0';
		strcpy(keywds, strcopy(ex, 10, 80));
	}
  }

  while ((fgets(ex, 250, fp) != NULL) && (ex[0] < 32));

  if (strcomp("BINFILE", ex) == 0) {
	fgets(s, 80, fp);
	fclose(fp);
	pd(s, keywds);
	return 1;
  }
  fclose(fp);

  return 0;
}





/***************************************************************************/
/*      FUNKTION  lesen()						   */
/*  BESCHREIBUNG  Zeigt einen Artikel o. eine persoenliche Mail an. Bietet */
/*		  dann versch. Optionen zum Weiterlesen o. Beantworten an. */
/*     PARAMETER  arg  =  Nummer des Artikels/der Mail                     */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void lesen(arg)
char arg[];
{
  FILE *fp;
  char s[LSTRING];
  char entry[STRING];
  char no[10];
  char c;
  int i;
  int ok;
  int MIN, MAX;
  int pr;

  struct stat fst;

  sprintf(no, "%s", arg);

  maybe_locked(INHALT, "r");
  fp = fopen(INHALT, "r");
  if (fp == NULL) {
	nerror("misc.c", 558, "lesen", "Datei-Lesefehler", INHALT);
  }
  while ((fgets(s, LSTRING, fp) != NULL) && (s[2] != '='));
  fgets(s, LSTRING, fp);
  MIN = atoi(s);
  while (fgets(s, LSTRING, fp) != NULL) {
	MAX = atoi(s);
  }
  fclose(fp);

  if (MAX < MIN) {
	i = MIN;
	MIN = MAX;
	MAX = i;
  }
  NEXT_MSG:

  if ((no[0] < '1') || (no[0] > '9')) {
	ansi("md");
	printf(" %s\n", MIS41_MSG);
	ansi("me");
	return;
  }
  if (pruefe(no) != 0) goto NEXT_NEXT;

  printf("\n\n");
  ansi("cl");

  if (strcomp(BRETT, "PM") != 0) {
        sprintf(entry, "%s/%s", BRETT, no); 
	if(USER.terminal == 4){
		ansi("md");
		printf("%s %s\n", MIS42_MSG, no);
		ansi("me");
	}
	else{
		sprintf(headinfo, " %s %s (%s) ", MIS43_MSG, no, NG);
		headline( headinfo );
	}
	ok = show(entry, 9999, USER.more);
  }
  else {
	sprintf(entry, "%s/usr/%d/%s", HOME, USER.id, no);
	if(USER.terminal == 4){
		ansi("md");
		printf("%s %s\n", MIS44_MSG, no);
		ansi("me");
	}
	else{
		sprintf(headinfo, " %s (%s) ", MIS45_MSG, no);
		headline( headinfo );
	}
	ok = show(entry, 9999, USER.more);
  }

  c = LF;

  NEXT_NEXT:

  printf("\n");
  ansi("mr");
  printf("[Mesg. %s] %s, ? > ", no, MIS46_MSG);
  ansi("me");
  printf("%c%c", MIS51_MSG, BS);

  do {
	c = getint();
	if (c == MIS50_MSG) c = '*';
	if (c >= 97) c -= 32;
	if (c == ENTER) c = MIS51_MSG;
	if (c == '?') {
		clearline();
		ansi("mr");
		printf("%c%s > ", CR, MIS53_MSG);
		ansi("me");
	}
	if ((c != MIS47_MSG) && (c != MIS48_MSG) && (c != MIS49_MSG) && (c != MIS50_MSG) && (c != MIS51_MSG) && (c != MIS52_MSG) && (c != '*'))
		c = 0;
  } while (c == 0);

  printf("%c", c);

  if (c == MIS50_MSG) {		/* LOESCHEN */
	clearline();
	ansi("mr");
	printf("%s [%c, %c] > ", MIS54_MSG, GBL06_MSG, GBL07_MSG);
	ansi("me");
	if (yesno() == GBL06_MSG) {
		loeschen(no);
	}
	printf("\n");
	c = MIS51_MSG;
  }
  if (c == '*') {		/* LOESCHEN (sofort) */
	loeschen(no);
	printf("\n");
	c = MIS51_MSG;
  }
  if (c == MIS51_MSG) {		/* NAECHSTE */
	ok = 0;
	do {
		i = atoi(no);
		i++;
		sprintf(no, "%d", i);
		pr = pruefe(no);
		if (pr == 0) ok = 1;
		if (pr == 1) goto NEXT_NEXT;
		if (i > MAX) {
			printf("\n\n%s\n", MIS55_MSG);
			return;
		}
	} while (ok == 0);
	if (ok == 1) goto NEXT_MSG;
	goto NEXT_NEXT;
  }
  if (c == MIS52_MSG) {		/* VORHERIGE */
	ok = 0;
	do {
		i = atoi(no);
		i--;
		sprintf(no, "%d", i);
		pr = pruefe(no);
		if (pr == 0) ok = 1;
		if (pr == 1) goto NEXT_NEXT;
		if (i < MIN) {
			printf("\n\n%s\n", MIS56_MSG);
			return;
		}
	} while (ok == 0);
	if (ok == 1) goto NEXT_MSG;
	goto NEXT_NEXT;
  }
  if (c == MIS49_MSG) goto NEXT_MSG;	/* WIEDERHOLEN */


  if (c == MIS48_MSG) {			/* BEANTWORTEN */
	headline( MIS57_MSG );
	printf("\n%s", MIS58_MSG);
	sprintf(s, "cp %s %s/%dRep > /dev/null", entry, TMP, getpid());
	system(s);

	if (strcomp(BRETT, "PM") == 0) {
		brief("~REPLY~");
		sprintf(s, "%s?", USER.name);
		brief(s);
		sprintf(s, "%s/usr/%d/INDEX", HOME, USER.id);
		stat(s, &fst);
		IDX_SIZE = (int) fst.st_size;
	}
	else {
		printf("\n\n");
		ansi("mr");
		printf("%s, ? > ", MIS59_MSG);
		ansi("me");

		do {
			c = getint();
			if (c >= 97) c -= 32;
			if (c == '?') {
				clearline();
				ansi("mr");
				printf("%c%s > ", CR, MIS60_MSG);
				ansi("me");
			}
			if ((c != MIS61_MSG) && (c != MIS62_MSG)) c = 0;
		} while (c == 0);

		printf("%c", c);

		if (c == MIS62_MSG) {
			schreiben("");
		}
		if (c == MIS61_MSG) {
			brief("~REPLY~");
			if(strcomp(GUEST, USER.name) != 0){
				sprintf(s, "%s?", USER.name);
				brief(s);
				sprintf(s, "%s/usr/%d/INDEX", HOME, USER.id);
				stat(s, &fst);
			        IDX_SIZE = (long) fst.st_size;
			}
		}
	}
	goto NEXT_NEXT;
  }
  printf("\n");
  return;
}

