/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  mb-daemon.c					   */
/*        FUNKTIONEN  reflector(), scan(), mix(), main()		   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  17.12.1991					   */
/***************************************************************************/

#ifndef _ESTDIO
#include <stdio.h>
#else
#include <estdio.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

#include "mbox.h"

#define TZS 1


int FASTMODE;

int mb_gruppen;
int mb_new;
long mb_bytes;
long mb_new_bytes;
long mb_artikel;


/***************************************************************************/
/*      FUNKTION  reflector()						   */
/*  BESCHREIBUNG  Sendet eine persoenliche Mail an den Autor eines Arti-   */
/*		  kels in einer bestimmten NG.	                           */
/*			                                                   */
/*		  VORSICHT: Wilde Reflectoren werden vom Netz getrennt !!! */
/*     PARAMETER  arg  =  DUMMY (?)                                        */
/*		  msg  =  Artikel                                          */
/*     RUECKGABE  -1   =  Artikel nicht gefunden                           */
/*                0    =  Ok					 	   */
/***************************************************************************/

#define MVERSION    "+++ Un.Net Reflecting Device - Version 0.1 / MB-DAEMON +++"
#define REFLECT_NG  "xenox.test"
#define REFLECT_LOG "/mbox/etc/reflector.log"
#define DIRLIST     "/public/pd/DIRLIST"
#define REFLECTUID  22

int FLAG;

int reflector(arg, msg)
char arg[];
char msg[];
{
  FILE *fp;
  FILE *ff;

  char s[255];
  char tmp[STRING];

  char receiver[STRING];

  char path[255];
  char reply_to[255];
  char from[255];
  char sender[255];
  char subject[255];
  char summary[255];
  char keywords[255];
  char newsgroups[255];
  char followup_to[255];
  char distribution[255];
  char date[255];
  char lines[255];
  char message_id[255];
  char organization[255];
  char posted[255];
  char article_id[255];
  char nntp_post[255];
  char references[255];

  int id_err = 0;
  int i;
  int inlines, ok;

  int reply = 0;
  int noreply = 0;
  int dirlist = 0;
  int logfile = 0;
  int info = 0;
  int minimal = 0;
  long timer;


  fp = fopen(msg, "r");
  if (fp == NULL) return -1;

  sprintf(tmp, "%s/%d", TMP, getpid());
  ff = fopen(tmp, "w");
  
  i = 1;
  inlines = -1;

  while (fgets(s, 255, fp) != NULL) {
	ok = 0;
	if (strcomp("Path:", s) == 0) {
		sprintf(path, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Reply-To:", s) == 0) {
		sprintf(reply_to, "%02d>> %s <<\n", i, (char *) stripped(s));
		reply--;
		ok++;
	}
	if (strcomp("From:", s) == 0) {
		sprintf(from, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Sender:", s) == 0) {
		sprintf(sender, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Subject:", s) == 0) {
		sprintf(subject, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Summary:", s) == 0) {
		sprintf(summary, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Keywords:", s) == 0) {
		sprintf(keywords, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Newsgroups:", s) == 0) {
		sprintf(newsgroups, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Followup-To:", s) == 0) {
		sprintf(followup_to, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Distribution:", s) == 0) {
		sprintf(distribution, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Date:", s) == 0) {
		sprintf(date, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Lines:", s) == 0) {
		sprintf(lines, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Message-I", s) == 0) {
		sprintf(message_id, "%02d>> %s <<\n", i, (char *) stripped(s));
		/*
		if (s[9] == 'D') id_err++;
		*/
		ok++;
	}
	if (strcomp("Organization:", s) == 0) {
		sprintf(organization, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Posted:", s) == 0) {
		sprintf(posted, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Article-I.D.:", s) == 0) {
		sprintf(article_id, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("Nntp-Posting-Host:", s) == 0) {
		sprintf(nntp_post, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}
	if (strcomp("References:", s) == 0) {
		sprintf(references, "%02d>> %s <<\n", i, (char *) stripped(s));
		ok++;
	}



	if (strcomp("NO REPLY", s)        == 0 ||
	    strcomp("NOT REPLY", s)       == 0 ||
	    strcomp("KEIN REPLY", s)      == 0 ||
	    strcomp("NO REPLIES", s)      == 0 ||
	    strcomp("KEINE REPLIES", s)   == 0 ||
	    strcomp("NO REPLYS", s)       == 0 ||
	    strcomp("KEINE REPLYS", s)    == 0 ||
	    strcomp("KEINE ANTWORTEN", s) == 0 ||
	    strcomp("NICHT ANTWORTEN", s) == 0 ||
	    strcomp("NO REFLECT", s)      == 0 ||
	    strcomp("NOT REFLECT", s)     == 0 ||
	    strcomp("NO ANSWER", s)       == 0 ||
	    strcomp("NOT ANSWER", s)      == 0 ||
	    strcomp("IGNORE", s)          == 0)
		noreply++;

	if (strcomp("PLEASE REPLY", s)    == 0 ||
	    strcomp("BITTE REPLY", s)     == 0 ||
	    strcomp("PLEASE REFLECT", s)  == 0 ||
	    strcomp("BITTE REFLECT", s)   == 0 ||
	    strcomp("BITTE ANTWORT", s)   == 0 ||
	    strcomp("REPLY", s)           == 0 ||
	    strcomp("REFLECT", s)         == 0 ||
	    strcomp("ANTWORT", s)         == 0)
		reply++;

	if (strcomp("DIRLIST", s) == 0) dirlist++;

	if (strcomp("LOGFILE", s) == 0) logfile++;

	if (strcomp("INFO", s) == 0 ||
	    strcomp("HELP", s) == 0)
		info++;

	if (strcomp("SHORT", s) == 0) minimal++;

	if (ok == 0) {
		/* Sprintf(s, "%02d Body >> %s <<\n\n", i, (char *) stripped(s)); */
		inlines++;
	}
	i++;
  }
  fclose(fp);

  strcpy(s, (char *) strcopy(organization, 19, 80));
  if ((FLAG == 1) && (strcomp(ORGANIZATION, s) != 0)) return -1;

  if (reply_to[0] != '\0') {
	strcpy(receiver, (char *) strcopy(reply_to, 15, 80));
  } else {
	strcpy(receiver, (char *) strcopy(from, 11, 80));
  }

  i = 0;
  while ((receiver[i] != '\0') && (receiver[i] != '(')) i++;
  receiver[(i - 1)] = '\0';



  time(&timer);

  fprintf(ff, "From: reflector@%s (Reflecting Device)\n", UUCPID); 
  fprintf(ff, "Organization: %s\n", ORGANIZATION);
  if(message_id[0] != '\0'){
	fprintf(fp, "References: %s", message_id);
  }
  fprintf(ff, "To: %s\n", receiver);
  fprintf(ff, "Subject: *Reflexion*\n");
  fprintf(ff, "X-Mailer: %s %s %s\n", VERSION, PATCHLEVEL, AUTOR);	
  fprintf(ff, "Message-Id: <%x.reflector@%s>\n", timer, UUCPID);
  fputs("\n", ff);



  fp = fopen(REFLECT_LOG, "a");
  if (fp == NULL) {
	while (1) printf("%c", 7);
  }
  fprintf(fp, "%s - %s", (char *) mydate(1), from);
  fprintf(fp, "         - %s", message_id);
  fprintf(fp, "         - %s", subject);
  if (dirlist != 0) {
	fprintf(fp, "         - DIRLIST-Request\n");
  }
  if (logfile != 0) {
	fprintf(fp, "         - LOGFILE-Request\n");
  }
  if (info != 0) {
	fprintf(fp, "         - INFO-Request\n");
  }
  fprintf(fp, "         - Reflected to %s\n\n", receiver);
  fclose(fp);


  fprintf(ff, "%s\n\n", MVERSION);


  if ((dirlist == 0) && (logfile == 0) && (info == 0) && (minimal == 0)) {
	fprintf(ff, "That's what we received in NG \"%s\" ...\n\n", arg);

	fputs(path, ff);
	fputs(from, ff);
	fputs(reply_to, ff);
	fputs(sender, ff);
	fputs(newsgroups, ff);
	fputs(subject, ff);
	fputs(article_id, ff);
	fputs(posted, ff);
	fputs(nntp_post, ff);
	fputs(summary, ff);
	fputs(keywords, ff);
	fputs(followup_to, ff);
	fputs(distribution, ff);
	fputs(references, ff);
	fputs(message_id, ff);
	fputs(organization, ff);
	fputs(date, ff);
	fputs(lines, ff);


	fputs("\n\nDiagnostics ...\n\n", ff);

	if (id_err != 0) {
		fprintf(ff, "- \"Message-ID\" may cause trouble ... use \"Message-Id\".\n\n");
	}
	if (reply_to[0] == '\0') {
		fprintf(ff, "- No \"Reply-To\"-Path ... don't know how to deliever responses.\n\n");
	}
	i = atoi((char *) strcopy(lines, 12, 80));
	inlines--;
	if (inlines != i) {
		fprintf(ff, "- Your Header reports %d lines ... we counted %d.\n\n", i, inlines);
	}
	if ((reply != 0) || (noreply != 0)) {
		fprintf(ff, "- Found %d Reply-Requests and %d No-Replies.\n\n", reply, noreply);
	}
  }
  if (dirlist != 0) {
	fp = fopen(DIRLIST, "r");
	if (fp != NULL) {
		fputs("DIRLIST:\n\n", ff);
		while (fgets(s, 250, fp) != NULL) fputs(s, ff);
		fclose(fp);
	} else {
		fputs("Sorry, no DIRLIST-Entry found ...\n\n", ff);
	}
	printf("\n\n");
  }
  if (logfile != 0) {
	fp = fopen(REFLECT_LOG, "r");
	if (fp != NULL) {
		fputs("LOGFILE:\n\n", ff);
		while (fgets(s, 250, fp) != NULL) fputs(s, ff);
		fclose(fp);
	} else {
		fputs("Sorry, no LOGFILE-Entry found ...\n\n", ff);
	}
	printf("\n\n");
  }
  if (info != 0) {
	fputs("INFO (weitere Schluesselwoerter):\n\n", ff);
	fputs("LOGFILE - Wenn der Reflektor nicht reflektiert, kann man sich\n", ff);
	fputs("          das LOGFILE senden lassen, um zu ueberpruefen ob der\n", ff);
	fputs("		         Artikel jemals erfasst worden ist.\n\n", ff);

	fputs("DIRLIST - Eine Liste des lokalen MINIX-Archivs. Da der Reflektor\n", ff);
	fputs("          (noch) kein PD-Server ist, kann man diese Liste nur zu\n", ff);
	fputs("          Testzwecken anfordern.\n\n", ff);

	fputs("SHORT   - Quittiert nur den Empfang des Artikels.\n\n", ff);
  }
  if (minimal != 0) {
	fprintf(ff, "Received your article %s", message_id);
  }
  fclose(ff);

  sprintf(s, "/bin/sh ./etc/rmail.sh %s %s", tmp, receiver);
  system(s);

  unlink(tmp);

  return 0;
}



/***************************************************************************/
/*      FUNKTION  pdsize()						   */
/*  BESCHREIBUNG  Groesse eine PD-Datei ermitteln 			   */
/*     PARAMETER  arg - Name des NG-Eintrags                               */
/*     RUECKGABE  Groesse in kBytes                                        */
/***************************************************************************/

int pdsize( arg )
char arg[];
{
  FILE *fp;
  char s[STRING];
  int ok = 0;
  struct stat fstat;

  fp = fopen( arg, "r" );
  if(fp == NULL){
	return (int) 0;
  }
  while((ok == 0) && (fgets(s, 80, fp) != NULL)){
	if(strcomp("BINFILE", s) == 0) ok++;
  }
  if(ok == 0){
	fclose(fp);
	stat(arg, &fstat);
	return (int) (fstat.st_size / 1024);
  }

  fgets(s, 80, fp);
  fclose(fp);
 
  stat((char *) stripped(s), &fstat);
  return (int) (fstat.st_size / 1024);
}








/***************************************************************************/
/*      FUNKTION  scan()						   */
/*  BESCHREIBUNG  Filtert einen NEWS-Artikel, und erstellt einen Eintrag   */
/*		  fuer das entsprechenden INDEX-Files der ix/Mbox.	   */
/*     PARAMETER  arg  =  NG                                               */
/*     RUECKGABE  Datum des aktuellsten Artikels                           */
/***************************************************************************/

char *scan(arg)
char arg[];
{
  FILE *ff;
  FILE *fp;
  FILE *fl;
  FILE *ft;
  char s[STRING];
  char t[STRING];
  char f[STRING];
  char v[STRING];
  char num[STRING];
  char from[STRING];
  char subj[STRING];
  char date[STRING];
  char line[STRING];
  char Ndir[STRING];
  char Ldir[STRING];
  char Tdir[STRING];
  char ex[355];
  char et[355];
  char sdate[STRING];
  char today[STRING];
  char thatday[STRING];
  char arti[STRING];
  int i, j;
  int ok = 0;
  int a, b;
  int BINFILE = 0;
  int PDGROUP = 0;
  int fsi = 0;
  int seq = 0;
  int OLDENTRY = 0;
  int OLDn = 0;
  int OLDo = 0;
  struct stat fstat;
  struct tm *tp;

  i = 0;
  while (arg[i] != '\0') {
	t[i] = arg[i];
	if (t[i] == '.') t[i] = '/';
	i++;
  }
  t[i] = '\0';

  sprintf(Ndir, "%s/%s", NEWS, t);

  if(length(arg) > 14){
	s[0] = '\0'; strcat(s, (char *) shortname(arg));
	sprintf(Ldir, "%s/%s", LIB, s);
  } 
  else{
	sprintf(Ldir, "%s/%s", LIB, arg);
  }
  sprintf(Tdir, "%s/TD.%d", TMP, getpid());

  if (FLAG == 0) printf("\n%s...\n", Ndir);

  sprintf(s, "ls %s > %s/%d", Ndir, TMP, getpid());
  system(s);

  sprintf(f, "%s/%d", TMP, getpid());
  sprintf(t, "sort -nr %s > %sA", f, f);
  system(t);

  unlink(f);

  strcat(f, "A");

  fl = fopen(f, "r");
  if (fl == NULL) {
	if (FLAG == 0) printf("cancled!");
	return;
  }
  sprintf(sdate, "%s", ":-)");

  sprintf(today, "%s", (char *) mydate(1));


  ft = fopen(Ldir, "r");
  if(ft == NULL){
	ft = fopen(Ldir, "w");
	fputs("\n\n0\n", ft);
	fclose(ft);
	ft = fopen(Ldir, "r");
	OLDo = -2;
  }
  fgets(s, 81, ft);
  fgets(s, 81, ft);
  fgets(s, 81, ft);
  OLDENTRY = atoi(s); 

  lockf(Ldir);

  ff = fopen(Tdir, "w");

  seq = 0;

  mb_gruppen++;

  if(strcomp(PDNG, arg) == 0){
	PDGROUP++;	
	fprintf(ff, "%s\n", GBL08_MSG); 
  }
  else{
	fprintf(ff, "%s\n", GBL05_MSG);
  }
  fputs("===============================================================================\n", ff);
  
  while (fgets(num, 80, fl) != NULL) {

	if((atoi(num) < OLDENTRY) && (FASTMODE == 1)) goto YET_SCANNED;

	OLDn++;

	seq++;
	BINFILE = 0;
	fsi++;

	strcpy(s, (char *) stripped(num));
	sprintf(t, "%s/%s", Ndir, s);
        sprintf(arti, "%s", t);
  

	if (FLAG == 0) printf("%s: ", t);

	fp = fopen(t, "r");
	if (fp != NULL) {

		stat(t, &fstat);
		tp = localtime(&fstat.st_mtime);

		if(fstat.st_mode & S_IFDIR) goto OFF_HERE;

		mb_bytes += (long) fstat.st_size;
		sprintf(thatday, "%02.2d.%02.2d.%02.2d", tp->tm_mday, tp->tm_mon + TZS, tp->tm_year);
		if(strcomp(thatday, today) == 0) mb_new_bytes += (long) fstat.st_size;

		if (sdate[0] == ':') {
			sprintf(sdate, "%4.4d%02.2d%02.2d",
				1900 + tp->tm_year, tp->tm_mon + TZS, tp->tm_mday);
			sprintf(s, "%02.2d:%02.2d",
				tp->tm_hour, tp->tm_min);
			LASTTIME = timeconv(s);
			if (FLAG == 0) printf(" (%s) ", sdate);
			if(strcomp(thatday, today) == 0) mb_new++;
		}
		if (strcomp(arg, REFLECT_NG) == 0) {
			if (strcomp(thatday, today) == 0) {
				reflector(arg, t);
			}
		}
		from[0] = '\0';
		subj[0] = '\0';
		date[0] = '\0';
		line[0] = '\0';

		for (i = 0; i < 20; i++) {
			fgets(s, 80, fp);
			if (strcomp("From:", s) == 0) {
				strcpy(from, s);
			}
			if (strcomp("Reply-To:", s) == 0) {
				strcpy(from, s);
			}
			if (strcomp("Subject:", s) == 0) strcat(subj, s);
			if (strcomp("Date:", s)    == 0) strcat(date, s);
			if (strcomp("Lines:", s)   == 0) strcat(line, s);
			if (strcomp("BINFILE", s)  == 0) BINFILE++;
		}


		if (FLAG == 0) printf("%s", subj);

		if ((from[0] == 'F') || (from[0] == 'R')) {

			strcpy(s, (char *) stripped(num));
			strcat(s, "       ");
			s[6] = '\0';
			if (BINFILE != 0) s[5] = '*';

			subj[79] = '\0';
			strcpy(ex, (char *) strcopy(subj, 8, 79));
			strcpy(et, (char *) stripped(ex));
			strcpy(ex, et);
			strcat(ex, "                           ");
			ex[25] = '\0';
			strcat(s, ex);
			strcat(s, "   ");


			i = 8;
			if (from[0] == 'R') i = 10;

			from[79] = '\0';
			strcpy(ex, (char *) strcopy(from, i, 80));
			strcpy(et, (char *) stripped(ex));
			strcpy(ex, et);

			a = 0;
			b = 0;
			i = 0;
			while (ex[i] != '\0') {
				if (ex[i] == '(') a = i + 1;
				if (ex[i] == ')') b = i - 1;
				i++;
			}
			if (a < b) {
				strcpy(et, (char *) strcopy(ex, a, b));
				strcpy(ex, et);
			}
			strcat(ex, "                           ");
			ex[19] = '\0';
			strcat(s, ex);
			strcat(s, "   ");


			i = 0;
			j = 0;
			while (date[i] != '\0') {
				if (j == 0) {
					if ((date[i] >= '1') && (date[i] <= '9'))
						j = i;
				}
				i++;
			}

			sprintf(ex, "%02.2d.%02.2d.%02.2d  %02.2d:%02.2d",
			 tp->tm_mday, tp->tm_mon + TZS, tp->tm_year,
				tp->tm_hour, tp->tm_min);
			strcat(ex, "                         ");
			ex[15] = '\0';
			strcat(s, ex);
			strcat(s, "  ");

			strcpy(ex, (char *) strcopy(line, 7, 20));
			strcpy(t, (char *) stripped(ex));
			i = atoi(t);
			sprintf(ex, "%-6.d", i);
		
			if(PDGROUP != 0){
				sprintf(ex, "%-6.d", pdsize(arti));
			}

			strcat(s, ex);
			fputs(s, ff);
			fputs("\n", ff);

			mb_artikel++;

			ok = 1;
		} else {
			if (FLAG == 0) printf("invalid header!\n");
		}

		OFF_HERE:

		if (fp != 0) fclose(fp);
	} else {
		if (FLAG == 0) printf("can't open!");
	}
  }

  YET_SCANNED:

  while(fgets(num, 80, fl) != NULL){
	fgets(s, 81, ft); 
	fputs(s, ff);
	strcpy(s, (char *) stripped(num));
	sprintf(t, "%s/%s", Ndir, s);
	stat(t, &fstat);
	mb_bytes += (long) fstat.st_size;
	mb_artikel++;
	OLDo++;
  }
  fgets(s, 81, ft);
  if(FASTMODE == 1) fputs(s, ff);

  if (ff != 0) fclose(ff);
  if (fl != 0) fclose(fl);
  if (ft != 0) fclose(ft);
  
  fp = fopen( Ldir, "w" );
  fl = fopen( Tdir, "r" );
  while(fgets(s, 81, fl) != NULL){
	fputs(s, fp);
  }
  fclose(fp);
  fclose(fl);

  unlink(f);
  unlink(Tdir);
  
  if (sdate[0] == ':') {
	sprintf(sdate, "%s", "19700101");
	LASTTIME = 0;
  }

#ifdef _SYS7
  if ((seq > MAX_PER_NG) && (FLAG == 0) && (strcomp("local", arg) != 0)) {
	sprintf(s, "%s -n %s -e %d", EXPIRE, arg, EXPIRED_DAYS);
	printf("%s\n", s);
	system(s);
	sprintf(s, "mb-daemon %s EXP", arg);
	system(s);
  }
#endif
  
  unlockf(Ldir);

  if((FASTMODE == 1) && (FLAG == 0)){
	if(OLDn != 0) OLDn -= 1;
	OLDo += 2;
	printf("\n==> %s %d. %s %d.\n\n", MBD01_MSG, OLDn, MBD02_MSG, OLDo);
  }
  
  return (char *) sdate;
}



/***************************************************************************/
/*      FUNKTION  mix()							   */
/*  BESCHREIBUNG  Aktualisiert einzelnen Eintraege im AGROUPS-File.	   */
/*     PARAMETER  s  =  NG                                                 */
/*		  t  =  Neuer AGROUPS-Eintrag                              */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void mix( s, t )
char s[], t[];
{
  FILE *ff, *fp;
  char tmp[STRING];
  char f[STRING];

  sprintf(tmp, "%s/ff%d", TMP, getpid());


  maybe_locked( AGROUPS, "r" );
  fp = fopen( AGROUPS, "r" );
  if(fp == NULL){
	printf("%s ?", AGROUPS);
	exit(-1);
  }

  ff = fopen( tmp, "w" );
  if(ff == NULL){
	printf("%s ?", tmp);
	exit(-1);
  }

  while(fgets(f, 80, fp) != NULL){
	if(strcomp(s, f) == 0){
		fputs(t, ff);
	}
	else{
		fputs(f, ff);
	}
  }
  fclose(fp);
  fclose(ff);

  sprintf(f, "mv %s %s", tmp, AGROUPS);
  system( f );
}





/***************************************************************************/
/*      FUNKTION  main() (mb_daemon)					   */
/*  BESCHREIBUNG  Scannt einen bzw. alle NEWS-Artikel, um die INDEX-Files  */
/*		  der ix/Mbox zu aktualisieren.                            */
/*     PARAMETER  argc  =  Anzahl der Parameter                            */
/*		  argv  =  NG  = nur diese NG scannen 			   */
/*			   ''  = alle NGs scannen     			   */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

main(argc, argv)
int argc;
char *argv[];
{
  FILE *fp;
  FILE *fa;
  char s[STRING];
  char t[STRING];
  char d[STRING];


  int a, b, i;

  chdir(HOME);

  setuid(0);
  setgid(0);
  umask(0000);

  FLAG = 0;
  FASTMODE = 1;

  if(argc > 1){
	FLAG++;
  }
  if(argc > 2){			/* MB-Daemon ruft MB-Daemon !!! */
	FLAG++; 
	FASTMODE = 0; 
  }
  if(argv[2][0] == '-'){	/* Index KOMPLETT neu bilden !!! */
	FASTMODE = 0;
  }

  if(FLAG == 0){
	fa = fopen(AGROUPS, "w");
	fclose(fa);
  }


  mb_gruppen = 0;
  mb_new = 0;
  mb_bytes = 0L;
  mb_new_bytes = 0L;
  mb_artikel = 0L;


  fp = fopen(NGROUPS, "r");
  while (fscanf(fp, "%s %d %d %s", &s, &a, &b, &t) > 0) {
	if(FLAG > 0){
		if(strcomp(argv[1], s) == 0){
			d[0] = '\0';
#ifdef _SYS7
			strcat(d, (char *) scan(s));
#else
			strcat(d, (char *) scan(&s));
#endif
			sprintf(t, "%s  %s  %d\n", s, d, LASTTIME);
			if(FLAG < 2) mix( s, t );
		}
	}
	else{
		d[0] = '\0';
#ifdef _SYS7	
		strcat(d, (char *) scan(s));
#else	
		strcat(d, (char *) scan(&s));
#endif
		fa = fopen(AGROUPS, "a");
		fprintf(fa, "%s  %s  %d\n", s, d, LASTTIME);
		fclose(fa);
	}
  }
  if(fp != 0) fclose(fp);

  if(FLAG > 0){
  }
  else{
     mb_bytes = (long)(mb_bytes / 1024);
     mb_new_bytes = (long)(mb_new_bytes /1024);
   
     sprintf(d, "%s/%d.mbd", TMP, getpid());
     fp = fopen( d, "w" );
     fprintf(fp, "%s  %s    %6.d   %6.d",
                  mydate(1), mytime(1), mb_new, mb_new_bytes);
     fprintf(fp, "%16.16s", " ");
     fprintf(fp, "%6.d   %6.d   %6.d\n", mb_gruppen, mb_artikel, mb_bytes);

     b = PRO_ENTRIES / 2; a = 0;

     fa = fopen( MB_DLOG, "r" );
     if(fa != 0){
	while((fgets(s, STRING, fa) != 0) && (a < b)){
		fputs(s, fp);
		a++;
	}
	fclose(fa);
     }
     fclose(fp);

     sprintf(s, "mv %s %s > /dev/null", d, MB_DLOG);
     system(s);
  } 

  if((FASTMODE == 1) && (FLAG == 0)){
	printf("%s %d %s %d %s.\n", MBD03_MSG, mb_new, MBD04_MSG, 
		mb_new_bytes, MBD05_MSG);
	printf("%s %d %s %d %s %d %s.\n\n", 
		MBD06_MSG, mb_gruppen, MBD07_MSG, mb_artikel, MBD08_MSG, 
		mb_bytes, MBD09_MSG);
  }

  return;
}


