/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  main.c						   */
/*        FUNKTIONEN  logout(), init(), fixoutput(), main()		   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  24.11.1991					   */
/***************************************************************************/

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>

#include "mbox.h"

extern time_t time_start, time_now;



/***************************************************************************/
/*      FUNKTION  logout()						   */
/*  BESCHREIBUNG  Entfernt den User aus "WHO" und reorganisiert seine      */
/*		  Teilnehmerdaten.                                         */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine							   */
/***************************************************************************/

void logout()
{
  FILE *fp;
  FILE *ff;
  char s[STRING];
  char t[STRING];
  char u[STRING];
  char f[STRING];
  long ll;
  int a, b;
  int fd;
  struct tm *timeptr;
  struct userdaten DUMMY;
  int dummy = sizeof(DUMMY);

  printf("\n");


  time(&time_now);
  USER.elapsed += (long) (time_now - time_start);

  sprintf(f, "%s/who%d", TMP, getpid());
  maybe_locked(WHO, "r"); lockf(WHO);
  fp = fopen(WHO, "r");
  if (fp == NULL) {
	nerror("main.c", 34, "logout", "Datei-Lesefehler", WHO);
  }
 
  t[0] = '\0'; strcat(t, ttyna());

  ff = fopen(f, "w");
  if (ff == NULL) {
	nerror("main.c", 38, "logout", "Datei-Schreibfehler", f);
  }
  while (fgets(s, 80, fp) != NULL) {
	if(strcomp(t, s) != 0) fputs(s, ff);
  }
  fclose(ff);
  fclose(fp);
  sprintf(s, "cp %s %s", f, WHO);
  system(s);
  unlink(f);
  unlockf(WHO);

  strcpy(s, HOME); strcat(s, "/etc/");
  strcat(s, (char *) ttyna()); strcat(s, ".");
  unlink( s );

  sprintf(USER.abused, "%ld", IDX_SIZE);

  USER.seq--;		
  printf("\n");
  init_user( MAI01_MSG );

  control(MAI02_MSG, 3);
}



/***************************************************************************/
/*      FUNKTION  init()						   */
/*  BESCHREIBUNG  Liest die Befehle aus "BEFEHLE", fuellt die Befehl-      */
/*		  Stuktur und verteilt die Level-Vorgaben.                 */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine							   */
/***************************************************************************/

void init()
{
  FILE *fp;
  char s[STRING];
  int b = 0;

  maybe_locked(BEFEHLE, "r");
  fp = fopen(BEFEHLE, "r");
  if (fp == NULL) {
	nerror("main.c", 68, "init", "Datei-Lesefehler", BEFEHLE);
  }

  while((fgets(s, 80, fp) != NULL) && (s[0] == '/'));
  
  fgets(s, 80, fp); /* 3 Zeilen nach dem Kommentar (exakt 3 Zeilen !!!) */
  fgets(s, 80, fp);

  while (fscanf(fp, "%d %d %d %d %s", &BEF[b].id, &BEF[b].in, &BEF[b].ex, &BEF[b].prototyp, &BEF[b].befehl) > 0) {

	if (BEF[b].id == 160) MAILOUT_LEV = BEF[b].ex;
	if (BEF[b].id == 125) ADMIN_LEV = BEF[b].ex;
	if (BEF[b].id == 230) WRITE_EX_LEV = BEF[b].ex;
	if (BEF[b].id == 230) WRITE_IN_LEV = BEF[b].in;
	if (BEF[b].id == 998) WRITE_INTERNAT = BEF[b].in;
	if (BEF[b].id == 195) PD_D_LEV = BEF[b].in;
	if (BEF[b].id == 195) PD_U_LEV = BEF[b].ex;
	if (BEF[b].id == 240) EXE_LEV = BEF[b].ex;
	if (BEF[b].id == 320) GUEST_LEV = BEF[b].in;
	if (BEF[b].id == 130) BB1 = b;
	if (BEF[b].id == 150) BB2 = b;
	if (BEF[b].id == 160) BB3 = b;
	if (BEF[b].id == 170) BB4 = b;
	if (BEF[b].id == 210) BB5 = b;
	if (BEF[b].id == 180) BB6 = b;
	if (BEF[b].id == 190) BB7 = b;
	if (BEF[b].id == 200) BB8 = b;
	if (BEF[b].id == 270) BB9 = b;

	b++;
	if (b >= MAX_BEF) {
		nerror("main.c", 85, "init", "MAX_BEF ueberschritten !!", "???");
	}
  }
  BEF[b].id = -1;

  fclose(fp);
}



/***************************************************************************/
/*      FUNKTION  fixoutput()						   */
/*  BESCHREIBUNG  Legt fest an welches Geraet, oder in welche Datei, die   */
/*		  Logbuch-Eintraege geschickt werden.			   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine							   */
/***************************************************************************/

void fixoutput()
{
  char s[STRING];

  FILE *fp;

  strcpy(s, CONSOLE); CONSOLE_REDIRECT[0] = '\0';

  if(strcomp("REDIRECT", CONSOLE) == 0){
	fp = fopen( CDIRECTFL, "r" );
	if(fp != NULL){
		fgets(s, STRING, fp);
		fclose(fp);
		
	}
   }
   strcat(CONSOLE_REDIRECT, (char *) stripped(s));
}




/***************************************************************************/
/*      FUNKTION  main()						   */
/*  BESCHREIBUNG  Hauptfunktion. Rettet UID/GID, initialisiert, startet    */
/*		  die MBox-Funktionen und terminiert.                      */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  "Exit-Status"						   */
/***************************************************************************/

main()
{
  FILE *fp;
  int i;


  chdir(HOME);

  OLDUID = getuid();
  OLDGID = getgid();

  sprintf(MYNAME, "%s", "J. Random Looser");

  fp = fopen( UDBASE, "r" );
  if(fp == NULL){
	strcpy(TERMINAL, "ansi");
	ansi("INIT");

	headline( MAI03_MSG );
	ansi("md");
	printf("\n%s", MAI04_MSG);
	printf("\n%s", MAI05_MSG);
	printf("\n%s", MAI06_MSG);
	printf("\n");
	printf("\n%s", MAI07_MSG);
	printf("\n%s", MAI08_MSG);
	printf("\n%s\n\n", MAI09_MSG);
	ansi("me");

	postfach( "#1" );
	postfach( "#2" );

	ansi("md");
	printf("\n%s\n\n", MAI10_MSG);
	ansi("me");
	return 0;
  }
  fclose(fp);


  fixoutput();

  intro();
  init();
  get_makros();

  ctrlx();

  loop();
  logout();
  noctrlx();

  ansi("md");
  printf("\n\n%s\n\n", MAI11_MSG);
  ansi("me");

  return 0;
}
