#include <stdio.h>
#include <setjmp.h>
#include <signal.h>

#define VERSION "LED 3.4 (Unix)"
#define AUTOR   "Volker.Schuermann@unnet.w.open.de"

#ifndef STRING
#define STRING 85
#endif

#include "mbox.msg"


#define CR     13
#define LF     10
#define BS      8
#define CTRL_X 24
#define CTRL_D  4


#define TMP "/tmp"

#define APPEND 1
#define INSERT 2
#define FINISH 3
#define QUIT   4
#define UPLOAD 5

#ifdef _MBOX
#undef _MBOX
#endif

static int melted;

static char tmp1[STRING];
static char tmp2[STRING];

static int von, bis;
static int max_line;

static char imode;

static char THE_FILE[STRING];
static int  THE_LINE;


int melt(startlin)
int startlin;
{
  FILE *fp;
  FILE *ff;
  FILE *fg;
  char s[255];
  char tmp3[STRING];
  int i;


  if (melted == 0) return 0;

  sprintf(tmp3, "%s/bled3.%d", TMP, getpid());

  fg = fopen(tmp3, "w");
  if (fg == NULL) {
	printf("\n%s\n", tmp3);
	exit(-1);
  }
  fp = fopen(tmp1, "r");
  if (fp == NULL) {
	printf("\n%s\n", tmp1);
	exit(-1);
  }
  i = 0;
  while ((i < startlin) && (fgets(s, 250, fp) != NULL)) {
	fputs(s, fg);
	i++;
  }
  ff = fopen(tmp2, "r");
  if (ff != NULL) {
	while (fgets(s, 250, ff) != NULL) {
		fputs(s, fg);
		i++;
	}
	fclose(ff);
  }
  while (fgets(s, 250, fp) != NULL) {
	fputs(s, fg);
  }
  fclose(fg);
  fclose(fp);

  unlink(tmp1);
  rename(tmp3, tmp1);
  unlink(tmp3);

  return 0;
}



bledmove(from, to)
char from[], to[];
{
  FILE *fp;
  FILE *ff;
  char s[255];


  fp = fopen(from, "r");
  if (fp == NULL) {
	printf("\n%s\n", from);
	exit(-1);
  }
  ff = fopen(to, "w");
  if (ff == NULL) {
	printf("\n%s\n", from);
	exit(-1);
  }
  while (fgets(s, 250, fp) != NULL) {
	fputs(s, ff);
  }
  fclose(fp);
  fclose(ff);
}





zeigen(mode)
char mode;
{
  FILE *fp;
  char t[STRING];
  char s[255];
  int i;

  if ((von != 0) && (bis == 0)) bis = von;
  if ((von == 0) && (bis == 0)) bis = 32000;

  if (von > bis) {
	/*
	printf("\n\nLED: Fehler bei der Zeilenangabe.\n");
	*/	
	printf("\n\nLED: %s\n", BLD01_MSG);
	return;
  }
  fp = fopen(tmp1, "r");
  if (fp == NULL) {
	printf("\n%s\n", tmp1);
	exit(-1);
  }
  i = 1;
  printf("\n\n");
  while (fgets(s, 250, fp) != NULL) {
	if ((i >= von) && (i <= bis)) {
		if (mode == 'l')
			printf("L%04.4d %s", i, s);
		else
			printf("%s", s);
	}
	i++;
  }
  fclose(fp);
}



loeschen()
{
  FILE *fp;
  FILE *ff;
  char t[STRING];
  char s[255];
  int i;

  if ((von != 0) && (bis == 0)) bis = von;
  if ((von == 0) && (bis == 0)) bis = 32000;

  if (von > bis) {
	/*
	printf("\n\nLED: Fehler bei der Zeilenangabe.\n");
	*/	
	printf("\n\nLED: %s\n", BLD01_MSG);
	return;
  }
  ff = fopen(tmp2, "w");
  if (ff == NULL) {
	printf("\n%s\n", tmp2);
	exit(-1);
  }
  fp = fopen(tmp1, "r");
  if (fp == NULL) {
	printf("\n%s\n", tmp1);
	exit(-1);
  }
  i = 1;
  printf("\n\n");
  while (fgets(s, 250, fp) != 0) {
	if ((i < von) || (i > bis)) {
		fputs(s, ff);
	}
	i++;
  }
  fclose(fp);
  fclose(ff);

  unlink(tmp1);
  rename(tmp2, tmp1);
}



upload()
{
  FILE *fp;
  char c;
  char lf;

  fp = fopen(tmp2, "w");
  if (fp == NULL) {
	printf("\n%s\n", tmp2);
	exit(-1);
  }
  /*
  printf("\n\nLED: Uebertragung beginnt. (Beenden mit CTRL-X !)\n\n");
  */
  printf("\n\nLED: %s\n\n", BLD02_MSG);

  c = 0;
  lf = CR;


  while ((c != CTRL_X) && (c != CTRL_D)) {

        c = getint();

	if ((c == CR) && (lf == CR)) fputc(LF, fp);
	if (c == CR) lf = CR;
	if (c == LF) lf = LF;
	if ((c != CTRL_X) && (c != CTRL_D) && (c != CR)) {
		fputc(c, fp);
	}
  }
  fclose(fp);
}



korrigieren()
{
  FILE *fp;
  FILE *ff;
  char s[255];
  char t[255];
  int i;

  if (von == 0) {
	/*
	printf("\n\nLED: Fehler bei der Zeilenangabe.\n");
	*/	
	printf("\n\nLED: %s\n", BLD01_MSG);
	return;
  }
  fp = fopen(tmp1, "r");
  if (fp == NULL) {
	printf("\n%s\n", tmp1);
	exit(-1);
  }
  ff = fopen(tmp2, "w");
  if (ff == NULL) {
	printf("\n%s\n", tmp1);
	exit(-1);
  }
  i = 1;
  while (fgets(s, 250, fp) != NULL) {
	if (i == von) {
		t[0] = '\0';
		strcat(t, stripped(s));
		s[0] = '\0';
		if (length(t) < 74)
			printf("\n\nK%04.4d ", i);
		else
			printf("\n\n");
		strcat(s, getline(74, 1001, ' ', t));
		strcat(s, "\n");
		printf("\n");
	}
	fputs(s, ff);
	i++;
  }
  fclose(ff);
  fclose(fp);
  unlink(tmp1);
  rename(tmp2, tmp1);
}




crunch(s)
char s[];
{
  char t[STRING];
  int i = 0, a = 0;

  von = 0;
  bis = 0;

  while (s[i] != '\0') {
	if ((s[i] == ',') || (s[i] == '-')) a = i;
	i++;
  }
  if (a == 0) a = i;
  t[0] = '\0';
  strcat(t, strcopy(s, 3, (a - 1)));
  von = atoi(t);
  t[0] = '\0';
  strcat(t, strcopy(s, (a + 1), i));
  bis = atoi(t);
  if ((a != i) && (bis == 0)) bis = 32000;
}





int befehl(s)
char s[];
{
  char c = s[1];

  if ((s[2] != ' ') && (s[2] != '\0') && (s[1] != '\0')) {
	/*
	printf("\n\nLED: Syntax-Fehler.\n");
	*/
	printf("\n\nLED: %s\n", BLD03_MSG);
	return 0;
  }
  crunch(s);

  switch (c) {
      case '\0':
			return FINISH;
			break;
      case '?':
			printf("\n\n%c", CR);
			ansi("mr");
			/*
			printf(" %s  -  Befehlsuebersicht ", VERSION);
			*/
			printf(" %s  -  %s ", VERSION, BLD04_MSG);
			ansi("me");
			printf("\n\n");
			/*
			printf(".l [ZEILE]|[VON,BIS]   lesen\n");
			printf(".L [ZEILE]|[VON,BIS]   lesen (keine Zeilennummern)\n");
			printf(".i AB                  einfuegen\n");
			printf(".a                     anhaengen (beendet einfuegen)\n");
			printf(".k ZEILE               korrigieren\n");
			printf(".d [ZEILE]|[VON,BIS]   loeschen\n");
			printf(".u                     uebertragen (ASCII-Upload)\n");
			printf(".q                     abbrechen\n");
			printf(".h                     ausfuehrliche Hilfe\n");
			printf(".                      sichern & beenden\n\n");
			printf("ZEILE, VON, BIS, AB sind gueltige Zeilennummern.\n");
			printf("Angaben in [KLAMMERN] sind optional. Werden\n");
			printf("keine Angaben gemacht gilt AB=1, VON=1, BIS=32000.\n");
			*/
			printf("%s\n", BLD05_MSG);
			printf("%s\n", BLD06_MSG);
			printf("%s\n", BLD07_MSG);
			printf("%s\n", BLD08_MSG);
			printf("%s\n", BLD09_MSG);
			printf("%s\n", BLD10_MSG);			
			printf("%s\n", BLD11_MSG);
			printf("%s\n", BLD12_MSG);
			printf("%s\n", BLD13_MSG);
			printf("%s\n", BLD14_MSG);
			printf("\n");
			printf("%s\n", BLD15_MSG);
			printf("%s\n", BLD16_MSG);
			printf("%s\n", BLD17_MSG);
			break;
      case 'h':	        printf("\n\n%c", CR);
			ansi("mr");
			/*
			printf(" %s  -  Hilfe ", VERSION);
			*/
			printf(" %s  -  %s ", VERSION, BLD18_MSG);
			ansi("me");
			printf("\n\n");
			system( HILFE );
			break;
      case 'a':	
			return APPEND;	
			break;
      case 'i':
			return INSERT;	
			break;
      case 'l':
      case 'L':
			zeigen(c);
			return APPEND;
			break;
      case 'd':
			loeschen();
			return APPEND;
			break;
      case 'k':
      case 'c':
			korrigieren();
			return APPEND;
      case 'u':
			upload();
			return UPLOAD;
      case 'q':
			unlink(tmp1);
			unlink(tmp2);
			/*
			printf("\n\nLED: Abgebrochen. Datei NICHT gesichert.\n\n");
			*/
			printf("\n\nLED: %s\n\n", BLD19_MSG);
			exit(0);
			break;
      default:		/*
			printf("\n\nLED: Befehl unbekannt.\n");
			*/
			printf("\n\nLED: %s\n", BLD20_MSG);
}
  return 0;
}





int erfassen(line, mode)
int line, mode;
{
  FILE *fp;
  char s[STRING];
  char t[STRING];
  char def[STRING];
  int ok = 0;
  int elin = line;
  int startlin = line - 1;
  int a, b;

  melted = 1;			/* Sicher ist sicher ... */
  THE_LINE = startlin;

  fp = fopen(tmp2, "w");
  if (fp == NULL) return -1;

  def[0] = '\0';

  do {
	if (elin > max_line) max_line = elin;
	printf("\n%c%04.4d ", imode, elin);
	s[0] = '\0';
	if (def[0] == '\0')
		strcat(s, getline(73, 1, ' ', " "));
	else
		strcat(s, getline(73, 1001, ' ', def));

	if (strcomp("<BREAK>", s) == 0) {
		sprintf(s, ".?");
	}
	if (s[0] == '.') {
		fclose(fp);
		melted = melt(startlin);

		ok = befehl(s);

		if (ok == UPLOAD) {
			melted = 1;
			melted = melt(startlin);
			ok = APPEND;
		}
		if (ok == INSERT) {
			imode = 'I';
			if (von < 1) von = 1;
			if (von > max_line) {
				ok = APPEND;
			}
			 else {
				startlin = von - 1;
				THE_LINE = startlin;
				elin = von;
			}
		}
		if (ok == APPEND) {
			imode = 'A';
			unlink(tmp2);
			rename(tmp1, tmp2);
			startlin = getfile(tmp2);
			if (startlin < 1) startlin = 0;
			elin = startlin + 1;
			THE_LINE = startlin;
		}
		fp = fopen(tmp2, "w");
		if (fp == NULL) return -1;

	} else {
		def[0] = '\0';
		a = length(s);
		if (a == 73) {
			while ((s[a] != ' ') && (a > 40)) a--;
			if (s[a] == ' ') {
				strcat(def, strcopy(s, (a + 1), 73));
				s[a] = '\0';
				for (b = a; b < 73; b++) printf("%c", BS);
				for (b = a; b < 73; b++) printf(" ");
			}
		}
		fprintf(fp, "%s\n", s);
		elin++;
		melted++;
	}
  } while (ok != FINISH);
  return elin;
}



sigcatch(sig)
int sig;
{

  switch (sig) {
      case SIGINT:
      case SIGQUIT:
      case SIGHUP:
      case SIGABRT:
      case SIGTERM:
	melted++;
	melt(THE_LINE);
	bledmove(tmp1, THE_FILE);
	unlink(tmp1);
	unlink(tmp2);
	/*
	printf("\n\nLED: Prozess terminiert. Datei gesichert.\n\n");
	*/
	printf("\n\nLED: %s\n\n", BLD21_MSG);
	exit(-1);
	break;
  }
}



int getfile(path)
char path[];
{
  FILE *fp;
  FILE *ff;
  int i = 0;
  char s[STRING];

  ff = fopen(tmp1, "w");
  if (ff == NULL) {
	printf("\n%s\n", tmp1);
  }
  fp = fopen(path, "r");
  if (fp == NULL) {
	fclose(ff);
	return -1;
  }
  if (fgets(s, STRING, fp) != 0) i++;
  if ((s[0] == 1) && (s[1] == 3)) {	/* MAGIC NUMBER */
	return -2;
  }
  fputs(s, ff);

  while (fgets(s, STRING, fp) != NULL) {
	fputs(s, ff);
	i++;
  }
  fclose(fp);
  fclose(ff);

  return i;
}



main(argc, argv)
int argc;
char *argv[];
{
  char s[STRING];

  int eof = 0;


  if (argc < 2) {
	/*
	printf("\nLED: Keine Datei angegeben.\n\n");
	*/
	printf("\nLED: %s\n\n", BLD22_MSG);
	return;
  }
  /*
  signal(SIGINT, sigcatch);
  signal(SIGQUIT, sigcatch);
  signal(SIGHUP, sigcatch);
  signal(SIGABRT, sigcatch);
  signal(SIGTERM, sigcatch);
  */
  signal(SIGINT,  SIG_IGN);
  signal(SIGQUIT, SIG_IGN);
  signal(SIGHUP,  SIG_IGN);
  signal(SIGABRT, SIG_IGN);
  signal(SIGTERM, SIG_IGN);

#ifndef _SYS7

  setbuf(stdout, NULL);

#endif

  ansi( "INIT" );

  sprintf(s, " %s ", VERSION);
  headline(s);
 
  /*
  printf("\nMomentchen ...");
  */
  printf("\n%s", BLD23_MSG);

  sprintf(tmp1, "%s/bled1.%d", TMP, getpid());
  sprintf(tmp2, "%s/bled2.%d", TMP, getpid());

  sprintf(THE_FILE, "%s", argv[1]);
  THE_LINE = 0;

  eof = getfile(THE_FILE);
  printf("%c", CR);
  if (eof == -2) {
	/*
	printf("Datei \"%s\" enthaelt ein ausfuehrbares Programm.\n\n", THE_FILE);
	*/
	printf("%s \"%s\" %s\n\n", BLD24_MSG, THE_FILE, BLD25_MSG);
	return;
  }
  if (eof == -1)
	/*
	printf("Datei wird angelegt.");
	*/
	printf("%s", BLD26_MSG);
  else
	/*
	printf("Datei enthaelt %d Zeilen.", eof);
	*/
	printf("%s %d %s", BLD27_MSG, eof, BLD28_MSG);
  
  /*
  printf(" Befehlsuebersicht: \".?\"\n");
  */
  printf(" %s: \".?\"\n", BLD04_MSG);

  if (eof < 1) eof = 0;
  melted = 0;
  max_line = eof;
  eof++;

  imode = 'A';

  if (erfassen(eof, APPEND) < 1) {
	/*
	printf("\n\nLED: Probleme ...\n\n");
	*/
	printf("\n\nLED: %s\n\n", BLD29_MSG);
  }
  bledmove(tmp1, THE_FILE);
  unlink(tmp1);
  unlink(tmp2);

  /*
  printf("\n\nUnd 'tschuess ...\n\n");
  */
  printf("\n\n%s\n\n", BLD30_MSG);
}
