/* pu_lib.c						*/
/* Routine read pic structures to disk			*/
/* Ian King 1994 					*/

#include <stdio.h>
#include <ctype.h>
#include "pu_defs.h"


int PU_Read(char *filename, PICDEFN *pic)
{
	FILE *filehandle;
	int ch;

	if ((filehandle = fopen(filename, "r")) == NULL)
	{
		printf("Could not open file %s for reading\n",filename);
		return PU_FAIL;
	}

	while(!feof(filehandle))
	{
		while(isspace(ch = fgetc(filehandle)))
		;

		switch(ch)
		{
			case '#':	/* comment */
					while(fgetc(filehandle)!='\n')
					;
					break;

			case 'T':	fscanf(filehandle,"%d", &pic->pictype);
					break;

			case 'W':	fscanf(filehandle,"%d", &pic->wd_fuse);
					break;

			case 'P':	fscanf(filehandle,"%d", &pic->cp_fuse);
					break;

			case 'C':	fscanf(filehandle,"%d %e", &pic->osctype, &pic->clock);
					break;

			case 'U':	fscanf(filehandle,"%d", &pic->pu_fuse);
					break;

			case 'I':	fscanf(filehandle,"%x %x %x %x", &pic->picid[0],&pic->picid[1],&pic->picid[2],&pic->picid[3]);
					break;

			case EOF:	break;

			default:	printf("Illegal character in %s (%c)\n", filename, ch);
					return PU_FAIL;
		}
	}

	fclose(filehandle);

	return PU_OK;
}

/* ... The End ... */
