;	Definitions for a PIC 16C84
;
;-------------------------------------------
;       FILES ASSIGNMENT
;-------------------------------------------
;
;		Page 0 (0x00 ..)

		indir	equ 0x00		; indirect addressing
		rtcc	equ 0x01		; realtime clock counter
		pcl	equ 0x02		; pc low byte
		status	equ 0x03		; Status
		fsr	equ 0x04		; indirect data memory
		porta	equ 0x05		; I/O Port A
		portb	equ 0x06		; I/O Port B
		eedata	equ 0x08		; eeprom data register
		eeadr	equ 0x09		; eeprom data register
		pclath	equ 0x0a		; pc high bits
		intcon	equ 0x0b		; interrupt control

;		Page 1 (0x80 ..)

		optn	equ 0x01		; option register
		trisa	equ 0x05		; porta data direction
		trisb	equ 0x06		; portb data direction
		eecon1	equ 0x08		; eeprom control 1
		eecon2	equ 0x09		; eeprom control 2
;
;------------------------------------------
;       BIT ASSIGNMENT
;------------------------------------------
;
;		Status Register Bits
;
		c	equ 0		; Carry Flag
		dc	equ 1		; Digit Carry Flag
		z	equ 2		; Zero Flag
		pd	equ 3		; Power Down Flag
		to	equ 4		; Time Out Flag
		rp0	equ 5		; Register Page Select 0
		rp1	equ 6		; Register Page Select 1
		irp	equ 7		; Indirect Page Select

;		Intcon Register Bits
;
		rbif	equ 0		; port4[7:4] change interrupt flag
		intf	equ 1		; int interrupt flag
		rtif	equ 2		; rtcc overflow interrupt flag
		rbie	equ 3		; rbif interrupt enable
		inte	equ 4		; int interrupt enable
		rtie	equ 5		; rtif interrupt enable
		eeie	equ 6		; eeprom interrupt enable
		gie	equ 7		; global interrupt enable

;		Option Register Bits
;
		ps0	equ 0		; )
		ps1	equ 1		; } Prescaler Value
		ps2	equ 2		; )
		psa	equ 3		; Prescaler Assignment
		rte	equ 4		; rtcc signal edge
		rts	equ 5		; rtcc signal source
		intedg	equ 6		; int interrupt edge
		rbpu	equ 7		; Port B pull-up enable

;		Eecon1 Register Bits
;
		rd	equ 0		; read control bit
		wr	equ 1		; write control bit
		wren	equ 2		; eeprom write enable bit
		wrerr	equ 3		; write unsuccessful flag
		eeif	equ 4		; eeprom write complete interrupt flag
;
;		Useful Constants
		W 	equ 0		; for movf etc.
		F	equ 1

;  ... The End ...
