/* main.c */

#include "picasm.h"

int main(int argc, char *argv[])
{
	char inputfilename[40];
	char outputfilename[40];
	char symfilename[40];

	if(argc != 2)
	{
		printf("Useage:\n%s <filename>\n",argv[0]);
		printf("\te.g. %s myprog\ntakes myprog.asm produces myprog.pt and myprog.sym\n",argv[0]);
		printf("Current Version is %.1f\n",VERSION);
		exit(1);
	}

	sprintf(inputfilename,"%s.asm",argv[1]);
	sprintf(outputfilename,"%s.pt",argv[1]);
	sprintf(symfilename,"%s.sym",argv[1]);

	init_code_generator();
	init();
	clearstack();	/* expression stack */

	program(inputfilename);

	save_picfile(outputfilename, argv[0]);
	SaveSymbols(symfilename);

	exit(0);
}

/* ... The End ... */
