;****************************************************************
;**           :
;** Project   : Personal Logic Debugger (PLD)
;** Filename  : MAIN.ASM
;** Author    : Don Lekei
;** Status    : Experimental
;** Date      : 08/27/93
;** Purpose   : GLUE CODE and main foreground loop
;**           :
;****************************************************************
;
	SEG	ROMDATA
;**********************************************************************
;* 
;*  Keyboard Jump Table for normal keys functions
;*  all functions should leave carry clear on successful completion,
;*  or CS if they were terminated with an un-processed key in TEMP3
;*  (C will be clear on entry to the function)
;* 
;**********************************************************************
MAINPARSE:
	movwf	TEMP3		;store key for exit
	addlw	-(MAX_KEY_PARSE+1)  ;limit key
	movfw	TEMP3		;restore key
	skpc			;c set if w >= (MAX_KEY_PARSE+1)
	addwf	PCL		;offset from PC - clears cy.
				;NAME-- VALUE-- LEDGEND 
	goto	NULL_FUNC_CC	;NULL - CS if invalid
..tab:
	goto	F_NUMBER	;K_0:	1	;0
	goto	F_NUMBER 	;K_1:	2	;1
	goto	F_NUMBER 	;K_2:	3	;2
	goto	F_NUMBER 	;K_3:	4	;3
	goto	F_NUMBER 	;K_4:	5	;4
	goto	F_NUMBER 	;K_5:	6	;5
	goto	F_NUMBER 	;K_6:	7	;6
	goto	F_NUMBER 	;K_7:	8	;7
	goto	F_NUMBER 	;K_8:	9	;8
	goto	F_NUMBER 	;K_9:	10	;9
	goto	F_LOGIC		;K_PM	11	;+/-  LOGIC PROBE
	goto	F_DUALVOLT	;K_SQR:	12	;root DUAL VOLTAGE
	goto	F_WAVE		;K_PER:	13	;%    WAVEFORM
	goto	F_SCALEL	;K_DIV:	14	;    LOW SCALE
	goto	NULL_FUNC	;K_MRC:	15	;MRC  (no function)
	goto	F_KTEST		;K_MM:	16	;M-   KEYBOARD TEST
	goto	F_OFF		;K_MP:	17	;M+   STANDBY (OFF)
	goto	F_SCALEH	;K_MUL:	18	;X    HIGH SCALE
	goto	F_MINUS		;K_SUB:	19	;-    Negative Slope
	goto	F_PLUS		;K_ADD:	20	;+    Positive Slope
	goto	F_ONE		;K_EQ:	21	;=    1 pulse
	goto	NULL_FUNC	;K_DP:	22	;.
MAX_KEY_PARSE = * - ..tab

	SEG	CODE 

;**********************************************************************
;* MAIN LOOP
;* 
;* Not in a function, waiting for a key.
;* 
;**********************************************************************

MAIN_START:
	SEB	GO		;kick-start adc just in case
..loop:
	clb	RP0		;JUST IN CASE!
	.if clop_d		;for MPSIM - process interrupts manually
	  bbc	GIE,_noints	;ints don't work on MPSIM
	  bbc	ADIE,_noadints	;not enabled
	  btfsc	ADIF
	  call	_INTVEC		;Simulated A/D interrupt
_noadints:
	  bbc	RTIE,_noints	;not enabled
	  btfsc	RTIF
	  call	_INTVEC		;Simulated A/D interrupt
_noints:
	.endif

	call	GETKEY		;get key press Z if NONE
	skpnz			;skip if there is a key!
	goto	..loop

..loop2:
	call	MAINPARSE	;vector to keystrokes
	btfss	CY		;carry set if there is a leftover key to proc.
	goto	..loop
	movwf	TEMP3		;get unused key
	goto	..loop2		;


;**********************************************************************
;* KEY TEST
;* DISPLAY KEY STROKES ON/CLR to EXIT (ie. doesn't exit)
;* 
;**********************************************************************

F_KTEST:
	DISPLAY	"PRE55   "	;display key press

..loop:
	call	GETKEY		;get key press Z if NONE
	skpnz			;skip if there is a key!
	goto	..loop

	call	SHOW_W_DEC	;display key

	goto ..loop


;**********************************************************************
;* NULL FUNCTION:
;* CLEAR THE DISPLAY
;* 
;**********************************************************************
NULL_FUNC_CC: ;entry in case we need a null with CS on input
NULL_FUNC:
	call	CLS
	clrc
	return


;**********************************************************************
;* LOGIC PROBE
;* 
;* DETECTS HIGH, LOW, OPEN, UN-DRIVEN INPUT, PULSES
;* 
;* 
;* 
;**********************************************************************
VH_WINDOW = 20
VH_OPEN = 55+(VH_WINDOW/2) 
VH_INPUT = 75+(VH_WINDOW/2)

F_LOGIC:
	clrf	VALUE+0		;clear scale for waveform detect
	incf	VALUE+0
	call	CLS
..loop:
	call	GETKEY		;get key press Z if NONE
	seb	C		;set carry for keystroke
	movwf	TEMP3
	skpz			;skip if there is no key
	return			;return to continue processing

	bbs	B.PULSE,_fl_p1	;pulses detected
	btfss	LOGICPAT,7	;see if pattern is h or low
	goto	_fl_p1

	DISPLAY	"L0G1C H1"
	goto	..loop



_fl_p1:
	MOVFW	VSENSEL		;check low value
	SKPZ			;low is 0... maybee open?
	goto	_fl_pulse	;not 0... normal


	MOVFW	VSENSEH		;check high value
	ADDLW 	-VH_INPUT	;low is 0... maybee open?
	skpnc			;cc - h less than max limit
	goto	_fl_pulse	;not 0... normal
	addlw	VH_WINDOW	;check window
	skpnc
	goto	_fl_input	;!! UNDRIVEN INPUT !! 

	MOVFW	VSENSEH		;check high value
	ADDLW 	-VH_OPEN	;low is 0... maybee open?
	skpnc			;cc - h less than max limit
	goto	_fl_input	;was really input
	addlw	VH_WINDOW	;check window
	skpnc
	goto	_fl_open	;!! INPUT IS OPEN !! 

_fl_pulse:
	bbc	B.PULSE,_fl_low ;no pulses detected - low!
	DISPLAY	"   PUL5E"
	goto	..loop

_fl_open:
	DISPLAY	"    0PEN"
	goto	..loop

_fl_input:
	DISPLAY	"   INPUT"
	goto	..loop

_fl_low:
	DISPLAY	"L0G1C L0"
	goto	..loop


;**********************************************************************
;* 
;* DUAL VOLTAGE DISPLAY (two 0-255 readings)
;* 
;**********************************************************************
F_DUALVOLT:
	DISPLAY	"    -   "
..loop:
	call	GETKEY		;get key press Z if NONE
	seb	C		;set carry for keystroke
	movwf	TEMP3
	skpz			;skip if there is no key
	return			;return to continue processing

	BTFSC	B.NEWLOGIC	;bit set every 9.5 ms
	decfsz	TEMP2 		;slow down to about .6 seconds
	goto	..loop


	movlw	DISPLAY+1
	movwf	FSR		;start of number 1
	movfw	VSENSEH		;get high voltage
	CLB	B.ZEROENAB	;trim leading zeros
	call	SHOW_3DEC_FSR	;display high voltage

	movfw	VSENSEL		;get high voltage
	call	SHOW_W_DEC	;display low voltage at end
	goto	..loop


;**********************************************************************
;* 
;* TURN OFF (STANDBY)
;* 
;**********************************************************************

F_OFF:
	clrf    INTCON          ;disable all interrupts
	CLRF    PORTA           ;all ports to 0
	CLRF    PORTB           ;and power off to driver
	clrf    ADCON0          ;shut off A/D converter
	seb	RBPU		;pullups off
	SLEEP			;nitey-night!
	goto	RESVEC		;in case I missed something!


;**********************************************************************
;* 
;* F_ONE - display ONE SHOT pulse
;* 
;**********************************************************************

F_ONE:
	SEB	B.ONETRIG	;flag single trigger
	goto	_WAVE


;**********************************************************************
;* 
;* DISPLAY PIN WAVEFORM
;* 
;* If a number was entered, use it as the scale.
;* 
;**********************************************************************

F_WAVE:
	CLB	B.ONETRIG	;clear single trigger
_WAVE:
	DISPLAY "-rEADY--"

	MOVFW	VALUE+3		;get high bytes
	IORWF	VALUE+2
	IORWF	VALUE+1
	skpz			;skip if val<256
	SEB	B.SEG_E		;flag error (E segment)

	MOVFW	VALUE+3		;get high bytes
	IORWF	VALUE+2
	IORWF	VALUE+1
	IORWF	VALUE+0		;check for 0
	skpnz			;skip if value != 0
	INCF	VALUE+0		;make 0 -> 1

..again:
	CLRF	LOGICPAT	;clear pattern (for rizing edege test)

..loop:
	call	GETKEY		;get key press Z if NONE
	seb	C		;set carry for keystroke
	movwf	TEMP3
	skpz			;skip if there is no key
	return			;return to continue processing

	BTFSS	LOGICPAT,7	;wait for complete pattern
	goto	..loop

	movfw	LOGICPAT	;get pattern
	movwf	TEMP		;hold pattern
	BTFSC	B.SLOPE		;1 = negative slope
	COMF	TEMP		;NEGATIVE SLOPE - bits are inverted
	movlw	8		;count
	movwf	TEMP3           ;
	movlw	DISPLAY
	movwf	FSR		;point to display

..loop2:	
	rlf	TEMP		;get a bit from waveform
	movlw	sg		;segment a for H
	btfss	cy
	movlw	sd		;seg d for low
	movwf	(ind)
	incf	FSR
	decfsz	TEMP3
	goto	..loop2		;do 8 segments
	bbc	B.ONETRIG,..again ;wait for next trig
	clrc
	return			;done!



;**********************************************************************
;*  
;* Set attenuator on/off for logic level correction 
;*                                                  
;**********************************************************************


F_SCALEH:
	clb	B.RA5ON		;attenuator off
	DISPLAY	"H1 5CALE"
	clrc
	return

F_SCALEL:
	seb	B.RA5ON		;attenuator on
	DISPLAY	"L0 5CALE"
	clrc
	return


;**********************************************************************
;* 
;* Set slope for waveform display
;* 
;**********************************************************************

F_MINUS:
	SEB	B.SLOPE		;set negative slope on
	DISPLAY " NEG 5L "	;negative slope
	clrc			;(done)
	return

F_PLUS:
	CLB	B.SLOPE		;set negative slope off
	DISPLAY " P05 5L "	;positive slope
	clrc			;(done)
	return





