/*

   STRTOK.C

   Syntax:    char *strchr( char *string, int c );

   Returns:   a pointer to the first occurrence of <c> in <string1>, or
              NULL if <c> is not found.

      The strchr function returns a pointer to the first occurrence of
      <c> (converted to char) in <string>. The converted character <c>
      may be the null character (\0); the terminating null character of
      <string> is included in the search. The function returns NULL if
      the character is not found.


   Syntax:    size_t strcspn( char *string1, char *string2 );

   Returns:   the position of the first matching character in <string1>.

      The strcspn function returns the index of the first character in
      <string1> belonging to the set of characters specified by
      <string2>. This value is equivalent to the length of the initial
      substring of <string1>, consisting entirely of characters not
      in <string2>. Terminating null characters are not considered in
      the search. If <string1> begins with a character from <string2>,
      strcspn returns 0.


   Syntax:    size_t strspn( char *string1, char *string2 );

   Returns:   an integer value specifying the length of the segment in
              <string1> consisting entirely of characters in <string2>.

      The strspn function returns the index of the first character in
      <string1> not belonging to the set of characters specified by
      <string2>. This value is equivalent to the length of the initial
      substring of <string1>, consisting entirely of characters from
      <string2>. The null character (\0) terminating <string2> is not
      considered in the matching process. If <string1> begins with a
      character not in <string2>, strspn returns 0.


   Syntax:    char *strtok( char *string1, char *string2 );

   Returns:   a pointer to a token in <string1>.

      The strtok function reads <string1> as a series of zero or more
      tokens and <string2> as the set of characters serving as
      delimiters of the tokens in <string1>. The tokens in <string1> can
      be separated by one or more of the delimiters from <string2>.

      The tokens are broken out of <string1> by a series of calls to
      strtok. In the first call to strtok for <string1>, strtok searches
      for the first token in <string1>, skipping leading delimiters. A
      pointer to the first token is returned.

      To read the next token from <string1>, call strtok with a NULL
      value for the <string1> argument. The NULL <string1> argument
      causes strtok to search for the next token in the previous token
      string. The set of delimiters may vary from call to call, so
      <string2> can take any value.

      Calls to strtok do not modify <string1>. strtok copies the token
      to a temporary memory block and returns a pointer to that block.

      Return Value

      The first time strtok is called, it returns a pointer to the first
      token in <string1>. In later calls with the same token string,
      strtok returns a pointer to the next token in the string. A NULL
      pointer is returned when there are no more tokens. All tokens are
      null-terminated.
*/

#include "common.h"

char *strchr( char *string, int c )
{
   while( *string != '\0' )
   {
      if ( *string == (char)c )
         return string;
      string++;
   }
   return NULL;
}

size_t strcspn( char *string1, char *string2 )
{
   size_t i = 0;
   while( *string1 != '\0' )
   {
      if ( strchr( string2, (int)*string1 ) != NULL )
         break;
      i++;
      string1++;
   }
   return i;
}

size_t strspn( char *string1, char *string2 )
{
   size_t i = 0;
   while( *string1 != '\0' )
   {
      if ( strchr( string2, (int)*string1 ) == NULL )
         break;
      i++;
      string1++;
   }
   return i;
}

static char *next_str;
static char temp_str[32];


char *strtok( char *string1, char *string2 )
{
   char *s;
   size_t len;
   if ( string1 != NULL )
      next_str = string1;

   next_str += strspn( next_str, string2 );
   s = next_str;
   if ( *s != '\0' )
   {
      len = strcspn( next_str, string2 );
      next_str += len;
      memcpy(temp_str, s, len);
      temp_str[len] = '\0';
      return temp_str;
   }
   return NULL;
}

/*
void main(void)
{
   char *s = ".eins,.zwei,.drei.";
   puts(strtok( s, ".," ));
   puts(strtok( NULL, ".," ));
   puts(strtok( NULL, ".," ));
   printf("%p\n", strtok( NULL, ".," ));
}
*/
