/*

   STRCPY.C

*/

#include <common.h>

char *strcpy( char *dest, const char *src )
{
   char *s = dest;
   while( *src != '\0' )
      *s++ = *src++;
   return dest;
}

void *memcpy( void *dest, const void *src, size_t count )
{
   void *ptr = dest;
   while( count > 0 )
   {
      *((char *)ptr)++ = *((char *)src)++;
      count--;
   }
   return dest;
}
