/*

   ITOS.C

   Convert value to string (base 10).

   Format:
      Bit 7:  0: '0'   1: ' '
      Bit 0-6: Length

   This function is reentrant.

*/


char *itos( int value, char *string, int format )
{
   char s[8];
   int i = 0;
   int len = format & 7;
   int j = 0;
   char fill = (char)((format & 128) == 0 ? '0' : ' ');

   if ( value == 0 )
      s[i++] = '0';
   else
      while( value != 0 )
      {
         s[i++] = (char)((value % 10)+'0');
         value /= 10;
      }
   while( i < len-- )
      string[j++] = fill;
   while( i > 0 )
      string[j++] = s[--i];
   string[j] = '\0';
   return string;
}


/*
void main(void)
{
   char s[10];
   puts(itos( 123, s, 5|128 ));
}
*/
