/*

   ITOA.C

   This function is reentrant.

*/


char itoc( int value )
{
   if ( value < 10 )
      return (char)(value+'0');
   else
      return (char)(value-10+'A');
}

char *itoa( int value, char *string, int radix )
{
   char s[18];
   int i = 0;
   int j;
   if ( value == 0 )
      s[i++] = '0';
   else
      while( value != 0 )
      {
         s[i++] = itoc(value % radix);
         value /= radix;
      }
   j = 0;
   while( i > 0 )
      string[j++] = s[--i];
   string[j] = '\0';
   return string;
}


/*
void main(void)
{
   char s[10];
   puts(itoa( 1234, s, 10 ));
}
*/
