;-----------------------------------------
; CRT0BASE.S 
; Basic definitions for the compiled code.
; Registers are located at the end of the
; first page (=256 Bytes) of the M68HC11
;-----------------------------------------
	.module crt0base.s
	.area   DIRECT (ABS,PAG)
	.org  0
;
; Null-Ptr Destination (hope, that nobody writes more than 2 bytes here)
;
_os_null_ptr::
	.blkb 2
; 
; Pseudo regs
;
ZD0:: .blkb 2
ZD1:: .blkb 2
ZD2:: .blkb 2
ZD3:: .blkb 2
ZD4:: .blkb 2
ZD5:: .blkb 2
ZD6:: .blkb 2
ZD7:: .blkb 2
ZD8:: .blkb 2
ZB0:: .blkb 1
ZB1:: .blkb 1
ZB2:: .blkb 1
ZB3:: .blkb 1
ZB4:: .blkb 1
;
; scratch area
;
ZXT:: .blkb 2
_os_direct_end::

;-----------------------------------------
; required gcclib code
;-----------------------------------------
;
; signed divide: assumes numerator on stack and denominator on stack + 2
; returns quotient in D
;
	.area _CODE

___divhi3::
	tsx
	ldd   4,x
	bge   $1
	ldd   #0
	subd  4,x
$1:
	std   *ZXT
	ldd   2,x
	bge   $2
	ldd   #0
	subd  2,x
$2:
	xgdx
	ldd   *ZXT
	idiv
	stx   *ZXT
	tsx
	ldd   4,x
	clrb
	eora  2,x
	anda  #0x80
	beq   $3
	ldd   #0
	subd  *ZXT
	bra   $4
$3:
	ldd   *ZXT
$4:
	rts

;
; signed modulo divide: assumes numerator on stack and denominator on stack + 2
; returns remainder in D
;
___modhi3::
	tsx
	ldd   4,x
	bge   $5
	ldd   #0
	subd  4,x
$5:
	std   *ZXT
	ldd   2,x
	bge   $6
	ldd   #0
	subd  2,x
$6:
	xgdx
	ldd   *ZXT
	idiv
	std   *ZXT
	tsx
	ldd   4,x
	clrb
	eora  2,x
	anda  #0x80
	beq   $7
	ldd   #0
	subd  *ZXT
	bra   $8
$7:
	ldd   *ZXT
$8:
	rts

;
; signed multiply: assumes e1 in D and e2 on stack
; returns result (e1 * e2) in D
;
___mulhi3::
	pulx
	pshx
	pshx
	xgdx
	pshx
	tsx
	ldab  1,x
	ldaa  7,x
	mul
	std   *ZXT
	ldab  0,x 
	ldaa  7,x
	mul
	tba
	clrb
	addd  *ZXT
	std   *ZXT
	ldab  1,x
	ldaa  6,x
	mul
	tba
	clrb
	addd  *ZXT
	pulx
	pulx
	rts

;
; See aux-output.c module for more details on these routines
;
; __pushregs::
;  rts
;
; __pullregs::
;  rts

;
;  end crt0.s
;
