/*
   DMD.H
   Functions for Dot Matrix Displays

   68HC11 project

   by Oliver Kraus
*/

#ifndef _DMD_H
#define _DMD_H

#include <common.h>

void dmd_Init(byte *base);
short dmd_WaitBusy(void);
short dmd_Command(byte cmd);
short dmd_Data(byte data);
short dmd_ShowString(char *s);
short dmd_GotoXY(byte x, byte y);

#define dmd_Home()      (dmd_Command(0x02))
#define dmd_Clear()     (dmd_Command(0x01))
#define dmd_CursorOff() (dmd_Command(0x0c))
#define dmd_DCursorOn() (dmd_Command(0x0e))
#define dmd_BCursorOn() (dmd_Command(0x0f))

#endif
