#include <stdio.h>
#include <sys/time.h>
#include <signal.h>

extern int errno;
extern long getpid();
extern long doparent();

catchit()
{
}

setalarm(ticks,mticks)
{
	struct itimerval mytime;
	struct itimerval dummytime;

	mytime.it_value.tv_sec = (long) ticks;
	mytime.it_value.tv_usec = (long) mticks*1000;

	mytime.it_interval.tv_sec = (long) 0;
	mytime.it_interval.tv_usec = (long) 0;

	signal(SIGALRM,catchit);
	if (setitimer(ITIMER_REAL,&mytime,&dummytime) != 0)
	{
		fprintf(stderr,"panic -- setitimer failed errno = %d\n",errno);
	}
	sigpause(0);
	
}

int gotint = 0;
int gotchld = 0;
catchint()
{
	gotint = 1;
}
catchchld()
{
	gotchld = 1;
}
clean()
{
	system("stty echo");
	system("stty -raw");
}
main(argc,argv)
int argc;
char **argv;
{
	char tmp,junk;
	int infile;
	int in_num;
	long parent;

	switch (argc)
	{
	case 2:
		if (!(parent = doparent()))
		{
			exit(0);
		}
		break;
		
	default:
		printf("bad option count %d\n",argc);
		exit(1);
	}

	if ((infile = open(argv[1],0)) == -1)
	{
		printf("%s -- can't open file named :%s:\n",argv[0],argv[1]);
		exit(1);
	}
	system("stty -echo");
	system("stty raw");
	signal(SIGHUP,clean);
	write(1,"GO\n\r",4);
	sleep(3);
	while (read(infile,&tmp,1) != 0)
	{
		if (tmp == '\n')
		{
			write(1,"\r",1);
			setalarm(0,200);
			kill((int)parent,SIGINT);
		}
		else
		{
			write(1,&tmp,1);
			setalarm(0,35);
		}
	}
	sleep(5);
	clean();
}

long
doparent()
{
	long child;
	long par;
	par = getpid();
	if (!(child = fork()))
	{
		return(par);
	}
	/*
	**	we are the parent
	*/
	signal(SIGINT,catchint);
	signal(SIGCHLD,catchchld);
	sleep(5);
	while (1)
	{
		gotint = 0;
		sleep(2);
		if(!gotint)
		{
			if (gotchld)
				break;
			kill((int)child,SIGALRM);
		}
	}
	child = wait(0);
	return(0);
}
