This is Info file libc.i, produced by Makeinfo-1.50 from the input file
./libc.texinfo.

START-INFO-DIR-ENTRY
* libc: (libc).			The ANSI C library.
END-INFO-DIR-ENTRY

   This file documents the ANSI C library.

   Copyright (C) 1992 Cygnus Support

   `libc' includes software developed by the University of California,
Berkeley and its contributors.

   libc includes software developed by Martin Jackson, Graham Haley and
Steve Chamberlain of Tadpole Technology and released to Cygnus.

   libc uses floating point converstion software developed at AT&T,
which includes this copyright information:

   /****************************************************************  *
 * The author of this software is David M. Gay.  *  * Copyright (c)
1991 by AT&T.  *  * Permission to use, copy, modify, and distribute
this software for any  * purpose without fee is hereby granted,
provided that this entire notice  * is included in all copies of any
software which is or includes a copy  * or modification of this
software and in all copies of the supporting  * documentation for such
software.  *  * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY
EXPRESS OR IMPLIED  * WARRANTY.  IN PARTICULAR, NEITHER THE AUTHOR NOR
AT&T MAKES ANY  * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
MERCHANTABILITY  * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR
PURPOSE.  * 
***************************************************************/

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, subject to the
terms of the GNU General Public License, which includes the provision
that the entire resulting derived work is distributed under the terms
of a permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions.


File: libc.i,  Node: Top,  Prev: (dir),  Up: (dir)

* Menu:

* stdlib::
* ctype::
* stdio::
* strings::
* signals::
* timefns::
* locale::
* syscalls::
* machine::
* arglists::
* reentrancy::
* index::


File: libc.i,  Node: signals,  Up: top

Signal Handling (`signal.h')
****************************

   A "signal" is an event that interrupts the normal flow of control in
your program.  Your operating environment normally defines the full set
of signals available (see `sys/signal.h'), as well as the default means
of dealing with them--typically, either printing an error message and
aborting your program, or ignoring the signal.

   All systems support at least the following signals:
`SIGABRT'
     Abnormal termination of a program; raised by the <<abort>>
     function.

`SIGFPE'
     A domain error in arithmetic, such as overflow, or division by
     zero.

`SIGILL'
     Attempt to execute as a function data that is not executable.

`SIGINT'
     Interrupt; an interactive attention signal.

`SIGSEGV'
     An attempt to access a memory location that is not available.

`SIGTERM'
     A request that your program end execution.

   Two functions are available for dealing with asynchronous
signals--one to allow your program to send signals to itself (this is
called "raising" a signal), and one to specify subroutines (called
"handlers" to handle particular signals that you anticipate may
occur--whether raised by your own program or the operating environment.

   To support these functions, `signal.h' defines three macros:

`SIG_DFL'
     Used with the `signal' function in place of a pointer to a handler
     subroutine, to select the operating environment's default handling
     of a signal.

`SIG_IGN'
     Used with the `signal' function in place of a pointer to a
     handler, to ignore a particular signal.

`SIG_ERR'
     Returned by the `signal' function in place of a pointer to a
     handler, to indicate that your request to set up a handler could
     not be honored for some reason.

   `signal.h' also defines an integral type, `sig_atomic_t'. This type
is not used in any function declarations; it exists only to allow your
signal handlers to declare a static storage location where they may
store a signal value.  (Static storage is not otherwise reliable from
signal handlers.)

* Menu:

* raise::
* signal::


File: libc.i,  Node: raise,  Up: signals

`raise'--send a signal
======================

   *Synopsis*
     #include <signal.h>
     int raise(int SIG);
   *Description*
Send the signal SIG (one of the macros from ``sys/signal.h''). This
interrupts your program's normal flow of execution, and allows a signal
handler (if you've defined one, using `signal') to take control.

*Returns*
The result is `0' if SIG was successfully raised, `1' otherwise. 
However, the return value (since it depends on the normal flow of
execution) may not be visible, unless the signal handler for SIG
terminates with a `return' or unless `SIG_IGN' is in effect for this
signal.

*Portability*
ANSI C requires `raise', but allows the full set of signal numbers to
vary from one implementation to another.


File: libc.i,  Node: signal,  Up: signals

`signal'--specify handler subroutine for a signal
=================================================

*Synopsis*
     #include <signal.h>
     void ( * signal(int SIG, void(*FUNC)(int)) )(int);
   *Description*
`signal' allows you to request changed treatment for a particular
signal SIG.  You can use one of the predefined macros `SIG_DFL' (select
system default handling) or `SIG_IGN' (ignore this signal) as the value
of FUNC; otherwise, FUNC is a function pointer that identifies a
subroutine in your program as the handler for this signal.

   Some of the execution environment for signal handlers is
unpredictable; notably, the only library function required to work
correctly from within a signal handler is `signal' itself, and only
when used to redefine the handler for the current signal value.

   Static storage is likewise unreliable for signal handlers, with one
exception: if you declare a static storage location as ``volatile
sig_atomic_t'', then you may use that location in a signal handler to
store signal values.

   If your signal handler terminates using `return' (or implicit
return), your program's execution continues at the point where it was
when the signal was raised (whether by your program itself, or by an
external event).  Signal handlers can also use functions such as `exit'
and `abort' to avoid returning.

*Returns*
If your request for a signal handler cannot be honored, the result is
`SIG_ERR'; a specific error number is also recorded in `errno'.

   Otherwise, the result is the previous handler (a function pointer or
one of the predefined macros).

*Portability*
ANSI C requires `signal'.


File: libc.i,  Node: strings,  Up: top

Managing Strings and Memory (`string.h')
****************************************

This chapter describes string-handling functions and functions for
managing areas of memory.  The corresponding declarations are in
`string.h'.

* Menu:

* bcmp::
* bcopy::
* bzero::
* index function::
* memchr::
* memcmp::
* memcpy::
* memmove::
* memset::
* rindex::
* strcat::
* strchr::
* strcmp::
* strcoll::
* strcpy::
* strcspn::
* strerror::
* strlen::
* strncat::
* strncmp::
* strncpy::
* strpbrk::
* strrchr::
* strspn::
* strstr::
* strtok::
* strxfrm::


File: libc.i,  Node: bcmp,  Up: strings

`bcmp'--compare two memory areas
================================

   *Synopsis*
     #include <string.h>
     int bcmp(const char *S1, const char *S2, size_t N);
   *Description*
This function compares not more than N characters of the object pointed
to by S1 with the object pointed to by S2.

   This function is identical to `memcmp'.
*Returns*
The function returns an integer greater than, equal to or less than
zero 	according to whether the object pointed to by S1 is greater than,
equal to or less than the object pointed to by S2.


File: libc.i,  Node: bcopy,  Up: strings

`bcopy'--copy memory regions
============================

*Synopsis*
     #include <string.h>
     void bcopy(const char *IN, char  *OUT, size_t N);
   *Description*
This function copies N bytes from the memory region pointed to by IN to
the memory region pointed to by OUT.

   If the regions overlap, the behavior is undefined.

   This function is implemented in term of `memcpy'.


File: libc.i,  Node: bzero,  Up: strings

`bzero'--initialize memory to zero
==================================

*Synopsis*
     #include <string.h>
     void bzero(char *B, size_t LENGTH);
   *Description*
`bzero' initializes LENGTH bytes of memory, starting at address B, to
zero.

*Returns*
`bzero' does not return a result.

*Portability*
`bzero' is in the Berkeley Software Distribution. Neither ANSI C nor
the System V Interface Definition (Issue 2) require `bzero'.


File: libc.i,  Node: index function,  Up: strings

`index'--search for character in string
=======================================

*Synopsis*
     #include <string.h>
     char * index(const char *STRING, int C);
   *Description*
This function finds the first occurence of C (converted to a char) in
the string pointed to by STRING (including the terminating null
character).

   This function is identical to `strchr'.

*Returns*
Returns a pointer to the located character, or a null pointer if C does
not occur in STRING.


File: libc.i,  Node: memchr,  Up: strings

`memchr'--find character in memory
==================================

*Synopsis*
     #include <string.h>
     void *memchr(const void *SRC, int C, size_t LENGTH);
   *Description*
This function searches memory starting at `*SRC' for the character C. 
The search only ends with the first occurrence of C, or after LENGTH
characters; in particular, `NULL' does not terminate the search.

*Returns*
If the character C is found within LENGTH characters of `*SRC', a
pointer to the character is returned. If C is not found, then `NULL' is
returned.


File: libc.i,  Node: memcmp,  Up: strings

`memcmp'--compare two memory areas
==================================

*Synopsis*
     #include <string.h>
     int memcmp(const void *S1, const void *S2, size_t N);
   *Description*
This function compares not more than N characters of the object pointed
to by S1 with the object pointed to by S2.

*Returns*
The function returns an integer greater than, equal to or less than
zero 	according to whether the object pointed to by S1 is greater than,
equal to or less than the object pointed to by S2.


File: libc.i,  Node: memcpy,  Up: strings

`memcpy'--copy memory regions
=============================

*Synopsis*
     #include <string.h>
     void* memcpy(void *OUT, const void *IN, size_t N);
   *Description*
This function copies N bytes from the memory region pointed to by IN to
the memory region pointed to by OUT.

   If the regions overlap, the behavior is undefined.

*Returns*
`memcpy' returns a pointer to the first byte of the OUT region.


File: libc.i,  Node: memmove,  Up: strings

`memmove'--move possibly overlapping memory
===========================================

*Synopsis*
     #include <string.h>
     void *memmove(void *DST, const void *SRC, size_t LENGTH);
   *Description*
This function moves LENGTH characters from the block of memory starting
at `*SRC' to the memory starting at `*DST'. `memmove' reproduces the
characters correctly at `*DST' even if the two areas overlap.

*Returns*
The function returns DST as passed.


File: libc.i,  Node: memset,  Up: strings

`memset'--set an area of memory
===============================

*Synopsis*
     #include <string.h>
     void *memset(const void *DST, int C, size_t LENGTH);
   *Description*
This function converts the argument C into an unsigned char and fills
the first LENGTH characters of the array pointed to by DST to the value.

*Returns*
`memset' returns the value of M.


File: libc.i,  Node: rindex,  Up: strings

`rindex'--reverse search for character in string
================================================

*Synopsis*
     #include <string.h>
     char * rindex(const char *STRING, int C);
   *Description*
This function finds the last occurence of C (converted to a char) in
the string pointed to by STRING (including the terminating null
character).

   This function is identical to `strrchr'.

*Returns*
Returns a pointer to the located character, or a null pointer if C does
not occur in STRING.


File: libc.i,  Node: strcat,  Up: strings

`strcat'--concatenate strings
=============================

*Synopsis*
     #include <string.h>
     char *strcat(char *DST, const char *SRC);
   *Description*
`strcat' Appends a copy of the string pointed to by SRC (including the
terminating null character) to the end of the string pointed to by DST.
 The initial character of SRC overwrites the null character at the end
of DST.

*Returns*
This function returns the initial value of DST


File: libc.i,  Node: strchr,  Up: strings

`strchr'--search for character in string
========================================

*Synopsis*
     #include <string.h>
     char * strchr(const char *STRING, int C);
   *Description*
This function finds the first occurence of C (converted to a char) in
the string pointed to by STRING (including the terminating null
character).

*Returns*
Returns a pointer to the located character, or a null pointer if C does
not occur in STRING.


File: libc.i,  Node: strcmp,  Up: strings

`strcmp'--character string compare
==================================

*Synopsis*
     #include <string.h>
     int strcmp(const char *STRA, const char * STRB);
   *Description*
The `strcmp' compares the string pointed to by STRA to the string
pointed to by STRB.

*Returns*
If the first string is greater than the second string, `strcmp' returns
a number greater than zero.  If the two strings are equivalent,
`strcmp' returns zero.  If the first string is less than the second
string, `strcmp' returns a number less than zero.


File: libc.i,  Node: strcoll,  Up: strings

`strcoll'--locale specific character string compare
===================================================

*Synopsis*
     #include <string.h>
     int strcoll(const char *STRA, const char * STRB);
   *Description*
The `strcmp' compares the string pointed to by STRA to the string
pointed to by STRB, using an interpretation appropriate to the current
`LC_COLLATE' state.

*Returns*
If the first string is greater than the second string, `strcmp' returns
a number greater than zero.  If the two strings are equivalent,
`strcmp' returns zero.  If the first string is less than the second
string, `strcmp' returns a number less than zero.


File: libc.i,  Node: strcpy,  Up: strings

`strcpy'--copy string
=====================

*Synopsis*
     #include <string.h>
     char *strcpy(char *DST, const char *SRC);
   *Description*
`strcpy' copies the string pointed to by SRC (including the terminating
null character) to the array pointed to by DST.

*Returns*
This function returns the initial value of DST


File: libc.i,  Node: strcspn,  Up: strings

`strcspn'--count chars not in string
====================================

*Synopsis*
     size_t strcspn(const char *S1, const char *S2);
   *Description*
This function computes the length of the initial part of the string
pointed to by S1 which consists entirely of characters NOT from the
string pointed to by S2 (excluding the terminating null character).

*Returns*
`strcspn' returns the length of the substring found.


File: libc.i,  Node: strerror,  Up: strings

`strerror'--convert error number to string
==========================================

*Synopsis*
     #include <string.h>
     char *strerror(int ERRNUM);
   *Description*
`strerror' converts the error number ERRNUM into a string.  The value
of ERRNUM is usually a copy of `errno'. If `errnum' is not a known
error number, the result points to an empty string.

   This implementation of `strerror' prints out the following strings
for each of the values defined in ``errno.h'':

`E2BIG'
     `Arg list too long'

`EACCES'
     `Permission denied'

`EADV'
     `Advertise error'

`EAGAIN'
     `No more processes'

`EBADF'
     `Bad file number'

`EBADMSG'
     `Bad message'

`EBUSY'
     `Device or resource busy'

`ECHILD'
     `No children'

`ECOMM'
     `Communication error'

`EDEADLK'
     `Deadlock'

`EEXIST'
     `File exists'

`EDOM'
     `Math argument'

`EFAULT'
     `Bad address'

`EFBIG'
     `File too large'

`EIDRM'
     `Identifier removed'

`EINTR'
     `Interrupted system call'

`EINVAL'
     `Invalid argument'

`EIO'
     `I/O error'

`EISDIR'
     `Is a directory'

`ELIBACC'
     `Cannot access a needed shared library'

`ELIBBAD'
     `Accessing a corrupted shared library'

`ELIBEXEC'
     `Cannot exec a shared library directly'

`ELIBMAX'
     `Attempting to link in more shared libraries than system limit'

`ELIBSCN'
     `.lib section in a.out corrupted'

`EMFILE'
     `Too many open files'

`EMLINK'
     `Too many links'

`EMULTIHOP'
     `Multihop attempted'

`ENFILE'
     `File table overflow'

`ENODEV'
     `No such device'

`ENOENT'
     `No such file or directory'

`ENOEXEC'
     `Exec format error'

`ENOLCK'
     `No lock'

`ENOLINK'
     `Virtual circuit is gone'

`ENOMEM'
     `Not enough space'

`ENOMSG'
     `No message of desired type'

`ENONET'
     `Machine is not on the network'

`ENOPKG'
     `No package'

`ENOSPC'
     `No space left on device'

`ENOSR'
     `No stream resources'

`ENOSTR'
     `Not a stream'

`ENOTBLK'
     `Block device required'

`ENOTDIR'
     `Not a directory'

`ENOTTY'
     `Not a character device'

`ENXIO'
     `No such device or address'

`EPERM'
     `Not owner'

`EPIPE'
     `Broken pipe'

`EPROTO'
     `Protocol error'

`ERANGE'
     `Result too large'

`EREMOTE'
     `Resource is remote'

`EROFS'
     `Read-only file system'

`ESPIPE'
     `Illegal seek'

`ESRCH'
     `No such process'

`ESRMNT'
     `Srmount error'

`ETIME'
     `Stream ioctl timeout'

`ETXTBSY'
     `Text file busy'

`EXDEV'
     `Cross-device link'

*Returns*
This function returns a pointer to a string.  Your application must not
modify that string.

*Portability*
ANSI C requires `strerror', but does not specify the strings used for
each error number.

   Although this implementation of `strerror' is reentrant, ANSI C
declares that subsequent calls to `strerror' may overwrite the result
string.


File: libc.i,  Node: strlen,  Up: strings

`strlen'--character string length
=================================

*Synopsis*
     #include <string.h>
     size_t strlen(const char *STR);
   *Description*
The `strlen' function works out the length of the string starting at
`*STR' by counting chararacters until it reaches a `NULL' character.

*Returns*
`strlen' returns the character count.


File: libc.i,  Node: strncat,  Up: strings

`strncat'--concatenate strings
==============================

*Synopsis*
     #include <string.h>
     char *strncat(char *DST, const char *SRC, size_t LENGTH);
   *Description*
`strcat' appends not more than LENGTH characters from the string
pointed to by SRC (including the	terminating null character) to the end
of the string pointed to by DST.  The initial character of SRC
overwrites the null character at the end of DST.  A terminating null
character is always appended to the result

*Warnings*
Note that a null is always appended, so that if the copy is limited by
the LENGTH argument, the number of characters appended to DST is `n +
1'.
*Returns*
This function returns the initial value of DST


File: libc.i,  Node: strncmp,  Up: strings

`strncmp'--character string compare
===================================

*Synopsis*
     #include <string.h>
     int strncmp(const char *STRA, const char * STRB, size_t LENGTH);
   *Description*
The `strncmp' compares not more than LENGTH characters from the string
pointed to by STRA to the string pointed to by STRB.

*Returns*
If the first string is greater than the second string, `strcmp' returns
a number greater than zero.  If the two strings are equivalent,
`strcmp' returns zero.  If the first string is less than the second
string, `strcmp' returns a number less than zero.


File: libc.i,  Node: strncpy,  Up: strings

`strncpy'--counted copy string
==============================

*Synopsis*
     #include <string.h>
     char *strncpy(char *DST, const char *SRC, size_t LENGTH);
   *Description*
`strcpy' copies not more than LENGTH characters from the the string
pointed to by SRC] (including the terminating null character) to the
array pointed to by DST.  If the string pointed to by SRC is shorter
than LENGTH characters, null characters are appended to the destination
array until a total of LENGTH characters have been written.

*Returns*
This function returns the initial value of DST


File: libc.i,  Node: strpbrk,  Up: strings

`strpbrk'--find chars in string
===============================

*Synopsis*
     #include <string.h>
     char *strpbrk(const char *S1, const char *S2);
   *Description*
This function locates the first occurence in the string pointed to by
S1 of any character in string pointed to by S2 (excluding the
terminating null character).

*Returns*
`strpbrk' returns a pointer to the character found in S1, or a null
pointer if no character from S2 occurs in S1.


File: libc.i,  Node: strrchr,  Up: strings

`strrchr'--reverse search for character in string
=================================================

*Synopsis*
     #include <string.h>
     char * strrchr(const char *STRING, int C);
   *Description*
This function finds the last occurence of C (converted to a char) in
the string pointed to by STRING (including the terminating null
character).

*Returns*
Returns a pointer to the located character, or a null pointer if C does
not occur in STRING.


File: libc.i,  Node: strspn,  Up: strings

`strspn'--find initial match
============================

*Synopsis*
     #include <string.h>
     size_t strspn(const char *S1, const char *S2);
   *Description*
This function computes the length of the initial segment of the string
pointed to by S1 which consists entirely of characters from the string
pointed to by S2 (excluding the terminating null character).

*Returns*
`strspn' returns the length of the segment found.


File: libc.i,  Node: strstr,  Up: strings

`strstr'--find string segment
=============================

*Synopsis*
     #include <string.h>
     char *strstr(const char *S1, const char *S2);
   *Description*
Locates the first occurence in the string pointed to by S1 of the
sequence of characters in the string pointed to by S2 (excluding the
terminating null  character).

*Returns*
Returns a pointer to the located string segment, or a null pointer if
the string S2 is not found. If S2 points to a string with zero length,
the S1 is returned.


File: libc.i,  Node: strtok,  Up: strings

`strtok'--get next token from a string
======================================

*Synopsis*
     #include <string.h>
     char *strtok(char *SOURCE, const char *DELIMITERS)
   *Description*
A series of calls to `strtok' break the string starting at `*SOURCE'
into a sequence of tokens.  The tokens are delimited from one another
by characters from the string at `*DELIMITERS', at the outset.

   The first call to `strtok' normally has a string address as the
first argument; subsequent calls can use `NULL' as the first argument,
to continue searching the same string.  You can continue searching a
single string with different delimiters by using a different delimiter
string on each call.

   `strtok' begins by searching for any character not in the DELIMITERS
string: the first such character is the beginning of a token (and its
address will be the result of the `strtok' call). `strtok' then
continues searching until it finds another delimiter character; it
replaces that character by `NULL' and returns.  (If `strtok' comes to
the end of the `*SOURCE' string without finding any more delimiters,
the entire remainder of the string is treated as the next token).

   `strtok' begins its search at `*SOURCE', unless you pass `NULL' as
the first argument;  if SOURCE is `NULL', `strtok' continues searching
from the end of the last search. Exploiting the `NULL' first argument
leads to non-reentrant code. You can easily circumvent this problem by
saving the last delimiter address in your application, and always using
it to pass a non-null SOURCE argument.

*Returns*
`strtok' returns a pointer to the next token, or `NULL' if no more
tokens can be found.

*Warnings*
`strtok' is non-reentrant by definition; an internal static variable
saves the end of the last token. The ANSI standard allows the
implementation to assume that no library function calls `strtok'.


File: libc.i,  Node: strxfrm,  Up: strings

`strxfrm'--transform string
===========================

*Synopsis*
     #include <string.h>
     size_t strxfrm(char *S1, const char *S2, size_t N);
   *Description*
This function transforms the string pointed to by S2 and places the
resulting string into the array pointed to by S1. The transformation is
such that if the `strcmp' function is applied to the two transformed
strings, it returns a value greater than, equal to, or less than zero,
correspoinding to the result of a `strcoll' function applied to the
same two original strings.

   No more than N characters are placed into the resulting array
pointed to by S1, including the terminating null character. If N is
zero, S1 may be a null pointer. If copying takes place between objects
that overlap, the behavior is undefined.

   With a C locale, this function just copies.

*Returns*
The `strxfrm' function returns the length of the transformed string
(not including the terminating null character). If the value returned
is N or more, the contents of the array pointed to by S1 are
indeterminate.


File: libc.i,  Node: ctype,  Up: top

Character Type Macros and Functions (`ctype.h')
***********************************************

This chapter groups macros (which are also available as subroutines) to
classify characters into several categories (alphabetic, numeric,
control characters, whitespace, and so on), or to perform simple
character mappings.

   The header file `ctype.h' defines the macros.

* Menu:

* isalnum::
* isalpha::
* isascii::
* iscntrl::
* isdigit::
* islower::
* isprint::
* ispunct::
* isspace::
* isupper::
* isxdigit::
* toascii::
* tolower::
* toupper::


File: libc.i,  Node: isalnum,  Up: ctype

`isalnum'--alphanumeric character predicate
===========================================

   *Synopsis*
     #include <ctype.h>
     int isalnum(int C);
   *Description*
`isalnum' is a macro which classifies ASCII integer values by table
lookup.  It is a predicate returning non-zero for alphabetic or numeric
ASCII characters, and `0' for other arguments.  It is defined for all
integer values.

   You can use a compiled subroutine instead of the macro definition by
undefining the macro using ``#undef isalnum''.

*Returns*
`isalnum' returns non-zero if C is a letter (`a'--`z' or `A'--`Z') or a
digit (`0'--`9').

*Portability*
`isalnum' is ANSI C.


File: libc.i,  Node: isalpha,  Up: ctype

`isalpha'--alphabetic character predicate
=========================================

*Synopsis*
     #include <ctype.h>
     int isalpha(int C);
   *Description*
`isalpha' is a macro which classifies ASCII integer values by table
lookup.  It is a predicate returning non-zero when C represents an
alphabetic ASCII character, and 0 otherwise.  It is defined only when
`isascii'(C) is true or C is EOF.

   You can use a compiled subroutine instead of the macro definition by
undefining the macro using ``#undef isalpha''.

*Returns*
`isalpha' returns non-zero if C is a letter (`A'--`Z' or `a'--`z').

*Portability*
`isalpha' is ANSI C.


File: libc.i,  Node: isascii,  Up: ctype

`isascii'--ASCII character predicate
====================================

*Synopsis*
     #include <ctype.h>
     int isascii(int C);
   *Description*
`isascii' is a macro which returns non-zero when C is an ASCII
character, and 0 otherwise.  It is defined for all integer values.

   You can use a compiled subroutine instead of the macro definition by
undefining the macro using ``#undef isascii''.

*Returns*
`isascii' returns non-zero if the low order byte of C is in the range 0
to 127 (`0x00'--`0x7F').

*Portability*
`isascii' is ANSI C.


File: libc.i,  Node: iscntrl,  Up: ctype

`iscntrl'--control character predicate
======================================

*Synopsis*
     #include <ctype.h>
     int iscntrl(int C);
   *Description*
`iscntrl' is a macro which classifies ASCII integer values by table
lookup.  It is a predicate returning non-zero for control characters,
and 0 for other characters.  It is defined only when `isascii'(C) is
true or C is EOF.

   You can use a compiled subroutine instead of the macro definition by
undefining the macro using ``#undef iscntrl''.

*Returns*
`iscntrl' returns non-zero if C is a delete character or ordinary
control character (`0x7F' or `0x00'--`0x1F').

*Portability*
`iscntrl' is ANSI C.


File: libc.i,  Node: isdigit,  Up: ctype

`isdigit'--decimal digit predicate
==================================

*Synopsis*
     #include <ctype.h>
     int isdigit(int C);
   *Description*
`isdigit' is a macro which classifies ASCII integer values by table
lookup.  It is a predicate returning non-zero for decimal digits, and 0
for other characters.  It is defined only when `isascii'(C) is true or
C is EOF.

   You can use a compiled subroutine instead of the macro definition by
undefining the macro using ``#undef isdigit''.

*Returns*
`isdigit' returns non-zero if C is a decimal digit (`0'--`9').

*Portability*
`isdigit' is ANSI C.


File: libc.i,  Node: islower,  Up: ctype

`islower'--lower-case character predicate
=========================================

*Synopsis*
     #include <ctype.h>
     int islower(int C);
   *Description*
`islower' is a macro which classifies ASCII integer values by table
lookup.  It is a predicate returning non-zero for minuscules
(lower-case alphabetic characters), and 0 for other characters. It is
defined only when `isascii'(C) is true or C is EOF.

   You can use a compiled subroutine instead of the macro definition by
undefining the macro using ``#undef islower''.

*Returns*
`islower' returns non-zero if C is a lower case letter (`a'--`z').

*Portability*
`islower' is ANSI C.


File: libc.i,  Node: isprint,  Up: ctype

`isprint', `isgraph'--printable character predicates
====================================================

*Synopsis*
     #include <ctype.h>
     int isprint(int C);
     int isgraph(int C);
   *Description*
`isprint' is a macro which classifies ASCII integer values by table
lookup.  It is a predicate returning non-zero for printable characters,
and 0 for other character arguments. It is defined only when
`isascii'(C) is true or C is EOF.

   You can use a compiled subroutine instead of the macro definition by
undefining either macro using ``#undef isprint'' or ``#undef isgraph''.

*Returns*
`isprint' returns non-zero if C is a printing character,
(`0x20'--`0x7E'). `isgraph' behaves identically to `isprint', except
that the space character (`0x20') is excluded.

*Portability*
`isprint' and `isgraph' are ANSI C.


File: libc.i,  Node: ispunct,  Up: ctype

`ispunct'--punctuation character predicate
==========================================

*Synopsis*
     #include <ctype.h>
     int ispunct(int C);
   *Description*
`ispunct' is a macro which classifies ASCII integer values by table
lookup.  It is a predicate returning non-zero for printable punctuation
characters, and 0 for other characters.  It is defined only when
`isascii'(C) is true or C is EOF.

   You can use a compiled subroutine instead of the macro definition by
undefining the macro using ``#undef ispunct''.

*Returns*
`ispunct' returns non-zero if C is a printable punctuation character
(`isgraph(C) && !isalnum(C)').

*Portability*
`ispunct' is ANSI C.


File: libc.i,  Node: isspace,  Up: ctype

`isspace'--whitespace character predicate
=========================================

*Synopsis*
     #include <ctype.h>
     int isspace(int C);
   *Description*
`isspace' is a macro which classifies ASCII integer values by table
lookup.  It is a predicate returning non-zero for whitespace
characters, and 0 for other characters.  It is defined only when
`isascii'(C) is true or C is EOF.

   You can use a compiled subroutine instead of the macro definition by
undefining the macro using ``#undef isspace''.

*Returns*
`isspace' returns non-zero if C is a space, tab, carriage return, new
line, vertical tab, or formfeed (`0x09'--`0x0D', `0x20').

*Portability*
`isspace' is ANSI C.


File: libc.i,  Node: isupper,  Up: ctype

`isupper'--uppercase character predicate
========================================

*Synopsis*
     #include <ctype.h>
     int isupper(int C);
   *Description*
`isupper' is a macro which classifies ASCII integer values by table
lookup.  It is a predicate returning non-zero for upper-case letters
(`A'--`Z'), and 0 for other characters.  It is defined only when
`isascii'(C) is true or C is EOF.

   You can use a compiled subroutine instead of the macro definition by
undefining the macro using ``#undef isupper''.

*Returns*
`isupper' returns non-zero if C is a upper case letter (A-Z).

*Portability*
`isupper' is ANSI C.


File: libc.i,  Node: isxdigit,  Up: ctype

`isxdigit'--hexadecimal digit predicate
=======================================

*Synopsis*
     #include <ctype.h>
     int isxdigit(int C);
   *Description*
`isxdigit' is a macro which classifies ASCII integer values by table
lookup.  It is a predicate returning non-zero for hexadecimal digits,
and `0' for other characters.  It is defined only when `isascii'(C) is
true or C is EOF.

   You can use a compiled subroutine instead of the macro definition by
undefining the macro using ``#undef isxdigit''.

*Returns*
`isxdigit' returns non-zero if C is a hexadecimal digit (`0'--`9',
`a'--`f', or `A'--`F').

*Portability*
`isxdigit' is ANSI C.


File: libc.i,  Node: toascii,  Up: ctype

`toascii'--force integers to ASCII range
========================================

*Synopsis*
     #include <ctype.h>
     int toascii(int C);
   *Description*
`toascii' is a macro which coerces integers to the ASCII range (0--127)
by zeroing any higher-order bits.

   You can use a compiled subroutine instead of the macro definition by
undefining this macro using ``#undef toascii''.

*Returns*
`toascii' returns integers between 0 and 127.

*Portability*
`toascii' is not ANSI C.


File: libc.i,  Node: tolower,  Up: ctype

`tolower'--translate characters to lower case
=============================================

*Synopsis*
     #include <ctype.h>
     int tolower(int C);
     int _tolower(int C);
   *Description*
`tolower' is a macro which converts upper-case characters to lower
case, leaving all other characters unchanged.  It is only defined when
C is an integer in the range `EOF' to `255'.

   You can use a compiled subroutine instead of the macro definition by
undefining this macro using ``#undef tolower''.

   `_tolower' performs the same conversion as `tolower', but should
only be used when C is known to be an uppercase character (`A'--`Z').

*Returns*
`tolower' returns the lower-case equivalent of C when it is a character
between `A' and `Z', and C otherwise.

   `_tolower' returns the lower-case equivalent of C when it is a
character between `A' and `Z'.  If C is not one of these characters,
the behaviour of `_tolower' is undefined.

*Portability*
`tolower' is ANSI C.  `_tolower' is not recommended for portable
programs.


File: libc.i,  Node: toupper,  Up: ctype

`toupper'--translate characters to upper case
=============================================

*Synopsis*
     #include <ctype.h>
     int toupper(int C);
     int _toupper(int C);
   *Description*
`toupper' is a macro which converts lower-case characters to upper
case, leaving all other characters unchanged.  It is only defined when
C is an integer in the range `EOF' to `255'.

   You can use a compiled subroutine instead of the macro definition by
undefining this macro using ``#undef toupper''.

   `_toupper' performs the same conversion as `toupper', but should
only be used when C is known to be a lowercase character (`a'--`z').

*Returns*
`toupper' returns the upper-case equivalent of C when it is a character
between `a' and `z', and C otherwise.

   `_toupper' returns the upper-case equivalent of C when it is a
character between `a' and `z'.  If C is not one of these characters,
the behaviour of `_toupper' is undefined.

*Portability*
`toupper' is ANSI C.  `_toupper' is not recommended for portable
programs.


File: libc.i,  Node: timefns,  Up: top

Time Reporting and Time Calculations (`time.h')
***********************************************

This chapter groups functions used either for reporting on time
(elapsed, current, or compute time) or to perform calculations based on
time.

   The header file `time.h' defines three types.  `clock_t' and
`time_t' are both used for representations of time particularly
suitable for arithmetic.  (In this implementation, quantities of type
`clock_t' have the highest resolution possible on your machine, and
quantities of type `time_t' resolve to seconds.)  `size_t' is also
defined if necessary for quantities representing sizes.

   `time.h' also defines the structure `tm' for the traditional
representation of Gregorian calendar time as a series of numbers, with
the following fields:

`tm_sec'
     Seconds.

`tm_min'
     Minutes.

`tm_hour'
     Hours.

`tm_mday'
     Day.

`tm_mon'
     Month.

`tm_year'
     Year (since 1900).

`tm_wday'
     Day of week: the number of days since Sunday.

`tm_yday'
     Number of days elapsed since last January 1.

`tm_isdst'
     Daylight Savings Time flag: positive means DST in effect, zero
     means DST not in effect, negative means no information about DST
     is available.

* Menu:

* asctime::
* clock::
* ctime::
* difftime::
* gmtime::
* localtime::
* mktime::
* strftime::
* time::


File: libc.i,  Node: asctime,  Up: timefns

`asctime'--format time as string
================================

   *Synopsis*
     #include <time.h>
     char *asctime(const struct tm *TIMP);
   *Description*
Format the time value at TIMP into a string of the form
      Wed Jun 15 11:38:07 1988\n\0
   The string is generated in a static buffer; each call to `asctime'
overwrites the string generated by previous calls.

*Returns*
A pointer to the string containing a formatted timestamp.

*Portability*
ANSI C requires `asctime'.


File: libc.i,  Node: clock,  Up: timefns

`clock'--cumulative processor time
==================================

*Synopsis*
     #include <time.h>
     clock_t clock(void);
   *Description*
Calculates the best available approximation of the cumulative amount of
time used by your program since it started.  To convert the result into
seconds, divide by the macro `CLOCKS_PER_SEC'.

*Returns*
The amount of processor time used so far by your program, in units
defined by the machine-dependent macro `CLOCKS_PER_SEC'.  If no
measurement is available, the result is `-1'.

*Portability*
ANSI C requires `clock' and `CLOCKS_PER_SEC'.


File: libc.i,  Node: ctime,  Up: timefns

`ctime'--convert time to local and format as string
===================================================

*Synopsis*
     #include <time.h>
     char *ctime(time_t TIMP);
   *Description*
Convert the time value at TIMP to local time (like `localtime') and
format it into a string of the form
      Wed Jun 15 11:38:07 1988\n\0
   (like `asctime').

*Returns*
A pointer to the string containing a formatted timestamp.

*Portability*
ANSI C requires `ctime'.


File: libc.i,  Node: difftime,  Up: timefns

`difftime'--subtract two times
==============================

*Synopsis*
     #include <time.h>
     double difftime(time_t TIM1, time_t TIM2);
   *Description*
Subtracts the two times in the arguments: ``TIM1 - TIM2''.

*Returns*
The difference (in seconds) between TIM2 and TIM1, as a `double'.

*Portability*
ANSI C requires `difftime', and defines its result to be in seconds in
all implementations.


File: libc.i,  Node: gmtime,  Up: timefns

`gmtime'--convert time to UTC (GMT) traditional representation
==============================================================

*Synopsis*
     #include <time.h>
     struct tm *gmtime(const time_t *TIMEP
   *Description*
`gmtime' assumes the time at TIMEP represents a local time. `gmtime'
converts it to UTC (Universal Coordinated Time, also known in some
countries as GMT, Greenwich Mean time), then converts the
representation from the arithmetic representation to the traditional
representation defined by `struct tm'.

   `gmtime' constructs the traditional time representation in static
storage; each call to `gmtime' or `localtime' will overwrite the
information generated by previous calls to either function.

*Returns*
A pointer to the traditional time representation (`struct tm').

*Portability*
ANSI C requires `gmtime'.


File: libc.i,  Node: localtime,  Up: timefns

`localtime'--convert time to local representation
=================================================

*Synopsis*
     #include <time.h>
     struct tm *localtime(time_t *TIMEP);
   *Description*
`localtime' converts the time at TIMEP into local time, then converts
its representation from the arithmetic representation to the
traditional representation defined by `struct tm'.

   `localtime' constructs the traditional time representation in static
storage; each call to `gmtime' or `localtime' will overwrite the
information generated by previous calls to either function.

   `mktime' is the inverse of `localtime'.

*Returns*
A pointer to the traditional time representation (`struct tm').

*Portability*
ANSI C requires `localtime'.


File: libc.i,  Node: mktime,  Up: timefns

`mktime'--convert time to arithmetic representation
===================================================

*Synopsis*
     #include <time.h>
     time_t mktime(struct tm *TIMP);
   *Description*
`mktime' assumes the time at TIMP is a local time, and converts its
representation from the traditional representation defined by `struct
tm' into a representation suitable for arithmetic.

   `localtime' is the inverse of `mktime'.

*Returns*
If the contents of the structure at TIMP do not form a valid calendar
time representation, the result is `-1'.  Otherwise, the result is the
time, converted to a `time_t' value.

*Portability*
ANSI C requires `mktime'.


File: libc.i,  Node: strftime,  Up: timefns

`strftime'--flexible calendar time formatter
============================================

*Synopsis*
     #include <time.h>
     size_t strftime(char *S, size_t MAXSIZE,
         const char *FORMAT, const struct tm *TIMP);
   *Description*
`strftime' converts a `struct tm' representation of the time (at TIMP)
into a string, starting at S and occupying no more than MAXSIZE
characters.

   You control the format of the output using the string at FORMAT.
`*FORMAT' can contain two kinds of specifications: text to be copied
literally into the formatted string, and time conversion
specifications.  Time conversion specifications are two-character
sequences beginning with ``%'' (use ``%%'' to include a percent sign in
the output).  Each defined conversion specification selects a field of
calendar time data from `*TIMP', and converts it to a string in one of
the following ways:

`%a'
     An abbreviation for the day of the week.

`%A'
     The full name for the day of the week.

`%b'
     An abbreviation for the month name.

`%B'
     The full name of the month.

`%c'
     A string representing the complete date and time, in the form
           Mon Apr 01 13:13:13 1992

`%d'
     The day of the month, formatted with two digits.

`%H'
     The hour (on a 24-hour clock), formatted with two digits.

`%I'
     The hour (on a 12-hour clock), formatted with two digits.

`%j'
     The count of days in the year, formatted with three digits (from
     ``001'' to ``366'').

`%m'
     The month number, formatted with two digits.

`%M'
     The minute, formatted with two digits.

`%p'
     Either ``AM'' or ``PM'' as appropriate.

`%S'
     The second, formatted with two digits.

`%U'
     The week number, formatted with two digits (from ``00'' to ``53'';
     week number 1 is taken as beginning with the first Sunday in a
     year). See also `%W'.

`%w'
     A single digit representing the day of the week: Sunday is day `0'.

`%W'
     Another version of the week number: like ``%U'', but counting week
     1 as beginning with the first Monday in a year.

`%x'
     A string representing the complete date, in a format like
           Mon Apr 01 1992

`%X'
     A string representing the full time of day (hours, minutes, and
     seconds), in a format like
           13:13:13

`%y'
     The last two digits of the year.

`%Y'
     The full year, formatted with four digits to include the century.

`%Z'
     Defined by ANSI C as eliciting the time zone if available; it is
     not available in this implementation (which accepts ``%Z'' but
     generates no output for it).

`%%'
     A single character, ``%''.

*Returns*
When the formatted time takes up no more than MAXSIZE characters, the
result is the length of the formatted string.  Otherwise, if the
formatting operation was abandoned due to lack of room, the result is
`0', and the string starting at S corresponds to just those parts of
`*FORMAT' that could be completely filled in within the MAXSIZE limit.

*Portability*
ANSI C requires `strftime', but does not specify the contents of `*S'
when the formatted string would require more than MAXSIZE characters.


File: libc.i,  Node: time,  Up: timefns

`time'--get current calendar time (as single number)
====================================================

*Synopsis*
     #include <time.h>
     time_t time(time_t *T);
   *Description*
*WARNING: `time' is not available in this implementation of the C
library.*

   `time' looks up the best available representation of the current
time and returns it, encoded as a `time_t'.  It stores the same value
at T unless the argument is `NULL'.

*Returns*
A `-1' result means the current time is not available; otherwise the
result represents the current time.

*Portability*
ANSI C requires `time'.


File: libc.i,  Node: stdio,  Up: top

Input and Output (`stdio.h')
****************************

This chapter comprises functions to manage files or other input/output
streams. Among these functions are subroutines to generate or scan
strings according to specifications from a format string.

   The underlying facilities for input and output depend on the host
system, but these functions provide a uniform interface.

   The corresponding declarations are in `stdio.h'.

* Menu:

* clearerr::
* fclose::
* feof::
* ferror::
* fflush::
* fgetc::
* fgetpos::
* fgets::
* fiprintf::
* fopen::
* fputc::
* fputs::
* fread::
* freopen::
* fseek::
* fsetpos::
* ftell::
* fwrite::
* getc::
* getchar::
* gets::
* iprintf::
* mktemp::
* perror::
* putc::
* putchar::
* puts::
* remove::
* rename::
* rewind::
* setbuf::
* setvbuf::
* sprintf::
* sscanf::
* tmpfile::
* tmpnam::
* vfprintf::


File: libc.i,  Node: clearerr,  Up: stdio

`clearerr'--clear file or stream error indicator
================================================

   *Synopsis*
     #include <stdio.h>
     void clearerr(FILE *FP);
   *Description*
The `stdio' functions maintain an error indicator with each file
pointer FP, to record whether any read or write errors have occurred on
the associated file or stream.  Similarly, it maintains an end-of-file
indicator to record whether there is no more data in the file.

   Use `clearerr' to reset both of these indicators.

   See `ferror' and `feof' to query the two indicators.

*Returns*
`clearerr' does not return a result.

*Portability*
ANSI C requires `clearerr'.


File: libc.i,  Node: fclose,  Up: stdio

`fclose'--close a file
======================

*Synopsis*
     #include <stdio.h>
     int fclose(FILE *FP);
   *Description*
If the file or stream identified by FP is open, `fclose' closes it,
after first ensuring that any pending data is written (by calling
`fflush(FP)').

*Returns*
`fclose' returns `0' if successful (including when FP is `NULL' or not
an open file); otherwise, it returns `EOF'.

*Portability*
`fclose' is required by ANSI C.


File: libc.i,  Node: feof,  Up: stdio

`feof'--test for end of file
============================

*Synopsis*
     #include <stdio.h>
     int feof(FILE *FP);
   *Description*
`feof' tests whether or not the end of the file identified by FP has
been reached.

*Returns*
`feof' returns `0' if the end of file has not yet been reached; if at
end of file, the result is nonzero.

*Portability*
`feof' is required by ANSI C.


File: libc.i,  Node: ferror,  Up: stdio

`ferror'--test whether read/write error has occurred
====================================================

*Synopsis*
     #include <stdio.h>
     int ferror(FILE *FP);
   *Description*
The `stdio' functions maintain an error indicator with each file
pointer FP, to record whether any read or write errors have occurred on
the associated file or stream. Use `ferror' to query this indicator.

   See `clearerr' to reset the error indicator.

*Returns*
`ferror' returns `0' if no errors have occurred; it returns a nonzero
value otherwise.

*Portability*
ANSI C requires `ferror'.


File: libc.i,  Node: fflush,  Up: stdio

`fflush'--flush buffered file output
====================================

*Synopsis*
     #include <stdio.h>
     int fflush(FILE *FP);
   *Description*
The `stdio' output functions can buffer output before delivering it to
the host system, in order to minimize the overhead of system calls.

   Use `fflush' to deliver any such pending output (for the file or
stream identified by FP) to the host system.

   If FP is `NULL', `fflush' delivers pending output from all open
files.

*Returns*
`fflush' returns `0' unless it encounters a write error; in that
situation, it returns `EOF'.

*Portability*
ANSI C requires `fflush'.


File: libc.i,  Node: fgetc,  Up: stdio

`fgetc'--get a character from a file or stream
==============================================

*Synopsis*
     #include <stdio.h>
     int fgetc(FILE *FP);
   *Description*
Use `fgetc' to get the next single character from the file or stream
identified by FP.  As a side effect, `fgetc' advances the file's
current position indicator.

   For a macro version of this function, see `getc'.

*Returns*
The next character (read as an `unsigned char', and cast to `int'),
unless there is no more data, or the host system reports a read error;
in either of these situations, `fgetc' returns `EOF'.

   You can distinguish the two situations that cause an `EOF' result by
using the `ferror' and `feof' functions.

*Portability*
ANSI C requires `fgetc'.


File: libc.i,  Node: fgetpos,  Up: stdio

`fgetpos'--record position in a stream or file
==============================================

*Synopsis*
     #include <stdio.h>
     int fgetpos(FILE *FP, fpos_t *POS);
   *Description*
Objects of type `FILE' can have a "position" that records how much of
the file your program has already read.  Many of the `stdio' functions
depend on this position, and many change it as a side effect.

   You can use `fgetpos' to report on the current position for a file
identified by FP; `fgetpos' will write a value representing that
position at `*POS'.  Later, you can use this value with `fsetpos' to
return the file to this position.

   In the current implementation, `fgetpos' simply uses a character
count to represent the file position; this is the same number that
would be returned by `ftell'.

*Returns*
`fgetpos' returns `0' when successful.  If `fgetpos' fails, the result
is `1'.  Failure occurs on streams that do not support positioning; the
global `errno' indicates this condition with the value `ESPIPE'.

*Portability*
`fgetpos' is required by the ANSI C standard, but the meaning of the
value it records is not specified beyond requiring that it be
acceptable as an argument to `fsetpos'.  In particular, other
conforming C implementations may return a different result from `ftell'
than what `fgetpos' writes at `*POS'.


File: libc.i,  Node: fgets,  Up: stdio

`fgets'--get character string from a file or stream
===================================================

*Synopsis*
     #include <stdio.h>
     char *fgets(char *BUF, int N, FILE *FP);
   *Description*
Reads at most N-1 characters from FP until a newline is found. The
characters including to the newline are stored in BUF. The buffer is
terminated with a 0.

*Returns*
`fgets' returns the buffer passed to it, with the data filled in. If
end of file occurs with some data already accumulated, the data is
returned with no other indication. If no data are read, NULL is
returned instead.

*Portability*
`fgets' should replace all uses of `gets'. Note however that `fgets'
returns all of the data, while `gets' removes the trailing newline
(with no indication that it has done so.)


File: libc.i,  Node: fiprintf,  Up: stdio

`fiprintf'--write formatted output to file (integer only)
=========================================================

*Synopsis*
     #include <stdio.h>
     
     int fiprintf(FILE *FD, const char *FORMAT, ...);
   *Description*
`fiprintf' is a restricted version of `fprintf': it has the same
arguments and behavior, save that it cannot perform any floating-point
formatting--the `f', `g', `G', `e', and `F' type specifiers are not
recognized.

*Returns*
`fiprintf' returns the number of bytes in the output string, save that
the concluding `NULL' is not counted. `fiprintf' returns when the end
of the format string is encountered.  If an error occurs, `fiprintf'
returns `EOF'.

*Portability*
`fiprintf' is not required by ANSI C.


File: libc.i,  Node: fopen,  Up: stdio

`fopen'--open a file
====================

*Synopsis*
     #include <stdio.h>
     FILE *fopen(const char *FILE, const char *MODE);
   *Description*
`fopen' initializes the data structures needed to read or write a file.
 Specify the file's name as the string at FILE, and the kind of access
you need to the file with the string at MODE.

   Three fundamental kinds of access are available: read, write, and
append. `*MODE' must begin with one of the three characters ``r'',
``w'', or ``a'', to select one of these:

`r'
     Open the file for reading; the operation will fail if the file does
     not exist, or if the host system does not permit you to read it.

`w'
     Open the file for writing *from the beginning* of the file:
     effectively, this always creates a new file.  If the file whose
     name you specified already existed, its old contents are discarded.

`a'
     Open the file for appending data, that is writing from the end of
     file.  When you open a file this way, all data always goes to the
     current end of file; you cannot change this using `fseek'.

   Some host systems distinguish between "binary" and "text" files.
Such systems may perform data transformations on data written to, or
read from, files opened as "text". If your system is one of these, then
you can append a ``b'' to any of the three modes above, to specify that
you are opening the file as a binary file (the default is to open the
file as a text file).

   ``rb'', then, means "read binary"; ``wb'', "write binary"; and
``ab'', "append binary".

   To make C programs more portable, the ``b'' is accepted on all
systems, whether or not it makes a difference.

   Finally, you might need to both read and write from the same file.
You can also append a ``+'' to any of the three modes, to permit this. 
(If you want to append both ``b'' and ``+'', you can do it in either
order: for example, `"rb+"' means the same thing as `"r+b"' when used
as a mode string.)

   Use `"r+"' (or `"rb+"') to permit reading and writing anywhere in an
existing file, without discarding any data; `"w+"' (or `"wb+"') to
create a new file (or begin by discarding all data from an old one)
that permits reading and writing anywhere in it; and `"a+"' (or
`"ab+"') to permit reading anywhere in an existing file, but writing
only at the end.

*Returns*
`fopen' returns a file pointer which you can use for other file
operations, unless the file you requested could not be opened; in that
situation, the result is `NULL'.  If the reason for failure was an
invalid string at MODE, `errno' is set to `EINVAL'.

*Portability*
`fopen' is required by ANSI C.


File: libc.i,  Node: fputc,  Up: stdio

`fputc'--write a character on a stream or file
==============================================

*Synopsis*
     #include <stdio.h>
     int fputc(int CH, FILE *FP);
   *Description*
`fputc' converts the argument CH from an `int' to an `unsigned char',
then writes it to the file or stream identified by FP.

   If the file was opened with append mode (or if the stream cannot
support positioning), then the new character goes at the end of the
file or stream.  Otherwise, the new character is written at the current
value of the position indicator, and the position indicator advances by
one.

   For a macro version of this function, see `putc'.

*Returns*
If successful, `fputc' returns its argument CH.  If an error
intervenes, the result is `EOF'.  You can use ``ferror(FP)'' to query
for errors.

*Portability*
`fputc' is required by ANSI C.


File: libc.i,  Node: fputs,  Up: stdio

`fputs'--write a character string in a file or stream
=====================================================

*Synopsis*
     #include <stdio.h>
     int fputs(const char *S, FILE *FP);
   *Description*
`fputs' writes the string at S (but without the trailing null) to the
file or stream identified by FP.

*Returns*
If successful, the result is `0'; otherwise, the result is `EOF'.

*Portability*
ANSI C requires `fputs', but does not specify that the result on
success must be `0'; any non-negative value is permitted.


File: libc.i,  Node: fread,  Up: stdio

`fread'--read array elements from a file
========================================

*Synopsis*
     #include <stdio.h>
     size_t fread(void *BUF, size_t SIZE, size_t COUNT,
         FILE *FP);
   *Description*
`fread' attempts to copy, from the file or stream identified by FP,
COUNT elements (each of size SIZE) into memory, starting at BUF.  
`fread' may copy fewer elements than COUNT if an error, or end of file,
intervenes.

   `fread' also advances the file position indicator (if any) for FP by
the number of *characters* actually read.

*Returns*
The result of `fread' is the number of elements it succeeded in reading.

*Portability*
ANSI C requires `fread'.


File: libc.i,  Node: freopen,  Up: stdio

`freopen'--open a file using an existing file descriptor
========================================================

*Synopsis*
     #include <stdio.h>
     FILE *freopen(const char *FILE, const char *MODE,
         FILE *FP);
   *Description*
Use this variant of `fopen' if you wish to specify a particular file
descriptor FP (notably `stdin', `stdout', or `stderr') for the file.

   If FP was associated with another file or stream, `freopen' closes
that other file or stream (but ignores any errors while closing it).

   FILE and MODE are used just as in `fopen'.

*Returns*
If successful, the result is the same as the argument FP.  If the file
cannot be opened as specified, the result is `NULL'.

*Portability*
ANSI C requires `freopen'.


File: libc.i,  Node: fseek,  Up: stdio

`fseek'--set file position
==========================

*Synopsis*
     #include <stdio.h>
     int fseek(FILE *FP, long OFFSET, int WHENCE)
   *Description*
Objects of type `FILE' can have a "position" that records how much of
the file your program has already read.  Many of the `stdio' functions
depend on this position, and many change it as a side effect.

   You can use `fseek' to set the position for the file identified by
FP.  The value of OFFSET determines the new position, in one of three
ways selected by the value of WHENCE (defined as macros in ``stdio.h''):

   `SEEK_SET'--OFFSET is the absolute file position (an offset from the
beginning of the file) desired.  OFFSET must be positive.

   `SEEK_CUR'--OFFSET is relative to the current file position. OFFSET
can meaningfully be either positive or negative.

   `SEEK_END'--OFFSET is relative to the current end of file. OFFSET
can meaningfully be either positive (to increase the size of the file)
or negative.

   See `ftell' to determine the current file position.

*Returns*
`fseek' returns `0' when successful.  If `fseek' fails, the result is
`EOF'.  The reason for failure is indicated in `errno': either `ESPIPE'
(the stream identified by FP doesn't support repositioning) or `EINVAL'
(invalid file position).

*Portability*
ANSI C requires `fseek'.


File: libc.i,  Node: fsetpos,  Up: stdio

`fsetpos'--restore position of a stream or file
===============================================

*Synopsis*
     #include <stdio.h>
     int fsetpos(FILE *FP, const fpos_t *POS);
   *Description*
Objects of type `FILE' can have a "position" that records how much of
the file your program has already read.  Many of the `stdio' functions
depend on this position, and many change it as a side effect.

   You can use `fsetpos' to return the file identified by FP to a
previous position `*POS' (after first recording it with `fgetpos').

   See `fseek' for a similar facility.

*Returns*
`fgetpos' returns `0' when successful.  If `fgetpos' fails, the result
is `1'.  The reason for failure is indicated in `errno': either
`ESPIPE' (the stream identified by FP doesn't support repositioning) or
`EINVAL' (invalid file position).

*Portability*
ANSI C requires `fsetpos', but does not specify the nature of `*POS'
beyond identifying it as written by `fgetpos'.


File: libc.i,  Node: ftell,  Up: stdio

`ftell'--return position in a stream or file
============================================

*Synopsis*
     #include <stdio.h>
     long ftell(FILE *FP);
   *Description*
Objects of type `FILE' can have a "position" that records how much of
the file your program has already read.  Many of the `stdio' functions
depend on this position, and many change it as a side effect.

   The result of `ftell' is the current position for a file identified
by FP.  If you record this result, you can later use it with `fseek' to
return the file to this position.

   In the current implementation, `ftell' simply uses a character count
to represent the file position; this is the same number that would be
recorded by `fgetpos'.

*Returns*
`ftell' returns the file position, if possible.  If it cannot do this,
it returns `-1L'.  Failure occurs on streams that do not support
positioning; the global `errno' indicates this condition with the value
`ESPIPE'.

*Portability*
`ftell' is required by the ANSI C standard, but the meaning of its
result (when successful) is not specified beyond requiring that it be
acceptable as an argument to `fseek'.  In particular, other conforming
C implementations may return a different result from `ftell' than what
`fgetpos' records.


File: libc.i,  Node: fwrite,  Up: stdio

`fwrite'--write array elements from memory to a file or stream
==============================================================

*Synopsis*
     #include <stdio.h>
     size_t fwrite(const void *BUF, size_t SIZE,
         size_t COUNT, FILE *FP);
   *Description*
`fwrite' attempts to copy, starting from the memory location BUF, COUNT
elements (each of size SIZE) into the file or stream identified by FP. 
`fwrite' may copy fewer elements than COUNT if an error intervenes.

   `fwrite' also advances the file position indicator (if any) for FP
by the number of *characters* actually written.

*Returns*
If `fvwrite' succeeds in writing all the elements you specify, the
result is the same as the argument COUNT.  In any event, the result is
the number of complete elements that `fvwrite' copied to the file.

*Portability*
ANSI C requires `fvwrite'.


File: libc.i,  Node: getc,  Up: stdio

`getc'--get a character from a file or stream (macro)
=====================================================

*Synopsis*
     #include <stdio.h>
     int getc(FILE *FP);
   *Description*
`getc' is a macro, defined in `stdio.h'.  You can use `getc' to get the
next single character from the file or stream identified by FP.  As a
side effect, `getc' advances the file's current position indicator.

   For a subroutine version of this macro, see `fgetc'.

*Returns*
The next character (read as an `unsigned char', and cast to `int'),
unless there is no more data, or the host system reports a read error;
in either of these situations, `getc' returns `EOF'.

   You can distinguish the two situations that cause an `EOF' result by
using the `ferror' and `feof' functions.

*Portability*
ANSI C requires `getc'; it suggests, but does not require, that `getc'
be implemented as a macro.  The standard explicitly permits macro
implementations of `getc' to use the argument more than once;
therefore, in a portable program, you should not use an expression with
side effects as the `getc' argument.


File: libc.i,  Node: getchar,  Up: stdio

`getchar'--get a character from standard input (macro)
======================================================

*Synopsis*
     #include <stdio.h>
     int getchar(void);
   *Description*
`getchar' is a macro, defined in `stdio.h'.  You can use `getchar' to
get the next single character from the standard input stream. As a side
effect, `getchar' advances the standard input's current position
indicator.

*Returns*
The next character (read as an `unsigned char', and cast to `int'),
unless there is no more data, or the host system reports a read error;
in either of these situations, `getchar' returns `EOF'.

   You can distinguish the two situations that cause an `EOF' result by
using ``ferror(stdin)'' and ``feof(stdin)''.

*Portability*
ANSI C requires `getchar'; it suggests, but does not require, that
`getchar' be implemented as a macro.


File: libc.i,  Node: gets,  Up: stdio

`gets'--get character string from standard input (obsolete)
===========================================================

*Synopsis*
     #include <stdio.h>
     
     char *gets(char *BUF);
   *Description*
Reads characters from standard input until a newline is found. The
characters up to the newline are stored in BUF. The newline is
discarded, and the buffer is terminated with a 0.

   This is a DANGEROUS function, as it has no way of checking the
amount of space available in BUF. One of the attacks used by the
Internet Virus of 1988 used this to overrun a buffer allocated on the
stack of the finger daemon and overwrite the return address, causing
the daemon to execute code downloaded into it over the connection.

*Returns*
`gets' returns the buffer passed to it, with the data filled in. If end
of file occurs with some data already accumulated, the data is returned
with no other indication. If end of file occurs with no data in the
buffer, NULL is returned.


File: libc.i,  Node: iprintf,  Up: stdio

`iprintf'--write formatted output (integer only)
================================================

*Synopsis*
     #include <stdio.h>
     
     int iprintf(const char *FORMAT, ...);
   *Description*
`iprintf' is a restricted version of `printf': it has the same
arguments and behavior, save that it cannot perform any floating-point
formatting: the `f', `g', `G', `e', and `F' type specifiers are not
recognized.

*Returns*
`iprintf' returns the number of bytes in the output string, save that
the concluding `NULL' is not counted. `iprintf' returns when the end of
the format string is encountered.  If an error occurs, `iprintf'
returns `EOF'.

*Portability*
`iprintf' is not required by ANSI C.


File: libc.i,  Node: mktemp,  Up: stdio

`mktemp', `mkstemp'--generate unused file name
==============================================

*Synopsis*
     #include <stdio.h>
     char *mktemp(char *PATH);
     int mkstemp(char *PATH);
   *Description*
`mktemp' and `mkstemp' attempt to generate a file name that is not yet
in use for any existing file.

   `mkstemp' creates the file and opens it for reading and writing;
`mktemp' simply generates the file name.

   You supply a simple pattern for the generated file name, as the
string at PATH.  The pattern should be a valid filename (including path
information if you wish) ending with some number of ``X'' characters. 
The generated filename will match the leading part of the name you
supply, with the trailing ``X'' characters replaced by some combination
of digits and letters.

*Returns*
`mktemp' returns the pointer PATH to the modified string representing
an unused filename, unless it could not generate one, or the pattern
you provided is not suitable for a filename; in that case, it returns
`NULL'.

   `mkstemp' returns a file descriptor to the newly created file,
unless it could not generate an unused filename, or the pattern you
provided is not suitable for a filename; in that case, it returns `-1'.

*Portability*
ANSI C does not require either `mktemp' or `mkstemp'; the System V
Interface Definition requires `mktemp' as of Issue 2.


File: libc.i,  Node: perror,  Up: stdio

`perror'--print an error message on standard error
==================================================

*Synopsis*
     #include <stdio.h>
     void perror(char *PREFIX);
   *Description*
Use `perror' to print (on standard error) an error message
corresponding to the current value of the global variable `errno'.
Unless you use `NULL' as the value of the argument PREFIX, the error
message will begin with the string at PREFIX, followed by a colon and a
space (`: '). The remainder of the error message is one of the strings
described for `strerror'.

*Returns*
`perror' returns no result.

*Portability*
ANSI C requires `perror', but the strings issued vary from one
implementation to another.


File: libc.i,  Node: putc,  Up: stdio

`putc'--write a character on a stream or file (macro)
=====================================================

*Synopsis*
     #include <stdio.h>
     int putc(int CH, FILE *FP);
   *Description*
`putc' is a macro, defined in `stdio.h'.  `putc' writes the argument CH
to the file or stream identified by FP, after converting it from an
`int' to an `unsigned char'.

   If the file was opened with append mode (or if the stream cannot
support positioning), then the new character goes at the end of the
file or stream.  Otherwise, the new character is written at the current
value of the position indicator, and the position indicator advances by
one.

   For a subroutine version of this macro, see `fputc'.

*Returns*
If successful, `putc' returns its argument CH.  If an error intervenes,
the result is `EOF'.  You can use ``ferror(FP)'' to query for errors.

*Portability*
ANSI C requires `putc'; it suggests, but does not require, that `putc'
be implemented as a macro.  The standard explicitly permits macro
implementations of `putc' to use the FP argument more than once;
therefore, in a portable program, you should not use an expression with
side effects as this argument.


File: libc.i,  Node: putchar,  Up: stdio

`putchar'--write a character on standard output (macro)
=======================================================

*Synopsis*
     #include <stdio.h>
     int putchar(int CH);
   *Description*
`putchar' is a macro, defined in `stdio.h'.  `putchar' writes its
argument to the standard output stream, after converting it from an
`int' to an `unsigned char'.

*Returns*
If successful, `putchar' returns its argument CH.  If an error
intervenes, the result is `EOF'.  You can use ``ferror(stdin)'' to
query for errors.

*Portability*
ANSI C requires `putchar'; it suggests, but does not require, that
`putchar' be implemented as a macro.


File: libc.i,  Node: puts,  Up: stdio

`puts'--write a character string on standard output
===================================================

*Synopsis*
     #include <stdio.h>
     int fputs(const char *S);
   *Description*
`puts' writes the string at S (followed by a newline, instead of the
trailing null) to the standard output stream.

*Returns*
If successful, the result is `0'; otherwise, the result is `EOF'.

*Portability*
ANSI C requires `puts', but does not specify that the result on success
must be `0'; any non-negative value is permitted.


File: libc.i,  Node: remove,  Up: stdio

`remove'--delete a file's name
==============================

*Synopsis*
     #include <stdio.h>
     int remove(char *FILENAME);
   *Description*
Use `remove' to dissolve the association between a particular filename
(the string at FILENAME) and the file it represents. After calling
`remove' with a particular filename, you will no longer be able to open
the file by that name.

   In this implementation, you may use `remove' on an open file without
error; existing file descriptors for the file will continue to access
the file's data until the program using them closes the file.

*Returns*
`remove' returns `0' if it succeeds, `-1' if it fails.

*Portability*
ANSI C requires `remove', but only specifies that the result on failure
be nonzero.  The behavior of `remove' when you call it on an open file
may vary among implementations.


File: libc.i,  Node: rename,  Up: stdio

`rename'--rename a file
=======================

*Synopsis*
     #include <stdio.h>
     int rename(const char *OLD, const char *NEW);
   *Description*
Use `rename' to establish a new name (the string at NEW) for a file now
known by the string at OLD.  After a successful `rename', the file is
no longer accessible by the string at OLD.

   If `rename' fails, the file named `*OLD' is unaffected.  The
conditions for failure depend on the host operating system.

*Returns*
The result is either `0' (when successful) or `-1' (when the file could
not be renamed).

*Portability*
ANSI C requires `rename', but only specifies that the result on failure
be nonzero.  The effects of using the name of an existing file as
`*NEW' may vary from one implementation to another.


File: libc.i,  Node: rewind,  Up: stdio

`rewind'--reinitialize a file or stream
=======================================

*Synopsis*
     #include <stdio.h>
     void rewind(FILE *FP);
   *Description*
`rewind' returns the file position indicator (if any) for the file or
stream identified by FP to the beginning of the file.  It also clears
any error indicator and flushes any pending output.

*Returns*
`rewind' does not return a result.

*Portability*
ANSI C requires `rewind'.


File: libc.i,  Node: setbuf,  Up: stdio

`setbuf'--specify full buffering for a file or stream
=====================================================

*Synopsis*
     #include <stdio.h>
     void setbuf(FILE *FP, char *BUF);
   *Description*
`setbuf' specifies that output to the file or stream identified by FP
should be fully buffered.  All output for this file will go to a buffer
(of size `BUFSIZ', specified in ``stdio.h'').  Output will be passed on
to the host system only when the buffer is full, or when an input
operation intervenes.

   You may, if you wish, supply your own buffer by passing a pointer to
it as the argument BUF.  It must have size `BUFSIZ'.  You can also use
`NULL' as the value of BUF, to signal that the `setbuf' function is to
allocate the buffer.

*Warnings*
You may only use `setbuf' before performing any file operation other
than opening the file.

   If you supply a non-null BUF, you must ensure that the associated
storage continues to be available until you close the stream identified
by FP.

*Returns*
`setbuf' does not return a result.

*Portability*
Both ANSI C and the System V Interface Definition (Issue 2) require
`setbuf'.  However, they differ on the meaning of a `NULL' buffer
pointer: the SVID issue 2 specification says that a `NULL' buffer
pointer requests unbuffered output.  For maximum portability, avoid
`NULL' buffer pointers.


File: libc.i,  Node: setvbuf,  Up: stdio

`setvbuf'--specify buffering for a file or stream
=================================================

*Synopsis*
     #include <stdio.h>
     int setvbuf(FILE *FP, char *BUF,
         int MODE, size_t SIZE);
   *Description*
Use `setvbuf' to specify what kind of buffering you want for the file
or stream identified by FP, by using one of the following values (from
`stdio.h') as the MODE argument:

`_IONBF'
     Do not use a buffer send output directly to the host system for the
     file or stream identified by FP.

`_IOFBF'
     Use full output buffering: output will be passed on to the host
     system only when the buffer is full, or when an input operation
     intervenes.

`_IOLBF'
     Use line buffering: pass on output to the host system at every
     newline, as well as when the buffer is full, or when an input
     operation intervenes.

   Use the SIZE argument to specify how large a buffer you wish.  You
can supply the buffer itself, if you wish, by passing a pointer to a
suitable area of memory as BUF.  Otherwise, you may pass `NULL' as the
BUF argument, and `setvbuf' will allocate the buffer.

*Warnings*
You may only use `setvbuf' before performing any file operation other
than opening the file.

   If you supply a non-null BUF, you must ensure that the associated
storage continues to be available until you close the stream identified
by FP.

*Returns*
A `0' result indicates success, `EOF' failure (invalid MODE or SIZE can
cause failure).

*Portability*
Both ANSI C and the System V Interface Definition (Issue 2) require
`setvbuf'. However, they differ on the meaning of a `NULL' buffer
pointer: the SVID issue 2 specification says that a `NULL' buffer
pointer requests unbuffered output.  For maximum portability, avoid
`NULL' buffer pointers.

   Both specifications describe the result on failure only as a nonzero
value.


File: libc.i,  Node: sprintf,  Up: stdio

`printf', `fprintf', `sprintf'--write formatted output
======================================================

*Synopsis*
     #include <stdio.h>
     
     int printf(const char *FORMAT [, ARG, ...]);
     int fprintf(FILE *FD, const char *FORMAT [, ARG, ...]);
     int sprintf(char *STR, const char *FORMAT [, ARG, ...]);
   *Description*
`printf' accepts a series of arguments, applies to each a format
specifier from `*FORMAT', and writes the formatted data to `stdout',
terminated with a null character. The behavior of `printf' is undefined
if there are not enough arguments for the format. `printf' returns when
it reaches the end of the format string. If there are more arguments
than the format requires, excess arguments are ignored.

   `fprintf' and `sprintf' are identical to `printf', other than the
destination of the formatted output: `fprintf' sends the output to a
specified file FD, while `sprintf' stores the output in the specified
char array STR.  For `sprintf', the behavior is also undefined if the
output `*STR' overlaps with one of the arguments. FORMAT is a pointer
to a charater string containing two types of objects: ordinary
characters (other than `%'), which are copied unchanged to the output,
and conversion specifications, each of which is introduced by `%'. (To
include `%' in the output, use `%%' in the format string.) A conversion
specification has the following form:

            %[FLAGS][WIDTH][.PREC][SIZE][TYPE]

   The fields of the conversion specification have the following
meanings:

   * FLAGS

     an optional sequence of characters which control output
     justification, numeric signs, decimal points, trailing zeroes, and
     octal and hex prefixes. The flag characters are minus (`-'), plus
     (`+'), space ( ), zero (`0'), and sharp (`#').  They can appear in
     any combination.

    `-'
          The result of the conversion is left justified, and the right
          is padded with blanks.  If you do not use this flag, the
          result is right justified, and padded on the left.

    `+'
          The result of a signed conversion (as determined by TYPE)
          will always begin with a plus or minus sign.  (If you do not
          use this flag, positive values do not begin with a plus sign.)

    `" " (space)'
          If the first character of a signed conversion specification
          is not a sign, or if a signed conversion results in no
          characters, the result will begin with a space.  If the space
          ( ) flag and the plus (`+') flag both appear, the space flag
          is ignored.

    `0'
          If the TYPE character is `d', `i', `o', `u', `x', `X', `e',
          `E', `f', `g', or `G': leading zeroes, are used to pad the
          field width (following any indication of sign or base); no
          spaces are used for padding.  If the zero (`0') and minus
          (`-') flags both appear, the zero (`0') flag will be ignored.
           For `d', `i', `o', `u', `x', and `X' conversions, if a
          precision PREC is specified, the zero (`0') flag is ignored.
          Note that `0' is interpreted as a flag, not as the beginning
          of a field width.

    `#'
          The result is to be converted to an alternative form,
          according to the next character:

         `0'
               increases precision to force the first digit of the
               result to be a zero.

         `x'
               a non-zero result will have a `0x' prefix.

         `X'
               a non-zero result will have a `0X' prefix.

         `e, E or f'
               The result will always contain a decimal point even if
               no digits follow the point. (Normally, a decimal point
               appears only if a digit follows it.)  Trailing zeroes
               are removed.

         `g or G'
               same as `e' or `E', but trailing zeroes are not removed.

         `all others'
               undefined.

   * WIDTH

     WIDTH is an optional minimum field width.  You can either specify
     it directly as a decimal integer, or indirectly by using instead
     an asterisk (`*'), in which case an `int' argument is used as the
     field width.  Negative field widths are not supported; if you
     attempt to specify a negative field width, it is interpreted as a
     minus (`-') flag followed by a positive field width.

   * PREC

     an optional field; if present, it is introduced with ``.'' (a
     period). This field gives the maximum number of characters to
     print in a conversion; the minimum number of digits of an integer
     to print, for conversions with TYPE `d', `i', `o', `u', `x', and
     `X'; the maximum number of significant digits, for the `g' and `G'
     conversions; or the number of digits to print after the decimal
     point, for `e', `E', and `f' conversions.  You can specify the
     precision either directly as a decimal integer or indirectly by
     using an asterisk (`*'), in which case an `int' argument is used
     as the precision.  Supplying a negative precision is equivalent to
     omitting the precision. If only a period is specified the
     precision is zero. If a precision appears with any other
     conversion TYPE than those listed here, the behavior is undefined.

   * SIZE

     `h', `l', and `L' are optional size characters which override the
     default way that `printf' interprets the data type of the
     corresponding argument.  `h' forces the following `d', `i', `o',
     `u', `x' or `X' conversion TYPE to apply to a `short' or `unsigned
     short'. `h' also forces a following `n' TYPE to apply to a pointer
     to a `short'. Similarily, an `l' forces the following `d', `i',
     `o', `u', `x' or `X' conversion TYPE to apply to a `long' or
     `unsigned long'.  `l' also forces a following `n' TYPE to apply to
     a pointer to a `long'. If an `h' or an `l' appears with another
     conversion specifier, the behavior is undefined.  `L' forces a
     following `e', `E', `f', `g' or `G' conversion TYPE to apply to a
     `long double' argument.  If `L' appears with any other conversion
     TYPE, the behavior is undefined.

   * TYPE

     TYPE specifies what kind of conversion `printf' performs. Here is
     a table of these:

    `%'
          prints the percent character (`%')

    `c'
          prints ARG as single character

    `s'
          prints characters until precision is reached or a null
          terminator is encountered; takes a string pointer

    `d'
          prints a signed decimal integer; takes an `int' (same as `i')

    `i'
          prints a signed decimal integer; takes an `int' (same as `d')

    `o'
          prints a signed octal integer; takes an `int'

    `u'
          prints an unsigned decimal integer; takes an `int'

    `x'
          prints an unsigned hexadecimal integer (using `abcdef' as
          digits beyond `9'); takes an `int'

    `X'
          prints an unsigned hexadecimal integer (using `ABCDEF' as
          digits beyond `9'); takes an `int'

    `f'
          prints a signed value of the form `[-]9999.9999'; takes a
          floating point number

    `e'
          prints a signed	value of the form
          `[-]9.9999e[+|-]999'; takes a floating point number

    `E'
          prints the same way as `e', but using `E' to introduce the
          exponent; takes a floating point number

    `g'
          prints a signed value in either `f' or `e' form, based on
          given value and precision--trailing zeros and the decimal
          point are printed only if necessary; takes a floating point
          number

    `G'
          prints the same way as `g', but using `E' for the exponent if
          an exponent is needed; takes a floating point number

    `n'
          stores (in the same object) a count of the characters written;
          takes a pointer to `int'

    `p'
          prints a pointer in an implementation-defined format. This
          implementation treats the pointer as an `unsigned long' (same
          as `Lu').

*Returns*
`sprintf' returns the number of bytes in the output string, save that
the concluding `NULL' is not counted. `printf' and `fprintf' return the
number of characters transmitted. If an error occurs, `printf' and
`fprintf' return `EOF'. No error returns occur for `sprintf'.

*Portability*
The  ANSI C standard specifies that implementations must support at
least formatted output of up to 509 characters.


File: libc.i,  Node: sscanf,  Up: stdio

`scanf', `fscanf', `sscanf'--scan and format input
==================================================

*Synopsis*
     #include <stdio.h>
     
     int scanf(const char *FORMAT [, ARG, ...]);
     int fscanf(FILE *FD, const char *FORMAT [, ARG, ...]);
     int sscanf(const char *STR, const char *FORMAT [, ARG, ...]);
   *Description*
`scanf' scans a series of input fields from standard input, one
character at a time.  Each field is interpreted according to a format
specifier passed to `scanf' in the format string at `*FORMAT'.  `scanf'
stores the interpreted input from each field at the address passed to
it as the corresponding argument following FORMAT.  You must supply the
same number of format specifiers and address arguments as there are
input fields.

   There must be sufficient address arguments for the given format
specifiers; if not the results are unpredictable and likely
disasterous.  Excess address arguments are merely ignored.

   `scanf' often produces unexpected results if the input diverges from
an expected pattern. Since the combination of `gets' or `fgets'
followed by `sscanf' is safe and easy, that is the preferred way to be
certain that a program is synchronized with input at the end of a line.

   `fscanf' and `sscanf' are identical to `scanf', other than the
source of input: `fscanf' reads from a file, and `sscanf' from a string.

   The string at `*FORMAT' is a character sequence composed of zero or
more directives. Directives are composed of one or more whitespace
characters, non-whitespace characters, and format specifications.

   Whitespace characters are blank (` '), tab (`\t'), or newline (`\n').
When `scanf' encounters a whitespace character in the format string it
will read (but not store) all consecutive whitespace characters up to
the next non-whitespace character in the input.

   Non-whitespace characters are all other ASCII characters except the
percent sign (`%').  When `scanf' encounters a non-whitespace character
in the format string it will read, but not store a matching
non-whitespace character. Format specifications tell `scanf' to read
and convert characters from the input field into specific types of
values, and store then in the locations specified by the address
arguments.

   Trailing whitespace is left unread unless explicitly matched in the
format string.

   The format specifiers must begin with a percent sign (`%') and have
the following form:

            %[*][WIDTH][SIZE]TYPE

   Each format specification begins with the percent character (`%').
The other fields are:
`*'
     an optional marker; if present, it suppresses interpretation and
     assignment of this input field.

`WIDTH'
     an optional maximum field width: a decimal integer, which controls
     the maximum number of characters that will be read before
     converting the current input field.  If the input field has fewer
     than WIDTH characters, `scanf' reads all the characters in the
     field, and then proceeds with the next field and its format
     specification.

     If a whitespace or a non-convertable character occurs before WIDTH
     character are read, the characters up to that character are read,
     converted, and stored. Then `scanf' proceeds to the next format
     specification.

`size'
     `h', `l', and `L' are optional size characters which override the
     default way that `scanf' interprets the data type of the
     corresponding argument.

              Modifier        Type(s)
                 h         d, i, o, u, x        convert input to short int,
                                                store in short object
          
                 h         D, I, O, U, X        no effect
                           e, f, c, s, n, p
          
                 l         d, i, o, u, x        convert input to long int,
                                                store in long object
          
                 l         e, f, g              convert input to double
                                                store in a double object
          
                 l         D, I, O, U, X        no effect
                           c, s, n, p
          
                 L         d, i, o, u, x        convert to long double,
                                                store in long double
          
                 L        all others            no effect

`TYPE'
     A character to specify what kind of conversion `scanf' performs. 
     Here is a table of the conversion characters:

    `%'
          No conversion is done; the percent character (`%') is stored.

    `c'
          Scans one character.  Corresponding ARG: `(char *arg)'.

    `s'
          Reads a character string into the array supplied.
          Corresponding ARG: `(char arg[])'.

    `[PATTERN]'
          Reads a non-empty character string into memory starting at
          ARG.  This area must be large enough to accept the sequence
          and a terminating null character which will be added
          automatically.  (PATTERN is discussed in the paragraph
          following this table). Corresponding ARG: `(char *arg)'.

    `d'
          Reads a decimal integer into the corresponding ARG: `(int
          *arg)'.

    `D'
          Reads a decimal integer into the corresponding ARG: `(long
          *arg)'.

    `o'
          Reads an octal integer into the corresponding ARG: `(int
          *arg)'.

    `O'
          Reads an octal integer into the corresponding ARG: `(long
          *arg)'.

    `u'
          Reads an unsigned decimal integer into the corresponding ARG:
          `(unsigned int *arg)'.

    `U'
          Reads an unsigned decimal integer into the corresponding ARG:
          `(unsigned long *arg)'.

    `x,X'
          Read a hexadecimal integer into the corresponding ARG: `(int
          *arg)'.

    `e, f, g'
          Read a floating point number into the corresponding ARG:
          `(float *arg)'.

    `E, F, G'
          Read a floating point number into the corresponding ARG:
          `(double *arg)'.

    `i'
          Reads a decimal, octal or hexadecimal integer into the
          corresponding ARG: `(int *arg)'.

    `I'
          Reads a decimal, octal or hexadecimal integer into the
          corresponding ARG: `(long *arg)'.

    `n'
          Stores the number of characters read in the corresponding
          ARG: `(int *arg)'.

    `p'
          Stores a scanned pointer.  This is implementation-defined;
          this implementation treats `%p' exactly the same as `%U'.
          Corresponding ARG: `(void **arg)'.

     A PATTERN of characters surrounded by square brackets can be used
     instead of the `s' type character.  PATTERN is a set of characters
     which define a search set of possible characters making up the
     `scanf' input field.  If the first character in the brackets is a
     caret (`^'), the search set is inverted to include all ASCII
     characters except those between the brackets.  There is also a
     range facility which you can use as a shortcut. `%[0-9] ' matches
     all decimal digits. The hyphen must not be the first or last
     character in the set. The character prior to the hyphen must be
     lexically less than the character after it.

     Here are some PATTERN examples:
    `%[abcd]'
          matches strings containing only `a', `b', `c', and `d'.

    `%[^abcd]'
          matches strings containing any characters except `a', `b',
          `c', or `d'

    `%[A-DW-Z]'
          matches strings containing `A', `B', `C', `D', `W', `X', `Y',
          `Z'

    `%[z-a]'
          matches the characters  `z', `-', and `a'

     Floating point numbers (for field types `e', `f', `g', `E', `F',
     `G') must correspond to the following general form:

          		[+/-] ddddd[.]ddd [E|e[+|-]ddd]

     where objects inclosed in square brackets are optional, and `ddd'
     represents decimal, octal, or hexadecimal digits.

*Returns*
`scanf' returns the number of input fields successfully scanned,
converted and stored; the return value does not include scanned fields
which were not stored.

   If `scanf' attempts to read at end-of-file, the return value is
`EOF'.

   If no fields were stored, the return value is `0'.

   `scanf' might stop scanning a particular field before reaching the
normal field end character, or may terminate entirely.

   `scanf' stops scanning and storing the current field and moves to
the next input field (if any) in any of the following situations:

   * The assignment suppressing character (`*') appears after the `%'
     in the format specification; the current input field is scanned
     but not stored.

   * WIDTH characters have been read (WIDTH is a width specification, a
     positive decimal integer).

   * The next character read cannot be converted under the the current
     format (for example, if a `Z' is read when the format is decimal).

   * The next character in the input field does not appear in the
     search set (or does appear in the inverted search set).

   When `scanf' stops scanning the current input field for one of these
reasons, the next character is considered unread and used as the first
character of the following input field, or the first character in a
subsequent read operation on the input.

   `scanf' will terminate under the following circumstances:

   * The next character in the input field conflicts with a
     corresponding non-whitespace character in the format string.

   * The next character in the input field is `EOF'.

   * The format string has been exhausted.

   When the format string contains a character sequence that is not
part of a format specification, the same character sequence must appear
in the input; `scanf' will scan but not store the matched characters. 
If a conflict occurs, the first conflicting character remains in the
input as if it had never been read.


File: libc.i,  Node: tmpfile,  Up: stdio

`tmpfile'--create a temporary file
==================================

*Synopsis*
     #include <stdio.h>
     FILE *tmpfile(void);
   *Description*
Create a temporary file (a file which will be deleted automatically),
using a name generated by `tmpnam'.  The temporary file is opened with
the mode `"wb+"', permitting you to read and write anywhere in it as a
binary file (without any data transformations the host system may
perform for text files).

*Returns*
`tmpfile' normally returns a pointer to the temporary file.  If no
temporary file could be created, the result is NULL, and `errno'
records the reason for failure.

*Portability*
Both ANSI C and the System V Interface Definition (Issue 2) require
`tmpfile'.


File: libc.i,  Node: tmpnam,  Up: stdio

`tmpnam, tempnam'--generate name for a temporary file
=====================================================

*Synopsis*
     #include <stdio.h>
     char *tmpnam(char *S);
     char *tempnam(char *DIR, char *PFX);
   *Description*
Use either of these functions to generate a name for a temporary file.
The generated name is guaranteed to avoid collision with other files
(for up to `TMP_MAX' calls of either function).

   `tmpnam' generates file names with the value of `P_tmpdir' (defined
in ``stdio.h'') as the leading directory component of the path.

   You can use the `tmpnam' argument S to specify a suitable area of
memory for the generated filename; otherwise, you can call
`tmpnam(NULL)' to use an internal static buffer.

   `tempnam' allows you more control over the generated filename: you
can use the argument DIR to specify the path to a directory for
temporary files, and you can use the argument PFX to specify a prefix
for the base filename.

   If DIR is `NULL', `tempnam' will attempt to use the value of
environment variable `TMPDIR' instead; if there is no such value,
`tempnam' uses the value of `P_tmpdir' (defined in ``stdio.h'').

   If you don't need any particular prefix to the basename of temporary
files, you can pass `NULL' as the PFX argument to `tempnam'.

*Warnings*
The generated filenames are suitable for temporary files, but do not in
themselves make files temporary.  Files with these names must still be
explicitly removed when you no longer want them.

   If you supply your own data area S for `tmpnam', you must ensure
that it has room for at least `L_tmpnam' elements of type `char'.

*Returns*
Both `tmpnam' and `tempnam' return a pointer to the newly generated
filename.

*Portability*
ANSI C requires `tmpnam', but does not specify the use of `P_tmpdir'. 
The System V Interface Definition (Issue 2) requires both `tmpnam' and
`tmpname'.


File: libc.i,  Node: vfprintf,  Up: stdio

`vprintf', `vfprintf', `vsprintf'--format variable argument list
================================================================

*Synopsis*
     #include <stdio.h>
     #include <stdarg.h>
     int vprintf(const char *FMT, va_list LIST);
     int vfprintf(FILE *FP, const char *FMT, va_list LIST);
     int vsprintf(char *STR, const char *FMT, va_list LIST);
   *Description*
`vprintf', `vfprintf', and `vsprintf' are (respectively) variants of
`printf', `fprintf', and `sprintf'.  They differ only in allowing their
caller to pass the variable argument list as a `va_list' object
(initialized by `va_start') rather than directly accepting a variable
number of arguments.

*Returns*
The return values are consistent with the corresponding functions:
`vsprintf' returns the number of bytes in the output string, save that
the concluding `NULL' is not counted. `vprintf' and `vfprintf' return
the number of characters transmitted. If an error occurs, `vprintf' and
`vfprintf' return `EOF'. No error returns occur for `vsprintf'.

*Portability*
ANSI C requires all three functions.


File: libc.i,  Node: stdlib,  Up: top

Standard Utility Functions (`stdlib.h')
***************************************

This chapter groups utility functions useful in a variety of programs.
The corresponding declarations are in the header file `stdlib.h'.

* Menu:

* abort::
* abs::
* assert::
* atexit::
* atof::
* atoi::
* bsearch::
* calloc::
* div::
* efgcvt::
* ecvtbuf::
* exit::
* getenv::
* labs::
* ldiv::
* malloc::
* mbtowc::
* qsort::
* rand::
* strtod::
* strtol::
* strtoul::
* system::
* wctomb::


File: libc.i,  Node: abort,  Up: stdlib


File: libc.i,  Node: abs,  Up: stdlib

`abs'--integer absolute value (magnitude)
=========================================

   *Synopsis*
     #include <stdlib.h>
     int abs(int I);
   *Description*
`abs' returns the absolute value of I (also called the magnitude of I).
 That is, if I is negative, the result is the opposite of I, but if I
is nonnegative the result is I.

   The similar function `labs' uses and returns `long' rather than
`int' values.

*Returns*
The result is a nonnegative integer.

*Portability*
`abs' is ANSI.


File: libc.i,  Node: assert,  Up: stdlib

`assert'--Macro for Debugging Diagnostics
=========================================

*Synopsis*
     #include <assert.h>
     #include <stdlib.h>
     void assert(int EXPRESSION);
   *Description*
Use this macro to embed debuggging diagnostic statements in your
programs.  The argument EXPRESSION should be an expression which
evaluates to true (nonzero) when your program is working as you
intended.

   When EXPRESSION evaluates to false (zero), `assert' calls `abort',
after first printing a message showing what failed and where:

      Assertion failed: EXPRESSION, file FILENAME, line LINENO

   The macro is defined to permit you to turn off all uses of `assert'
at compile time by defining `NDEBUG' as a preprocessor variable.   If
you do this, the `assert' macro expands to

      (void(0))

*Returns*
`assert' does not return a value.

*Portability*
The `assert' macro is required by ANSI, as is the behavior when
`NDEBUG' is defined.


File: libc.i,  Node: atexit,  Up: stdlib

`atexit'--request execution of functions at program exit
========================================================

*Synopsis*
     #include <stdlib.h>
     int atexit(void (*FUNCTION)(void);
   *Description*
You can use `atexit' to enroll functions in a list of functions that
will be called when your program terminates normally.  The argument is
a pointer to a user-defined function (which must not require arguments
and must not return a result).

   The functions are kept in a LIFO stack; that is, the last function
enrolled by `atexit' will be the first to execute when your program
exits.

   There is no built-in limit to the number of functions you can enroll
in this list; however, after every group of 32 functions is enrolled,
`atexit' will call `malloc' to get space for the next part of the list.
  The initial list of 32 functions is statically allocated, so you can
always count on at least that many slots available.

*Returns*
`atexit' returns `0' if it succeeds in enrolling your function, `-1' if
it fails (possible only if no space was available for `malloc' to
extend the list of functions).

*Portability*
`atexit' is required by the ANSI standard, which also specifies that
implementations must support enrolling at least 32 functions.


File: libc.i,  Node: atof,  Up: stdlib

`atof', `atoff'--string to double or float
==========================================

*Synopsis*
     #include <stdlib.h>
     double atof(const char *S);
     float atoff(const char *S);
   *Description*
`atof' converts the initial portion of a string to a `double'. `atoff'
converts the initial portion of a string to a `float'.

   The functions parse the character string S, locating a substring
which can be converted to a floating point value. The substring must
match the format:
      [+|-]DIGITS[.][DIGITS][(e|E)[+|-]DIGITS]
   The substring converted is the longest initial fragment of S that
has the expected format, beginning with the first non-whitespace
character.  The substring is empty if `str' is empty, consists entirely
of whitespace, or if the first non-whitespace character is something
other than `+', `-', `.', or a digit.

   `atof(S)' is implemented as `strtod(S, NULL)'. `atoff(S)' is
implemented as `strtodf(S, NULL)'.

*Returns*
`atof' returns the converted substring value, if any, as a `double'; or
`0.0',  if no conversion could be performed. If the correct value is
out of the range of representable values, plus or minus `HUGE_VAL' is
returned, and `ERANGE' is stored in `errno'. If the correct value would
cause underflow, `0.0' is returned and `ERANGE' is stored in `errno'.

   `atoff' obeys the same rules as `atof', except that it returns a
`float'.


File: libc.i,  Node: atoi,  Up: stdlib

`atoi', `atol'--string to integer
=================================

*Synopsis*
     #include <stdlib.h>
     int atoi(const char *S);
     long atol(const char *S);
   *Description*
`atoi' converts the initial portion of a string to an `int'. `atok'
converts the initial portion of a string to a `long'.

   `atoi(s)' is implemented as `(int)strtol(s, NULL, 10).' `atol(s)' is
implemented as `strtol(s, NULL, 10).'

*Returns*
The functions return the converted value, if any. If no conversion was
made, `0' is returned.


File: libc.i,  Node: bsearch,  Up: stdlib

`bsearch'--binary search
========================

*Synopsis*
     #include <stdlib.h>
     void *bsearch(const void *KEY, const void *BASE,
         size_t NMEMB, size_t SIZE,
         int (*COMPAR)(const void *, const void *));
   *Description*
`bsearch' searches an array beginning at BASE for any element that
matches KEY, using binary search.  NMEMB is the element count of the
array; SIZE is the size of each element.

   The array must be sorted in ascending order with respect to the
comparison function COMPAR (which you supply as the last argument of
`bsearch').

   You must define the comparison function `(*COMPAR)' to have two
arguments; its result must be negative if the first argument is less
than the second, zero if the two arguments match, and positive if the
first argument is greater than the second (where "less than" and
"greater than" refer to whatever arbitrary ordering is appropriate).

*Returns*
Returns a pointer to an element of ARRAY that matches KEY.  If more
than one matching element is available, the result may point to any of
them.

*Portability*
`bsearch' is ANSI.


File: libc.i,  Node: calloc,  Up: stdlib

`calloc'--allocate space for arrays
===================================

*Synopsis*
     #include <stdlib.h>
     void *calloc(size_t N, size_t S);
   *Description*
Use `calloc' to request a block of memory sufficient to hold an array
of N elements, each of which has size S.

   The memory allocated by `calloc' comes out of the same memory pool
used by `malloc', but the memory block is initialized to all zero
bytes.  (To avoid the overhead of initializing the space, use `malloc'
instead.)

*Returns*
If successful, a pointer to the newly allocated space.

   If unsuccessful, `NULL'.

*Portability*
`calloc' is ANSI.


File: libc.i,  Node: div,  Up: stdlib

`div'--divide two integers
==========================

*Synopsis*
     #include <stdlib.h>
     div_t div(int N, int D);
   *Description*
Divide N/D, returning quotient and remainder as two integers in a
structure `div_t'.

*Returns*
The result is represented with the structure

      typedef struct
      {
       int quot;
       int rem;
      } div_t;

   where the `quot' field represents the quotient, and `rem' the
remainder.  For nonzero D, if ``R = div(N,D);'' then N equals ``R.rem +
D*R.quot''.

   When D is zero, the `quot' member of the result has the same sign as
N and the largest representable magnitude.

   To divide `long' rather than `int' values, use the similar function
`ldiv'.

*Portability*
`div' is ANSI, but the behavior for zero D is not specified by the
standard.


File: libc.i,  Node: efgcvt,  Up: stdlib

`ecvt',`ecvtf',`fcvt',`fcvtf'--double or float to string of digits
==================================================================

*Synopsis*
     #include <stdlib.h>
     
     char *ecvt(double VAL, int CHARS, int *DECPT, int *SGN);
     char *ecvtf(float VAL, int CHARS, int *DECPT, int *SGN);
     
     char *fcvt(double VAL, int DECIMALS, int *DECPT, int *SGN);
     char *fcvtf(float VAL, int DECIMALS, int *DECPT, int *SGN);
   *Description*
`ecvt' and `fcvt' produce (null-terminated) strings of digits
representating the `double' number VAL. `ecvtf' and `fcvtf' produce the
corresponding character representations of `float' numbers.

   (The `stdlib' functions `ecvtbuf' and `fcvtbuf' are reentrant
versions of `ecvt' and `fcvt'.)

   The only difference between `ecvt' and `fcvt' is the interpretation
of the second argument (CHARS or DECIMALS). For `ecvt', the second
argument CHARS specifies the total number of characters to write (which
is also the number of significant digits in the formatted string, since
these two functions write only digits). For `fcvt', the second argument
DECIMALS specifies the number of characters to write after the decimal
point; all digits for the integer part of VAL are always included.

   Since `ecvt' and `fcvt' write only digits in the output string, they
record the location of the decimal point in `*DECPT', and the sign of
the number in `*SGN'.  After formatting a number, `*DECPT' contains the
number of digits to the left of the decimal point.  `*SGN' contains `0'
if the number is positive, and `1' if it is negative.

*Returns*
All four functions return a pointer to the new string containing a
character representation of VAL.

*Portability*
None of these functions are ANSI C.

`gvcvt', `gcvtf'--format double or float as string
==================================================

*Synopsis*
     #include <stdlib.h>
     
     char *gcvt(double VAL, int PRECISION, char *BUF);
     char *gcvtf(float VAL, int PRECISION, char *BUF);
   *Description*
`gcvt' writes a fully formatted number as a null-terminated string in
the buffer `*BUF'.  `gdvtf' produces corresponding character
representations of `float' numbers.

   `gcvt' uses the same rules as the `printf' format
``%.PRECISIONg''--only negative values are signed (with ``-''), and
either exponential or ordinary decimal-fraction format is chosen
depending on the number of significant digits (specified by PRECISION).

*Returns*
The result is a pointer to the formatted representation of VAL (the
same as the argument BUF).

*Portability*
Neither function is ANSI C.


File: libc.i,  Node: ecvtbuf,  Up: stdlib

`ecvtbuf', `fcvtbuf'--double or float to string of digits
=========================================================

*Synopsis*
     #include <stdio.h>
     
     char *ecvtbuf(double VAL, int CHARS, int *DECPT, int *SGN, char *BUF);
     
     char *fcvtbuf(double VAL, int DECIMALS, int *DECPT, int *SGN, char *BUF);
   *Description*
`ecvtbuf' and `fcvtbuf' produce (null-terminated) strings of digits
representating the `double' number VAL.

   The only difference between `ecvtbuf' and `fcvtbuf' is the
interpretation of the second argument (CHARS or DECIMALS). For
`ecvtbuf', the second argument CHARS specifies the total number of
characters to write (which is also the number of significant digits in
the formatted string, since these two functions write only digits). For
`fcvtbuf', the second argument DECIMALS specifies the number of
characters to write after the decimal point; all digits for the integer
part of VAL are always included.

   Since `ecvtbuf' and `fcvtbuf' write only digits in the output
string, they record the location of the decimal point in `*DECPT', and
the sign of the number in `*SGN'. After formatting a number, `*DECPT'
contains the number of digits to the left of the decimal point.  `*SGN'
contains `0' if the number is positive, and `1' if it is negative.  For
both functions, you supply a pointer BUF to an area of memory to hold
the converted string.

*Returns*
Both functions return a pointer to BUF, the string containing a
character representation of VAL.

*Portability*
Neither function is ANSI C.


File: libc.i,  Node: exit,  Up: stdlib

`exit'--end program execution
=============================

*Synopsis*
     #include <stdlib.h>
     void exit(int CODE);
   *Description*
Use `exit' to return control from a program to the host operating
environment.  Use the argument CODE to pass an exit status to the
operating environment: two particular values, `EXIT_SUCCESS' and
`EXIT_FAILURE', are defined in ``stdlib.h'' to indicate success or
failure in a portable fashion.

   `exit' does two kinds of cleanup before ending execution of your
program.  First, it calls all application-defined cleanup functions you
have enrolled with `atexit'.  Second, files and streams are cleaned up:
any pending output is delivered to the host system, each open file or
stream is closed, and files created by `tmpfile' are deleted.

*Returns*
`exit' does not return to its caller.

*Portability*
ANSI C requires `exit', and specifies that `EXIT_SUCCESS' and
`EXIT_FAILURE' must be defined.


File: libc.i,  Node: getenv,  Up: stdlib

`getenv'--look up environment variable
======================================

*Synopsis*
     #include <stdlib.h>
     char *getenv(const char *NAME);
   *Description*
`getenv' searches the list of environment variable names and values
(using the global pointer ``char **environ'') for a variable whose name
matches the string at NAME.  If a variable name matches, `getenv'
returns a pointer to the associated value.

*Returns*
A pointer to the (string) value of the environment variable, or `NULL'
if there is no such environment variable.

*Portability*
`getenv' is ANSI, but the rules for properly forming names of
environment variables vary from one system to another.


File: libc.i,  Node: labs,  Up: stdlib

`labs'--long integer absolute value (magnitude)
===============================================

*Synopsis*
     #include <stdlib.h>
     long labs(long I);
   *Description*
`labs' returns the absolute value of I (also called the magnitude of
I).  That is, if I is negative, the result is the opposite of I, but if
I is nonnegative the result is I.

   The similar function `abs' uses and returns `int' rather than `long'
values.

*Returns*
The result is a nonnegative long integer.

*Portability*
`labs' is ANSI.


File: libc.i,  Node: ldiv,  Up: stdlib

`ldiv'--divide two long integers
================================

*Synopsis*
     #include <stdlib.h>
     ldiv_t ldiv(long N, long D);
   *Description*
Divide N/D, returning quotient and remainder as two integers in a
structure `ldiv_t'.

*Returns*
The result is represented with the structure

      typedef struct
      {
       long quot;
       long rem;
      } ldiv_t;

   where the `quot' field represents the quotient, and `rem' the
remainder.  For nonzero D, if ``R = ldiv(N,D);'' then N equals ``R.rem
+ D*R.quot''.

   When D is zero, the `quot' member of the result has the same sign as
N and the largest representable magnitude.

   To divide `int' rather than `long' values, use the similar function
`div'.

*Portability*
`ldiv' is ANSI, but the behavior for zero D is not specified by the
standard.


File: libc.i,  Node: malloc,  Up: stdlib

`malloc', `realloc', `free'--allocate and manage memory
=======================================================

*Synopsis*
     #include <stdlib.h>
     void *malloc(size_t NBYTES);
     void *realloc(void *APTR, size_t NBYTES);
     void free(void *APTR);
   *Description*
These three functions manage a pool of system memory.

   Use `malloc' to request allocation of an object with at least NBYTES
bytes of storage available.  If the space is available, `malloc'
returns a pointer to a newly allocated block as its result.

   If you already have a block of storage allocated by `malloc', but
you no longer need all the space allocated to it, you can make it
smaller by calling `realloc' with both the object pointer and the new
desired size as arguments.  `realloc' guarantees that the contents of
the smaller object match the beginning of the original object.

   Similarly, if you need more space for an object, use `realloc' to
request the larger size; again, `realloc' guarantees that the beginning
of the new, larger object matches the contents of the original object.

   When you no longer need an object originally allocated by `malloc'
or `realloc' (or the related function `calloc'), return it to the
memory storage pool by calling `free' with the address of the object as
the argument.  You can also use `realloc' for this purpose by calling
it with `0' as the NBYTES argument.

*Returns*
`malloc' returns a pointer to the newly allocated space, if successful;
otherwise it returns `NULL'.  If your application needs to generate
empty objects, you may use `malloc(0)' for this purpose.

   `realloc' returns a pointer to the new block of memory, or `NULL' if
a new block could not be allocated.  `NULL' is also the result when you
use ``realloc(APTR,0)'' (which has the same effect as ``free(APTR)''). 
You should always check the result of `realloc'; successful
reallocation is not guaranteed even when you request a smaller object.

   `free' does not return a result.

*Portability*
`malloc', `realloc', and `free' are specified by the ANSI C standard,
but other conforming implementations of `malloc' may behave differently
when NBYTES is zero.


File: libc.i,  Node: mbtowc,  Up: stdlib

`mbtowc'--minimal multibyte to wide character converter
=======================================================

*Synopsis*
     #include <stdlib.h>
     int mbtowc(wchar_t *PWC, const char *S, size_t N);
   *Description*
This is a minimal ANSI-conforming implementation of `mbtowc'.  The only
"multi-byte character sequences" recognized are single bytes, and they
are "converted" to themselves.

   Each call to `mbtowc' copies one character from `*S' to `*PWC',
unless S is a null pointer.

   In this implementation, the argument N is ignored.

*Returns*
This implementation of `mbtowc' returns `0' if S is `NULL'; it returns
`1' otherwise (reporting the length of the character "sequence" used).

*Portability*
`mbtowc' is required in the ANSI C standard.  However, the precise
effects vary with the locale.


File: libc.i,  Node: qsort,  Up: stdlib

`qsort'--sort an array
======================

*Synopsis*
     #include <stdlib.h>
     void qsort(void *BASE, size_t NMEMB, size_t SIZE,
         int (*COMPAR)(const void *, const void *) );
   *Description*
`qsort' sorts an array (beginning at BASE) of NMEMB objects. SIZE
describes the size of each element of the array.

   You must supply a pointer to a comparison function, using the
argument shown as COMPAR.  (This permits sorting objects of unknown
properties.)  Define the comparison function to accept two arguments,
each a pointer to an element of the array starting at BASE.  The result
of `(*COMPAR)' must be negative if the first argument is less than the
second, zero if the two arguments match, and positive if the first
argument is greater than the second (where "less than" and "greater
than" refer to whatever arbitrary ordering is appropriate).

   The array is sorted in place; that is, when `qsort' returns, the
array elements beginning at BASE have been reordered.

*Returns*
`qsort' does not return a result.

*Portability*
`qsort' is required by ANSI (without specifying the sorting algorithm).


File: libc.i,  Node: rand,  Up: stdlib

`rand, srand'--pseudo-random numbers
====================================

*Synopsis*
     #include <stdlib.h>
     int rand(void);
     void srand(unsigned int SEED);
   *Description*
`rand' returns a different integer each time it is called; each integer
is chosen by an algorithm designed to be unpredictable, so that you can
use `rand' when you require a random number.

   The algorithm depends on a static variable called the "random seed";
starting with a given value of the random seed always produces the same
sequence of numbers in successive calls to `rand'.

   You can set the random seed using `srand'; it does nothing beyond
storing its argument in the static variable used by `rand'.  You can
exploit this to make the pseudo-random sequence less predictable, if
you wish, by using some other unpredictable value (often the least
significant parts of a time-varying value) as the random seed before
beginning a sequence of calls to `rand'; or, if you wish to ensure (for
example, while debugging) that successive runs of your program use the
same "random" numbers, you can use `srand' to set the same random seed
at the outset.

*Returns*
`rand' returns the next pseudo-random integer in sequence; it is a
number between `0' and `RAND_MAX' (inclusive).

   `srand' does not return a result.

*Portability*
`rand' is required by ANSI, but the algorithm for pseudo-random number
generation is not specified; therefore, even if you use the same random
seed, you cannot expect the same sequence of results on two different
systems.


File: libc.i,  Node: strtod,  Up: stdlib

`strtod', `strtodf'--string to double or float
==============================================

*Synopsis*
     #include <stdlib.h>
     double strtod(const char *STR, char **TAIL);
     float strtodf(const char *STR, char **TAIL);
   *Description*
The function `strtod' parses the character string STR, producing a
substring which can be converted to a double value.  The substring
converted is the longest initial subsequence of STR, beginning with the
first non-whitespace character, that has the format:
     [+|-]DIGITS[.][DIGITS][(e|E)[+|-]DIGITS] The
   substring contains no characters if STR is empty, consists entirely
of whitespace, or if the first non-whitespace character is something
other than `+', `-', `.', or a digit. If the substring is empty, no
conversion is done, and the value of STR is stored in `*TAIL'. 
Otherwise, the substring is converted, and a pointer to the final string
(which will contain at least the terminating null character of STR) is
stored in `*TAIL'.  If you want no assignment to `*TAIL', pass a null
pointer as TAIL. `strtodf' is identical to `strtod' except for its
return type.

   This implementation returns the nearest machine number to the input
decimal string, ties are borken by using the IEEE round-even rule.

*Returns*
`strtod' returns the converted substring value, if any.  If no
conversion could be performed, 0 is returned.  If the correct value is
out of the range of representable values, plus or minus `HUGE_VAL' is
returned, and `ERANGE' is stored in errno. If the correct value would
cause underflow, 0 is returned and `ERANGE' is stored in errno.


File: libc.i,  Node: strtol,  Up: stdlib

`strtol'--string to long
========================

*Synopsis*
     #include <stdlib.h>
     long strtol(const char *S, char **PTR,int BASE);
   *Description*
The function `strtol' converts the string `*S' to a `long'. First, it
breaks down the string into three parts: leading whitespace, which is
ignored; a subject string consisting of characters resembling an
integer in the radix specified by BASE; and a trailing portion
consisting of zero or more unparseable characters, and always including
the terminating null character. Then, it attempts to convert the
subject string into a `long' and returns the result.

   If the value of BASE is 0, the subject string is expected to look
like a normal C integer constant: an optional sign, a possible ``0x''
indicating a hexadecimal base, and a number. If BASE is between 2 and
36, the expected form of the subject is a sequence of letters and
digits representing an integer in the radix specified by BASE, with an
optional plus or minus sign. The letters `a'--`z' (or, equivalently,
`A'--`Z') are used to signify values from 10 to 36; only letters whose
ascribed values are less than BASE are permitted. If BASE is 16, a
leading `0x' is permitted.

   The subject sequence is the longest initial sequence of the input
string that has the expected form, starting with the first
non-whitespace character.  If the string is empty or consists entirely
of whitespace, or if the first non-whitespace character is not a
permissible letter or digit, the subject string is empty.

   If the subject string is acceptable, and the value of BASE is zero,
`strtol' attempts to determine the radix from the input string. A
string with a leading `0x' is treated as a hexadecimal value; a string
with a leading 0 and no `x' is treated as octal; all other strings are
treated as decimal. If BASE is between 2 and 36, it is used as the
conversion radix, as described above. If the subject string begins with
a minus sign, the value is negated. Finally, a pointer to the first
character past the converted subject string is stored in PTR, if PTR is
not `NULL'.

   If the subject string is empty (or not in acceptable form), no
conversion is performed and the value of S is stored in PTR (if PTR is
not `NULL').

*Returns*
`strtol' returns the converted value, if any. If no conversion was
made, 0 is returned.

   `strtol' returns `LONG_MAX' or `LONG_MIN' if the magnitude of the
converted value is too large, and sets `errno' to `ERANGE'.

*Portability*
`strtol' is ANSI.


File: libc.i,  Node: strtoul,  Up: stdlib

`strtoul'--string to unsigned long
==================================

*Synopsis*
     #include <stdlib.h>
     unsigned long strtoul(const char *S, char **PTR, int BASE);
   *Description*
The function `strtoul' converts the string `*S' to an `unsigned long'.
First, it breaks down the string into three parts: leading whitespace,
which is ignored; a subject string consisting of the digits meaningful
in the radix specified by BASE (for example, `0' through `7' if the
value of BASE is 8); and a trailing portion consisting of one or more
unparseable characters, which always includes the terminating null
character. Then, it attempts to convert the subject string into an
unsigned long integer, and returns the result.

   If the value of BASE is zero, the subject string is expected to look
like a normal C integer constant (save that no optional sign is
permitted): a possible `0x' indicating hexadecimal radix, and a number.
If BASE is between 2 and 36, the expected form of the subject is a
sequence of digits (which may include letters, depending on the base)
representing an integer in the radix specified by BASE. The letters
`a'--`z' (or `A'--`Z') are used as digits valued from 10 to 36. If BASE
is 16, a leading `0x' is permitted.

   The subject sequence is the longest initial sequence of the input
string that has the expected form, starting with the first
non-whitespace character.  If the string is empty or consists entirely
of whitespace, or if the first non-whitespace character is not a
permissible digit, the subject string is empty.

   If the subject string is acceptable, and the value of BASE is zero,
`strtoul' attempts to determine the radix from the input string. A
string with a leading `0x' is treated as a hexadecimal value; a string
with a leading `0' and no `x' is treated as octal; all other strings are
treated as decimal. If BASE is between 2 and 36, it is used as the
conversion radix, as described above. Finally, a pointer to the first
character past the converted subject string is stored in PTR, if PTR is
not `NULL'.

   If the subject string is empty (that is, if `*'S does not start with
a substring in acceptable form), no conversion is performed and the
value of S is stored in PTR (if PTR is not `NULL').

*Returns*
`strtoul' returns the converted value, if any. If no conversion was
made, `0' is returned.

   `strtoul' returns `ULONG_MAX' if the magnitude of the converted
value is too large, and sets `errno' to `ERANGE'.

*Portability*
`strtoul' is ANSI.


File: libc.i,  Node: system,  Up: stdlib

`system'--execute command string
================================

*Synopsis*
     #include <stdlib.h>
     int system(char *S);
   *Description*
Use `system' to pass a command string `*S' to a command processor on
your system, and wait for it to finish executing. `system' uses the
value of environment variable `SHELL' as the name of the command
processor.

   Use ``system(NULL)'' to test whether your system has a command
processor available.

*Returns*
`system(NULL)' returns a non-zero value if a command processor is
available, and `0' if there is no command processor.

   With a command argument, the result of `system' is the exit status
returned by the command processor.

*Portability*
ANSI C requires `system', but leaves the nature and effects of a
command processor undefined.  ANSI C does, however, specify that
`system(NULL)' return zero or nonzero to report on the existence of a
command processor.


File: libc.i,  Node: wctomb,  Up: stdlib

`wctomb'--minimal wide character to multibyte converter
=======================================================

*Synopsis*
     #include <stdlib.h>
     int wctomb(char *S, wchar_t WCHAR);
   *Description*
This is a minimal ANSI-conforming implementation of `wctomb'.  The only
"wide characters" recognized are single bytes, and they are "converted"
to themselves.

   Each call to `wctomb' copies the character WCHAR to `*S', unless S
is a null pointer.

*Returns*
This implementation of `wctomb' returns `0' if S is `NULL'; it returns
`1' otherwise (reporting the length of the character "sequence"
generated).

*Portability*
`wctomb' is required in the ANSI C standard.  However, the precise
effects vary with the locale.


File: libc.i,  Node: locale,  Up: top

Locale (`locale.h')
*******************

A "locale" is the name for a collection of parameters (affecting
collating sequences and formatting conventions) that may be different
depending on location or culture.  The `"C"' locale is the only one
defined in the ANSI C standard.

   `locale.h' defines the structure `lconv' to collect the information
on a locale, with the following fields:

`char *decimal_point'
     The decimal point character used to format "ordinary" numbers (all
     numbers except those referring to amounts of money).  `"."' in the
     C locale.

`char *thousands_sep'
     The character (if any) used to separate groups of digits, when
     formatting ordinary numbers. `""' in the C locale.

`char *grouping'
     Specifications for how many digits to group (if any grouping is
     done at all) when formatting ordinary numbers.  The *numeric
     value* of each character in the string represents the number of
     digits for the next group, and a value of `0' (that is, the
     string's trailing `NULL') means to continue grouping digits using
     the last value specified.  Use `CHAR_MAX' to indicate that no
     further grouping is desired.  `""' in the C locale.

`char *int_curr_symbol'
     The international currency symbol (first three characters), if
     any, and the character used to separate it from numbers. `""' in
     the C locale.

`char *currency_symbol'
     The local currency symbol, if any. `""' in the C locale.

`char *mon_decimal_point'
     The symbol used to delimit fractions in amounts of money. `""' in
     the C locale.

`char *mon_thousands_sep'
     Similar to `thousands_sep', but used for amounts of money. `""' in
     the C locale.

`char *mon_grouping'
     Similar to `grouping', but used for amounts of money. `""' in the
     C locale.

`char *positive_sign'
     A string to flag positive amounts of money when formatting. `""'
     in the C locale.

`char *negative_sign'
     A string to flag negative amounts of money when formatting. `""'
     in the C locale.

`char int_frac_digits'
     The number of digits to display when formatting amounts of money to
     international conventions. `CHAR_MAX' (the largest number
     representable as a `char') in the C locale.

`char frac_digits'
     The number of digits to display when formatting amounts of money to
     local conventions. `CHAR_MAX' in the C locale.

`char p_cs_precedes'
     `1' indicates the local currency symbol is used before a *positive
     or zero* formatted amount of money; `0' indicates the currency
     symbol is placed after the formatted number. `CHAR_MAX' in the C
     locale.

`char p_sep_by_space'
     `1' indicates the local currency symbol must be separated from
     *positive or zero* numbers by a space; `0' indicates that it is
     immediately adjacent to numbers. `CHAR_MAX' in the C locale.

`char n_cs_precedes'
     `1' indicates the local currency symbol is used before a
     *negative* formatted amount of money; `0' indicates the currency
     symbol is placed after the formatted number. `CHAR_MAX' in the C
     locale.

`char n_sep_by_space'
     `1' indicates the local currency symbol must be separated from
     *negative* numbers by a space; `0' indicates that it is
     immediately adjacent to numbers. `CHAR_MAX' in the C locale.

`char p_sign_posn'
     Controls the position of the *positive* sign for numbers
     representing money.  `0' means parentheses surround the number;
     `1' means the sign is placed before both the number and the
     currency symbol; `2' means the sign is placed after both the number
     and the currency symbol; `3' means the sign is placed just before
     the currency symbol; and `4' means the sign is placed just after
     the currency symbol. `CHAR_MAX' in the C locale.

`char n_sign_posn'
     Controls the position of the *negative* sign for numbers
     representing money, using the same rules as `p_sign_posn'.
     `CHAR_MAX' in the C locale.

* Menu:

* setlocale::


File: libc.i,  Node: setlocale,  Up: locale

`setlocale', `localeconv'--select or query locale
=================================================

   *Synopsis*
     #include <locale.h>
     char *setlocale(int CATEGORY, const char *LOCALE);
     lconv *localeconv(void);
   *Description*
`setlocale' is the facility defined by ANSI C to condition the
execution environment for various international collating and
formatting information; `localeconv' reports on the settings of the
current locale.

   This is a minimal implementation, supporting only the required `"C"'
value for LOCALE; strings representing other locales are not honored. 
(`""' is also accepted; it represents the default locale for an
implementation, here equivalent to `"C"'.)

   If you use `NULL' as the LOCALE argument, `setlocale' returns a
pointer to the string representing the current locale (always `"C"' in
this implementation).

   The acceptable values for CATEGORY are defined in ``locale.h'' as
macros beginning with `"LC_"', but this implementation does not check
the values you pass in the CATEGORY argument.

   `localeconv' returns a pointer to a structure (also defined in
``locale.h'') describing the locale-specific conventions currently in
effect.

*Returns*
`setlocale' returns either a pointer to a string naming the locale
currently in effect (always `"C"' for this implementation), or, if the
locale request cannot be honored, `NULL'.

   `localeconv' returns a pointer to a structure of type `lconv', which
describes the formatting and collating conventions in effect (in this
implementation, always those of the C locale).

*Portability*
ANSI C requires `setlocale', but the only locale required across all
implementations is the C locale.


File: libc.i,  Node: syscalls,  Up: Top

System calls
************

This chapter needs to be written


File: libc.i,  Node: machine,  Up: Top

Machine specific functions
**************************

   This chapter needs to be written


File: libc.i,  Node: arglists,  Up: Top

Variable Argument Lists (`stdarg.h', `varargs.h')
*************************************************

   The `printf' family of functions is defined to accept a variable
number of arguments, rather than a fixed argument list.  You can define
your own functions with a variable argument list, by using macro
definitions from either `stdarg.h' (for compatibility with ANSI C) or
from `varargs.h' (for compatibility with a popular convention prior to
ANSI C).

* Menu:

* stdarg::
* varargs::


File: libc.i,  Node: stdarg,  Next: varargs,  Prev: arglists,  Up: arglists

ANSI-standard macros, `stdarg.h'
================================

   In ANSI C, a function has a variable number of arguments when its
parameter list ends in an ellipsis (`...').  The parameter list must
also include at least one explicitly named argument; that argument is
used to initialize the variable list data structure.

   ANSI C defines three macros (`va_start', `va_arg', and `va_end') to
operate on variable argument lists.  `stdarg.h' also defines a special
type to represent variable argument lists: this type is called
`va_list'.

* Menu:

* va_start::
* va_arg::
* va_end::


File: libc.i,  Node: va_start,  Next: va_arg,  Prev: stdarg,  Up: stdarg

Initialize variable argument list
---------------------------------

   *Synopsis*
     #include <stdarg.h>
     void va_start(va_list AP, RIGHTMOST);

   *Description*
Use `va_start' to initialize the variable argument list AP, so that
`va_arg' can extract values from it.  RIGHTMOST is the name of the last
explicit argument in the parameter list (the argument immediately
preceding the ellipsis `...' that flags variable arguments in an ANSI C
function header).  You can only use `va_start' in a function declared
using this ellipsis notation (not, for example, in one of its
subfunctions).

   *Returns*
`va_start' does not return a result.

   *Portability*
ANSI C requires `va_start'.


File: libc.i,  Node: va_arg,  Next: va_end,  Prev: va_start,  Up: stdarg

Extract a value from variable argument list
-------------------------------------------

   *Synopsis*
     #include <stdarg.h>
     TYPE va_arg(va_list AP, TYPE);

   *Description*
`va_arg' returns the next unprocessed value from a variable argument
list AP (which you must previously create with VA_START).  Specify the
type for the value as the second parameter to the macro, TYPE.

   You may pass a `va_list' object AP to a subfunction, and use
`va_arg' from the subfunction rather than from the function actually
declared with an ellipsis in the header; however, in that case you may
*only* use `va_arg' from the subfunction.  ANSI C does not permit
extracting successive values from a single variable-argument list from
different levels of the calling stack.

   There is no mechanism for testing whether there is actually a next
argument available; you might instead pass an argument count (or some
other data that implies an argument count) as one of the fixed arguments
in your function call.

   *Returns*
`va_arg' returns the next argument, an object of type TYPE.

   *Portability*
ANSI C requires `va_arg'.


File: libc.i,  Node: va_end,  Prev: va_arg,  Up: stdarg

Abandon a variable argument list
--------------------------------

   *Synopsis*
     #include <stdarg.h>
     void va_end(va_list AP);

   *Description*
Use `va_end' to declare that your program will not use the variable
argument list AP any further.

   *Returns*
`va_end' does not return a result.

   *Portability*
ANSI C requires `va_end'.


File: libc.i,  Node: varargs,  Prev: stdarg,  Up: arglists

Traditional macros, `varargs.h'
===============================

   If your C compiler predates ANSI C, you may still be able to use
variable argument lists using the macros from the `varargs.h' header
file.  These macros resemble their ANSI counterparts, but have
important differences in usage.   In particular, since traditional C has
no declaration mechanism for variable argument lists, two additional
macros are provided simply for the purpose of defining functions with
variable argument lists.

   As with `stdarg.h', the type `va_list' is used to hold a data
structure representing a variable argument list.

* Menu:

* va_alist::
* va_start-trad::
* va_arg-trad::
* va_end-trad::


File: libc.i,  Node: va_alist,  Next: va_start-trad,  Prev: varargs,  Up: varargs

Declare variable arguments
--------------------------

   *Synopsis*
     #include <varargs.h>
     FUNCTION(va_alist)
     va_dcl

   *Description*
To use the `varargs.h' version of variable argument lists, you must
declare your function with a call to the macro `va_alist' as its
argument list, and use `va_dcl' as the declaration.  *Do not use a
semicolon after `va_dcl'.*

   *Returns*
These macros cannot be used in a context where a return is syntactically
possible.

   *Portability*
VA_ALIST and VA_DCL were the most widespread method of declaring
variable argument lists prior to ANSI C.


File: libc.i,  Node: va_start-trad,  Next: va_arg-trad,  Prev: va_alist,  Up: varargs

Initialize variable argument list
---------------------------------

   *Synopsis*
     #include <varargs.h>
     va_list AP;
     va_start(AP);

   *Description*
With the `varargs.h' macros, use `va_start' to initialize a data
structure AP to permit manipulating a variable argument list. AP must
have the type VA_ALIST.

   *Returns*
`va_start' does not return a result.

   *Portability*
`va_start' is also defined as a macro in ANSI C, but the definitions
are incompatible; the ANSI version has another parameter besides AP.


File: libc.i,  Node: va_arg-trad,  Next: va_end-trad,  Prev: va_start-trad,  Up: varargs

Extract a value from variable argument list
-------------------------------------------

   *Synopsis*
     #include <varargs.h>
     TYPE va_arg(va_list AP, TYPE);

   *Description*
`va_arg' returns the next unprocessed value from a variable argument
list AP (which you must previously create with VA_START).  Specify the
type for the value as the second parameter to the macro, TYPE.

   *Returns*
`va_arg' returns the next argument, an object of type TYPE.

   *Portability*
The `va_arg' defined in `varargs.h' has the same syntax and usage as
the ANSI C version from `stdarg.h'.


File: libc.i,  Node: va_end-trad,  Prev: va_arg-trad,  Up: varargs

Abandon a variable argument list
--------------------------------

   *Synopsis*
     #include <varargs.h>
     va_end(va_list AP);

   *Description*
Use `va_end' to declare that your program will not use the variable
argument list AP any further.

   *Returns*
`va_end' does not return a result.

   *Portability*
The `va_end' defined in `varargs.h' has the same syntax and usage as
the ANSI C version from `stdarg.h'.


File: libc.i,  Node: reentrancy,  Up: Top

Reentrancy
**********

   Whenever possible, these library functions are reentrant. 
Nevertheless, many functions within this library cannot be defined
reentrantly.

   For example, the ANSI C function `strtok' keeps a pointer to an area
of memory supplied by the caller in static memory. If two different
processes in the same memory space interleave calls, `strtok' will
return incorrect results.

   Another case is `ecvt'.  This function fills an internal buffer with
the character representation of a `double' number, then returns a
pointer to the internal buffer.  If a second caller runs `ecvt' before
the first caller uses the data in the buffer, the data is overwritten. 
In this instance, another function `ecvtbuf' is available.  The
application provides `ecvtbuf' with a pointer to its own private buffer
space, so other processes cannot overwrite the data.

   More insidious is the operation of the `matherr' function.  By
default, when a math function detects an error it sets the static
variable `errno'.  Depending upon the severity of the error, it may
also print a message to `stderr'.  None of this behavior is reentrant. 
When one process detects an error, it sets `errno'.  If another process
is testing `errno', it will detect the change and probably fail.  Note
that failing system calls can also set `errno'.  This problem can only
be fixed by either ignoring `errno', or treating it as part of the
context of a process and switching it along with the rest of a
processor state.  In normal debugged programs, there are usually no
math subroutine errors--and therefore no `matherr' calls; in that
situation, the math functions behave reentrantly.

   You can provide your own `matherr' function in an application, to
override the default behavior of the math functions, so it is possible
to suppress the error message output to `stderr' quite simply.

   Applications will have to be careful in their use of the heap.
`malloc' maintains static pointers to various areas of memory as part
of its duty.  `malloc' may be made reentrant with a simple spin lock
scheme.


File: libc.i,  Node: Index,  Up: Top

Index
*****

* Menu:

* abs:                                  abs.
* asctime:                              asctime.
* assert:                               assert.
* atexit:                               atexit.
* atof:                                 atof.
* atoff:                                atof.
* atoi:                                 atoi.
* atol:                                 atoi.
* bcmp:                                 bcmp.
* bsearch:                              bsearch.
* bzero:                                bzero.
* calloc:                               calloc.
* clearerr:                             clearerr.
* clock:                                clock.
* ctime:                                ctime.
* difftime:                             difftime.
* div:                                  div.
* ecvtbuf:                              ecvtbuf.
* ecvtbuf:                              efgcvt.
* environ:                              getenv.
* exit:                                 exit.
* fclose:                               fclose.
* fcvtbuf:                              efgcvt.
* fcvtbuf:                              ecvtbuf.
* feof:                                 feof.
* ferror:                               ferror.
* fflush:                               fflush.
* fgetc:                                fgetc.
* fgetpos:                              fgetpos.
* fgets:                                fgets.
* fiprintf:                             fiprintf.
* fopen:                                fopen.
* fprintf:                              sprintf.
* fputc:                                fputc.
* fputs:                                fputs.
* fread:                                fread.
* free:                                 malloc.
* freopen:                              freopen.
* fscanf:                               sscanf.
* fseek:                                fseek.
* fsetpos:                              fsetpos.
* ftell:                                ftell.
* fwrite:                               fwrite.
* gcvt:                                 efgcvt.
* gcvtf:                                efgcvt.
* getc:                                 getc.
* getchar:                              getchar.
* getenv:                               getenv.
* gets:                                 gets.
* gmtime:                               gmtime.
* index:                                index function.
* iprintf:                              iprintf.
* isalnum:                              isalnum.
* isalpha:                              isalpha.
* isascii:                              isascii.
* iscntrl:                              iscntrl.
* isdigit:                              isdigit.
* isgraph:                              isprint.
* islower:                              islower.
* isprint:                              isprint.
* ispunct:                              ispunct.
* isspace:                              isspace.
* isupper:                              isupper.
* isxdigit:                             isxdigit.
* labs:                                 labs.
* ldiv:                                 ldiv.
* localeconv:                           setlocale.
* localtime:                            localtime.
* malloc:                               malloc.
* mbtowc:                               mbtowc.
* memchr:                               memchr.
* memcmp:                               memcmp.
* memmove:                              memmove.
* memset:                               memset.
* mkstemp:                              mktemp.
* mktemp:                               mktemp.
* mktime:                               mktime.
* perror:                               perror.
* printf:                               sprintf.
* putc:                                 putc.
* putchar:                              putchar.
* puts:                                 puts.
* qsort:                                qsort.
* raise:                                raise.
* rand:                                 rand.
* realloc:                              malloc.
* remove:                               remove.
* rename:                               rename.
* rewind:                               rewind.
* rindex:                               rindex.
* scanf:                                sscanf.
* setbuf:                               setbuf.
* setlocale:                            setlocale.
* setvbuf:                              setvbuf.
* signal:                               signal.
* sprintf:                              sprintf.
* srand:                                rand.
* sscanf:                               sscanf.
* strcat:                               strcat.
* strcat:                               strncat.
* strchr:                               strchr.
* strcmp:                               strcmp.
* strcoll:                              strcoll.
* strcpy:                               strcpy.
* strcspn:                              strcspn.
* strerror:                             strerror.
* strftime:                             strftime.
* strlen:                               strlen.
* strncmp:                              strncmp.
* strncpy:                              strncpy.
* strpbrk:                              strpbrk.
* strrchr:                              strrchr.
* strspn:                               strspn.
* strstr:                               strstr.
* strtod:                               strtod.
* strtodf:                              strtod.
* strtok:                               strtok.
* strtol:                               strtol.
* strtoul:                              strtoul.
* strxfrm:                              strxfrm.
* system:                               system.
* tempnam:                              tmpnam.
* time:                                 time.
* tmpfile:                              tmpfile.
* tmpnam:                               tmpnam.
* toascii:                              toascii.
* tolower:                              tolower.
* toupper:                              toupper.
* va_alist:                             va_alist.
* va_arg:                               va_arg-trad.
* va_arg:                               va_arg.
* va_dcl:                               va_alist.
* va_end:                               va_end-trad.
* va_end:                               va_end.
* va_start:                             va_start.
* va_start:                             va_start-trad.
* vfprintf:                             vfprintf.
* vprintf:                              vfprintf.
* vsprintf:                             vfprintf.
* wctomb:                               wctomb.
* _tolower:                             tolower.
* _toupper:                             toupper.



Tag Table:
Node: Top2082
Node: signals2287
Node: raise4436
Node: signal5225
Node: strings6903
Node: bcmp7495
Node: bcopy8079
Node: bzero8509
Node: index function8985
Node: memchr9513
Node: memcmp10105
Node: memcpy10651
Node: memmove11106
Node: memset11608
Node: rindex12017
Node: strcat12556
Node: strchr13043
Node: strcmp13522
Node: strcoll14097
Node: strcpy14779
Node: strcspn15148
Node: strerror15619
Node: strlen18541
Node: strncat18933
Node: strncmp19685
Node: strncpy20317
Node: strpbrk20939
Node: strrchr21442
Node: strspn21940
Node: strstr22414
Node: strtok22962
Node: strxfrm24879
Node: ctype25987
Node: isalnum26577
Node: isalpha27274
Node: isascii27955
Node: iscntrl28546
Node: isdigit29251
Node: islower29895
Node: isprint30587
Node: ispunct31456
Node: isspace32171
Node: isupper32901
Node: isxdigit33571
Node: toascii34264
Node: tolower34793
Node: toupper35866
Node: timefns36938
Node: asctime38322
Node: clock38856
Node: ctime39489
Node: difftime39990
Node: gmtime40443
Node: localtime41323
Node: mktime42109
Node: strftime42811
Node: time46000
Node: stdio46637
Node: clearerr47527
Node: fclose48230
Node: feof48722
Node: ferror49145
Node: fflush49769
Node: fgetc50441
Node: fgetpos51231
Node: fgets52609
Node: fiprintf53434
Node: fopen54214
Node: fputc56894
Node: fputs57783
Node: fread58346
Node: freopen59058
Node: fseek59847
Node: fsetpos61216
Node: ftell62218
Node: fwrite63520
Node: getc64415
Node: getchar65550
Node: gets66443
Node: iprintf67459
Node: mktemp68203
Node: perror69610
Node: putc70349
Node: putchar71570
Node: puts72247
Node: remove72806
Node: rename73692
Node: rewind74503
Node: setbuf74987
Node: setvbuf76375
Node: sprintf78281
Node: sscanf86810
Node: tmpfile96769
Node: tmpnam97535
Node: vfprintf99466
Node: stdlib100593
Node: abort101110
Node: abs101153
Node: assert101691
Node: atexit102681
Node: atof103986
Node: atoi105419
Node: bsearch105983
Node: calloc107133
Node: div107800
Node: efgcvt108637
Node: ecvtbuf111272
Node: exit112861
Node: getenv113842
Node: labs114561
Node: ldiv115118
Node: malloc115977
Node: mbtowc118187
Node: qsort119044
Node: rand120209
Node: strtod121795
Node: strtol123451
Node: strtoul126000
Node: system128553
Node: wctomb129515
Node: locale130286
Node: setlocale134336
Node: syscalls136077
Node: machine136181
Node: arglists136315
Node: stdarg136848
Node: va_start137518
Node: va_arg138286
Node: va_end139484
Node: varargs139889
Node: va_alist140642
Node: va_start-trad141325
Node: va_arg-trad141944
Node: va_end-trad142620
Node: reentrancy143111
Node: Index145246

End Tag Table
