/*
 * stdlib.h
 *
 * Definitions for common types, variables, and functions.
 */


#ifndef _STDLIB_H_
#define _STDLIB_H_

#include <_ansi.h>

#define __need_size_t
#define __need_wchar_t
#include <stddef.h>

typedef struct 
{
 int quot; /* quotient */
 int rem; /* remainder */
} div_t;

typedef struct 
{
 long quot; /* quotient */
 long rem; /* remainder */
} ldiv_t;

#ifndef NULL
#define NULL 0
#endif

#define EXIT_FAILURE 1
#define EXIT_SUCCESS 0

#define RAND_MAX 0x7ffffffff

#define MB_CUR_MAX 1 



_VOID	_EXFUN(abort,(_VOID));
int	_EXFUN(abs,(int));
int	_EXFUN(atexit,(_VOID (*_func)(_VOID)));
double	_EXFUN(atof,(_CONST char *_nptr));
float	_EXFUN(atoff,(_CONST char *_nptr));
int	_EXFUN(atoi,(_CONST char *_nptr));
long	_EXFUN(atol,(_CONST char *_nptr));
_PTR	_EXFUN(bsearch,(_CONST _PTR _key,
		       _CONST _PTR _base,
		       size_t _nmemb,
		       size_t size,
		       int _EXFUN((*_compar),(_CONST _PTR , _CONST _PTR ))));
_PTR	_EXFUN(calloc,(size_t _nmemb, size_t _size));
div_t	_EXFUN(div,(int _numer, int _denom));
_VOID	_EXFUN(exit,(int _status));
_VOID	_EXFUN(free,(_PTR ));
char *  _EXFUN(getenv,(_CONST char *_string));
long	_EXFUN(labs,(long));
ldiv_t	_EXFUN(ldiv,(long _numer, long _denom));
_PTR	_EXFUN(malloc,(size_t _size));
_VOID	_EXFUN(qsort,(_PTR _base, size_t _nmemb, size_t _size, int(*_compar)(_CONST _PTR , _CONST _PTR )));
int	_EXFUN(rand,(_VOID));
_PTR	_EXFUN(realloc,(_PTR r, size_t _size));
_VOID	_EXFUN(srand,(unsigned _seed));
double	_EXFUN(strtod,(_CONST char *n, char **end_PTR));
float	_EXFUN(strtodf,(_CONST char *n, char **end_PTR));
long	_EXFUN(strtol,(_CONST char *_n, char **_end_PTR, int _base));
unsigned long _EXFUN(strtoul,(_CONST char *_n_PTR, char **_end_PTR, int _base));
int	_EXFUN(system,(_CONST char *_string));

#ifndef _ANSI_SOURCE
_VOID	_EXFUN(cfree,(_PTR, _PTR));
int	_EXFUN(putenv,(_CONST char *_string));
int	_EXFUN(setenv,(_CONST char *_string, _CONST char *_value, int _overwrite));
#endif




char * _EXFUN(gcvt,(double,int,char *));
char * _EXFUN(gcvtf,(float,int,char *));
char * _EXFUN(fcvt,(double,int,int *,int *));
char * _EXFUN(fcvtf,(float,int,int *,int *));
char * _EXFUN(ecvt,(double,int,int *,int *));
char * _EXFUN(ecvtbuf,(double, int, int*, int*, char *));
char * _EXFUN(fcvtbuf,(double, int, int*, int*, char *));
char * _EXFUN(ecvtf,(float,int,int *,int *));
char * _EXFUN(dtoa,(double, int, int, int *, int*, char**));
#endif /* _STDLIB_H_ */
