/*
** This file is part of the alternative 80386 math library and is
** covered by the GNU General Public license with my modification
** as noted in the README file that accompanied this file.
**
** Copyright 1990 G. Geers
**
** A mix of C and assembler - well I've got the functions so I might 
** as well use them!
**
*/

#include "fpumath.h"

asm(".align 4");
asm(".Lulp:");
asm(".double 5.9604644775390625e-08");

asm(".align 4");
asm(".Lulpup:");
asm(".double 1.1920928955078125e-07");

float
nextafterf(float x, float y)
{
	asm("subl $8, %esp");

	if (isnanf(x) || isnanf(y))
		return(quiet_nanf(1.0));

	if (isinff(x))
		if (y > x)
			return(-max_normalf());
		else
		if (y < x)
			return(max_normalf());

	if (x == 0.0) {
		if (y > 0.0)
			return(min_subnormalf());
		else
			return(-min_subnormalf());
	}

	if (isnormalf(x)) {
		if ((x == min_normalf()) && y < x)
			return(max_subnormalf());

		if ((x == max_normalf()) && y > x)
			return(infinityf());

		if ((x == -max_normalf()) && y < x)
			return(-infinityf());

		asm("movl 8(%ebp), %eax");
		asm("andl $0x7f800000, %eax");
		asm("movl %eax, -8(%ebp)");
		asm("fincstp");

		if (fabsf(x) <= 2.0 && y < x) 
			asm("fldl .Lulp");
		else
			asm("fldl .Lulpup");

		asm("flds -8(%ebp)");
		asm("fmulp");

		if (y > x) {
			asm("flds 8(%ebp)");
			asm("faddp");
			asm("leave");
			asm("ret");
		}
		if (y < x) {
			asm("flds 8(%ebp)");
			asm("fsubp");
			asm("leave");
			asm("ret");
		}
	}
	else
	if (issubnormalf(x)) {
		if ((x == max_subnormalf()) && y > x)
			return(min_normalf());

		if ((x == -max_subnormalf()) && y < x)
			return(-min_normalf());

		if (y > x) 
			return(x + min_subnormalf());

		if (y < x)
			return(x - min_subnormalf());
	}
	
	return(x);
}
