// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 *  Please check the following before installing this file:
 *
 *  Make sure USG is #defined if you are on a USG system!
 *
 *  Check whether your libc.a sprintf function returns
 *  an int (as do most) versus a char* (BSD), and (un)comment
 *  the corresponding SPRINTF_RETURNS_INT line.
 *
 *  Check the value of BUFSIZ against the one in your /usr/include/stdio.h.
 *
 *  Carefully check the fields and order of _iobuf declaration against
 *  the one in your /usr/include/stdio.h. Xenix-based systems
 *  may need some re-ordering of _iobuf. fields.
 *
 *  Note that some _IOXXX #defines may not be present in your 
 *  /usr/include/stdio.h. This is ok, so long as the ones that
 *  are present in both are set to the same values.
 *
 *  Some of the prototypes refer to functions that may not be
 *  present in your libc.a. This is ok so long as you do not
 *  actually call such functions.
 *
 */

#ifndef _stdio_h
#ifdef __GNUG__
#pragma interface
#endif

#ifdef __stdio_h_recursive
#include_next <stdio.h>
#else
#define __stdio_h_recursive

// Note:  The #define _stdio_h is at the end of this file,
// in case #include_next <stdio.h> finds an installed version of this
// same file -- we want it to continue until it finds the C version.

#ifdef SYSTEM_FIVE
#define USG
#endif

#if defined(IBM6000)
#define NO_LIBGXX_MALLOC
#endif	// IBM6000

#if defined(USG)

#elif defined(VMS)
#define NO_LIBGXX_MALLOC

#elif masscomp
#ifdef _ATT
#define USG
#endif

#elif defined(DGUX)
#define SPRINTF_RETURNS_INT
#define USG

#elif defined(TEKTRONIX_SYSV) || defined(hp9000s300) || defined(i386)
#define  USG
#endif

#if defined(MACH)
#undef USG
#define SPRINTF_RETURNS_INT
#endif //MACH

extern "C" {

#undef NULL

#define fdopen __hide_fdopen
#define fopen __hide_fopen
#define fprintf __hide_fprintf
#define fputs __hide_fputs
#define freopen __hide_freopen
#define fscanf __hide_fscanf
#define fwrite __hide_fwrite
#define new __hide_new /* In case 'new' is used as a parameter name. */
#define perror __hide_perror
#define popen __hide_popen
#define printf __hide_printf
#define puts __hide_puts
#define putw __hide_putw
#define rewind __hide_rewind
#define tempnam __hide_tempnam
#define scanf __hide_scanf
#define setbuf __hide_setbuf
#define setlinebuf __hide_setlinebuf
#define setvbuf __hide_setvbuf
#define sprintf __hide_sprintf
#define sscanf __hide_sscanf
#define tempnam __hide_tempnam
#define vfprintf __hide_vfprintf
#define vprintf __hide_vprintf
#define vsprintf __hide_vsprintf

#include_next <stdio.h>

#undef fdopen
#undef fopen
#undef fprintf
#undef fputs
#undef freopen
#undef fscanf
#undef fwrite
#undef new
#undef perror
#undef popen
#undef printf
#undef puts
#undef putw
#undef rewind
#undef tempnam
#undef scanf
#undef setbuf
#undef setlinebuf
#undef setvbuf
#undef sprintf
#undef sscanf
#undef tempnam
#undef vprintf
#undef vfprintf
#undef vsprintf

#ifndef NULL
#define NULL ((void*)0)
#endif
}

#ifndef __SIZE_TYPE__ /* Defined by gcc-2. */
#define __SIZE_TYPE__ long unsigned int
#endif

extern "C" {

#ifdef VMS
int     c$$doprint(const char*, void*, FILE*);
int     c$$doscan(FILE*, const char*, ...);
int	c$$filbuf(FILE*);
int	c$$flsbuf(unsigned, FILE*);
#elif ! defined(ultrix)
int    _doprnt(const char*, void*, FILE*);
int    _doscan(FILE*, const char*, ...);
int    _filbuf(FILE*);
int    _flsbuf(unsigned, FILE*);
#endif

int    fclose(FILE*);
FILE*  fdopen(int, const char*);
int    fflush(FILE*);
int    fgetc(FILE*);
char*  fgets(char*, int, FILE *);
FILE*  fopen(const char*, const char*);
int    fprintf(FILE*, const char* ...);
int    fputc(int, FILE*);
int    fputs(const char*, FILE*);
__SIZE_TYPE__ fread(void*, __SIZE_TYPE__, __SIZE_TYPE__, FILE*);
#ifdef VMS
FILE*  freopen(const char*, const char*, FILE* ...);
#else
FILE*  freopen(const char*, const char*, FILE*);
#endif
int    fscanf(FILE*, const char* ...);
int    fseek(FILE*, long, int);
long   ftell(FILE *);
__SIZE_TYPE__ fwrite(const void*, __SIZE_TYPE__, __SIZE_TYPE__, FILE*);
char*  gets(char*);
int    getw(FILE*);
int    pclose(FILE*);
void   perror(const char*);
FILE*  popen(const char*, const char*);
int    printf(const char* ...);
int    puts(const char*);
int    putw(int, FILE*);
int    rewind(FILE*);
int    scanf(const char* ...);
int    setbuf(FILE*, char*);
int    setbuffer(FILE*, char*, int);
int    setlinebuf(FILE*);
int    setvbuf(FILE*, char*, int, __SIZE_TYPE__);
int    sscanf(char*, const char* ...);
FILE*  tmpfile();
int    ungetc(int, FILE*);
int    vfprintf(FILE*, const char*, ...);

// Third arg to vprintf must be '...' for some machines, & doesn't
// hurt for others.

int    vprintf(const char*, ... );

#ifdef SPRINTF_RETURNS_INT
int    sprintf(char*, const char* ...);
int    vsprintf(char*, const char*, ...);
#else
char*  sprintf(char*, const char*, ...);
char*  vsprintf(char*, const char*, ...);
#endif

}

#ifndef L_ctermid
#define L_ctermid	9 
#endif
#ifndef L_cuserid
#define L_cuserid	9
#endif
#ifndef P_tmpdir
#define	P_tmpdir    "/tmp/"
#endif
#ifndef L_tmpnam
#define	L_tmpnam    (sizeof(P_tmpdir) + 15)
#endif

#define _stdio_h 1

#endif
#endif // _stdio_h
