/*	mcread: wordwrap.c
	Copyright (C) 1991, Mike Gleason Jr & NCEMRSoft.
	All Rights Reserved. */

#include <stdio.h>
#include <string.h>
#include "mcread.h"

char				*out, *maxwidth;
char				lyne1[256];
short				tab = 4, width = 78, pager = 0, linecount;
#ifndef DO_NOT_MAP_HICHARS
char				hibitTable[128][8] = {
"A", "A", "C", "E", "N", "O", "U", "a",
"a", "a", "a", "a", "a", "c", "e", "e",
"e", "e", "i", "i", "i", "i", "n", "o",
"o", "o", "o", "o", "u", "u", "u", "u",
"*", "*", "c", "L", "S", "*", "P", "B",
"(R)", "(C)", "(tm)", "'", "", "", "AE", "0",
"oo", "+/-", "<=", ">=", "Y", "m", "d", "E",
"PI", "pi", "|", "a", "o", "O", "ae", "o",
"?", "!", "", "", "f", "", "", "<<",
">>", "...", " ", "A", "A", "O", "OE", "oe",
"-", "--", "\"", "\"", "'", "'", "/", "",
"y", "Y", "|", "", "<", ">", "fi", "fl",
"", ".", ",", ",,", "o/oo", "A", "E", "A",
"E", "E", "I", "I", "I", "I", "O", "O",
"Apple", "O", "U", "U", "U", "I", "^", "~",
"-", "", ".", ".", "", "", "", "" };
#endif

int	wwInit()
{
	maxwidth = lyne1 + width;
	out = lyne1;
}	/* wwInit */




int wwPutchar(c)
	register int c;
{
	register short count;
	
	count = 1;
	if (c == '\t' && tab > 0) {
		count = tab - ((out - lyne1 - 0) % tab);
		c = ' ';
	} else if (c == '\r') {
		/* We don't want raw CRs in the unix output. */ 
		if (out == lyne1) {
			putchar ((int)'\n');	/* Probably a blank line. */
			if (CheckPage())
				return (1);				/* user canceled */
		}
		return (0);		
	}
	
	/*	while we're at it, turn some common mac 8-bit chars into
		acceptable 7-bit ASCII equivalents. */
	if (EIGHTBIT(c)) {
#ifndef DO_NOT_MAP_HICHARS
		char *map;
		for (map=hibitTable[(unsigned int)c - 128]; *map; map++)
			if (wwPutchar ((int)*map))
				return (1);					/* user skipped file */
		return (0);
#else
#ifdef STRIP_HICHARS
		else c &= 0x0080;
#else
#ifdef OMIT_HICHARS
		return (0);
#endif /* omit hichars */
#endif /* strip hichars */
#endif /* map hichars... sure wish elif would work on every compiler... */
	} else if (NONPRINTING(c))
		return (0);	/* don't bother printing a non-printing char. */
	
	while (--count >= 0) {
		*out++ = c;
		
		if (out > maxwidth) {			/* word wrap */
			for (*out='\0'; !isspace(*out); *out--)
				if (out == lyne1) break;
			if (out == lyne1) {			/* word too long! */
				(void) puts (lyne1);
			} else {
				*out++ = '\0';			/* null terminate string */
				(void) puts (lyne1);			/* spew wrapped line */
				(void) strcpy (lyne1, out);	/* wrap word onto new line */
				out = lyne1 + (int) strlen (lyne1);
			}
			if (CheckPage())
				return (1);				/* user canceled */
			break;
		}								/* end word wrap */
	}
	return (0);
}	/* wwPutchar */





int wwFlush()
{
	*out = '\0';
	if (out > lyne1 && *lyne1) {
		(void) puts (lyne1);
		return (CheckPage());
	}
	return (0);
}	/* wwFlush */




int CheckPage()
{
	char crap[80];
	if (++linecount >= pager && pager > 0) {		
		linecount = 0;
		(void) printf("...hit return to continue, q to cancel...");
		(void) fflush(stdout);
		(void) fgets (crap, 78, stdin);
		if (*crap == 'q' || *crap == 'n')
			return (1);
	}
	return (0);
}

/* eof */
