/*
 * macwho.c
 *
 * djh@munnari.OZ.AU, 03/05/90
 *
 * List Chooser Names of Macintoshes running "Messages"
 *
 */

#include "notify.h"

extern NBPTEntry nbpt[];

main(argc, argv)
int argc;
char *argv[];
{
	int notify();
	int compare();
	int num, i, j, k;
	EntityName en;
	AddrBlock addr;
	char *zonelist[MAXZONES];

	zonelist[0] = OURZONE;
	zonelist[1] = NULL;

	for(i = 0 ; --argc > 0 && i < MAXZONES-1 ; i++) {
		zonelist[i] = *++argv;
		zonelist[i+1] = NULL;
	}

	j = 0;
	k = 1;
	while(zonelist[j] != NULL) {
	    if((num = notify(0, "", "", "=", zonelist[j], 0, 1, 6)) > 0) {
		qsort((char *) nbpt, num, sizeof(NBPTEntry), compare);
		for(i = 1; i <= num ; i++)
		    if(NBPExtract(nbpt, num, i, &en, &addr) == noErr) {
			printf("%3d  %-34s[Net %3d.%-3d Node %3d%s%s]\n",
			    k++,
			    en.objStr.s,
			    ntohs(addr.net) / 256,
			    ntohs(addr.net) % 256,
			    addr.node,
			    (*zonelist[j]=='*') ? "" : " ",
			    (*zonelist[j]=='*') ? "" : zonelist[j]);
			    /* Sigh: much nicer if we could use en.zoneStr */
			}
	    }
	    j++;
	}
}

int
compare(a, b)
NBPTEntry *a, *b;
{
	return(strcmp(a->ent.objStr.s, b->ent.objStr.s));
}
