/* NFS RPC procedures that log args and results */

/*
Copyright Technical Research Centre of Finland (VTT), 
Information Technology Institute (TTE) 1993, 1994 - All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of VTT or TTE not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission. 

VTT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
VTT BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
*/

static char RCS_Id[] = "$Id: trace_svc_subr.c,v 1.5 1994/07/31 13:12:13 tml Exp $";

#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include <sys/time.h>

#include <rpc/rpc.h>

#include "nfs_prot.h"
#include "log_nfs.h"

#include "util.h"

extern CLIENT *clntp;
extern char hostname[];
extern struct timeval timeout;

#if __STDC__
static AUTH *
pass_auth(const struct svc_req *rqstp)
#else
static AUTH *
pass_auth(rqstp)
     struct svc_req *rqstp;
#endif
{
  struct authunix_parms *unix_cred;

  switch (rqstp->rq_cred.oa_flavor)
    {
    case AUTH_UNIX:
      unix_cred = (struct authunix_parms *) rqstp->rq_clntcred;

      return authunix_create(hostname, unix_cred->aup_uid, unix_cred->aup_gid,
			     unix_cred->aup_len, unix_cred->aup_gids);
    case AUTH_NULL:
      return authnone_create();

    default:
      return NULL;
    }
}

typedef char void_;
#define xdr_void_ xdr_void
#define print_void_(level, value)

#if __STDC__
#define GENARGS(arg) (arg *argp, struct svc_req *rqstp)
#else
#define GENARGS(arg) (argp, rqstp) arg *argp; struct svc_req *rqstp;
#endif

#define GENIT(name, proc, arg, result, type)			\
type *								\
CONCAT3(nfsproc_,name,_2) GENARGS(arg)				\
{								\
  static result res;						\
								\
  printf("%s\n", STRINGIFY(name));				\
  print_auth(rqstp);						\
  clntp->cl_auth = pass_auth(rqstp);				\
  CONCAT2(print_,arg)(0, argp);					\
  clnt_call(clntp, proc, CONCAT2(xdr_,arg), argp,		\
	    CONCAT2(xdr_,result), &res, timeout);		\
  auth_destroy(clntp->cl_auth);					\
  CONCAT2(print_,result)(1, &res);				\
  printf("\n");							\
  return &res;							\
}

#define GEN(name, proc, arg, result) \
  GENIT(name,CONCAT2(NFSPROC_,proc),arg,result,result)
#define GENVOID(name, proc, arg) \
  GENIT(name,CONCAT2(NFSPROC_,proc),arg,void_,void)

/* Must aboid spaces in macro argument list */
GENIT(null,NFSPROC_NULL,void_,void_,void)
GEN(getattr,GETATTR,nfs_fh,attrstat)
GEN(setattr,SETATTR,sattrargs,attrstat)
GENVOID(root,ROOT,void_)
GEN(lookup,LOOKUP,diropargs,diropres)
GEN(readlink,READLINK,nfs_fh,readlinkres)
GEN(read,READ,readargs,readres)
GENVOID(writecache,WRITECACHE,void_)
GEN(write,WRITE,writeargs,attrstat)
GEN(create,CREATE,createargs,diropres)
GEN(remove,REMOVE,diropargs,nfsstat)
GEN(rename,RENAME,renameargs,nfsstat)
GEN(link,LINK,linkargs,nfsstat)
GEN(symlink,SYMLINK,symlinkargs,nfsstat)
GEN(mkdir,MKDIR,createargs,diropres)
GEN(rmdir,RMDIR,diropargs,nfsstat)
GEN(readdir,READDIR,readdirargs,readdirres)
GEN(statfs,STATFS,nfs_fh,statfsres)
