static const char RCS_Id[] = "$Id: dumpfi.c,v 1.3 1993/03/25 10:58:14 tml Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>

#include <netat/appletalk.h>
#include <netat/afp.h>
#include <netat/afpcmd.h>
#include <netat/afpc.h>

extern int errno;

static void
dumpfi(const char *fname)
{
  FILE *f;
  FileInfo finfo;
  OldFileInfo *oinfo = &finfo;
  int nbytes;
  int i, j;

  if ((f = fopen(fname, "r")) == NULL)
    {
      fprintf(stderr, "Couldn't open %s: %s\n", fname, strerror(errno));
      return;
    }

  nbytes = fread(&finfo, 1, sizeof(finfo), f);

  fclose(f);
  
  if (nbytes < sizeof(OldFileInfo))
    {
      fprintf(stderr, "Read only %d bytes from %s\n", nbytes, fname);
      return;
    }

  printf("Finder info for %s:\n", fname);
  for (i = 0; i < FINFOLEN; i += 16)
    {
      for (j = 0; j < 16; j++)
	printf("%02x ", finfo.fi_fndr[i+j]);
      printf("\n");
      for (j = 0; j < 16; j++)
	if (isprint(finfo.fi_fndr[i+j]))
	  printf("%2c ", finfo.fi_fndr[i+j]);
	else
	  printf("   ");
      printf("\n");
    }

  printf("Attribute bits: ");
  if (finfo.fi_attr & FPA_INV)
    printf("Invisible ");
  if (finfo.fi_attr & FPA_MUS)
    printf("MultiUser ");
  if (finfo.fi_attr & FPA_SYS)
    printf("System ");
  if (finfo.fi_attr & FPA_DAO)
    printf("DAlreadyOpen ");
  if (finfo.fi_attr & FPA_RAO)
    printf("RAlreadyOpen ");
  if (finfo.fi_attr & FPA_WRI)
    printf("ReadOnly ");
  if (finfo.fi_attr & FPA_BKUP)
    printf("BackupNeeded ");
  if (finfo.fi_attr & FPA_RNI)
    printf("RenameInhibit ");
  if (finfo.fi_attr & FPA_DEI)
    printf("DeleteInhibit ");
  if (finfo.fi_attr & FPA_CPR)
    printf("CopyProtect ");
  printf("\n");

  if (nbytes < sizeof(FileInfo))
    {
      if (oinfo->fi_comln > 0)
	printf("Comment: \"%.*s\"\n", oinfo->fi_comln, oinfo->fi_comnt);
    }
  else
    {
      if (finfo.fi_bitmap & FI_BM_SHORTFILENAME)
	printf("Short name: \"%s\"\n", finfo.fi_shortfilename+1);

      if (finfo.fi_bitmap & FI_BM_MACINTOSHFILENAME)
	printf("Mac name: \"%s\"\n", finfo.fi_macfilename);
      
      if (finfo.fi_comln > 0)
	printf("Comment: \"%.*s\"\n", finfo.fi_comln, finfo.fi_comnt);
    }
}

main(int argc, char **argv)
{
  int i;

  for (i = 1; i < argc; i++)
    dumpfi(argv[i]);
  return 0;
}
