/*
Copyright Technical Research Centre of Finland (VTT), 
Information Technology Institute (TTE) 1993, 1994 - All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of VTT or TTE not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission. 

VTT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
VTT BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
*/

/* $Id: afpmount.h,v 1.12 1994/07/31 13:12:13 tml Exp $ */

/* Types of AFI file handles */

#define AFIFH_TOP 1		/* The mount point, which contains */
				/* the volumes */
#define AFIFH_DIR 2		/* A folder */
#define AFIFH_RESDIR 3		/* CAP .resources directory */
#define AFIFH_FIDIR 4		/* CAP .finderinfo directory */
#define AFIFH_DFORK 5		/* CAP data fork, or Apple Double data fork */
#define AFIFH_RFORK 6		/* CAP resource fork */
#define AFIFH_FINFO 7		/* CAP finderinfo */
#define AFIFH_SINGLE 8		/* Apple Single file */
#define AFIFH_DOUBLERES 9	/* Apple Double resource file */
#define AFIFH_CONTROL 10	/* Control file used to log in */

/* afpmount uses the following structure as a file handle */

typedef struct
{
  char fh_type;			/* Type of file handle */
				/* For dirs and files: */
  short fh_volix;		/* Index into volume_parms */
  int fh_dirid;			/* Parent directory, or self ID */
				/* For files: */
  int fh_fileid;		/* File ID */
} afi_fh;

extern afi_fh *toplevel_fh;

/*
 * Each potential or open AFP session has an afi_user structure.
 *
 * These structures are allocated when an UNIX user "logs in" to an 
 * afpmount-mounted AFP server, that is tells afpmount what AFP
 * user name and password to use if and when the user's processes
 * eventually access the AFP server.
 */

typedef struct afi_user
{
  uid_t u_uxuid;		/* UNIX uid */
  int u_srn;			/* ASP session number, or magic flag */
#define SRN_LOGIN_FAILED -1
#define SRN_NOT_OPEN -2
  int u_dtrn;			/* AFP Desktop database refnum if open */
  int u_dtvol;			/* Which volume's DT does u_dtrn refer to */
#define DTRN_OPEN_FAILED -1
#define DTRN_NOT_OPEN -2
  char *u_name;			/* AFP user name */
  char *u_passwd;		/* AFP password */
  int u_mark;			/* Used in "garbage collecting" */
  time_t u_timestamp;		/* Also used in GC */
  struct afi_user *u_link;
} afi_user;

extern int afpversion;

#define DEBUG_TRACENFS 0x001

extern int debug;

extern GetSrvrInfoReplyPkt server_info;
extern GSPRPPtr server_parms;
extern GVPRPPtr volume_parms;
extern CONST char *server_name;
extern afi_user guest;

typedef struct
{
  char *uam_name;
  int supported;
} uam_present;

extern byte local_to_afp[];
extern byte afp_to_local[];
extern byte afp_downcase[];

/* Mac file structure translation modes.  */

#define MODE_CAP 0		/* .finderinfo and .resource directories */
#define MODE_APPLESINGLE 1	/* Apple Single format */
#define MODE_APPLEDOUBLE 2	/* Apple Double format */

extern int mode;

/* Mac file name translation modes.  */

#define TRANSL_NONE 0		/* No translation (except ':' <-> '/') */
#define TRANSL_LATIN1 1		/* ISO Latin-1 */
#define TRANSL_CAP 2		/* non-ASCII as ":%02x" */

/* Open forks time out and are closed after TIMEOUT seconds.  */

#ifndef TIMEOUT
#define TIMEOUT 30
#endif

extern int fntransl;

extern char revision[];

extern void check_errors P((const char *function, int comp, dword cr));
extern int open_session P((int *srn));
extern void logout P((afi_user *u));
extern int login_user P((afi_user *user, int uam));
extern int login P((int srn, int uam, const char *user, const char *passwd));
extern void try_getsrvprm P((afi_user *user));
extern void init_nfs_subr P((void));
extern void nfs_timeout P((time_t now));
#ifndef SENTINEL
/* Error-checking versions of malloc() etc. */
extern void *xmalloc P((size_t nbytes));
extern void *xrealloc P((void *ptr, size_t nbytes));
extern void *xzalloc P((size_t nbytes));
#else
/* We want mempory leaks reported. */
#define xmalloc malloc
#define xrealloc realloc
#define xzalloc(n) calloc(1,n)
#endif

#define xstrdup(s) strcpy(xmalloc(strlen(s) + 1), s)

