#!/bin/sh

# $Id: afplogin.sh,v 1.3 1993/03/31 14:48:59 tml Exp $

usage() 
{
	echo "Usage: $0 mountpoint [ username [ password ] ]"
	echo ' mountpoint is the directory where the AFP server is mounted.'
	echo ' username is the AFP user name you want to use (default is'
	echo ' your UNIX username), and password is its password.'
	echo ' If no password is given, it is read from standard input.'
}

if [ $# -lt 1 ]; then
	usage
	exit 255
fi

if [ "$2" ]; then
	user="$2"
else
	user="$LOGNAME"
	[ -z "$user" ] && user="$USER"
	[ -z "$user" ] && user="`logname`"
	if [ -z "$user" ]; then
		echo 'Who are you?'
		exit 255
	fi
fi


if [ "$3" ]; then
	password="$3"
else
	if [ -t 0 -a -t 1 ]; then
		STTYG="`stty -g`"
		stty -echo
		echo "Password: \c"
	fi
	read password
	[ -t 0 -a -t 1 ] && (echo; stty "$STTYG")
fi

echo login "$user" "$password" >$1/.control
